/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) chgrp.c: version 25.1 created on 12/2/91 at 13:56:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)chgrp.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/
/*	ATT: #ident	"chgrp:chgrp.c	1.3"			*/

#ident	"@(#)chgrp:chgrp.c	25.1"

/*
 * chgrp gid file ...
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <grp.h>

#define	SYMLINK	1

struct	group	*gr,*getgrnam();
struct	stat	stbuf;
ushort	gid;
int	status;
#ifdef	SYMLINK
int	h_flag;
#endif

main(argc, argv)
char *argv[];
{
#ifdef	SYMLINK
 	register argv_index = 1;
#endif
	register c;

	if(argc < 3) {
#ifdef	SYMLINK
 		fprintf(stderr,"chgrp: usage: chgrp [-h] gid file ...\n");
#else
		fprintf(stderr,"chgrp: usage: chgrp gid file ...\n");
#endif
		exit(4);
	}
#ifdef SYMLINK
 	while ((c = getopt(argc, argv, "h")) != EOF)
 		switch(c) {
 		
 		case 'h':
 			h_flag++;
 			argv_index++;
 			break;
 		default:
 			fprintf(stderr,
 				"chgrp: usage: chgrp [-h] gid file ...\n");
 			exit(4);
 		}
 
 	if(isnumber(argv[argv_index])) {
 		gid = atoushort(argv[argv_index]); /* gid is unsigned short */
#else
	if(isnumber(argv[1])) {
		gid = atoushort(argv[1]); /* gid is unsigned short */
#endif
	} else {
#ifdef SYMLINK
 		if((gr=getgrnam(argv[argv_index])) == NULL) {
#else
		if((gr=getgrnam(argv[1])) == NULL) {
#endif
			fprintf(stderr,"chgrp: unknown group: %s\n",argv[1]);
			exit(4);
		}
		gid = gr->gr_gid;
	}
#ifdef SYMLINK
 	argv_index++;
 	for(c = argv_index; c < argc; c++) {
 		if (h_flag) {
 			lstat(argv[c], &stbuf);
 			if(lchown(argv[c], stbuf.st_uid, gid) < 0) {
 				perror(argv[c]);
 				status = 1;
 			}
 		}
 		else {
 			stat(argv[c], &stbuf);
 			if(chown(argv[c], stbuf.st_uid, gid) < 0) {
 				perror(argv[c]);
 				status = 1;
 			}
		}
#else
	for(c=2; c<argc; c++) {
		stat(argv[c], &stbuf);
		if(chown(argv[c], stbuf.st_uid, gid) < 0) {
			perror(argv[c]);
			status = 1;
		}
#endif
	}
	exit(status);
}

isnumber(s)
char *s;
{
	register c;

	while(c = *s++)
		if(!isdigit(c))
			return(0);
	return(1);
}

atoushort(s)
register char *s;
{
	register char c;
	ushort register i, previ;
	i = previ = 0;
	while(c = *s++) {
		i = c - '0' + 10 * i;
		if(i < previ) {
			fprintf(stderr,"chgrp: numeric group id too large\n");
			exit(4);
    		}
		previ = i;
	}
	return(i);
}
