#	START NEW ARIX SCCS HEADER
#
#	@(#) awk.mk: version 25.1 created on 12/2/91 at 13:50:40
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)awk.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

# AT&T #ident	"awk:awk.mk	1.1"

#ident "@(#)awk:awk.mk	25.1"

IROOT =
include $(IROOT)/macdefs
RDIR = $(SROOT)/usr/src/cmd/awk
INSDIR = $(ROOT)/usr/bin
YACCRM=-rm
TESTDIR = .
FRC =
YFLAGS=-d
LIBM= -lm
REL = current
LIST = lp

FILES=awk.lx.o b.o main.o token.o tran.o lib.o run.o parse.o proctab.o freeze.o

SOURCE=awk.def awk.g.y awk.h awk.lx.l b.c lib.c main.c parse.c \
	makeprctab.c freeze.c\
	run.c token.c tokenscript tran.c

all:  awk

awk:	$(FILES) awk.g.o
	$(CC) awk.g.o  $(FILES)  $(LIBM) -o  $(TESTDIR)/awk $(LDFLAGS)

y.tab.h:	awk.g.o

awk.h:	y.tab.h
	-cp y.tab.h awk.h

$(FILES):	awk.h awk.def $(FRC)

token.c:	awk.h tokenscript
	ed - <tokenscript

src:	$(SOURCE) test.a tokenscript makefile README EXPLAIN
	cp $? $(SROOT)/usr/src/cmd/awk
	touch $(NEWDATE) src

get:
	for i in $(SOURCE) awk.mk tokenscript EXPLAIN README; \
	do \
		cp $(SROOT)/usr/src/cmd/awk/$$i .; \
	done

bin:
	cp a.out $(ROOT)/usr/bin/awk
	strip $(ROOT)/usr/bin/awk

profile:	awk.g.o $(FILES) mon.o
	$(CC) $(CFLAGS) -p  awk.g.o $(FILES) mon.o $(LIBM)

find:
	egrep -n "$(PAT)" *.[ylhc] awk.def

list:
	-pr WISH $(SOURCE) awk.mk tokenscript README EXPLAIN

lint:
	lint -spu b.c main.c token.c tran.c run.c lib.c parse.c $(LIBM) |\
		egrep -v '^(error|free|malloc)'

proctab.c:	./makeprctab
	./makeprctab >proctab.c

ltoken.c: token.c
	ln token.c ltoken.c

./makeprctab:	awk.h ltoken.c 
	/bin/cc -o ./makeprctab makeprctab.c ltoken.c

#dux#1	There are no LOCALINCS here.  The empty -I was causing problems.
#	/bin/cc -I$(LOCALINCS) -o ./makeprctab makeprctab.c ltoken.c

diffs:
	-for i in $(SOURCE) EXPLAIN README; \
	do \
		echo $$i:; \
		diff $$i $(SROOT)/usr/src/cmd/awk | ind; \
	done
lcomp:
	-rm -f  [b-z]*.o
	lcomp b.c main.c token.c tran.c run.c lib.c parse.c freeze.c proctab.c   *.o $(LIBM)

FRC:

install:  awk
	$(INS) awk $(INSDIR)/awk
	chmod 755 $(INSDIR)/awk
	chgrp bin $(INSDIR)/awk
	chown bin $(INSDIR)/awk

build:	bldmk
	get -p -r`gsid awk $(REL)` s.awk.src $(REWIRE) | ntar -d $(RDIR) -g
	cd $(RDIR) ; $(YACC) $(YFLAGS) awk.g.y
	cd $(RDIR) ; mv y.tab.c  awk.g.c ; rm -f y.tab.h

bldmk:
	get -p -r`gsid awk.km $(REL) s.awk.mk >$(RDIR)/awk.mk

listing:
	pr awk.mk $(SOURCE) EXPLAIN README | $(LIST)

listmk:
	pr awk.mk | $(LIST)

edit:
	get -e -p s.awk.src |ntar -g

delta:
	ntar -p $(SOURCE) EXPLAIN README >awk.src
	delta s.awk.src

mkedit:		;	get -e s.awk.mk
mkdelta:	;	delta s.awk.mk

ctags:
	ctags	$(SOURCE)
	echo 'grep $$* \\' > greplist
	for i in $(SOURCE) EXPLAIN README	;\
	do echo "$$i \\" >> greplist	;\
	done
	echo /dev/null >> greplist
	chmod +x greplist

clean:
	rm -f a.out *.o t.* y.tab.* \
	awk.h ./makeprctab proctab.c tags greplist temp

clobber:	clean
	-rm  -f  $(TESTDIR)/awk ltoken.c
