#	START NEW ARIX SCCS HEADER
#
#	@(#) assist.mk: version 25.1 created on 12/2/91 at 13:32:08
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)assist.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT:ident	"assist:assist.mk	1.11"

#ident	"@(#)assist:assist.mk	25.1"

include	$(IROOT)/macdefs

INSDIR = $(ROOT)/usr/bin
LIB = $(ROOT)/usr/lib
LIBDIR = $(LIB)/assist/lib
ALIBDIR = `echo $(LIBDIR) | sed \"s;$(ROOT);;\"`
BINDIR = $(LIB)/assist/bin
ABINDIR = `echo $(BINDIR) | sed \"s;$(ROOT);;\"`
CURSES = -lcurses
INCLUDE =
FFLAG =

all:
	cd ./src/forms; $(MAKE) -$(MAKEFLAGS)e LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) INS="$(INS)" INCLUDE=$(INCLUDE) CURSES=$(CURSES) -f forms.mk
	cd ./src/scripts; $(MAKE) -$(MAKEFLAGS)e LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" INCLUDE=$(INCLUDE) CURSES=$(CURSES) -f mscript.mk
	cd ./src/search; $(MAKE) -$(MAKEFLAGS)e LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" -f msearch.mk
	cd ./src/setup; $(MAKE) -$(MAKEFLAGS)e LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" -f setup.mk
	cd ./src/astgen; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" INCLUDE=$(INCLUDE) CURSES=$(CURSES) -f tools.mk

install: $(LIBDIR) $(BINDIR)
	cd ./lib/forms; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f forms.mk install
	cd ./lib/scripts; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f scripts.mk install
	cd ./lib/search; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f search.mk install
	cd ./lib/setup; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f setup.mk install
	cd ./lib/astgen; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f tools.mk install
	cd ./src/forms; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" INCLUDE=$(INCLUDE) CURSES=$(CURSES) -f forms.mk install
	cd ./src/scripts; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" INCLUDE=$(INCLUDE) CURSES=$(CURSES) -f mscript.mk install
	cd ./src/search; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" -f msearch.mk install
	cd ./src/setup; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" -f setup.mk install
	cd ./src/astgen; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) FFLAG=$(FFLAG) "INS=$(INS)" INCLUDE=$(INCLUDE) CURSES=$(CURSES) -f tools.mk install
	$(CH)chmod 755 $(BINDIR); chgrp bin $(BINDIR); chown bin $(BINDIR)
	$(CH)chmod 755 $(LIBDIR); chgrp bin $(LIBDIR); chown bin $(LIBDIR)
########################################################################
#
#	NOTE: The next section creates an edit script
#		to automatically change assist.sh to
#		point to the bin and lib directories
#		and then installs assist.sh in the bin
#		directory as assist.  If the format
#		of assist.sh changes, it is necessary to
#		check the next section for possible changes.
#
########################################################################
	@echo "/^ASSISTLIB" > ./assist.edit
	@echo "s;=.*;=$(ALIBDIR)" >> ./assist.edit
	@echo "/^ASSISTBIN" >> ./assist.edit
	@echo "s;=.*;=$(ABINDIR)" >> ./assist.edit
	@echo "w assist" >> ./assist.edit
	@echo "q" >> ./assist.edit
	ed ./src/assist.sh < ./assist.edit > /dev/null
	@rm ./assist.edit
	$(INS)  assist $(INSDIR)/assist
	chmod 755 $(INSDIR)/assist
	chgrp bin $(INSDIR)/assist
	chown bin $(INSDIR)/assist
########################################################################
#
#	NOTE: The next section creates an edit script
#		to automatically change astgen.sh to
#		point to the bin and lib directories
#		and then installs astgen.sh in the bin
#		directory as astgen.  If the format
#		of astgen.sh changes, it is necessary to
#		check the next section for possible changes.
#
########################################################################
	@echo "/^ASSISTLIB" > ./astgen.edit
	@echo "s;=.*;=$(ALIBDIR)" >> ./astgen.edit
	@echo "/^ASSISTBIN" >> ./astgen.edit
	@echo "s;=.*;=$(ABINDIR)" >> ./astgen.edit
	@echo "w astgen" >> ./astgen.edit
	@echo "q" >> ./astgen.edit
	ed ./src/astgen.sh < ./astgen.edit > /dev/null
	@rm ./astgen.edit
	$(INS) astgen $(INSDIR)/astgen
	chmod 755 $(INSDIR)/astgen
	chgrp bin $(INSDIR)/astgen
	chown bin $(INSDIR)/astgen

clobber:
	cd ./lib/forms; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f forms.mk clobber
	cd ./lib/scripts; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f scripts.mk clobber
	cd ./lib/search; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f search.mk clobber
	cd ./lib/setup; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f setup.mk clobber
	cd ./lib/astgen; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f tools.mk clobber
	cd ./src/forms; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f forms.mk clobber
	cd ./src/scripts; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f mscript.mk clobber
	cd ./src/search; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f msearch.mk clobber
	cd ./src/setup; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f setup.mk clobber
	cd ./src/astgen; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f tools.mk clobber
	-rm -f assist astgen

clean:
	cd ./lib/forms; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f forms.mk clean
	cd ./lib/scripts; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f scripts.mk clean
	cd ./lib/search; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f search.mk clean
	cd ./lib/setup; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f setup.mk clean
	cd ./lib/astgen; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f tools.mk clean
	cd ./src/forms; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f forms.mk clean
	cd ./src/scripts; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f mscript.mk clean
	cd ./src/search; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f msearch.mk clean
	cd ./src/setup; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f setup.mk clean
	cd ./src/astgen; $(MAKE) -e$(MAKEFLAGS) LIBDIR=$(LIBDIR) BINDIR=$(BINDIR) -f tools.mk clean

$(BINDIR):
	if [ ! -d `dirname $(BINDIR)` ] ;\
	then \
		mkdir `dirname $(BINDIR)` ;\
	fi
	if [ ! -d $(BINDIR) ] ;\
	then \
		mkdir $(BINDIR) ;\
	fi

$(LIBDIR):
	if [ ! -d `dirname $(LIBDIR)` ] ;\
	then \
		mkdir `dirname $(LIBDIR)` ;\
	fi
	if [ ! -d $(LIBDIR) ] ;\
	then \
		mkdir $(LIBDIR) ;\
	fi
