#	START NEW ARIX SCCS HEADER
#
#	@(#) adm.mk: version 25.1 created on 12/2/91 at 13:30:22
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)adm.mk	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#	Copyright (c) 1984 AT&T
#	  All Rights Reserved

#	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T
#	The copyright notice above does not evidence any
#	actual or intended publication of such source code.

#	ATT:#ident	"adm:.adm.mk	1.18.1.2"

#ident	"@(#)adm:adm.mk	25.1"

IROOT =
SROOT =
include $(IROOT)/macdefs

LIB = $(ROOT)/usr/lib
CRONTABS = $(ROOT)/usr/spool/cron/crontabs
LIBCRON = $(LIB)/cron
INSDIR = $(ROOT)/etc
RFSDIR = $(ROOT)/usr/nserve
TOUCH=/bin/touch

CRON_ENT= adm root sys sysadm uucp

CRON_LIB= proto at.allow cron.allow queuedefs

ETC_SCRIPTS= filesave gettydefs group ioctl.syscon machid \
	     motd passwd tapesave

RFS_SCRIPTS= rfmaster.df

all install:	etc_scripts crontab cronlib

crontab: $(CRON_ENT)

cronlib: $(CRON_LIB)

etc_scripts: $(ETC_SCRIPTS)

rfs_scripts: $(RFS_SCRIPTS)

clean:

clobber:

adm::
	$(INS) adm $(CRONTABS)/adm
	chmod 644 $(CRONTABS)/adm
	chgrp sys $(CRONTABS)/adm
	$(TOUCH) 0101000070 $(CRONTABS)/adm
	chown root $(CRONTABS)/adm

root::
	$(INS) root $(CRONTABS)/root
	chmod 644 $(CRONTABS)/root
	chgrp sys $(CRONTABS)/root
	$(TOUCH) 0101000070 $(CRONTABS)/root
	chown root $(CRONTABS)/root

sys::
	$(INS) sys $(CRONTABS)/sys
	chmod 644 $(CRONTABS)/sys
	chgrp sys $(CRONTABS)/sys
	$(TOUCH) 0101000070 $(CRONTABS)/sys
	chown root $(CRONTABS)/sys

sysadm::
	$(INS) sysadm $(CRONTABS)/sysadm
	chmod 644 $(CRONTABS)/sysadm
	chgrp sys $(CRONTABS)/sysadm
	$(TOUCH) 0101000070 $(CRONTABS)/sysadm
	chown root $(CRONTABS)/sysadm

uucp::
	$(INS) uucp $(CRONTABS)/uucp
	chmod 644 $(CRONTABS)/uucp
	chgrp sys $(CRONTABS)/uucp
	$(TOUCH) 0101000070 $(CRONTABS)/uucp
	chown root $(CRONTABS)/uucp

proto::
	$(INS) proto $(LIBCRON)/.proto
	chmod 744 $(LIBCRON)/.proto
	chgrp sys $(LIBCRON)/.proto
	$(TOUCH) 0101000070 $(LIBCRON)/.proto
	chown root $(LIBCRON)/.proto

at.allow::
	$(INS) at.allow $(LIBCRON)/at.allow
	chmod 644 $(LIBCRON)/at.allow
	chgrp sys $(LIBCRON)/at.allow
	$(TOUCH) 0101000070 $(LIBCRON)/at.allow
	chown root $(LIBCRON)/at.allow

cron.allow::
	$(INS) cron.allow $(LIBCRON)/cron.allow
	chmod 644 $(LIBCRON)/cron.allow
	chgrp sys $(LIBCRON)/cron.allow
	$(TOUCH) 0101000070 $(LIBCRON)/cron.allow
	chown root $(LIBCRON)/cron.allow

queuedefs::
	$(INS) queuedefs $(LIBCRON)/queuedefs
	chmod 644 $(LIBCRON)/queuedefs
	chgrp sys $(LIBCRON)/queuedefs
	$(TOUCH) 0101000070 $(LIBCRON)/queuedefs
	chown root $(LIBCRON)/queuedefs


bcheckrc::
	$(INS) bcheckrc.sh $(INSDIR)/bcheckrc
	chmod 744 $(INSDIR)/bcheckrc
	chgrp sys $(INSDIR)/bcheckrc
	$(TOUCH) 0101000070 $(INSDIR)/bcheckrc
	chown root $(INSDIR)/bcheckrc

brc::
	$(INS) brc.sh $(INSDIR)/brc
	chmod 744 $(INSDIR)/brc
	chgrp sys $(INSDIR)/brc
	$(TOUCH) 0101000070 $(INSDIR)/brc
	chown root $(INSDIR)/brc

checkall::
	$(INS) checkall.sh $(INSDIR)/checkall
	chmod 744 $(INSDIR)/checkall
	chgrp bin $(INSDIR)/checkall
	$(TOUCH) 0101000070 $(INSDIR)/checkall
	chown bin $(INSDIR)/checkall

checklist::
	$(INS) checklist $(INSDIR)/checklist
	chmod 664 $(INSDIR)/checklist
	chgrp sys $(INSDIR)/checklist
	$(TOUCH) 0101000070 $(INSDIR)/checklist
	chown root $(INSDIR)/checklist

filesave::
	$(INS) filesave.sh $(INSDIR)/filesave
	chmod 744 $(INSDIR)/filesave
	chgrp sys $(INSDIR)/filesave
	$(TOUCH) 0101000070 $(INSDIR)/filesave
	chown root $(INSDIR)/filesave
	echo "" > $(INSDIR)/log/filesave.log
	chmod 666 $(INSDIR)/log/filesave.log
	chgrp bin $(INSDIR)/log/filesave.log
	chown bin $(INSDIR)/log/filesave.log


gettydefs::
	$(INS) mach/gettydefs $(INSDIR)/gettydefs
	chmod 644 $(INSDIR)/gettydefs
	chgrp sys $(INSDIR)/gettydefs
	$(TOUCH) 0101000070 $(INSDIR)/gettydefs
	chown root $(INSDIR)/gettydefs

group::
	$(INS) group $(INSDIR)/group
	chmod 644 $(INSDIR)/group
	chgrp sys $(INSDIR)/group
	$(TOUCH) 0101000070 $(INSDIR)/group
	chown root $(INSDIR)/group

ioctl.syscon::
	$(INS) mach/ioctl.syscon $(INSDIR)/ioctl.syscon
	chmod 644 $(INSDIR)/ioctl.syscon
	chgrp sys $(INSDIR)/ioctl.syscon
	$(TOUCH) 0101000070 $(INSDIR)/ioctl.syscon
	chown root $(INSDIR)/ioctl.syscon

machid::
	for i in m68k M68020 M68040 pdp11 u3b u3b5 vax ;              \
	do                                                            \
		rm -f $(ROOT)/bin/$$i ;                               \
		if [ "$$i" = "$(MACH)" -o "$$i" = "$(FAMILY)" ] ;     \
		then                                                  \
			$(INS) ../t/true.sh  $(ROOT)/bin/$$i ;        \
		else                                                  \
			$(INS) ../f/false.sh $(ROOT)/bin/$$i ;        \
		fi ;                                                  \
		chmod 755 $(ROOT)/bin/$$i ;                           \
		chown bin $(ROOT)/bin/$$i ;                           \
		chgrp bin $(ROOT)/bin/$$i ;                           \
	done

master::
	$(INS) master $(INSDIR)/master
	chmod 644 $(INSDIR)/master
	chgrp sys $(INSDIR)/master
	chown root $(INSDIR)/master

motd::
	sed 1d mach/motd > $(INSDIR)/motd
	chmod 644 $(INSDIR)/motd
	chgrp sys $(INSDIR)/motd
	chown root $(INSDIR)/motd

passwd::
	$(INS) mach/passwd $(INSDIR)/passwd
	chmod 444 $(INSDIR)/passwd
	chgrp sys $(INSDIR)/passwd
	$(TOUCH) 0101000070 $(INSDIR)/passwd
	chown root $(INSDIR)/passwd

passwd.shad::
	$(INS) mach/passwd.shad $(ROOT)/etc/security/passwd
	chmod 600 $(ROOT)/etc/security/passwd
	chgrp sys $(ROOT)/etc/security/passwd
	$(TOUCH) 0101000070 $(ROOT)/etc/security/passwd
	chown root $(ROOT)/etc/security/passwd

powerfail::
	$(INS) powerfail.sh $(INSDIR)/powerfail
	chmod 744 $(INSDIR)/powerfail
	chgrp sys $(INSDIR)/powerfail
	$(TOUCH) 0101000070 $(INSDIR)/powerfail
	chown root $(INSDIR)/powerfail

rc::
	$(INS) rc.sh $(INSDIR)/rc
	chmod 744 $(INSDIR)/rc
	chgrp sys $(INSDIR)/rc
	$(TOUCH) 0101000070 $(INSDIR)/rc
	chown root $(INSDIR)/rc

shutdown::
	$(INS) shutdown.sh $(INSDIR)/shutdown
	chmod 744 $(INSDIR)/shutdown
	chgrp sys $(INSDIR)/shutdown
	$(TOUCH) 0101000070 $(INSDIR)/shutdown
	chown root $(INSDIR)/shutdown

tapesave::
	$(INS) tapesave.sh $(INSDIR)/tapesave
	chmod 744 $(INSDIR)/tapesave
	chgrp sys $(INSDIR)/tapesave
	$(TOUCH) 0101000070 $(INSDIR)/tapesave
	chown root $(INSDIR)/tapesave

rfmaster.df::
	$(INS) mach/rfmaster.df $(RFSDIR)/rfmaster.df
	chmod 644 $(RFSDIR)/rfmaster.df
	chgrp sys $(RFSDIR)/rfmaster.df
	chown root $(RFSDIR)/rfmaster.df

