/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) getacl.c: version 25.1 created on 12/2/91 at 13:29:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)getacl.c	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*	Copyright (c) 1989 ARIX	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF ARIX	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	ARIX:#ident	"getacl:getacl.c	1.1"		*/

#ident	"@(#)getacl:getacl.c	25.1"

/* getacl - Retrieves an ACL block from a file */
/* Written 10-89, mer */

#include <sys/types.h>
#include <stdio.h>
#include <limits.h>
#include <sys/stat.h>
#include <pwd.h>
#include <grp.h>
#include <sys/acl.h>
#include <time.h>

void	display_acl ();
struct	passwd	*getpwuid ();
struct	group	*getgrgid ();
char	*malloc ();
extern	char	*optarg;
extern	int	optind;
void adjust_for_tz();

/* This is used to determine the name of the ACL type */
char	*acl_name [4] = {
		"A_USER",
		"A_GROUP",
		"A_TIME",
		"A_DATE" };

main (argc, argv)
int	argc;
char	**argv;
{
	char	*file_name;		/* File whose ACL is to be retrieved */
	char	*acl_buf;		/* Where the retrieved ACL data will be
					   stored */
	int	opt, deflt;		/* Print default acls for a directory */
	struct stat acl_stat;		/* The stat on the ACL is stored here */
	struct stat stbf;

	if (argc < 2)

		usage ();

	while( (opt = getopt( argc, argv, "d")) != EOF ) {

		switch (opt) {

		case 'd':
			deflt++;
			break;

		default:
			usage();
			break;
		}
	}

	if (argc == optind)

		usage();

	else

		file_name = argv [optind];

	/* Check if file exists */
	if ( access (file_name, 00) == -1){

		fprintf (stderr, "%s: %s - does not exist\n", argv[0],
			 file_name);
		exit (1);
	}

	/* If the -d option is chosen, make sure the file is a directory */
	if ( deflt ) {

		if ( stat ( file_name, &stbf ) == -1){

			fprintf (stderr, "%s: Cannot stat %s\n", argv[0],
				 file_name);
			exit (1);
		}

		if ( (stbf.st_mode & S_IFMT) != S_IFDIR ) {

			fprintf (stderr, "%s: %s - not a directory\n", argv[0],
				 file_name);
			exit (1);
		}
	}
	/* Check if file has an ACL */
	if ( acl (file_name, deflt ? ACLSTAT_DEFAULT : ACLSTAT, &acl_stat) 
	     == -1){

		fprintf (stderr, "%s: %s has no %s acl associated with it\n",
			 argv[0], file_name, deflt ? "default" : "");
		exit (1);
	}

	/* Allocate memory for ACL to be read into */
	if ( (acl_buf = malloc (acl_stat.st_size)) == (char *)-1){

		fprintf (stderr, "%s: Unable to allocate memory\n", argv[0]);
		exit (1);
	}

	/* Retrieve the ACL */
	if ( acl (file_name, deflt ? GETACL_DEFAULT : GETACL, acl_buf, acl_stat.st_size) == -1){

		fprintf (stderr, "%s: Unable to get ACL for file %s\n", argv[0],
			 file_name);
		exit (1);
	}

	display_acl (acl_buf, acl_stat.st_size);
}


/* Takes a buffer with an ACL in it, parses & displays it.  This routine
   displays ACL type by its mnemonic, and will display the user & group
   name if possible, as well as the ACL data */

void
display_acl (buffer, buf_size)
char	*buffer;		/* The ACL is stored here */
off_t	buf_size;		/* The size of the ACL */
{
	acl_t *next;
	struct	passwd *pw;
	struct	group  *grp;
	struct	tm  t_start;
	struct	tm  t_end;
	char	name [128], group [128];

	while (buf_size){

		/* The type of ACL determines how its data will be
		   displayed */
		next = (acl_t *)buffer;
		buffer += sizeof (acl_t );
		buf_size -= sizeof (acl_t );

		switch ( next->type){
			case A_USER:
			    fprintf (stdout, "%s ", acl_name [(int)next->type - 
				     1]);
			    pw = getpwuid ( (int)next->id );
			    if (pw)

				fprintf (stdout, "%s ", pw->pw_name);

			    else

				fprintf (stdout, "%d ", (int)next->id);

			    fprintf (stdout, "%o ", next->mode); 
			    adjust_for_tz(next->hour_start, next->hour_end, 
				next->day_start, next->day_end);
			    break;

			case A_GROUP:
			    grp = getgrgid ( (int)next->id );
			    fprintf (stdout, "%s ", acl_name [(int)next->type - 1]);
			    if (grp)

				fprintf (stdout, "%s ", grp->gr_name);

			    else

				fprintf (stdout, "%d ", (int)next->id);

			    fprintf (stdout, "%o ", next->mode);
			    adjust_for_tz( next->hour_start, next->hour_end, 
				next->day_start, next->day_end);
			    break;

			case A_TIME:
			    fprintf (stdout, "%s ", 
			       acl_name [(int)next->type - 1]);
			    adjust_for_tz(next->hour_start,next->hour_end,
			                  next->day_start, next->day_end);
			    break;
			
			case A_DATE:
				t_start = *localtime(&(next->date_start));
				t_end = *localtime(&(next->date_end));
			    fprintf (stderr, "%s %.2d/%.2d/%.2d %.2d/%.2d/%.2d\n",
				  acl_name [(int)next->type - 1], 
				  (t_start.tm_mon+1),t_start.tm_mday,t_start.tm_year,
				  (t_end.tm_mon+1),t_end.tm_mday,t_end.tm_year);
				break;

			default:
			    fprintf (stderr, "Unknown type code = %d -- unable to continue\n",
				next->type);
			    exit (1);
		}
	}

	return;
}


int
usage ()
{
	fprintf (stderr, "Usage: getacl file_name | -d directory\n");
	exit (1);
}

void
adjust_for_tz(st_hr,end_hr,st_day,end_day)
ushort st_hr,end_hr,st_day,end_day;
{

ushort tmp, hours_diff;
time_t tloc;
struct tm *junk;

	tloc = time(0);
	junk = localtime(&tloc);    /*all this just to get timezone*/

	hours_diff = timezone / (60*60);

        if ((tmp = (st_hr + ( 24 -  hours_diff)) % 24) > st_hr)
		st_day = (st_day + 6) % 7;
	st_hr = tmp;
        if ((tmp = (end_hr + (24 - hours_diff)) % 24) > end_hr)
		end_day = (end_day + 6) % 7;
        end_hr = tmp;

	fprintf (stdout, "%d %d %d %d\n", st_hr,end_hr,st_day,end_day);
	
}
