/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) acctdef.h: version 25.1 created on 12/2/91 at 13:26:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)acctdef.h	25.1	12/2/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/* AT&T	#ident	"acct:acctdef.h	1.10"			*/
#ident "@(#)acct:acctdef.h	1.1"

/*
 *	defines, typedefs, etc. used by acct programs
 */


/*
 *	acct only typedefs
 */
typedef	unsigned short	uid_t;

#if u3b || u3b15 || u3b2
#define HZ	100
#else
#ifndef HZ
#define HZ	50
#endif
#endif

#define LSZ	12	/* sizeof line name */
#define NSZ	8	/* sizeof login name */
#define P	0	/* prime time */
#define NP	1	/* nonprime time */

/*
 *	limits which may have to be increased if systems get larger
 */
#define A_SSIZE	1000	/* max number of sessions in 1 acct run */
#define A_TSIZE	128	/* max number of line names in 1 acct run */
#define A_USIZE	500	/* max number of distinct login names in 1 acct run */

#define EQN(s1, s2)	(strncmp(s1, s2, sizeof(s1)) == 0)
#define CPYN(s1, s2)	strncpy(s1, s2, sizeof(s1))

#define SECSINDAY	86400L
#define SECS(tics)	((double) tics)/HZ
#define MINS(secs)	((double) secs)/60
#define MINT(tics)	((double) tics)/(60*HZ)

#ifdef pdp11
#define KCORE(clicks)	((double) clicks/16)
#endif
#if m68 || m68k || M68020
#define KCORE(clicks)	((double) clicks/16)
#endif
#ifdef vax
#define KCORE(clicks)	((double) clicks/2)
#endif
#if u3b || u3b15 || u3b2
#define KCORE(clicks)	((double) clicks*2)
#endif
