/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) gets.c: version 25.1 created on 11/27/91 at 15:42:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)gets.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* get a line of input from console: call getchar which calls xgetchar
 * routine xgetchar echoes the character, changes carriage return
 *   to line feed and echoes carriage return line feed.
 * continue getting characters and store them into buf until a line feed 
 * or carriage return is received.
 * take care character delete \b or #
 * take care line delete character  @
 * user will never get carriage return in the buf 
 */

int
gets(buf)
char	*buf;
{
	register char	*lp;
	register int	c, count;

	lp = buf;
	count = 0;
	for (;;) {
		c = getchar() & 0x7f;	/* only take 7 bits */

		/* if last character is \ and that is not first character */
		/* backup one space */

		if (lp > buf && *(lp-1) == '\\') {
			--lp;
			if (c >= 'a' && c <= 'z')
				c += 'A' - 'a';
		}

		switch(c) {
		case '\n':
		case '\r':
			c = '\n';
			*lp++ = '\0';
			return( count );
		case '\b':
			putchar(' ');	/* overwrite old character */
			putchar('\b');
			if (lp <= buf)
				lp = buf;
			else	{
				count--;
				lp--;
			}
			continue;
		case '\025':	/* ^U */
		case '\030':	/* ^X */
			count = 0;
			lp = buf;
			putchar('\n');
			continue;
		case '\033':
			lp = buf;
			*lp = '\0';
			putchar('\n');
			return( -1 );
		default:
			count++;
			*lp++ = c;
		}
	}
}

