/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) get_dev.c: version 25.1 created on 11/27/91 at 15:42:34	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)get_dev.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/sbus.h"
#include "sys/iunit.h"
#include "ctype.h"
#include "dev.h"

#ifndef NULL
#define NULL	(0)
#endif

/* These values should be the largest expected from all possible controllers */
#define MAX_TAPE_DRIVE_NUM	14
#define MAX_DISK_DRIVE_NUM	14
#define MAX_LOGICAL_DRIVE_NUM	31

uint	i_unit_set(),
	i_unit_get(),
	get_device_name(),
	get_device_info();

extern long	strtol();

#ifdef TEST
main()
{
	uint	dev_type;
	iunit_t	unit;
	char	*p;
	char	dev_name[DEV_NAMLEN];
	char	filename[DEV_NAMLEN];

	while (1) {
		printf("Enter Device Name : ");
		gets(dev_name);
		dev_type = get_device_info(dev_name, &unit, &p);
		strcpy(filename, p);
		printf("info - device %s : type %#x; unit %#x; filename %s\n", 
			dev_name, dev_type, unit.i, filename);
		
		printf("Enter Device Name : ");
		dev_type = get_device_name(dev_name);
		printf("name - device %s : type %#x\n", dev_name, dev_type);
	}
}
#endif

uint
get_device_name(dev_name)
char	*dev_name;
{
	iunit_t	unit;

	gets(dev_name);
	return(get_device_info(dev_name, &unit, NULL));
}

/*
 * gd_info_err -- print out more illuminating error message
 */

static void
gd_info_err(path, ptr, msg)
char	*path, *ptr, *msg;
{
	printf("ERROR: %s:\n%s\n%*s^\n", msg, path, ptr - path, "");
}

/*
 * get_device_info(path, unit, filename)
 *
 * unit - ALTERED by this routine, will contain an i_unit.
 * filename - ALTERED by this routine, will point to file name if there is one,
 *		or will be set to NULL if not.  Filename may be NULL.
 */
uint
get_device_info(path, unit, filename)
char	*path;
iunit_t	*unit;
char	**filename;
{
	register uint	slot;
	register uint	type, pd, ld;
	register char	*str = path;
	char		*p;

	type = DV_NO_DEV;			/* default error code */
	ld = IUNIT_NONE;
	pd = IUNIT_NONE;
	unit->i = IUNIT_NO_DEV;

	if (filename)
		*filename = NULL;

	while (isspace(*str)) {
		++str;
		++path;				/* eat leading white space */
	}
	if (*str == '?')
		return(DV_HELP_REQUEST);

	if (!isdigit(*str)) {
		gd_info_err(path, str,
		  "Device specifications must begin with a CSS slot number");
		return(type);
	}
	p = str;
	slot = strtol(str, &p, 10);
	if (slot >= SBUS_NUM_SLOT || (slot == 0 && p == str)) {
		gd_info_err(path, str, "Invalid CSS slot number");
		return(type);
	}
	unit->s.slot = slot;

	str = p;
	if (*str == '/') {
		p = ++str;
		if (!isdigit(*str) ||
		    (slot = strtol(str, &p, 10)) >= SBUS_NUM_SLOT ||
		    (slot == 0 && p == str)) {
			/* special case for DPM40s */
			if (str[1] == '\0' &&
			    ((slot = tolower(*str)) == 'a' || slot == 'b')) {
				unit->s.subslot =
				  (slot == 'a' ? NO_SUB_SLOT : 1);
				return(DV_SLOT);
			}
			gd_info_err(path, str, "Invalid subslot number");
			return(type);
		}
		str = p;
	}
	else 
		slot = NO_SUB_SLOT;

	unit->s.subslot = slot;

	switch (*str) {
	case 'm':
	case 'n':
		ld = (*str == 'm') ? DV_MT : DV_9T;
		if (*++str != 't') {
			gd_info_err(path, str,
			  "Incorrect tape device specification");
			return(type);
		}
		p = ++str;
		if (!isdigit(*str) ||
		    (pd = strtol(str, &p, 10)) == 0 && p == str) {
			gd_info_err(path, str,
			  "Must specify tape drive number");
			return(type);
		}
		if (pd > MAX_TAPE_DRIVE_NUM) {
			gd_info_err(path, str, "Invalid tape drive number");
			return(type);
		}
		str = p;
		type = ld;
		ld = IUNIT_NONE;
		break;

	case 'd':
		p = ++str;
		if (!isdigit(*str) ||
		    (pd = strtol(str, &p, 10)) == 0 && p == str) {
			gd_info_err(path, str,
			  "Must specify disk drive number");
			return(type);
		}
		if (pd > MAX_DISK_DRIVE_NUM) {
			gd_info_err(path, str, "Invalid disk drive number");
			return(type);
		}
		str = p;

		switch (*str) {
		case 's':
			p = ++str;
			if (!isdigit(*str) ||
			    (ld = strtol(str, &p, 10)) == 0 && p == str) {
				gd_info_err(path, str,
				  "Must specify a logical drive number");
				return(type);
			}
			if (ld > MAX_LOGICAL_DRIVE_NUM) {
				gd_info_err(path, str, "Invalid logical drive");
				return(DV_NO_DEV);
			}
			type = DV_DK;
			str = p;
			break;
		case 'r':
			if (*++str != 'v') {
				gd_info_err(path, str,
				  "Bad reserved area specification");
				return(type);
			}
			++str;
			type = DV_RV;
			break;
		case '\0':
			type = DV_RV;
			break;
		default: 
			gd_info_err(path, str,
			  "Incorrect disk device specification");
			return(type);
		}
		break;
	case '\0':
		type = DV_SLOT;
		break;
	default: 
		gd_info_err(path, str, "Unknown device type specification");
		return(type);
	}
	if (filename)
		*filename = str;
	unit->s.phys = pd;
	unit->s.log = ld;

	return(type);
}

uint
i_unit_set(i_unit, field, value)
iunit_t	*i_unit;
uint	field, value;
{
	switch (field) {
	case I_UNIT_CSS_SLOT:
		i_unit->s.slot = (uchar)value;
		break;
	case I_UNIT_SUB_SLOT:
		i_unit->s.subslot = (uchar)value;
		break;
	case I_UNIT_PD_NUM:
		i_unit->s.phys = (uchar)value;
		break;
	case I_UNIT_LD_NUM:
		i_unit->s.log = (uchar)value;
		break;
	default:
		return(~0);
	}
	return(0);
}

uint
i_unit_get(i_unit, field)
iunit_t	i_unit;
uint	field;
{
	switch (field) {
	case I_UNIT_CSS_SLOT:
		return(i_unit.s.slot);
	case I_UNIT_SUB_SLOT:
		return(i_unit.s.subslot);
	case I_UNIT_PD_NUM:
		return(i_unit.s.phys);
	case I_UNIT_LD_NUM:
		return(i_unit.s.log);
	case I_UNIT_DEV_NUM:
		return((i_unit.s.phys << 4) | i_unit.s.log);
	case I_UNIT_IOSLOT:
		/* Extract slot and subslot, return as one 8-bit number. */
		return((i_unit.s.slot << 4) | (i_unit.s.subslot & 0x0f));
	}
	return (~0);
}


static char	*help_message[] = {
"",
"Device names are of the form X[/Y]mtZ, X[/Y]dZ, or X[/Y]dZsN, where:",
"  X = CSS slot number (the slot where the controller or IOM resides),",
"  Y = optional sub-slot number (the controller's slot in the expansion box),",
"  \"mtZ\" is a cartridge tape device, where Z is the drive ID,",
"  \"dZ\" is an entire disk drive (Z is the drive's ID number).",
"  \"dZsN\" is a disk slice (Z is the drive ID, N is the slice number).",
"Examples of possible names:  15mt3, 7/12mt0, 4d11, 7/2d8, 6d0s0, 9/14d10s2",
"",
"Disk controllers:",
"",
0
};

dev_help_message()
{
	int	i;

	for (i = 0; help_message[i]; i++) {
		printf("%s\n", help_message[i]);
	}
	showcont();
}
