/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) charfunc.c: version 25.1 created on 11/27/91 at 15:42:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)charfunc.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/******************************************************************************
 *
 * charfunc.c -- various character functions for those without ctype.h
 *
 ******************************************************************************/

#include "ctype.h"

#undef	isalpha
#undef	isupper
#undef	islower
#undef	isdigit
#undef	isxdigit
#undef	isalnum
#undef	isspace
#undef	ispunct
#undef	isprint
#undef	isgraph
#undef	iscntrl
#undef	isascii
#undef	_toupper
#undef	_tolower
#undef	toascii

isdelimit(c)
register char c;
{
	switch (c) {
		case ' ':
		case ';':
        case   0:
            return(1);
        default:
            return(0);
	}
}

ishexnum(c)
register int c;
{
    return (isxdigit(c));
}

isalpha(c)
register int c;
{
    return ((_ctype + 1)[c] & (_U | _L));
}

isupper(c)
register int c;
{
    return ((_ctype + 1)[c] & _U);
}

islower(c)
register int c;
{
    return ((_ctype + 1)[c] & _L);
}

isdigit(c)
register int c;
{
    return ((_ctype + 1)[c] & _N);
}

isxdigit(c)
register int c;
{
    return ((_ctype + 1)[c] & _X);
}

isalnum(c)
register int c;
{
    return ((_ctype + 1)[c] & (_U | _L | _N));
}

isspace(c)
register int c;
{
    return ((_ctype + 1)[c] & _S);
}

ispunct(c)
register int c;
{
    return ((_ctype + 1)[c] & _P);
}

isprint(c)
register int c;
{
    return ((_ctype + 1)[c] & (_P | _U | _L | _N | _B));
}

isgraph(c)
register int c;
{
    return ((_ctype + 1)[c] & (_P | _U | _L | _N));
}

iscntrl(c)
register int c;
{
    return ((_ctype + 1)[c] & _C);
}

isascii(c)
register int c;
{
    return (!((c) & ~0177));
}

_toupper(c)
register int c;
{
    return ((_ctype + 258)[c]);
}

_tolower(c)
register int c;
{
    return ((_ctype + 258)[c]);
}

toascii(c)
register int c;
{
    return ((c) & 0177);
}

asc_to_hex(c)
register char c;
{
    if (isdigit(c))
        return (c - '0');
    if (c >= 'A' && c <= 'F')
        return (c + (10 - 'A'));
    if (c >= 'a' && c <= 'f')
        return (c + (10 - 'a'));
    return (-1);
}

#ifdef TESTING

char cs[80];

main()
{
        register char *c;

        printf("String: ");
        gets(cs);
        for (c = cs; *c; c++) {
            printf("%c is ", *c);
            if (isupper(*c))
                printf("Upper ");
            if (islower(*c))
                printf("Lower ");
            if (isalpha(*c))
                printf("Alpha ");
            if (isxdigit(*c))
                if (isdigit(*c))
                    printf("Digit ");
                else
                    printf("Hex digit ");
            if (isalnum(*c))
                printf("Alnum ");
            if (isspace(*c))
                printf("Space ");
            if (ispunct(*c))
                printf("Punctuation ");
            if (isprint(*c))
                printf("Printable ");
            if (isgraph(*c))
                printf("Graph ");
            if (iscntrl(*c))
                printf("Control ");
            if (isascii(*c))
                printf("Ascii ");
	    printf("upper/lower=%c ", _toupper(*c));
            printf("\n");
        }
}
#endif
