/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tty_mach.c: version 25.1 created on 11/27/91 at 15:41:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tty_mach.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *	03-02-90 - gh00 - keep copy of hardware dtr regs (hardware write only)
 *			- set  'ms_start' and 'ms_stop' even if IXON not set
 */
#include <sys/types.h>
#include <sys/termio.h>
#include <sys/tyd_sram.h>
#include <sys/spm_mem.h>
#include "spm_tty.h"
#include "octart.h"
#include "memdev.h"

extern int	ms_size;
extern uint	ms_code[];

#define T_DCD			0x400	/* data carrier detect (DCD) */
#define T_DSR			0x800	/* data set ready (DSR)*/

char	dtr_reg_copy[(NUM_SPM_TTYS+7)/8];  /* one byte per octart (8 ports) */

ms_init()
{
	static uint	ms_initialized;

	register uchar	*ptr,
			*iptr,
			*msptr;
	register uint 	i, 
			count;
	struct ms_ctl 	*ms_ctl_ptr;
	uint 		tmp, 
			first_port, 
			last_port, 
			j, 
			mask;

	if (ms_initialized++)
		return;		

	/* keep board halted, set RESET = 0 to reset board */

	*SRAM_CONTROL_REG = 0;		/* !RESET resets device board */

	for (i = 0; i < 10; i++)
		;			/* wait for board to complete reset */

	/* now set RESET bit to enable access to uSeq code space */

	*SRAM_CONTROL_REG = SRAM_CTL_RESET;	/*disable RESET */


	/* 
	 * must load MS code a char at a time - bus is only 8 bits wide!
	 */
	iptr = (uchar *)START_OF_SRAM_CODE;
	msptr = (uchar *)&ms_code[0];

	for (i = 0; i < ms_size * (sizeof(int) / sizeof(char)); i++)
		*(iptr++) = *(msptr++);		/* load uSeq code */

	/* 
	 * now set SEQEN bit to enable access to buffers
	 */
	*SRAM_CONTROL_REG = SRAM_CTL_RESET |	/*disable RESET */
			    SRAM_CTL_SEQEN|	/*allow access to sram buffers*/
			    0;			/* !HALT keep useq halted */

	*SRAM_CONTROL_REG = 0;		/*!RESET resets device board */
	*SRAM_CONTROL_REG = SRAM_CTL_RESET;	/*disable RESET */
	*SRAM_CONTROL_REG = SRAM_CTL_RESET |	/*disable RESET */
			    SRAM_CTL_SEQEN|	/*allow access to sram buffers*/
			    0;			/* !HALT keep useq halted */

	ptr = START_OF_SRAM_SPEC_TAB;
	count = NUM_SPM_TTYS * 32;		/* 32 bytes per port */
	for (i = 0; i < count; i++)
		*(ptr++) = 0;		/*clear special char tbl for each port*/

	/* FIX THIS, HH - UGLY!!!!! */
	ptr = (uchar *)START_OF_SRAM_BUF - 0x100;
	count = (NUM_SPM_TTYS + 8) * sizeof(struct ms_ctl);
	for (i = 0; i < count; i++)
		*(ptr++) = 0;		/*clear control tbls for each port */

	/* 
	 * check to see how many (and which) ace cards are plugged in 
	 * xxxxx110 = ace # 1
	 * xxxxx101 = ace # 2
	 * xxxxx011 = ace # 3 
	 */
	for (i = 0, ptr = ACE_ID; i < 3; i++, ptr += ACE_SIZE) {

		tmp = *ptr;
		tmp = (~tmp) & 7;
		mask = 1 << i;		/* check for 001, 010, 100 */
		if (tmp != mask) {	/* This ACE does not exist */

			first_port = i * TYD_PORTS_PER_ACE + NUM_ACRW_PORTS;
			last_port = first_port + TYD_PORTS_PER_ACE;
			ms_ctl_ptr = (struct ms_ctl *)START_OF_SRAM_BUF;
			ms_ctl_ptr += first_port;

			for (j = first_port; j < last_port; j++, ms_ctl_ptr++)
				/* 
				 * flag port as not available
				 */
				ms_ctl_ptr->ms_status |= MSS_DISABLED;
		}
	}

	ptr = (uchar *)START_OF_SRAM_INPUT;
	count = NUM_SPM_TTYS * SPM_TTY_BUFSIZE;
	for (i = 0; i < count; i++)
		*(ptr++) = 0;		/*clear buffers for each port */

	ptr = START_OF_OCTARTS - OCTART_SIZE;

	for (i = 0; i < NUM_SPM_TTYS/8; i+=2) {	/* turn off loopback */
		*(ptr + UT_LOOP_OFFSET) = 0x0f;
		ptr += 2 * OCTART_SIZE;
	}

	ptr =  START_OF_OCTARTS;
	for (i = 0; i < NUM_SPM_TTYS/8; i++) {
		dtr_reg_copy[i] = 0xff;		/* drop our copy of 8-port dtr*/
		*(ptr + UT_DTR_OFFSET) = 0xff;	/*drop dtr for 8 ports */
		ptr += OCTART_SIZE;
	}

	*SRAM_CONTROL_REG = SRAM_CTL_PC_TO_0 |	/*allow pc counter to advance*/
			    SRAM_CTL_HALT |	/* don't halt useq */
			    SRAM_CTL_RESET |	/*disable device board reset*/
			    SRAM_CTL_SEQEN;	/*let uSeq access uSeq code */
}

/*
 *	turn on dtr
 */
tty_turn_on_dtr(mp)
register ms_ptrs_t	*mp;
{
	/* gh00 - keep track of dtr in ram since hardware is write-only */
	dtr_reg_copy[mp->octart_num] &= ~mp->dtr_reg_mask;	/* turn on DTR*/
	*(mp->octart_dtr_reg) = dtr_reg_copy[mp->octart_num];
}

/*
 *	turn off dtr
 */
tty_turn_off_dtr(mp)
register ms_ptrs_t	*mp;
{
	/* gh00 - keep track of dtr in ram since hardware is write-only */
	dtr_reg_copy[mp->octart_num] |= mp->dtr_reg_mask; /* turn on DTR */
	*(mp->octart_dtr_reg) = dtr_reg_copy[mp->octart_num];
}


/*
 *	tell uart to start sending a break to the terminal
 */
tty_start_break(mp)
register ms_ptrs_t	*mp;
{
	*(mp->uartptr + UT_COMMAND) |= UT_CMD_TxBRK;
}


/*
 *	tell uart to stop sending a break to the terminal
 */
tty_stop_break(mp)
register ms_ptrs_t	*mp;
{
	*(mp->uartptr + UT_COMMAND) &= ~UT_CMD_TxBRK;
}


get_eia_stat(mp)
register ms_ptrs_t	*mp;
{
	uint 	status;

	status = *(mp->uartptr + UT_STATUS);

	return(status);
}

/*
 *	initialize sram pointers, tables
 */
init_ms_ptrs(mp, tty_num)
register ms_ptrs_t *mp;
uint	tty_num;
{
	register uint 	octart_num;	/* octart number for this device */
	register unchar *octart_base;	/* addr of octart containing this port*/
	register uint	i;

	mp->sram_spec_tab = (unchar *)((32 * tty_num) + START_OF_SRAM_SPEC_TAB);

	octart_num = tty_num / 8;
	octart_base = (unchar *) (octart_num * OCTART_SIZE + START_OF_OCTARTS) ;
	mp->octart_num = octart_num;

	mp->octart_dtr_reg = octart_base + UT_DTR_OFFSET;
	mp->dtr_reg_mask = 1 << (tty_num & 7);

	mp->uartptr = octart_base + ((tty_num & 7) * UT_OFFSET);
}

/*
 *	enable transmit interrupts for a device
 */
enable_transmitter(mp)
register ms_ptrs_t *mp;
{
	*(mp->uartptr + UT_COMMAND) |= UT_CMD_TxIE | UT_CMD_TxEN;
}
