/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tty_flags.c: version 25.1 created on 11/27/91 at 15:41:23	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tty_flags.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include <sys/types.h>
#include <sys/termio.h>
#include <sys/tyd_sram.h>
#include "spm_tty.h"
#include "octart.h"

/*
 *	baud rate conversion table, used to get the number to write
 *	to the COM78808 based on the value in cflag
 */
unchar	baud_table[] =
{
/*	COM78808 value		cflag value	speed */
/*	--------------		-----------	----- */
	0,			/*  0		    0	hang up */
	0,			/*  1		   50 */
	1,			/*  2		   75 */
	2,			/*  3		  110 */
	3,			/*  4		  134.5 */
	4,			/*  5		  150 */
	0xff,			/*  6		  200	not supported */
	5,			/*  7		  300 */
	6,			/*  8		  600 */
	7,			/*  9		 1200 */
	8,			/* 10		 1800 */
	10,			/* 11		 2400 */
	12,			/* 12		 4800 */
	14,			/* 13		 9600 */
	15,			/* 14		19200 */
	0xff,			/* 15		38400	not supported */
};

/* note: 2000 baud (COM78808 value = 9) and 7200 baud (COM78808 value = 13)
	 are not available to the user at this time */

/*
 *	iflag_program
 *
 *	set uSeq control_flag and special character table
 *	based on settings in iflag
 */
iflag_program(mp, sram_ctl, iflag, cflag)
register ms_ptrs_t 	*mp;
register struct ms_ctl 	*sram_ctl;
register uint		iflag;
register uint		cflag;
{
	register 	ms_iflag = 0;	/* copy of ms control_flag */
	register 	i;
	unchar 		spec_tab[32];	/* local copy of special char tab */
	unchar 		*sc_ptr;	/* addr of spec char tab in sram*/

	unchar	i_xon;		/* index into spec_tab for un_stripped X-ON*/
	unchar	i_xof;		/* index into spec_tab for un_stripped X-OFF*/
	unchar	xon_mask;	/* bit index into spec_tab byte for X-ON */
	unchar	xof_mask;	/* bit index into spec_tab byte for X-OFF */

	if (iflag & IGNBRK)
		ms_iflag |= MS_IGNBRK;
	if (iflag & BRKINT)
		ms_iflag |= MS_BRKINT;
	if (iflag & IGNPAR)
		ms_iflag |= MS_IGNPAR;
	if (iflag & PARMRK)
		ms_iflag |= MS_PARMRK;
	if (iflag & INPCK)
		ms_iflag |= MS_INPCK;
	if (iflag & IXOFF)
		ms_iflag |= MS_IXOFF;
	if (iflag & ISTRIP)
		ms_iflag |= MS_ISTRIP;
	if (iflag & IXANY)
		ms_iflag |= MS_IXANY;

	sram_ctl->ms_ctl_flag = ms_iflag;

	bzero(spec_tab, 32);

	/* 
	 * tell uSeq to look for 0xff as a special character
	 */
	if (iflag & PARMRK && !(iflag & ISTRIP))
		spec_tab[31] |= 0x80;

	if (iflag & IXON) {

		i_xon = (CSTART >> 3) & 0x1f; /* index into 32-byte tbl */
		xon_mask = 1 << (CSTART & 7); /* index into byte */

		i_xof = (CSTOP >> 3) & 0x1f; /* index into 32-byte tbl */
		xof_mask = 1 << (CSTOP & 7); /* index into byte */

		spec_tab[i_xon] |= xon_mask;
		spec_tab[i_xof] |= xof_mask;

		if (iflag & ISTRIP || (cflag & CSIZE) != CS8) {
			/* recognize stripped version of char */
			spec_tab[i_xon & 0xf] |= xon_mask;
			spec_tab[i_xof & 0xf] |= xof_mask;

			/* recognize unstripped version of char */
			spec_tab[(i_xon & 0xf) | 0x10] |= xon_mask;
			spec_tab[(i_xof & 0xf) | 0x10] |= xof_mask;
		}
		sram_ctl->ms_start = CSTART;
		sram_ctl->ms_stop  = CSTOP;
	}

	/* modify special character table in sram for this device */

	for (i = 0, sc_ptr = mp->sram_spec_tab; i < 32; i ++, sc_ptr++)
		*sc_ptr = spec_tab[i];
}

/*
 *
 *	cflag_program - program uart for this port
 */
cflag_program(mp, cflag)
register ms_ptrs_t 	*mp;
register uint		cflag;
{
	register	mode_1 = 0;		/* mode 1 register */
	register	mode_2 = 0;		/* mode 2 register */
	register	cmd_reg;		/* command register */
	register unchar *uartptr;

	if (baud_table[cflag & CBAUD] == 0xff)
		return;		/* ignore un-supported baud rates */

	if (cflag & CSTOPB)
		mode_1 |= UT_MODE_STOP2;	/* 2   stop bits */
	else
		mode_1 |= UT_MODE_STOP1;	/* 1   stop bit */

	if (cflag & PARENB) {

		if (cflag & PARODD)
			mode_1 |= UT_MODE_PAR_O;
		else	
			mode_1 |= UT_MODE_PAR_E;
	}
	else	
		mode_1 |= UT_MODE_PAR_N;		/* no parity */

	switch (cflag & CSIZE) {
	case CS5: 
		mode_1 |= UT_MODE_CS5;
		break;
	case CS6: 
		mode_1 |= UT_MODE_CS6;
		break;
	case CS7: 
		mode_1 |= UT_MODE_CS7;
		break;
	case CS8: 
		mode_1 |= UT_MODE_CS8;
		break;
	}

	mode_2 = baud_table[cflag & CBAUD]; /* convert to baud hardware knows*/
	mode_2 |= (mode_2 << 4);	/* transmit and receive are same speed*/

	cmd_reg = UT_CMD_OMNO  |	/* operating mode = normal operation */
		  UT_CMD_RxEN  |	/* receiver enable */
		  UT_CMD_TxIE  |	/* transmitter interrupt enable */
		  UT_CMD_TxEN;		/* transmitter enable */

	if (cflag & CREAD)			/* enable receiver if CREAD */
		  cmd_reg |= UT_CMD_RxIE;	/* receiver interrupt enable */
		  
	uartptr = mp->uartptr;

	/* 
	 * store in mp->cmd_reg rather than in junk,because if we use junk,
	 * the compiler optimizer deletes the read into junk 
	 */
	mp->cmd_reg = *(uartptr + UT_COMMAND); /*read cmd reg points to mode 1*/

	*(uartptr + UT_MODE) = mode_1;  /*1st write=mode 1 after cmd read*/
	*(uartptr + UT_MODE) = mode_2;  /*2nd write automatically mode 2*/
	*(uartptr + UT_COMMAND) = cmd_reg;

	mp->cmd_reg = cmd_reg;

	/* if baud rate is zero, , drop dtr */

	if ((cflag & CBAUD) == 0)
		tty_turn_off_dtr(mp);
	else	
		tty_turn_on_dtr(mp);
}
