/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tty.c: version 25.1 created on 11/27/91 at 15:41:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tty.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include <sys/types.h>
#include "sys/tyd_sram.h"
#include "sys/spm_mem.h"
#include "spm_tty.h"
#include "memdev.h"
#include "rwi.h"
#include "cio.h"

#define MIN(X,Y)	( (X) < (Y) ? (X) : (Y) )

extern uchar 	*km_map();
extern uint	int_counter;

static tty_dat_t tty_dat[NUM_SPM_TTYS];

tty_troll()
{
	uint i;

	for (i = 0; i < NUM_SPM_TTYS; i++) {

		tty_sync(i);
		/*
 		 * FIX THIS, HH - shouldn't have to do this here - 
		 */
		Unix_Console_Output();
	}
}

tty_sync(tty_num)
uint tty_num;
{
	register struct ms_ctl	*ms 	 = tty_dat[tty_num].ms_ctl;
	register struct ms_ctl	*kern 	 = tty_dat[tty_num].kern_ctl;
	ms_ptrs_t	*ms_ptrs = &tty_dat[tty_num].ms_ptrs;
	uchar		status;
	int		output_pending = 0;

	if (ms->ms_status & MSS_DISABLED)
		return;

	do_ms_command(tty_num, ms, kern, ms_ptrs);

	do_ms_event(ms, kern);

	status = ms->ms_status;

	if (kern->ms_out_head != kern->ms_out_tail) {
		output_pending = 1;
		status |= MSS_OUTPUT_PENDING;
	}
	if (ms->ms_out_head != ms->ms_out_tail)
		status |= MSS_OUTPUT_PENDING;

	kern->ms_status = status;

	/* 
	 * buffer pointers
	 */
	sync_buffers(tty_num, ms, kern, output_pending);
	enable_transmitter(ms_ptrs);

	/* 
	 * eia_stat - exists only in kernel structure - copy register
	 */
	kern->eia_stat = get_eia_stat(ms_ptrs);
}

do_ms_command(tty_num, ms, kern, ms_ptrs)
uint			tty_num;
register struct ms_ctl	*ms,
			*kern;
ms_ptrs_t		*ms_ptrs;
{
	static uint		old_cflag;
	register tty_dat_t	*td = &tty_dat[tty_num];

	Unix_Console_Output(); /* FIX THIS, HH */

	if (!kern->ms_command)
		return;
	/*
	 * check MS_NEW_FLAG first, because we want to make sure the port
	 * is configured before doing any other commands
	 */
	if (kern->ms_command & MS_NEW_FLAG) {
		if (1 || kern->cflag != old_cflag) { /* FIX THIS, HH */
			cflag_program(ms_ptrs, kern->cflag);
			old_cflag = kern->cflag;
		}
		iflag_program(ms_ptrs, ms, kern->iflag, kern->cflag);
		atom_and_byte(&kern->ms_command, ~MS_NEW_FLAG);
	}
	if (kern->ms_command & MS_SEND_SPEC_CHAR) {
		ms->ms_spec_char = kern->ms_spec_char;
		ms->ms_command |= MS_SEND_SPEC_CHAR;
		atom_and_byte(&kern->ms_command, ~MS_SEND_SPEC_CHAR);
	}
	if (kern->ms_command & MS_STOP_OUTPUT) {
		ms->ms_command |= MS_STOP_OUTPUT;
		atom_and_byte(&kern->ms_command, ~MS_STOP_OUTPUT);
	}
	if (kern->ms_command & MS_START_OUTPUT) {
		ms->ms_command &= ~MS_STOP_OUTPUT;
		ms->ms_command |= MS_START_OUTPUT;
		atom_and_byte(&kern->ms_command, ~MS_START_OUTPUT);
#ifdef notdef	/* FIX THIS, HH */
		enable_transmitter(ms_ptrs);
#endif
	}
	if (kern->ms_command & MS_FLUSH_XMIT_BUF) {
		kern->ms_out_head = kern->ms_out_tail;
		ms->ms_command |= MS_FLUSH_XMIT_BUF;
		atom_and_byte(&kern->ms_command, ~MS_FLUSH_XMIT_BUF);
		/*
		 * avoid flushing XMIT & RCV in same pass..
		 */
		if (kern->ms_command & MS_FLUSH_RCV_BUF)
			return;
	}
	if (kern->ms_command & MS_FLUSH_RCV_BUF) {
		ms->ms_in_head = ms->ms_in_tail;
		atom_and_byte(&kern->ms_command, ~MS_FLUSH_RCV_BUF);
	}
	if (kern->ms_command & MS_START_BREAK &&
	    !(kern->ms_command & MS_STOP_BREAK)) {
		tty_start_break(ms_ptrs);
		atom_and_byte(&kern->ms_command, ~MS_START_BREAK);
	}

	if(kern->ms_command & MS_STOP_BREAK) {
		tty_stop_break(ms_ptrs);
		atom_and_byte(&kern->ms_command, ~MS_STOP_BREAK);
	}

}


do_ms_event(ms, kern)
struct ms_ctl	*ms,
		*kern;
{
	uchar save_event = ms->ms_event;
	uchar event_flag = ms->ms_event & ~MSE_INPUT_STOPPED; 

	Unix_Console_Output(); /* FIX THIS, HH */

	if (kern->ms_in_head != kern->ms_in_tail)
		event_flag |= MSE_INPUT_PENDING;
	else
		event_flag &= ~MSE_INPUT_PENDING;

	atom_or_byte(&kern->ms_event, event_flag);

	ms->ms_event &= ~save_event;	/* clear only bits that were set */
}

sync_buffers(n, ms, kern, dooutput)
uint 		n;
struct ms_ctl	*ms;
struct ms_ctl	*kern;
{
	register caddr_t kern_in	= tty_dat[n].kern_buff;
	register caddr_t kern_out 	= kern_in + MS_BUF_SIZE;
	register caddr_t ms_in		= tty_dat[n].ms_buff;
	register caddr_t ms_out		= ms_in + MS_BUF_SIZE;

	uint saved_map = iomap_save();

	Unix_Console_Output(); /* FIX THIS, HH */

	iomap_restore(tty_dat[n].km_map);

	/*
	 * take bytes out of buffers at the HEAD - put in at the TAIL !!
	 */
	while (ms->ms_in_tail != ms->ms_in_head && 
		kern->ms_in_tail != kern->ms_in_limit) {

		kern_in[kern->ms_in_tail] = ms_in[ms->ms_in_head];
		kern->ms_in_tail++;
		ms->ms_in_head++;
	}
	ms->ms_in_limit = ms->ms_in_head + MS_LIMIT_SIZE;

	/* FIX THIS, HH - MS_LIMIT_SIZE below will have to change */

	Unix_Console_Output(); /* FIX THIS, HH */

	if (dooutput)
		while (kern->ms_out_tail != kern->ms_out_head &&
		  ms->ms_out_tail != (uchar)(ms->ms_out_head + MS_LIMIT_SIZE)) {

			ms_out[ms->ms_out_tail] = kern_out[kern->ms_out_head];

			ms->ms_out_tail++;
			kern->ms_out_head++;
		}

	Unix_Console_Output(); /* FIX THIS, HH */

	iomap_restore(saved_map);
}
	

/* 
 * initialize tty_dat array.
 * return 0 if sucessful, nonzero if buffers not setup yet.
 */
tty_init()
{
	register tty_dat_t 	*tp;

	uint 		tty_num,
			i;
	caddr_t 	km_buff = Spm_Mem->spm_tty.tty_buffer_space;
	ulong 		saved_map = iomap_save();

	if (! km_buff) 		/* not yet initialized by PM */
		return(1);

	ms_init();

	for (i = 0; i < NUM_SPM_TTYS; i++) {

		tp = &tty_dat[i];

		tp->kern_buff = (caddr_t)km_map((uint)km_buff + 
					SPM_TTY_BUFSIZE * i);
		tp->km_map = iomap_save();
		tp->ms_buff = (caddr_t)(START_OF_SRAM_INPUT + 
					SPM_TTY_BUFSIZE * i);
		tp->ms_ctl = (struct ms_ctl *)(START_OF_SRAM_BUF + 
					sizeof(struct ms_ctl) * i);
		tp->ms_ctl->dev = i;	/* for debugging */
		tp->kern_ctl = &Spm_Mem->spm_tty.spm_tty_ctl[i]; 
		init_ms_ptrs(&tp->ms_ptrs, i);
	}

	iomap_restore(saved_map);

	return(0);
}

tty_timer()
{
	static uint 	ttys_enabled; 

	if (ttys_enabled) {
		tty_troll();
		return;
	}
	if (!tty_init()) {
		ttys_enabled++;
		tty_troll();
	}
}
