/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) spm_lp.c: version 25.1 created on 11/27/91 at 15:41:10	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)spm_lp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * spm_lp.c - ACRW parallel printer support
 */

#include "sys/spm_mem.h"
#include "memdev.h"

extern uchar	*km_map();
extern uchar	throw_away_uchar;

static	spm_pm_lp_t	*lp_ctl;

/*
 *	lp_timer - check for output ready and input available
 */
lp_timer()
{
	static uint	lp_initialized = 0;

	if (!lp_initialized) {
		if (!lp_init())
			return;
		lp_initialized++;
	}
	lp_ctl->status = *MS_LP_STATUS_REG;

	if (lp_ctl->command & MS_LP_FLUSH) {

		*MS_LP_CONTROL_REG = MS_LPC_PRIME | 
					MS_LPC_SETDONE | 
					MS_LPC_ACKNLG | 
					MS_LPC_RESET;
		lp_ctl->busy = 0;
		lp_ctl->count = 0;
		lp_ctl->command &= ~MS_LP_FLUSH;
	}
	else if (lp_ctl->busy && lp_ctl->status & MS_LPS_DONE)
		lp_ctl->busy = 0;

	if (!lp_ctl->busy && lp_ctl->count)
		lp_move_data_to_useq(); 
}

lp_init()
{
	lp_ctl = &Spm_Mem->spm_lp_ctl;
	if (!lp_ctl->base)
		return(0);

	ms_init();	/* reset microsequencer, etc. */

	*MS_LP_CONTROL_REG = 0;	/* reset is active low */
	*MS_LP_CONTROL_REG = MS_LPC_SETDONE | MS_LPC_ACKNLG | MS_LPC_RESET;

	return(1);
}

lp_move_data_to_useq()
{
	register uchar	*from_ptr, 
			*to_ptr;
	register uint 	i, 
			count;
	uchar		*first_addr;
	uint		saved_map = iomap_save();

	/* 
	 * disable printer DMA transfer
	 */
	*MS_LP_CONTROL_REG = MS_LPC_SETDONE | MS_LPC_ACKNLG | MS_LPC_RESET;

	from_ptr = km_map(lp_ctl->base);    /* addr if 1st data byte in PM */

	/* 
	 * the hardware counts up until the last address of the hardware
	 * buffer is reached, so the first address to store at is the
	 * last address + 1 minus the number of data bytes
	 */

	to_ptr = END_OF_MS_LP_BUF_HI + 1 - lp_ctl->count;
	first_addr = to_ptr;

	count = lp_ctl->count;
	for (i = 0; i < count; i++)
		*(to_ptr++) = *(from_ptr++);

	/* 
	 * do this so the last access by the SPM is to the 1st byte of data 
	 */
	throw_away_uchar = *first_addr;

	lp_ctl->busy = 1;
	lp_ctl->count = 0;
	*MS_LP_CLEAR_DONE = 0; /* the act of writing clears the F/F 	*/
	*MS_LP_CLEAR_INT = 0;

	/* 
	 * enable printer DMA transfer
	 */
	*MS_LP_CONTROL_REG = MS_LPC_DMAEN | 
				MS_LPC_SETDONE | 
				MS_LPC_ACKNLG |
				MS_LPC_RESET;

	lp_ctl->status = *MS_LP_STATUS_REG;

	iomap_restore(saved_map);
}

