#	START NEW ARIX SCCS HEADER
#
#	@(#) spm.mk: version 25.1 created on 11/27/91 at 15:40:48
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)spm.mk	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#

# IROOT is provided by the driving makefile or script OR
# for stand alone makes, PWD provide as a command line varible or
# environment varible (ksh).

IROOT=$(PWD)/../../..
include $(IROOT)/macdefs

.SUFFIXES: .list

ML_OBJ =\
	ml/spmscb.o   ml/startup.o ml/setjmp.o\
	ml/probe.o    ml/misc.o   ml/vector.o\
	$(END_OF_LIST)

OS_OBJ=\
	os/atox.o        os/k_dwnld.o     os/monitor.o     os/sa.o\
	os/dnld.o        os/localmenu.o   os/pagetable.o\
	os/exceptions.o  os/localvars.o   os/parse.o       os/status.o\
	os/init.o        os/main.o        os/printf.o      os/trap.o\
	os/iomap.o       os/pw.o          os/util.o\
	os/cpu.o	 os/timewarp.o\
	$(END_OF_LIST)

IO_OBJ =\
	io/SYS.o	io/console.o	io/iosba.o	io/sld.o\
	io/conf.o	io/dev.o	io/poll.o\
	$(END_OF_LIST)

DSDB_OBJ =\
	dsdb/dk.o dsdb/tp.o dsdb/scsi_drv.o dsdb/scsi_ermsg.o dsdb/pt.o\
	$(END_OF_LIST)

LOCAL_OBJ =\
	local/cio.o       local/mm.o        local/sbus.o\
	local/config.o    local/rtc.o       local/sbus_iom.o\
	local/local.o     local/xmodem.o\
	$(END_OF_LIST)

RWI_OBJ =\
	rwi/rwi.o	rwi/rwi_int.o	rwi/scc.o\
	$(END_OF_LIST)

DBUG_OBJ =\
	dbug/ddebug.o  dbug/kdebug.o  dbug/symbol.o\
	dbug/debug.o   dbug/tdb.o\
	$(END_OF_LIST)

DPM40_OBJ =	cpu/dpm40_tdb.o dpm40/kv_iomap.o dpm40/mmu.o

PM20_OBJ =	cpu/pm20_tdb.o pm20/mmu.o

IOPM_OBJ =	cpu/iopm.o cpu/iopm_tdb.o iopm/mmu.o

CPU_OBJ =\
	m68k/dis.o m68k/tdbsys.o m68k/trace.o m68k/load.o\
	cpu/spm_tdb.o\
	$(IOPM_OBJ)\
	$(DPM40_OBJ)\
	$(PM20_OBJ)\
	$(END_OF_LIST)

TTY_OBJ =\
	tty/tty.o tty/tty_flags.o tty/tty_mach.o tty/mscode.o tty/spm_lp.o\
	$(END_OF_LIST)

RUNTIME = spm.runtime

#
# NOTE : spmscb.o MUST be linked first so the interrupt vector table
#	 will be at the beginning of the text section of the runtime image.
#
#	startup.o MUST be next
#	FIX MSS, Why the above is true is a mystery
#

OBJS = 	$(ML_OBJ) $(OS_OBJ) $(IO_OBJ) $(LOCAL_OBJ) $(RWI_OBJ) $(DBUG_OBJ) \
	$(DSDB_OBJ) $(CPU_OBJ) $(TTY_OBJ)

LIBFLAG = ../../lib/libsc.a
VERPATT = 's/^.define[ 	]*SPM_ID_NUM[ 	]*\([0-9a-fA-Fx]*\)/-VS \1/p'
VERFLAG = `sed -n -e $(VERPATT) head/misc.h`

DEBUGFLAGS = -DASDEBUG=YES
AFLAG = -n
LDFLAGS = 
# LOCINC and LIBINC are defined in the "all" rule
LOCAL_CFLAGS = -T2 -I$(LOCINC) -I$(LIBINC) $(DEBUGFLAGS)

MACH = M68020
UMACH = M68040

AS = $(SGS_ROOT)/bin/as2

all default:
	$(MAKE) -f spm.mk IROOT=$(IROOT) LOCINC=`pwd`/head LIBINC=`pwd`/../../head spm

spm: vuifile $(OBJS)
	@-echo Linking...
	@$(LD) $(LDFLAGS) -o $(RUNTIME) vuifile $(OBJS) $(LIBFLAG) $(VERFLAG)
	nm -xv $(RUNTIME) | grep -v ' file |' | sort -t'|' +1 -2 +0 > spm.map &
	size -x $(RUNTIME)
	cp $(RUNTIME) spm
	strip spm		# strip symbol table 
	mcs -d spm		# strip out comment section of binary

umod : spm
	umod spm

.c.o:
	cd $(<D); $(CC) -cO $(CFLAGS) $(<F)

.s.o:
	cd $(<D); $(AS) $(<F)

.c.list:
	cd $(<D); $(CC) -Kc $(CFLAGS) $(<F)

.s.list:
	cd $(<D); $(CC) -K $(<F)

clean:
	rm -f  $(OBJS) *.cdb *.list lint.out spm.map nohup.out makelog

clobber: clean
	rm -f  $(RUNTIME) spm tags */tags tags.err

a.o:	a.c
	$(CC) -g $(CFLAGS) -c a.c

a.map:	a.o
	nm -xv a.o > a.map
