/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) scc.c: version 25.1 created on 11/27/91 at 15:40:45	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)scc.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:scc.c	25.1"

/* scc.c */

#include "misc.h"
#include "sys/types.h"
#include "spm_debug.h"
#include "spm.h"
#include "scc.h"
#include "rwi.h"
#include "novram.h"

/* initscc() - initialize Real World Interface serial ports
 *
 *	SCC0 channel a: Console port (DCE)
 *	SCC0 channel b: Remote Console (DTE)
 *	SCC1 channel a: Printer port (DCE)
 *	SCC1 channel b: UPS port (DTE)
 */
initscc()
{
	/* program scc 0 */

	/* wait for all characters to be sent */

	if (!(CONSOLE_PORT->reg[1].reg & RR1_ALLSENT) ||
	    !(MODEM_PORT->reg[1].reg & RR1_ALLSENT))
		delay_no_poll(1);

	/*****  program the modes *****/

	CONSOLE_PORT->reg[9].reg = WR9_HRST;	/* hardware reset */

	CONSOLE_PORT->reg[0].reg = WR0_SHL;	/* shift left mode */

			/* 1 stop bit, clock rate = 16 times data rate */
	CONSOLE_PORT->reg[4].reg = WR4_1STOP | WR4_16CLOCK;
			/* 1 stop bit, clock rate = 16 times data rate */
	MODEM_PORT->reg[4].reg = WR4_1STOP | WR4_16CLOCK;
	CONSOLE_PORT->reg[1].reg = WR1_RXALL;	/* int on all rx char */
	MODEM_PORT->reg[1].reg = WR1_EXTEN | WR1_RXALL;

	CONSOLE_PORT->reg[2].reg = SCC0_VECT;	/* int vector, both channels */

	CONSOLE_PORT->reg[3].reg = WR3_RX8;	/* receive 8 bits/character */ 
	MODEM_PORT->reg[3].reg = WR3_RX8;	/* receive 8 bits/character */ 

					/* DTR low, transmit 8 bits, RTS low */
	CONSOLE_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;
					/* DTR low, transmit 8 bits, RTS low */
	MODEM_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;

			/* use baud rate gen for transmit and receive clks */
	CONSOLE_PORT->reg[11].reg = WR11_RCGO | WR11_TCGO;
			/* use baud rate gen for transmit and receive clks */
	MODEM_PORT->reg[11].reg = WR11_RCGO | WR11_TCGO;

	program_baud(CONSOLE_PORT, NOVRAM->console_baud_rate,0);
	program_baud(MODEM_PORT, NOVRAM->modem_baud_rate,0);

	CONSOLE_PORT->reg[14].reg = WR14_PCLK;
	MODEM_PORT->reg[14].reg = WR14_PCLK;

	/***** program enables *****/

	CONSOLE_PORT->reg[3].reg = WR3_RX8 | WR3_RXEN;	/* enable receiver */
	MODEM_PORT->reg[3].reg = WR3_RX8 | WR3_RXEN;	/* enable receiver */

	/* enable the transmitter */
	CONSOLE_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;
	MODEM_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;

	CONSOLE_PORT->reg[0].reg = WR0_RXCRC;	/* reset trans crc checker */	
	MODEM_PORT->reg[0].reg = WR0_RXCRC;	/* reset trans crc checker */	

	CONSOLE_PORT->reg[14].reg = WR14_ENABD | WR14_PCLK;
	MODEM_PORT->reg[14].reg = WR14_ENABD | WR14_PCLK;

	/***** interrupt enables *****/

	CONSOLE_PORT->reg[15].reg = 0;
	MODEM_PORT->reg[15].reg = WR15_SHIE | WR15_DCDIE | WR15_BRKIE;

	CONSOLE_PORT->reg[0].reg = WR0_EXINT;	/* reset external status ints */
	CONSOLE_PORT->reg[0].reg = WR0_EXINT;	/* twice */
	CONSOLE_PORT->reg[9].reg = WR9_MIE | WR9_VIS; /* master int enable */

	/* program scc 1 */

	/*****  program the modes *****/

	if (!(PRINTER_PORT->reg[1].reg & RR1_ALLSENT) ||
	   !(PRINTER_PORT->reg[1].reg & RR1_ALLSENT))
		delay_no_poll(1);

	PRINTER_PORT->reg[9].reg = WR9_HRST;	/* hardware reset */

	PRINTER_PORT->reg[0].reg = WR0_SHL;	/* shift left mode */

			/* 1 stop bit, clock rate = 16 times data rate */
	PRINTER_PORT->reg[4].reg = WR4_1STOP | WR4_16CLOCK;
			/* 1 stop bit, clock rate = 16 times data rate */
	UPS_PORT->reg[4].reg = WR4_1STOP | WR4_16CLOCK;
	/* interrupt on all receive characters & external status change */ 
	PRINTER_PORT->reg[1].reg = WR1_EXTEN | WR1_RXALL;
	UPS_PORT->reg[1].reg = 0;

	PRINTER_PORT->reg[2].reg = SCC1_VECT; /* int vector, both channels */

	PRINTER_PORT->reg[3].reg = WR3_RX8;	/* receive 8 bits/character */ 
	UPS_PORT->reg[3].reg = WR3_RX8;		/* receive 8 bits/character */ 

					/* DTR low, transmit 8 bits, RTS low */
	PRINTER_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;
					/* DTR low, transmit 8 bits, RTS low */
	UPS_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_RTS;

			/* use baud rate gen for transmit and receive clks */
	PRINTER_PORT->reg[11].reg = WR11_RCGO | WR11_TCGO;
			/* use baud rate gen for transmit and receive clks */
	UPS_PORT->reg[11].reg = WR11_RCGO | WR11_TCGO;

	program_baud(PRINTER_PORT, NOVRAM->printer_baud_rate,0);
	program_baud(UPS_PORT, NOVRAM->ups_baud_rate,0);

	PRINTER_PORT->reg[14].reg = WR14_PCLK;
	UPS_PORT->reg[14].reg = WR14_PCLK;

	/***** program enables *****/

	PRINTER_PORT->reg[3].reg = WR3_RX8 | WR3_RXEN;	/* enable receiver */
	UPS_PORT->reg[3].reg = WR3_RX8 | WR3_RXEN;	/* enable receiver */

	/* enable the transmitter */
	PRINTER_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;
	UPS_PORT->reg[5].reg = WR5_DTR | WR5_TX8 | WR5_TXEN | WR5_RTS;

	PRINTER_PORT->reg[0].reg = WR0_RXCRC;	/* reset trans crc checker */	
	UPS_PORT->reg[0].reg = WR0_RXCRC;	/* reset trans crc checker */	

	PRINTER_PORT->reg[14].reg = WR14_ENABD | WR14_PCLK;
	UPS_PORT->reg[14].reg = WR14_ENABD | WR14_PCLK;

	/***** interrupt enables *****/

	PRINTER_PORT->reg[15].reg = WR15_DCDIE;
	UPS_PORT->reg[15].reg = 0;

	PRINTER_PORT->reg[0].reg = WR0_EXINT;	/* reset external status ints */
	PRINTER_PORT->reg[0].reg = WR0_EXINT;	/* twice */
	PRINTER_PORT->reg[9].reg = WR9_MIE | WR9_VIS; /* master int enable */
}

/* program_baud
 *
 *	parameters:	scc address
 *			baud rate
 *			flag for saving off to novram
 *
 *	exit:		0 no error
 *			1 invalid baud rate or port address
 */

program_baud(sccptr, baud_rate, novram_save)
register scc_t	*sccptr;
register ushort	baud_rate;
uint		novram_save;
{
	register uint	time_constant;

	switch (baud_rate) {
	case 300:
		time_constant = BDRT300;
		break;
	case 600:
		time_constant = BDRT600;
		break;
	case 1200:
		time_constant = BDRT1200;
		break;
	case 1800:
		time_constant = BDRT1800;
		break;
	case 2400:
		time_constant = BDRT2400;
		break;
	case 4800:
		time_constant = BDRT4800;
		break;
	case 9600:
		time_constant = BDRT9600;
		break;
	case 19200:
		time_constant = BDRT19K;
		break;
	default:
		return(1);
	}

	if (novram_save) {
		switch ((uint)sccptr) {
		case CONSOLE_PORT:
			NOVRAM->console_baud_rate = baud_rate;
			break;
		case MODEM_PORT:
			NOVRAM->modem_baud_rate = baud_rate;
			break;
		case PRINTER_PORT:
			NOVRAM->printer_baud_rate = baud_rate;
			break;
		case UPS_PORT:
			NOVRAM->ups_baud_rate = baud_rate;
			break;
		default:
			return(1);
		}
		shared_crc();
	}

	sccptr->reg[12].reg = time_constant; 
	sccptr->reg[13].reg = time_constant >> 8;
	return(0);
}

change_baud(sccptr, baud_rate, novram_save)
register scc_t	*sccptr;
ushort		baud_rate;
uint		novram_save;
{
	uint	ret_val;

	/* wait for all characters to be sent */

	if (!(sccptr->reg[1].reg & RR1_ALLSENT))
		delay_no_poll(1);

	/* disable baud rate generator */

	sccptr->reg[14].reg = WR14_PCLK;

	ret_val = program_baud(sccptr, baud_rate, novram_save);

	/* enable baud rate generator */

	sccptr->reg[14].reg = WR14_ENABD | WR14_PCLK;
	return(ret_val);
}

config_modem_port(state)
uint	state;
{
	if (state) {
		change_baud(MODEM_PORT, NOVRAM->modem_baud_rate, 1);
		MODEM_PORT->reg[1].reg = WR1_RXALL;
	}
	else {
		change_baud(MODEM_PORT, 19200, 0);
		MODEM_PORT->reg[1].reg = 0;
	}
}
