/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) rwi_int.c: version 25.1 created on 11/27/91 at 15:40:40	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)rwi_int.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:rwi_int.c	2.1"

/* rwi_int.c */

/*
 *  This module contains the interrupt service routines for the Service
 *  Processor board.
 */

#include "sys/param.h"
#include "sys/ints.h"
#include "sys/types.h"
#include "sys/uadmin.h"
#include "spm_debug.h"
#include "misc.h"
#include "spm.h"
#include "scc.h"
#include "cio.h"
#include "sys/state.h"
#include "rwi.h"
#include "novram.h"


extern uchar	throw_away_char;	/* globals to avoid optimizer problem */
extern unchar	console_xonflag;	/* stop console output when true */
extern unchar	printer_xonflag;

extern unchar	spm_bufinputq[], *spm_bufhead, *spm_buftail;
extern unchar	unix_bufinputq[], *unix_bufhead, *unix_buftail;

extern uint	spm_slot;
extern uint	key_on, 
		setting_password;
extern uint	pm_booting_done,
		unix_console_mode,
		modem_on,
		printer_on,
		baud_num;

extern struct sbus_config sbus_config;

uint		abortflag;

static int	spm_mode_char = CTRL_T;

modem_char_available()
{
	if (modem_on)
		service_channel(MODEM_PORT);
	else
		service_stray_int(MODEM_PORT);
}

console_char_available()
{
	service_channel(CONSOLE_PORT);
}

service_stray_int(sccptr)
register scc_t	*sccptr;
{
	int	n;

	/*
	 * Did the scc interrupt with a char?
	 */
    	if (sccptr->reg[0].reg & RR0_RX)
		throw_away_char = sccptr->reg[8].reg;

	/* Wait for any breaks to go away */
	for (n = BREAK_DELAY; --n >= 0 && (sccptr->reg[0].reg & RR0_BREAK); )
		;

	/* 
	 * Did the scc interrupt with a char? 
	 */
	for (n = READ_MAX; --n >= 0 && (sccptr->reg[0].reg & RR0_RX); )
		throw_away_char = sccptr->reg[8].reg;

	sccptr->reg[0].reg = WR0_RHIUS;
}

service_channel(sccptr)
register scc_t	*sccptr;
{
	uint 	c = 0;
	int	n;

	/* 
	 * Wait for any breaks to go away
	 */
	for (n = BREAK_DELAY; --n >= 0 && (sccptr->reg[0].reg & RR0_BREAK); )
		;

       	while (sccptr->reg[0].reg & RR0_RX) {

		c = sccptr->reg[8].reg;

		if (unix_console_mode) {

			if (c == spm_mode_char) {
				unix_console_mode = 0;
				break; 
			}
			if (unix_buftail == unix_bufinputq + CQSIZ) {
				if (unix_bufhead != unix_bufinputq) {
					unix_buftail = unix_bufinputq;
					*unix_buftail++ = c;
				}
				/* else throw away new character! */
			}
			else if(unix_buftail != unix_bufhead - 1)
					*unix_buftail++ = c;

			continue;
		}

		/* 
		 * spm console mode 
		 */
		if (c == ESCAPE)
			abortflag = 1;

		else if (c == CTRL_S) {
			console_xonflag = SCC_XON;
			break;
		}
		else if (c == CTRL_Q) {
			console_xonflag = SCC_XOFF;
			break;
		}
		if (spm_buftail == spm_bufinputq + CQSIZ) {
			if (spm_bufhead != spm_bufinputq) {
				spm_buftail = spm_bufinputq;
				*spm_buftail++ = c;
			}
			/* else throw away new character! */
		}
		else if (spm_buftail != spm_bufhead - 1)
				*spm_buftail++ = c;
	}

	/*
	 * reprime the interrput
	 */
	sccptr->reg[0].reg = WR0_RHIUS; 
}

printer_status_change()
{
	register scc_t	*scc = PRINTER_PORT;
	int		n;

	printer_xonflag = SCC_XOFF;

	/* read the character and disgard it */
    	for (n = READ_MAX; --n >= 0 && (scc->reg[0].reg & RR0_RX); )
		throw_away_char = scc->reg[8].reg;

	/* reset ext/status interrupts */
	scc->reg[0].reg = WR0_EXINT;

	/* delay for line to settle */
	/* FIX THIS, HH - delay no poll 100?? */
	delay_no_poll(100);

	NOVRAM->printer_active = printer_on =
	  (scc->reg[0].reg & RR0_DCD) ? 1 : 0;
	shared_crc();

	scc->reg[0].reg = WR0_RHIUS;
}

/*
 * Did the scc interrupt with a char?
 */
printer_char_available()
{
	register scc_t	*scc = PRINTER_PORT;
	int		n;

	/* Wait for any breaks to go away */
	n = BREAK_DELAY;
	while (--n >= 0 && (scc->reg[0].reg & RR0_BREAK))
		;

	for (n = READ_MAX; --n >= 0 && (scc->reg[0].reg & RR0_RX); ) {
		switch (scc->reg[8].reg) {
		case CTRL_S:
			printer_xonflag = SCC_XON;
			break;
		case CTRL_Q:
			printer_xonflag = SCC_XOFF;
			break;
		default:
			break;
		}
	}
	/* reprime the interrupt */
	scc->reg[0].reg = WR0_RHIUS;
}

printer_special_receive()
{
	register scc_t	*scc = PRINTER_PORT;
	int		n;

	for (n = READ_MAX; --n >= 0 && (scc->reg[0].reg & RR0_RX); )
		throw_away_char = scc->reg[8].reg;

	/* error reset */
	scc->reg[0].reg = WR0_ERROR;

	/* reprime the interrupt */
	scc->reg[0].reg = WR0_RHIUS;
}

console_status_change()
{
	register scc_t	*scc = CONSOLE_PORT;
	int		n;

	/* read the character(s) and disgard it */
	for (n = READ_MAX; --n >= 0 && (scc->reg[0].reg & RR0_RX); )
		throw_away_char = scc->reg[8].reg;

	/* reset ext/status interrupts */
	scc->reg[0].reg = WR0_EXINT;

	/* reprime the interrupt */
	scc->reg[0].reg = WR0_RHIUS;
}


console_special_receive()
{
	scc_t	*scc = CONSOLE_PORT;

    	if (scc->reg[0].reg & RR0_RX)
		throw_away_char = scc->reg[8].reg;

	/* error reset */
	scc->reg[0].reg = WR0_ERROR;

	/* reprime the interrupt */
	scc->reg[0].reg = WR0_RHIUS;
}

ushort baud_list[5] = {
	19200,
	9600,
	2400,
	1200,
	300,
};

/* modem port status change */
modem_status_change()
{
	register uint	change;
	register int	n;
	register scc_t	*scc = MODEM_PORT;

	console_xonflag = SCC_XOFF;

	/* flush out the receiver */
    	for (n = READ_MAX; --n >= 0 && (scc->reg[0].reg & RR0_RX); )
		throw_away_char = scc->reg[8].reg;

	if ((scc->reg[0].reg & DCD_DSR) == DCD_DSR) {
		change = !modem_on;
		modem_on = 1;
	}
	else {
		change = modem_on;
		modem_on = 0;
	}

	if (change) {
		NOVRAM->modem_active = modem_on;
		shared_crc();
	}

	/* only cycle baud rates on break if no change in modem status */
	if (modem_on && !change && (scc->reg[0].reg & RR0_BREAK)) {
		if (++baud_num >= NEL(baud_list))
			baud_num = 0;
		printf("modem port detected break: switching to %d baud\n",
		  baud_list[baud_num]);
		change_baud(scc, baud_list[baud_num], 1);
	}
	else
		delay_no_poll(100);		/* delay for line to settle */

	/* Wait for the break to go away and clear receive FIFO */
	for (n = BREAK_DELAY; --n >= 0 && (scc->reg[0].reg & RR0_BREAK); )
		;
    	for (n = READ_MAX; --n >= 0 && (scc->reg[0].reg & RR0_RX); )
		throw_away_char = scc->reg[8].reg;

	/* reset ext/status interrupts */
	scc->reg[0].reg = WR0_EXINT;

	if (modem_on && change)
		printf("modem connect at %d baud\n", NOVRAM->modem_baud_rate);

	/* reprime the interrupt */
	scc->reg[0].reg = WR0_RHIUS;
}


modem_special_receive()
{
	register scc_t	*scc = MODEM_PORT;
	int		n;

	for (n = READ_MAX; --n >= 0 && (scc->reg[0].reg & RR0_RX); )
		throw_away_char = scc->reg[8].reg;

	/* error reset */
	scc->reg[0].reg = WR0_ERROR;

	/* reprime the interrupt */
	scc->reg[0].reg = WR0_RHIUS;
}


cio0_porta_change()
{
	static uint	switched_off, 
			ups_state = NORMAL,
			last_ups_bits;
	register uint	state;
	register uint	cio0_porta_data = RWI_CIO0->portdata[0].reg;

	RWI_CIO0->portcs[0].reg = ICW_CPUS;

	/* did any power supplies fail? */
	if (cio0_porta_data & PS_ANY_FAIL) {
		/* wait for condition to stabilize */
		delay_no_poll(4);	/* delay for 4 msec */
		cio0_porta_data = RWI_CIO0->portdata[0].reg;

		if (cio0_porta_data & PS_ANY_FAIL)
			shutdown(MD_POWEROFF);
	}

	/* check UPS status */
	state = cio0_porta_data & (UPS_LOW_BATTERY | UPS_AC_FAIL);
	if (state != last_ups_bits) {
		delay_no_poll(4);			/* wait for 4 msec */
		cio0_porta_data = RWI_CIO0->portdata[0].reg;
		state = cio0_porta_data & (UPS_LOW_BATTERY | UPS_AC_FAIL);
	}
	last_ups_bits = state;

	if (cio0_porta_data & UPS_AC_FAIL) {		/* power failed */
		if (cio0_porta_data & UPS_LOW_BATTERY) {
			if (ups_state != SHUTDOWN) {	/* batteries low */
				state = ups_state;
				change_err_state(state, ups_state = SHUTDOWN);
				printf("\nSPM: Batteries low; shutting down\n");
			}
		}
		else if (ups_state == NORMAL) {
			state = ups_state;
			change_err_state(state, ups_state = WARNING);
			printf("\nSPM: Power failure!\n");
		}
	}
	else if (ups_state == WARNING) {		/* normal */
		change_err_state(WARNING, ups_state = NORMAL);
		printf("\nSPM: Power has been restored.\n");
	}

	if (cio0_porta_data & OFF_SW) {
		if (setting_password) 
			key_on = 0;
		else if (!switched_off) {
			if (!pm_booting_done)
				shutdown(MD_POWEROFF);

			switched_off = 1;
			change_err_state(NORMAL, SHUTDOWN);
			printf("\nSwitch Off: starting powerfail sequence.\n");
		}
	}
	else if (setting_password)
		key_on = 2;
}

cio0_portb_change()
{
	RWI_CIO0->portcs[1].reg = ICW_CPUS;
}


/*
 * set_spm_char -- get, and optionally set, the kernel-to-SPM mode change char
 */

set_spm_char(set_flag, new_char)
uint	set_flag;
int	new_char;
{
	int	old_char = spm_mode_char;

	if (set_flag)
		spm_mode_char = new_char;

	return (old_char);
}
