/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mmu.c: version 25.1 created on 11/27/91 at 15:40:27	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mmu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* pm20/mmu.c */

#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/kmem.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "sys/immu.h"
#include "sys/iopm_mmu.h"
#include "sys/lio.h"
#include "memstripe.h"


extern uint	km_allocate();
extern unchar	*km_map();

uint
pm20_mpfn_to_spfn(mpfn)
register uint	mpfn;
{
	register MEM_STRIPE	*msp;
	register uint		s_level, s_page, s_offset;
	uint			s_board;

	K_ASSERT(mpfn >= btoc(MAINSTORE));
	K_ASSERT(mpfn < btoc(KIO_START));

	/* calculate which stripe level this page is on */
	msp = mem_stripe_tbl;
	for (s_level = 0; s_level < MM_NUM_SIZES + 1; s_level++, msp++) {
		if (msp->num_mm == 0)
			break;
		if (mpfn < msp->base_km)
			break;
	}
	s_level -= 1;
	if (--msp < mem_stripe_tbl || msp->num_mm == 0) {
		printf("pm20_mpfn_to_spfn: out of range! mpfn = 0x%x\n", mpfn);
		rtn_to_monitor();
	}

	/* calculate which page/board/offset in this stripe level */
	s_page = mpfn - msp->base_km;
	s_board = s_page % msp->num_mm;
	s_offset = s_page / msp->num_mm;
#ifdef BARBER_POLE
	{ 
	int rotate;

	rotate = ( btoc(SRAM_SIZE) / msp->num_mm) * s_board;
	s_offset += rotate; 
	s_offset %= msp->pages_per_board;
	}
#endif
	return (msp->base_xpfn[s_board] + s_offset);
}

/*
 * pm20_km_to_rde -- make a root descriptor entry for the PM20.
 *	vaddr is an address in the memory portion of the PM's address space.
 *	This code takes advantage of the fact that both segment tables
 *	and pages are on 4K boundaries.
 */
rde_t
pm20_km_to_rde(vaddr)
uint	vaddr;
{
	rde_t	retval;

	K_ASSERT((vaddr & ((1 << PNUMSHFT) - 1)) == 0);	/* on 4k boundary */

	retval.rde_all = 0;
	retval.rdm.rde_rfn = pm20_mpfn_to_spfn(pnum(vaddr));
	return(retval);
}

/*
 * pm20_km_to_sde -- make a segment descriptor for the PM20's segment table.
 *	vaddr is an address in the memory portion of the PM's address space.
 *
 *	This code is complicated by the fact that page tables are half the
 *	size of a page.
 *	This means that a 'msfn' has one more bit than a 'mpfn'.
 *	The upper bits of the msfn must be converted using
 *	mpfn_to_spfn.  The lower bit, however, is passed thru.
 */

static sde_t
pm20_km_to_sde(vaddr)
uint	vaddr;
{
	sde_t	retval;
	uint	msfn;
	uint	mpfn;
	uint	low_bits;
	uint	spfn;
	uint	ssfn;

	msfn = vaddr >> BPTSHFT;
	low_bits = msfn % NPTPP;
	mpfn = msfn / NPTPP;
	spfn = pm20_mpfn_to_spfn(mpfn);
	ssfn = spfn * NPTPP + low_bits;

	retval.sg_sge = 0;
	retval.sgm.sg_sfn = ssfn;

	return(retval);
}

/*
 * pm20_km_to_pde -- make a page descriptor entry for the PM20's page table
 *	mode describes the form of page
 *	vaddr is an address in the memory portion of the PM's address space.
 */

static pde_t
pm20_km_to_pde(vaddr, mode)
uint	vaddr;
uint	mode;
{
	pde_t	retval;

	K_ASSERT((vaddr & ((1 << PNUMSHFT) - 1)) == 0);	/* on 4k boundary */

	retval.pgi.pg_pde = 0;
	retval.pgm.pg_pfn = pm20_mpfn_to_spfn(pnum(vaddr));
	retval.pgi.pg_pde |= mode;
	return(retval);
}

uint
pm20_spfn_to_lpfn(spfn)
uint	spfn;
{
	return(spfn - sbus_config.pfn_adjust[spfn >> SpfnToSlotShft]);
}


/*
 * build a table in main memory for the kernel to
 * use in converting lpfns to pfns.
 */

static void
pm20_lpfn_tbl_init()
{
	register int	n;
	register uint	*lpfn_ptr;
	register uint	km_addr, index, pg_num;
	uint		saved_map = iomap_save();

	/* The lpfn_tbl used to be on a page table boundary, but this doesn't
	 * seem to be required, so I'm putting it on a pde boundary.  JPC
	 */

	sbus_config.lpfn_tbl = lpfn_ptr =
	  (uint *)km_allocate(num_pages * sizeof(pde_t), sizeof(pde_t));

	for (km_addr = MAINSTORE, n = num_pages; --n >= 0; km_addr += NBPP) {
		pg_num = pnum(km_addr);
		index = pm20_spfn_to_lpfn(pm20_mpfn_to_spfn(pg_num));
		*(uint *)km_map((uint)&lpfn_ptr[index]) = pg_num;
	}

	iomap_restore(saved_map);
}

/*
 * pm20_ptbl() - build Kernel page tables
 */
static void
pm20_ptbl()
{
	register pde_t	*pt_ptr;
	register int	km_addr;
	register uint	pages;
	register uint	saved_map = iomap_save();

	sbus_config.invalid_pde = 0;

	/*
	 * build bad ptbl
	 */
	pt_ptr = (pde_t *) km_map(ADDR_BAD_PTBL);

	for (pages = NPGPT; pages; pt_ptr++, pages--)
		pt_ptr->pgi.pg_pde = sbus_config.invalid_pde;

	sbus_config.invalid_sde = pm20_km_to_sde(ADDR_BAD_PTBL).sg_sge;

	/*
	 * build kernel memory page tables
	 */

	/* allocate memory page tables on next page table boundary */

	sbus_config.mem_ptbl = km_allocate(num_pages * sizeof(pde_t), NBPPT);

	/* first 8 pages before the Kernel */

 	pt_ptr = (pde_t *)sbus_config.mem_ptbl;
	for (km_addr = MAINSTORE; km_addr != ADDR_KERNEL; km_addr += NBPP)
		*((pde_t *) km_map(pt_ptr++)) =
			pm20_km_to_pde(km_addr, PG_P|PG_R|PG_W|PG_CB);

	/* pages of the Kernel text */

	for (; km_addr < (uint)kernel_etext; km_addr += NBPP)
		*((pde_t *) km_map(pt_ptr++)) =
			pm20_km_to_pde(km_addr, PG_P|PG_R|PG_X|PG_CB);

	/* pages from the data portion to the end of free space */

	pages = MAINSTORE + ctob(num_pages);
	for ( ; km_addr < pages; km_addr += NBPP)
		*((pde_t *) km_map(pt_ptr++)) =
			pm20_km_to_pde(km_addr, PG_P|PG_R|PG_W|PG_CB);

	pm20_lpfn_tbl_init();

	iomap_restore(saved_map);
}

/*
 * pm20_stbl - build kernel segment table
 */

static void
pm20_stbl(addr_stbl)
register uint	addr_stbl;
{
	register sde_t	*st_ptr;
	register uint	segno;
	register uint	addr_pt;
	register uint	saved_map = iomap_save();

	st_ptr = (sde_t *) km_map(addr_stbl);

	/*
	 * invalidate all entries in segment table
	 */

	for (segno = 0; segno != KMEM_SIZE / NBPS; segno++)
		st_ptr[segno].sg_sge = sbus_config.invalid_sde;

	/*
	 * Fill in the entries for kernel memory
	 */

	st_ptr += (MAINSTORE - KMEM_START) / NBPS;
	addr_pt = sbus_config.mem_ptbl;
	for (segno = 0; segno != num_pages / NPGPT; segno++) {
		*st_ptr++ = pm20_km_to_sde(addr_pt);
		addr_pt += NBPPT;
	}
	iomap_restore(saved_map);
}

/*
 * pm20_own -- Allocate ownseg areas for each processor
 *	this is the segment that contains the own stucture,
 *	per processor u area, and the current u area.
 */

static void
pm20_own()
{
	/*
	 * Warning this code assumes that a segment table and
	 * a page table will fit in one page.
	 *
	 * This code also assumes that the own structure will
	 * fit in one page.
	 * This code on System 90 assumes that USIZE is 1.
	 * This code on System 95 no longer assumes that USIZE is 1.
	 */
	register uint sbus_slot;
	register sde_t	*st_ptr;
	register pde_t	*pt_ptr;
	register struct own *own_ptr;
	register uint	pageno;
	register uint	pm_id;
	uint	addr_stbl, addr_ptbl, addr_own_u, addr_own;
	uint	addr_extra_stk, addr_own_extra;
	register uint	saved_map = iomap_save();

	pm_id = 0;
	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {
		if (sbus_config.slot_id[sbus_slot] != SBUS_PM20)
			continue;

		/* allocate PM's own segment table on page boundary */
		addr_stbl = sbus_config.pm_stbl[pm_id] =
			km_allocate(KMEM_SIZE / NBPS * sizeof(sde_t), NBPP);

		/* allocate PM's own page table on page table boundary */
		addr_ptbl = km_allocate(NBPPT, NBPPT);

		/* allocate PM's extra system stack page */
		addr_extra_stk = km_allocate(USIZE, NBPP);

		/* allocate PM's extra own stack page */
		addr_own_extra = km_allocate(USIZE, NBPP);

		/* allocate PM's own u area on page boundary */
		addr_own_u = km_allocate(USIZE, NBPP);
		K_ASSERT(USIZE < NBPP);

		/* allocate PM's own variable area on page boundary */
		addr_own = km_allocate(sizeof(struct own), NBPP);
		K_ASSERT(sizeof(struct own) < NBPP);

		/* round up to next page boundary */
		(void *) km_allocate(0, NBPP);

		pm20_stbl(addr_stbl);
		st_ptr = (sde_t *) km_map(addr_stbl);

		/*
		 * Fill in the entry for the own segment
		 */

		st_ptr[SNUM(ADDR_OWN_SEGS)] = pm20_km_to_sde(addr_ptbl);



		/* Now ready to set up each PM's own page table */

		pt_ptr = (pde_t *) km_map(addr_ptbl);

		for (pageno = 0; pageno != NPGPT; pageno++)
			pt_ptr[pageno].pgi.pg_pde = sbus_config.invalid_pde;

		/* assign page used for own stbl and own ptbl */
		pt_ptr[pnum(ADDR_OWN_STBL - ADDR_OWN_SEGS)] =
			pm20_km_to_pde(addr_stbl, PG_P|PG_R|PG_W|PG_CB);

		/* assign pages used for per processor u area */
		pt_ptr[pnum(ADDR_EXTRA_STK - ADDR_OWN_SEGS)] =
			pm20_km_to_pde(addr_extra_stk, PG_P|PG_R|PG_W|PG_CB);
		pt_ptr[pnum(ADDR_U - ADDR_OWN_SEGS)] =
			pm20_km_to_pde(addr_own_u, PG_P|PG_R|PG_W|PG_CB);
		pt_ptr[pnum(ADDR_OWN_EXTRA - ADDR_OWN_SEGS)] =
			pm20_km_to_pde(addr_own_extra, PG_P|PG_R|PG_W|PG_CB);
		pt_ptr[pnum(ADDR_OWN_U - ADDR_OWN_SEGS)] =
			pm20_km_to_pde(addr_own_u, PG_P|PG_R|PG_W|PG_CB);

		/* assign page used for own variables */
		pt_ptr[pnum(ADDR_OWN - ADDR_OWN_SEGS)] =
			pm20_km_to_pde(addr_own, PG_P|PG_R|PG_W|PG_CB);

		sbus_config.pm_own[pm_id] = addr_own;

		/* done with own page table, now ready to initialize own */

		own_ptr = (own_t *) km_map(addr_own);
		bzero((caddr_t)own_ptr, sizeof(*own_ptr));

		own_ptr->o_qtbl = (qde_t *) ADDR_OWN_BAD;
		own_ptr->o_stbl = (sde_t *) addr_stbl;
		own_ptr->o_cur_root.rde_all = sbus_config.invalid_rde;
		own_ptr->o_slot = sbus_slot;
		own_ptr->o_pm_id =
		  own_ptr->o_base_pm_id =
		  own_ptr->o_last_pm_id =
		  own_ptr->o_lock_id = pm_id;
		pm_id++;
	}
	iomap_restore(saved_map);
}

/*
 * Build the "bad" segment table
 */

static void
pm20_bad_stbl()
{
	register sde_t	*st_ptr;
	register uint	segno;
	register uint	saved_map = iomap_save();


	/*
	 * build bad stbl
	 */
	st_ptr = (sde_t *) km_map(ADDR_BAD_STBL);
	for (segno = 0; segno != (uint) UMEM_SIZE / NBPS; segno++)
		st_ptr[segno].sg_sge = sbus_config.invalid_sde;

	sbus_config.invalid_rde = pm20_km_to_rde(ADDR_BAD_STBL).rde_all;


	iomap_restore(saved_map);
}

/*
 * pm20_lpfn_init() - initialize the page frame adjustment and
 *		 linear page frame end factors.
 *
 * setup sbus_config structure for pfn_adjust's
 * setup sbus_config structure for lpfn_end's
 */
static void
pm20_lpfn_init()
{
	register uint	sbus_slot;
	register uint	lpfn, spfn;

	lpfn = 0;

	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {
		spfn = sbus_slot << SpfnToSlotShft;

		sbus_config.pfn_adjust[sbus_slot] = spfn - lpfn;

		lpfn += sbus_config.slot_size[sbus_slot] / NBPP;
		sbus_config.lpfn_end[sbus_slot] = lpfn;
	}
	num_pages = lpfn;
}

static uint
pm20_lpfn_to_pfn(lpfn)
uint	lpfn;
{
	uint	retval;
	uint	saved_map = iomap_save();

	K_ASSERT(pm_booting_done);

	retval = *(uint *)km_map((uint)&Spm_Mem->lpfn_tbl[lpfn]);

	iomap_restore(saved_map);

	return(retval);
}

static uint
pm20_spfn_to_pfn(spfn)
register uint	spfn;
{
	return(pm20_lpfn_to_pfn(pm20_spfn_to_lpfn(spfn)));
}

/*
 * pm20_sde_to_km -- method routine
 */

uint
pm20_sde_to_km(sde)
sde_t	sde;
{
	uint	ssfn;
	uint	vsfn;

	ssfn = sde.sgm.sg_sfn;

	vsfn = pm20_spfn_to_pfn(ssfn >> NPTPPSHFT) << NPTPPSHFT;
	vsfn += ssfn & ((1 << NPTPPSHFT) - 1);
	return(vsfn << BPTSHFT);
}

uint
pm20_rde_to_km(rde)
rde_t	rde;
{
	/* WARNING: This code assumes that rfn and pfn are the same thing */
	return(pm20_spfn_to_pfn(rde.rdm.rde_rfn) << PNUMSHFT);
}


#if 0		/* JPC: seems to be unused.... */
static uint
pm20_pde_to_pfn(pde)
pde_t	pde;
{
	return(pm20_spfn_to_pfn(pde.pgm.pg_pfn));
}

uint
pm20_pde_to_km(pde)
pde_t	pde;
{
	return(pm20_pde_to_pfn(pde) << PNUMSHFT);
}
#endif /* 0 */

uint
pm20_mem_stripe_init()
{
	register MEM_STRIPE *msp;
	register uint	i, num_mm;
	register uint	base_km, board_offset;
	register uint	s_num_board;
	uint		s_size, s_level;

	if (did_mem_stripe)
		return (0);

	pm20_lpfn_init();

	num_mm = 0;
	for (i = 0; i < SBUS_NUM_SLOT; i++) {
		switch (sbus_config.slot_id[i]) {
		case SBUS_MM:
			mem_sizes[num_mm] = sbus_config.slot_size[i];
			mem_slots[num_mm] = i;
			num_mm++;
		}
	}
	if (num_mm == 0) {
		printf("No memory boards found -- cannot boot!\n");
		return (1);
	}

	/* set all pm_own pointers to point to a bad address */
	for (i = 0; i < SBUS_MAX_NUM_PM; i++)
		sbus_config.pm_own[i] = ADDR_OWN_BAD;

	board_offset = 0;
	s_level = 0;
	base_km = ADDR_MEM_SEGS;
	msp = mem_stripe_tbl;

	for ( ; ; ) {
		s_num_board = 0;
		s_size = 0;

		/* find the minimum sized board in the set */
		for (i = 0; i < num_mm; i++) {
			if (mem_sizes[i] == 0)
				continue;
			if (s_size > mem_sizes[i] || s_size == 0)
				s_size = mem_sizes[i];
		}
		if (s_size == 0) {
#ifdef MEM_STRIPE_DEBUG
			msp = mem_stripe_tbl;
			s_level = 0;
			for ( ; s_level <= MM_NUM_SIZES; msp++, s_level++) {
				if (msp->num_mm == 0)
					break;
				printf("lvl %d: num=%2d, base=%#x, mb=%#x\n", 
				  s_level, msp->num_mm, msp->base_km,
				  msp->mb_per_lpfn);
				for (i = 0; i < msp->num_mm; i++)
					printf("  slot=%#x, base_pfn=%#x\n", 
					  i, msp->base_xpfn[i]);
			}
			delay(500);
#endif /* MEM_STRIPE_DEBUG */
			did_mem_stripe = 1;
			return (0);			/* all done */
		}

		for (i = 0; i < num_mm; i++) {
			if (mem_sizes[i] == 0)
				continue;

			mem_sizes[i] -= s_size;

			msp->base_xpfn[s_num_board++] = 
			  mem_slots[i] << SpfnToSlotShft | pnum(board_offset);
		}

		msp->num_mm = s_num_board;
		msp->mb_per_lpfn = ~0;
		msp->base_km = pnum(base_km);
#ifdef BARBER_POLE
		msp->pages_per_board = btoc(s_size);
#endif
		base_km += s_size * s_num_board;
		board_offset += s_size;
		s_level++;
		msp++;
	}
}

/*
 * pm20_build_page_table() - build all the tables
 */
void
pm20_build_page_table()
{
	pm20_ptbl();			/* build page tables */
	pm20_bad_stbl();
	pm20_stbl(ADDR_MEM_STBL);	/* build segment tables */
	pm20_own();
}
