/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) util.c: version 25.1 created on 11/27/91 at 15:40:18	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)util.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * util.c
 *
 *	monitor utilities
 *
 */

#include "global.h"
#include "spm_debug.h"


/*
 * From gets.c...
 * get a line of input from console: echo characters.
 * Change carriage return to newline and echo newline.
 * Keep getting character and store them into buf until a newline is processed.
 * Take care character delete: \b
 * Take care line delete characters:  ^U or ^X
 * user will never get carriage return or newline in the buf 
 */

char *
getstr(buf, limit)
char	*buf;
{
	register char	*lp;
	register int	c, count;

	lp = buf;
	count = 0;
	while (count < limit) {
		c = get_char() & 0x7f;	/* only take 7 bits */
		put_char(c);	/* Echo char */

		switch (c) {
		case '\n':
		case '\r':
			if (c == '\r')
				put_char('\n');
			*lp = '\0';
			return (buf);
		case '\b':
			if (lp <= buf)
				lp = buf;
			else {
				count--;
				lp--;
			}
			continue;
		case '\025':	/* ^U */
		case '\030':	/* ^X */
			count = 0;
			lp = buf;
			put_char('\n');
			continue;
		case '\033':
			lp = buf;
			*lp = '\0';
			put_char('\n');
			return (NULL);
		default:
			count++;
			*lp++ = c;
		}
	}
	buf[limit - 1] = '\0';
	return (buf);
}
