/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) trap.c: version 25.1 created on 11/27/91 at 15:40:14	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)trap.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* trap.c */

/*
 *  This module contains the stand-alone program I/O support
 */

/* This is for the spm, specifically, so use 68020 include files & defines */
#ifdef	M68040
#undef	M68040
#define	M68020
#endif	/* M68040 */

#include "misc.h"
#include "global.h"
#include "sys/types.h"
#include "spm_debug.h"
#include "spm_trap.h"

trap_0(stk_frame)
struct trap stk_frame;		/* stk_frame is value/result */
{
	register uint ret_val=0;

	switch(stk_frame.function) {
	case CONOUT:
		con_out(stk_frame.param1);
		break;
	case CONIN:
		ret_val = con_in();
		break;
	case DEVREQ:
		printf("The DEVREQ psuedo-system call has gone away\n");
		ret_val = -1;
		break;
	case CHGINT:
		Chgint(stk_frame.param1);
		break;
	case PUTCHAR:
		put_char(stk_frame.param1);
		break;
	case GETCHAR:
		ret_val = Get_char();
		break;
	case USRABORT:
		ret_val = Usrabort();
		break;
	case OPEN:
		ret_val = Open(stk_frame.param1, stk_frame.param2);
		break;
	case CLOSE:
		ret_val = Close(stk_frame.param1);
		break;
	case WRITE:
		ret_val = Write(stk_frame.param1, stk_frame.param2,
				stk_frame.param3);
		break;
	case READ:
		ret_val = Read(stk_frame.param1, stk_frame.param2,
				stk_frame.param3);
		break;
	case IOCTL:
		ret_val = Ioctl(stk_frame.param1, stk_frame.param2,
				stk_frame.param3);
		break;
	case LSEEK:
		ret_val = Lseek(stk_frame.param1, stk_frame.param2,
				stk_frame.param3);
		break;
	case FSTAT:
		ret_val = Fstat(stk_frame.param1, stk_frame.param2);
		break;
	case EXIT:
		Exit();
	case CHKDRV:
		printf("The CHKDRV psuedo-system call has gone away\n");
		ret_val = -1;
		break;
	case NINETRK:
		printf("The NINETRK psuedo-system call has gone away\n");
		ret_val = -1;
		break;
	case CHKSCSI:
		printf("The CHKSCSI psuedo-system call has gone away\n");
		ret_val = -1;
		break;
	case SHOW_CONT:
		show_controllers();	/* FIX JPC, redo as method-based func */
		break;
	default:
		break;
	}
	return(ret_val);
}
