/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) status.c: version 25.1 created on 11/27/91 at 15:40:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)status.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* status.c */

#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "menu.h"
#include "scc.h"
#include "cio.h"
#include "adc.h"
#include "rwi.h"
#include "novram.h"
#include "sys/uadmin.h"
#include "sys/sysarix.h"

extern unsigned short crctab[];
extern char	*dis_en_abled[];
extern char	*off_on_str[];

extern uint	get_ps_reading(), 
		get_ps_amps_type(),
		get_local_reading(), 
		get_cabinet_reading();
extern char	*frac_str();

static char	*margin_nm[] = { "off", "high", "low", "ERROR!" };

uint	printer_on,
	modem_on;

static
console_control(argc)
int	argc;
{
	register uint	baud_rate = NOVRAM->console_baud_rate;

	if (argc == 0)
		printf("console port at %d\n", baud_rate);
	else if (argc == 1) {
		baud_rate = atoi(comm_args[1]);
		if (change_baud(CONSOLE_PORT, baud_rate, 1)) {
			printf("console port does not support %d baud\n",
			  baud_rate);
			return;
		}
	}
}

static
modem_control(argc)
int	argc;
{
	register int	baud_rate = NOVRAM->modem_baud_rate;
	uint		online;
	int		new_value;

	switch (on_off(argc, comm_args[1])) {
	case ON_ARG:
		new_value = 1;
		break;
	case OFF_ARG:
		new_value = 0;
		break;
	case NO_ARG:
		new_value = -1;
		break;
	case BAD_ARG:
	default:
		return;
	}

	online = (MODEM_PORT->reg[0].reg & DCD_DSR) == DCD_DSR ?  1 : 0;
	if (new_value >= 0) {
		NOVRAM->modem_active = modem_on = (online ? new_value : 0);
		shared_crc();
		if (!online) {
			printf("Sorry, modem not on line\n");
			return;
		}

		if (argc >= 2 && modem_on &&
		    ((baud_rate = atoi(comm_args[2])) <= 0 ||
		     change_baud(MODEM_PORT, baud_rate, 1))) {
			printf("modem port does not support %d baud\n",
			  baud_rate);
			return;
		}
	}

	printf("Modem port %sline (%s), baud rate: %d\n",
	  off_on_str[online], dis_en_abled[modem_on], baud_rate);
}

static
printer_control(argc)
int	argc;
{
	register uint	baud_rate = NOVRAM->printer_baud_rate;
	uint		online;
	int		new_value;

	switch (on_off(argc, comm_args[1])) {
	case ON_ARG:
		new_value = 1;
		break;
	case OFF_ARG:
		new_value = 0;
		break;
	case NO_ARG:
		new_value = -1;
		break;
	case BAD_ARG:
	default:
		return;
	}

	online = (PRINTER_PORT->reg[0].reg & RR0_DCD) ? 1 : 0;
	if (new_value >= 0) {
		NOVRAM->printer_active = printer_on = (online ? new_value : 0);
		shared_crc();
		if (!online) {
			printf("Sorry, printer not on line.\n");
			return;
		}

		if (argc >= 2 && printer_on &&
		    ((baud_rate = atoi(comm_args[2])) <= 0 ||
		     change_baud(PRINTER_PORT, baud_rate, 1))) {
			printf("printer port does not support %d baud\n",
			  baud_rate);
			return;
		}
	}

	printf("Printer port %sline (%s), baud rate: %d\n",
	  off_on_str[online], dis_en_abled[printer_on], baud_rate);
}

static
local_power_status()
{
	if (!local_first_pass_done || !poll_local)
		printf("Sorry, local sensor polling needs to be enabled\n");
	else
		local_ps_reading();
}

static
local_ps_reading()
{
	printf("Local 5 volt      = %s V\n",
	  frac_str(LOCAL_FIVE_VOLT, get_local_reading(LOC_FIVE_VOLT)));
	printf("Aux 5 volt        = %s V\n",
	  frac_str(AUX_FIVE_VOLT, get_local_reading(LOC_AUX_FIVE_VOLT)));
	printf("Local 12 volt     = %s V\n",
	  frac_str(LOCAL_TWELVE_VOLT, get_local_reading(LOC_TWELVE_VOLT)));
	printf("Aux 12 volt       = %s V\n",
	  frac_str(AUX_TWELVE_VOLT, get_local_reading(LOC_AUX_TWELVE_VOLT)));
	printf("Local neg 12 volt = %s V\n",
	  frac_str(LOCAL_NEG_TWELVE_VOLT,
	    get_local_reading(LOC_NEG_TWELVE_VOLT)));
	printf("Aux neg 12 volt   = %s V\n",
	  frac_str(AUX_NEG_TWELVE_VOLT,
	    get_local_reading(LOC_AUX_NEG_TWELVE_VOLT)));
}


static
cage_temperature()
{
	if (!local_first_pass_done)
		printf("sorry, local sensor polling needs to be enabled\n");
	else
		cage_reading();
}

static
cage_reading()
{
	printf("CSS card cage temperature = %s C\n",
	  frac_str(CAGE_AIR, get_local_reading(LOC_CAGE_AIR)));
}

static
cabinet_temperature(argc)
int	argc;
{
	register uint num;

	if (!poll_rwi)
		printf("Sorry, RWI sensor polling needs to be enabled\n");
	else if (!rwi_first_pass_done)
		printf("Sorry, did not finish reading RWI sensors\n");
	else if (argc == 0) {
		for (num = 0; num < NUM_CAB_PER_SYS; num++) {
			if (NOVRAM->cab_present[num].present)
				cab_reading(num);
		}
	}
	else {
		num = Atox(comm_args[1]);
		if (num >= NUM_CAB_PER_SYS)
			printf("Cabinet %d does not exist! (Try 0 to %d)\n",
			  num, NUM_CAB_PER_SYS - 1);
		else if (NOVRAM->cab_present[num].present)
			cab_reading(num);
		else
			printf("Cabinet %d isn't in the system configuration\n",
			  num);
	}
}

/*
 * cab_reading -- print data on cabinet num
 */

static
cab_reading(num)
uint	num;
{
	if (NOVRAM->cab_present[num].inlet_air) {
		printf("Cabinet %x inlet air  = %s C\n", num,
		  frac_str(INLET_AIR, get_cabinet_reading(num, CAB_INLET_AIR)));
	}
	else
		printf("Cabinet %x inlet air sensor is deconfigured\n", num);

	if (NOVRAM->cab_present[num].exhaust_air) {
		printf("Cabinet %x exhaust air  = %s C\n", num,
		  frac_str(EXHAUST_AIR,
		    get_cabinet_reading(num, CAB_EXHAUST_AIR)));
	}
	else
		printf("Cabinet %x exhaust air sensor is deconfigured\n", num);
}


/*
 * main_power_status -- print data on power suply num
 */

static
main_power_status(argc)
int	argc;
{
	register uint	num;
	uint		pass;
	int		c, count;
	static char	msg[] = "Press any key to continue or <ESC> to abort";

	if (!poll_rwi)
		printf("sorry, RWI sensor polling needs to be enabled\n");
	else if (!rwi_first_pass_done)
		printf("sorry, did not finish reading RWI sensors\n");
	else if (argc == 0) {
		for (num = 0, pass = 0; num < NUM_PS_PER_SYS; num++) {
			if (NOVRAM->main_pwr[num].ps_id == NO_POWER_SUPPLY)
				continue;
			if (pass) {
				printf("%s...", msg);
				for (count = 80; count > 0; count--) {
			   		delay_and_poll(5);
					if ((c = con_in()) != -1)
						break;
				}
				if ((count == 0) || (c == ESCAPE)) {
					printf("aborted\n");
					return;
				}
				printf("\n");
			}
			main_ps_reading(num);
			pass++;
		}
	}
	else {
		num = (uint)Atox(comm_args[1]);
		if (num >= NUM_PS_PER_SYS)
			printf("Main power supply %d invalid! (Use 0 to %d)\n",
			  num, NUM_PS_PER_SYS - 1);
		else if (NOVRAM->main_pwr[num].ps_id != NO_POWER_SUPPLY)
			main_ps_reading(num);
		else
			printf("Sorry, main power supply %d not in system configuration\n", num);
	}
}

static
main_ps_reading(num)
uint	num;
{
	if (NOVRAM->main_pwr[num].five_volt) {
		printf("Power supply %x   5V = %s V\n", num,
		  frac_str(MAIN_FIVE_VOLT, get_ps_reading(num, POW_FIVE_VOLT)));
	}
	else
		printf("Power supply %x 5V sensor is deconfigured\n", num);

	if (NOVRAM->main_pwr[num].twelve_volt) {
		printf("Power supply %x  12V = %s V\n", num, 
		  frac_str(MAIN_TWELVE_VOLT,
		   get_ps_reading(num, POW_TWELVE_VOLT)));
	}
	else
		printf("Power supply %x 12V sensor is deconfigured\n", num);

	if (NOVRAM->main_pwr[num].neg_twelve_volt) {
		printf("Power supply %x -12V = %s V\n", num,
		  frac_str(MAIN_NEG_TWELVE_VOLT,
		   get_ps_reading(num, POW_NEG_TWELVE_VOLT)));
	}
	else
		printf("Power supply %x -12V sensor is deconfigured\n", num);


	if (NOVRAM->main_pwr[num].five_volt_current) {
		printf("Power supply %x 5V current  = %s A\n", num,
		  frac_str(get_ps_amps_type(num),
		   get_ps_reading(num, POW_FIVE_VOLT_CURRENT)));
	}
	else
		printf("Power supply %x 5V current sensor is deconfigured\n",
		  num);


	if (NOVRAM->main_pwr[num].temp) {
		printf("Power supply %x temperature = %s C\n", num,
		  frac_str(PS_TEMP, get_ps_reading(num, POW_TEMP)));
	}
	else
		printf("Power supply %x temperature sensor is deconfigured\n",
		  num);
	/* report local stats for cabinet 0 */
	if ((num == 0) && (poll_local))
		local_power_status();
	printf("\n");
}

/*
 * rad -- control rwi polling
 */

static
rad(argc)
int	argc;
{
	unchar	rwi_type;

	rwi_type = (RWI_CIO1->portdata[0].reg) & RWI_TYPE_MASK;
	if (rwi_type & RWI_TYPE_ACRW) {
		printf("SPM interface card is an ACRW - no atod available\n");
		return;
	}
	if (rwi_type != RWI_REV_2B) {
		printf("sorry, RWI type not a rev 2B\n");
		return;
	}
	switch (on_off(argc, comm_args[1])) {
	case ON_ARG:
		poll_rwi = 1;
		rwi_first_pass_done = 0;
		break;
	case OFF_ARG:
		poll_rwi = 0;
		rem_rwi_sensors();
		break;
	case NO_ARG:
		break;
	case BAD_ARG:
	default:
		return;
	}
	printf("RWI sensor polling %s\n", dis_en_abled[poll_rwi]);
}

/*
 * lad -- control local polling
 */

static
lad(argc)
int	argc;
{
	switch (on_off(argc, comm_args[1])) {
	case ON_ARG:
		poll_local = 1;
		local_first_pass_done = 0;
		break;
	case OFF_ARG:
		poll_local = 0;
		rem_local_sensors();
		break;
	case NO_ARG:
		break;
	case BAD_ARG:
	default:
		return;
	}
	printf("local A/D poll %s\n", dis_en_abled[poll_local]);
}

/*
 * convert_reading - convert the result according to type and put the result
 *			in fnump
 */

convert_reading(type, result, fnump)
uint		type, result;
register frac_t	*fnump;
{
	register int	neg = 0;
	register int	val = result;

	switch (type) {
	case INLET_AIR:
	case EXHAUST_AIR:
	case EXHAUST_DELTA:
	case PS_TEMP:
	case CAGE_AIR:
		val *= TEN_THOUSAND * VOLTS_PER_BIT;
		val = (val - VOLTAGE_OFFSET) / VOLTS_PER_DEGREE;
		break;
	case MAIN_FIVE_VOLT:
	case LOCAL_FIVE_VOLT:
	case AUX_FIVE_VOLT:
		val *= FIVE_VOLTS_PER_BIT;
		break;
	case MAIN_TWELVE_VOLT:
	case LOCAL_TWELVE_VOLT:
	case AUX_TWELVE_VOLT:
		val *= TWELVE_VOLTS_PER_BIT;
		break;
	case LOCAL_NEG_TWELVE_VOLT:
	case AUX_NEG_TWELVE_VOLT:
	case MAIN_NEG_TWELVE_VOLT:
		/* val = 0 when voltage is equal to -25.92 volts */
		/* change rate = -118.8 volts/bit */
		/* 0x00	= -25.92 */
		/* 0x75 = 12.00 */
		/* 0xda =  0.00 */

		if (val >= NEG_TWELVE_ZERO)
			val = 0;
		else
			val = NEG_TWELVE_MAX - (NEG_TWELVE_VOLTS_PER_BIT * val);
		neg = 1;
		break;
	case MAIN_FIVE_VOLT_CURRENT:
		val = 0;	/* use the more descriptive types below */
		break;
	case MAIN_5V_HC_AMPS:
		val *= TEN_THOUSAND * VOLTS_PER_BIT;
		val /= HC_VOLTS_PER_AMP;
		break;
	case MAIN_5V_SWITCH_AMPS:
		val *= TEN_THOUSAND * VOLTS_PER_BIT;
		val /= SW_VOLTS_PER_AMP;
		break;
	case LOCAL_VREF:
		val *= VOLTS_PER_BIT;
		break;
	default:
		printf("convert_reading: unknown type = 0x%x\n", type);
		val = 0;
		break;
	}
	if (val < 0)
		val = 0;
	val /= 100;
	fnump->hundredths = val % 10;
	val /= 10;
	fnump->tenths	  = val % 10;
	val /= 10;
	fnump->number	  = neg ? -val : val;
}

/*
 * convert_frac - convert the fnump according to type and return it or BAD_UINT
 */

uint
convert_frac(type, fnump)
uint		type;
register frac_t	*fnump;
{
	register uint	neg;
	register uint	val;

	if (fnump->number < 0) {
		val = -fnump->number;
		neg = 1;
	}
	else {
		val = fnump->number;
		neg = 0;
	}

	val *= 10;
	val += fnump->tenths;
	val *= 10;
	val += fnump->hundredths;
	val *= 100;

	switch (type) {
	case INLET_AIR:
	case EXHAUST_AIR:
	case EXHAUST_DELTA:
	case PS_TEMP:
	case CAGE_AIR:
		val = (val + VOLTAGE_OFFSET) * VOLTS_PER_DEGREE;
		val /= TEN_THOUSAND * VOLTS_PER_BIT;
		break;
	case MAIN_FIVE_VOLT:
	case LOCAL_FIVE_VOLT:
	case AUX_FIVE_VOLT:
		val /= FIVE_VOLTS_PER_BIT;
		break;
	case MAIN_TWELVE_VOLT:
	case LOCAL_TWELVE_VOLT:
	case AUX_TWELVE_VOLT:
		val /= TWELVE_VOLTS_PER_BIT;
		break;
	case LOCAL_NEG_TWELVE_VOLT:
	case AUX_NEG_TWELVE_VOLT:
	case MAIN_NEG_TWELVE_VOLT:
		/* val = 0 when voltage is equal to -25.92 volts */
		/* change rate = -118.8 volts/bit */
		/* 0x00	= -25.92 */
		/* 0x75 = 12.00 */
		/* 0xda =  0.00 */

		if (!neg || val == 0)
			val = NEG_TWELVE_ZERO;
		else
			val = (NEG_TWELVE_MAX - val) / NEG_TWELVE_VOLTS_PER_BIT;
		break;
	default:
		return (BAD_UINT);
	}

	return (val);
}

/*
 * get_margin -- return the power supply margin for supply num
 */

uint
get_margin(num)
uint	num;
{
	register uint	portb_data, portc_data, v;

	if ((num >= NUM_PS_PER_SYS) ||
	  (NOVRAM->main_pwr[num].ps_id == NO_POWER_SUPPLY))
		return (PS_MARGIN_BAD);

	portb_data = RWI_CIO1->portdata[1].reg;
	portc_data = RWI_CIO1->portdata[2].reg;

	switch (num) {
	case 0:
		v  = (portb_data & PS_0_MARGIN_HIGH) ? 1 : 0;
		v |= (portb_data & PS_0_MARGIN_LOW)  ? 2 : 0;
		break;
	case 1:
		v  = (portb_data & PS_1_MARGIN_HIGH) ? 1 : 0;
		v |= (portb_data & PS_1_MARGIN_LOW)  ? 2 : 0;
		break;
	case 2:
		v  = (portb_data & PS_2_MARGIN_HIGH) ? 1 : 0;
		v |= (portb_data & PS_2_MARGIN_LOW)  ? 2 : 0;
		break;
	case 3:
		v  = (portb_data & PS_3_MARGIN_HIGH) ? 1 : 0;
		v |= (portc_data & PS_3_MARGIN_LOW)  ? 2 : 0;
		break;
	case 4:
		v  = (portb_data & PS_4_MARGIN_HIGH) ? 1 : 0;
		v |= (portc_data & PS_4_MARGIN_LOW)  ? 2 : 0;
		break;
	default:
		v = PS_MARGIN_BAD;
	}
	return (v);
}

/*
 * set_margin -- set/reset the margin for power supply num
 */

uint
set_margin(num, margin)
register uint	num, margin;
{
	register unchar	portc;
	register uint	high, low, old_margin;
	uint		spl_level;

	old_margin = get_margin(num);

	/*
	 * Its unhealthy to go directly from low to high, or vice versa,
	 * so switch to PS_MARGIN_OFF and delay for 3 clock ticks to
	 * guarantee at least 40 milliseconds of transition time.
	 */
	if (margin != PS_MARGIN_OFF && old_margin != PS_MARGIN_OFF) {
		(void) set_margin(num, PS_MARGIN_OFF);
		spl_level = spl0();
		delay_and_poll(3);
		splx(spl_level);
	}

	switch (num) {
	case 0:
		low  = PS_0_MARGIN_LOW;
		high = PS_0_MARGIN_HIGH;
		break;
	case 1:
		low  = PS_1_MARGIN_LOW;
		high = PS_1_MARGIN_HIGH;
		break;
	case 2:
		low  = PS_2_MARGIN_LOW;
		high = PS_2_MARGIN_HIGH;
		break;
	case 3:
		low  = PS_3_MARGIN_LOW;
		high = PS_3_MARGIN_HIGH;
		break;
	case 4:
		low  = PS_4_MARGIN_LOW;
		high = PS_4_MARGIN_HIGH;
		break;
	}

	switch (num) {
	case 0:
	case 1:
	case 2:
		switch (margin) {
		case PS_MARGIN_OFF:
			RWI_CIO1->portdata[1].reg &= ~(high | low);
			break;
		case PS_MARGIN_HIGH:
			RWI_CIO1->portdata[1].reg &= ~low;
			RWI_CIO1->portdata[1].reg |= high;
			break;
		case PS_MARGIN_LOW:
			RWI_CIO1->portdata[1].reg &= ~high;
			RWI_CIO1->portdata[1].reg |= low;
			break;
		}
		break;
	case 3:
	case 4:
		switch (margin) {
		case PS_MARGIN_OFF:
			RWI_CIO1->portdata[1].reg &= ~high;
			portc = RWI_CIO1->portdata[2].reg & 0x0f;
			RWI_CIO1->portdata[2].reg = portc & ~low;
			break;
		case PS_MARGIN_HIGH:
			portc = RWI_CIO1->portdata[2].reg & 0x0f;
			RWI_CIO1->portdata[2].reg = portc & ~low;
			RWI_CIO1->portdata[1].reg |= high;
			break;
		case PS_MARGIN_LOW:
			RWI_CIO1->portdata[1].reg &= ~high;
			portc = RWI_CIO1->portdata[2].reg & 0x0f;
			RWI_CIO1->portdata[2].reg = portc | low;
			break;
		}
		break;
	}

	return (old_margin);
}

static void
display_ps_margin(num)
uint	num;
{
	printf("Main power supply # %d margin is %s\n",
	  num, margin_nm[get_margin(num)]);
}

static
margin_power(argc)
int	argc;
{
	register uint	num;
	register uint	margin;

	if (argc == 0) {
		for (num = 0; num < NUM_PS_PER_SYS; num++) {
			if (NOVRAM->main_pwr[num].ps_id == NO_POWER_SUPPLY)
				continue;

			display_ps_margin(num);
		}
		return;
	}
	num = (uint)Atox(comm_args[1]);
	if (num >= NUM_PS_PER_SYS) {
		printf("Main power supply number %d exceeds the maximum\n",
		  num);
		return;
	}
	if (NOVRAM->main_pwr[num].ps_id == NO_POWER_SUPPLY) {
		printf("Main power supply %d is not in system configuration\n",
		  num);
		return;
	}
	if (argc == 1) {
		display_ps_margin(num);
		return;
	}
	if (!strcmp(comm_args[2], "off"))
		margin = PS_MARGIN_OFF;
	else if (!strcmp(comm_args[2], "high"))
		margin = PS_MARGIN_HIGH;
	else if (!strcmp(comm_args[2], "low"))
		margin = PS_MARGIN_LOW;
	else {
		printf("Illegal argument '%s'. Use 'high', 'low', or 'off'.\n",
		  comm_args[1]);
		return;
	}
	printf("Main power supply # %d margin was %s,",
	  num, margin_nm[set_margin(num, margin)]);
	printf(" now is %s\n", margin_nm[get_margin(num)]);
}

static
rcio()
{
	printf("CIO 0 data port A (0x%x) = 0x%02x\n",
	  RWI_CIO0_PORTA, *RWI_CIO0_PORTA);
	printf("CIO 0 data port B (0x%x) = 0x%02x\n",
	  RWI_CIO0_PORTB, *RWI_CIO0_PORTB);
	printf("CIO 0 data port C (0x%x) = 0x%x\n",
	  RWI_CIO0_PORTC, *RWI_CIO0_PORTC & 0xf);
	printf("CIO 1 data port A (0x%x) = 0x%02x\n",
	  RWI_CIO1_PORTA, *RWI_CIO1_PORTA);
	printf("CIO 1 data port B (0x%x) = 0x%02x\n",
	  RWI_CIO1_PORTB, *RWI_CIO1_PORTB);
	printf("CIO 1 data port C (0x%x) = 0x%x\n",
	  RWI_CIO1_PORTC, *RWI_CIO1_PORTC & 0xf);
}

static
rscc()
{
	printf("console read reg 0 (0x%x) = 0x%x\n", &CONSOLE_PORT->reg[0].reg,
	  CONSOLE_PORT->reg[0].reg);
	printf("console read reg 8 (0x%x) = 0x%x\n", &CONSOLE_PORT->reg[8].reg,
	  CONSOLE_PORT->reg[8].reg);

	printf("modem read reg 0 (0x%x) = 0x%x\n", &MODEM_PORT->reg[0].reg,
	  MODEM_PORT->reg[0].reg);
	printf("modem read reg 8 (0x%x) = 0x%x\n", &MODEM_PORT->reg[8].reg,
	  MODEM_PORT->reg[8].reg);

	printf("printer read reg 0 (0x%x) = 0x%x\n", &PRINTER_PORT->reg[0].reg,
	  PRINTER_PORT->reg[0].reg);
	printf("printer read reg 8 (0x%x) = 0x%x\n", &PRINTER_PORT->reg[8].reg,
	  PRINTER_PORT->reg[8].reg);
}

/*
 * cabinet_power -- power off all cabinets
 */

static
cabinet_power()
{
	if (getyn("\nReally switch off power?  ")) {
		printf("\nPowering system off...\n");
		shutdown(MD_POWEROFF);
	}
	printf("\nOk.\n");
}

static
sensor_poll(argc)
int	argc;
{
	switch (on_off(argc, comm_args[1])) {
	case ON_ARG:
		NOVRAM->poll = 1;
		runtime_crc();
		break;
	case OFF_ARG:
		NOVRAM->poll = 0;
		runtime_crc();
		break;
	case NO_ARG:
		break;
	case BAD_ARG:
	default:
		return;
	}
	printf("Sensor polling is %s by default\n",
	  dis_en_abled[NOVRAM->poll != 0]);
}

/*
 * nov_chk_sum -- checksum the NOVRAM, and return value calculated.
 */

uint
nov_chk_sum(cstart, cend)
register uchar	*cstart, *cend;
{
	register uint	crc = 0;

	/* crc all bytes, except crc itself.. */
	while (cstart < cend)
		crc = (crc << 8) ^
		  crctab[(((crc >> 8) & 0x00ff) ^ *cstart++) & 0x00ff];
	return(crc & 0x0000ffff);	/* and return to calling program. */
}

uint
runtime_crc_val()
{
	return (nov_chk_sum(&NOVRAM->shutdown, &NOVRAM->runtime_end));
}

uint
shared_crc_val()
{
	return (nov_chk_sum((uchar *)NOVRAM->nv_lim,
	  (uchar *)&NOVRAM->shared_crc));
}

uint
rwi_val_crc_val()
{
	return (nov_chk_sum((uchar *)NOVRAM->nv_lim,
	  (uchar *)&NOVRAM->console_baud_rate));
}

runtime_crc()
{
	NOVRAM->runtime_crc = runtime_crc_val();
}

shared_crc()
{
	NOVRAM->shared_crc = shared_crc_val();
}

rwi_val_crc()
{
	NOVRAM->rwi_val_crc = rwi_val_crc_val();
}

extern int	prnt_time_stamp();
extern int	print_spm_version();

struct init_menu i_system_status[] = {
 { "local",	"<on/off>- local sensor polling", MF_EXPERT, 0, 1, lad },
 { "rwi",	"<on/off>- RWI sensor polling", MF_EXPERT, 0, 1, rad },
 { "poll",	"<on/off>- alter sensor polling default",
   MF_EXPERT, 0, 1, sensor_poll },
 { "printer",	"<on/off> <baud rate>- printer port control",
   MF_EXPERT, 0, 2, printer_control },
 { "console",	"<baud rate>- console port control",
   MF_EXPERT, 0, 1, console_control },
 { "modem",	"<on/off> <baud rate>- modem port control",
   MF_EXPERT, 0, 2, modem_control },
 { "cab",	"<cabinet num>- display cabinet temperature",
   MF_EXPERT, 0, 1, cabinet_temperature },
 { "cage",	"- display CSS card cage temperature",
   MF_EXPERT, 0, 0, cage_temperature },
 { "pwr",	"<power supply num>- display main power supply status",
   MF_EXPERT, 0, 1, main_power_status },
 { "lpwr",	"- display local power supply status",
   MF_EXPERT, 0, 0, local_power_status },
 { "margin",	"<supply num> <high/low/off>- margin power supply",
   MF_EXPERT, 0, 2, margin_power },
 { "pwroff",	"- power off system", MF_EXPERT, 0, 1, cabinet_power },
 { "cio",	"- display CIO ports", MF_EXPERT, 0, 0, rcio },
 { "scc",	"- display SCC ports", MF_EXPERT, 0, 0, rscc },
 { "date",	"- display clock chip time", MF_EXPERT, 0, 0, prnt_time_stamp },
 { "version",	"- display SPM version info",
   MF_EXPERT, 0, 0, print_spm_version },
 { 0 }
};
