/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sa.c: version 25.1 created on 11/27/91 at 15:39:59	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sa.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* sa.c */


#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "sys/debug.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "sa_dir.h"
#include "scnhdr.h"
#include "filehdr.h"
#include "aouthdr.h"
#include "menu.h"
#include "novram.h"
#include "dev.h"
#include "slotdefs.h"
#include "sys/fs/s5dir.h"
#include "sys/stat.h"
#include "sys/uadmin.h"


extern int 	debugrq;
extern		match();
extern char	*off_on_str[];
extern char	*dis_en_abled[];

extern char	*strrchr(), *strcpy();
extern uint	load_m68k();

uint		running_standalone;


sa_load(arg_cnt)
int	arg_cnt;
{
	register int	(*exec)();
	uint		entry;
	char		*p;
	char		*filename;
	char		name[DEV_NAMLEN];
	ushort	version;

	if (pm_booted() || check_io())
		return;

	filename = comm_args[0];

	if (!cpu_set_slot(NULL, MAKE_SNS(spm_slot, NO_SUB_SLOT)))
		return;

	p  = (arg_cnt ? comm_args[1] : NOVRAM->sa_boot_disk);
	sprintf(name, "%s%s", p, filename);

	if ((entry = load_m68k_sa(name, &version)) == 0 || entry == ~0)
		return;
	exec = (int(*)())entry;
	
	if (dbug)
		printf("sa_load: %s : exec=0x%08x\n", name, exec);

	if (arg_cnt) {
		strcpy(NOVRAM->sa_boot_disk, p);
		runtime_crc();
	}

	abortflag = 0;			/* always do this before an exec */
	running_standalone = 1;
	/* standalone version numbers are represented as decimal purely
	 * because that's the way that the utility 'file' reports them
	 * Thus, the same value is given for standalone and utility iopmfmt
	 * Break the number into a version and revison part
	 */
	printf("\nStandalone %s Ver %d.%02d\n", filename,
			version / 100, version % 100);
	(*exec)();
	Exit();
	/*NOTREACHED*/
}

list_reserved(arg_cnt)
int	arg_cnt;
{
	register int	fd, i;
	sa_dir_t 	*dir_buf;	
	sa_dir_entry_t	*ent;
	char		*path;

	if (pm_booted() || check_io())
		return(-1);

	path = arg_cnt ? comm_args[1] : NOVRAM->sa_boot_disk;

	if ((fd = Open(path, 0)) < 0) {
		printf("open on %s failed\n", path);
		return(-1);
	}

	dir_buf = ((struct sa_dir *)(dir_load_point));

	if (Read(fd, dir_buf, BLK_SIZE) != BLK_SIZE) {
		printf("failed to read directory block!\n");
		(void) Close(fd);
		return(-1);
	}

	if (dir_buf->magic_num != MAGIC_NUM) {
		printf("invalid magic number in bootimage!\n");
		(void) Close(fd);
		return(-1);
	}

	for (ent = dir_buf->entry, i = MAX_DIR_ENTRY; --i >= 0; ent++) {
		if (ent->name[0]) {
			printf("%-15s version %2.1d.%02d %8d bytes",
			  ent->name, ent->major_version, ent->minor_version,
			  ent->byte_count);
			if (ent->spm_exec)
				printf(" (spm local executable)");
			put_char('\n');
		}
	}

	if (Close(fd) < 0) {
		printf("close of fd %d failed\n", fd);
		return(-1);
	}

	return(0);
}

/*
 * list_unix -- do a "ls" on the default slice, or a given slice/path
 */

list_unix(arg_cnt)
int	arg_cnt;
{
	register int		fd, tfd, n, size, num, fmt;
	register struct direct 	*dp;
	unchar	buffer[BLK_SIZE];
	char			source_device[DEV_NAMLEN], 
				tmp[DEV_NAMLEN];
	char			name[sizeof(dp->d_name) + 1];
	struct stat		stbuf;

	if (pm_booted() || check_io()) 
		return(-1);

	fmt = 1;					/* short format */
	*source_device = '\0';
	if (arg_cnt > 0) {
		if (strcmp(comm_args[1], "l") == 0 ||
		    strcmp(comm_args[1], "-l") == 0) {
			fmt = 0;			/* long format */
			if (arg_cnt == 2)
				strcpy(source_device, comm_args[2]);
		}
		else
			strcpy(source_device, comm_args[1]);
	}

	/*
	 * do default slice and/or append . to dev/slice
	 */
	if (*source_device == '\0') {
		strcpy(source_device, (char *)NOVRAM->kernel_boot_disk);
		slice_basename(source_device);
		strcat(source_device, ".");
	}
	else {
		strcpy(tmp, source_device);
		slice_basename(tmp);
		if (strcmp(source_device, tmp) == 0)
			strcat(source_device, ".");	/* append . to slice */
	}

	ls_str(source_device);
	if ((fd = Open(source_device, 0)) < 0) {
		printf("list_unix: open on %s failed\n", source_device);
		return (-1);
	}

	if (Fstat(fd, &stbuf)) {
		printf("list_unix: fstat failed!\n");
		(void) Close(fd);
		return (-1);
	}

	/*
	 * if not directory, just list the file itself
	 */
	if (!S_ISDIR(stbuf.st_mode)) {
		(void) ls_display(source_device, &stbuf, fmt);
		put_char('\n');
		(void) Close(fd);
		return (0);
	}

	printf("%s:\n", source_device);
	for (size = stbuf.st_size; size > 0; size -= num) {
		if ((num = Read(fd, buffer, BLK_SIZE)) < 0) {
			printf("failed to read directory\n");
			(void) Close(fd);
			return (-1);
		}

		dp = (struct direct *)buffer;
		for (n = num; n > 0; dp++, n -= sizeof(*dp)) {
			if (dp->d_ino == 0)
				continue;		/* skip empty slots */
			if (dp->d_name[0] == '.' &&
			  (dp->d_name[1] == '\0' ||
			    (dp->d_name[1] == '.' && dp->d_name[2] == '\0')))
				continue;		/* skip . and .. */

			strncpy(name, dp->d_name, sizeof(dp->d_name));
			name[sizeof(dp->d_name)] = '\0';
			ls_str(name);
			strcpy(tmp, source_device);
			strcat(tmp, "/");
			strcat(tmp, name);
			fmt = ls_display(tmp, &stbuf, fmt);
		}
	}
	if (fmt > 1)
		put_char('\n');
	(void) Close(fd);

	return(0);
}

/*
 * ls_str -- replace all non-printable characters with '?'s
 */

ls_str(str)
register char	*str;
{
	register int	c;

	while (c = *str)
		if (!isascii(c) || !isprint(c))
			*str++ = '?';
		else
			++str;
}

/*
 * pathend -- return a pointer to the last component of a pathname
 *		Now recognizes device descriptors
 */

char *
pathend(path)
register char	*path;
{
	register char	*p;
	char		tmp[4*DEV_NAMLEN];

	strcpy(tmp, path);
	slice_basename(tmp);

	if (strcmp(path, tmp) != 0) {
		path += strlen(tmp);

		if (p = strrchr(path, '/'))
			return (p + 1);
	}

	return (path);
}

/*
 * ls_display -- display one entry in either short or long format
 */

ls_display(name, sp, fmt)
char		*name;
struct stat	*sp;
int		fmt;
{
	int	tfd;
	char	lsflags[16];

	if (fmt == 0) {
		if ((tfd = Open(name, 0)) < 0) {
			printf("open on %s failed\n", name);
			return (fmt);
		}
		if (Fstat(tfd, sp)) {
			printf("ls_display: fstat of %s failed!\n", name);
			(void) Close(tfd);
			return (fmt);
		}
		(void) Close(tfd);
		ls_flags(sp, lsflags);
		printf("%5d %s%3d %4d %4d %7d %s\n",
		  sp->st_ino, lsflags, sp->st_nlink, sp->st_uid,
		  sp->st_gid, sp->st_size, pathend(name));
	}
	else {
		printf("%-15s", pathend(name));
		if (++fmt > 5) {
			printf("\n");
			fmt = 1;
		}
	}

	return (fmt);
}

/*
 * ls_flags -- build a ls -l style mode bit string
 */

ls_flags(sp, buf)
register struct stat	*sp;
char			*buf;
{
	register int	mode, i;
	register char	*p;
	static char	ls_types[] = "?pc?d?b?-???????";

	p = buf;
	p[0] = ls_types[(sp->st_mode >> 12) & (S_IFMT >> 12)];
	p[10] = '\0';
	p += 7;
	for (mode = sp->st_mode, i = 3; --i >= 0; mode >>= 3, p -= 3) {
		p[0] = (mode & S_IROTH) ? 'r' : '-';
		p[1] = (mode & S_IWOTH) ? 'w' : '-';
		p[2] = (mode & S_IXOTH) ? 'x' : '-';
	}
	p = buf;
	if ((mode = sp->st_mode) & S_ISUID)
		p[3] = (mode & S_IXUSR) ? 's' : 'S';
	if ((mode = sp->st_mode) & S_ISGID)
		p[6] = (mode & S_IXGRP) ? 's' : 'l';
	if ((mode = sp->st_mode) & S_ISVTX)
		p[9] = (mode & S_IXGRP) ? 't' : 'T';
}

uint
scan_for_mem_board()
{
	register uint	slot;

	for (slot = 0; slot < SBUS_NUM_SLOT; slot++)
		if (sbus_config.slot_id[slot] == SBUS_MM)
			return (slot);

	return (SBUS_NO_BOARD);
}

check_io()
{
	/* confirm that a memory board is available for use */
	if (scan_for_mem_board() == SBUS_NO_BOARD) {
		printf("memory board not found!\n");
		return(1);
	}
	/* FIX, HH - we used to check for i/o boards here - should we? */
	return(0);
}

time_stamp(arg_cnt)
int	arg_cnt;
{
	switch (on_off(arg_cnt, comm_args[1])) {
	case ON_ARG:
		time_stamp_window = STAMP_WIN_ON;
		NOVRAM->timestamp = 1;
		runtime_crc();
		break;
	case OFF_ARG:
		time_stamp_window = STAMP_WIN_OFF;
		NOVRAM->timestamp = 0;
		runtime_crc();
		break;
	case NO_ARG:
		break;
	case BAD_ARG:
	default:
		return;
	}
	printf("Kernel message time stamping %s.\n",
	  dis_en_abled[time_stamp_window != STAMP_WIN_OFF]);
}

/*
 * do_exit -- confirm an exit command
 */

do_exit()
{
	if (getyn("\nReally reset the system?  ")) {
		printf("\nBye...\n");
		prom();
	}
	printf("\nOk.\n");
}

/*
 * prom -- jump to the prom start address
 */

prom()
{
	set_pc_sp(*PROM_PC, *PROM_SP);
}

/*
 * do_reboot -- set autoboot flag and reboot
 */

do_reboot()
{
	if (getyn("\nReally reset the system?  ")) {
		printf("\nBye...\n");
		shutdown(MD_REBOOT);
	}
	printf("\nOk.\n");
}

extern int	load_it(), ps(), boot_k(), unix_console(), disp_save_buf();

struct init_menu i_utilities[] = {
 { "ldsa",	"<bootimage_device>- Load bootimage", 
   MF_PREBOOT, 0, 1, sa_load },
 { "mkfs",	"<bootimage_device>- Make file system", 
   MF_PREBOOT, 0, 1, sa_load },
 { "iopmfmt",	"<bootimage_device>- IOPM disk format/partition/setup", 
   MF_PREBOOT, 0, 1, sa_load },
 /*{ "secure",	"<bootimage_device>- Root file system security scan", 
   MF_PREBOOT, 0, 1, sa_load },* Removed until secure is passed by Security*/
 { "lr",	"<bootimage_device>- List contents of bootimage directory",
   MF_PREBOOT, 0, 1, list_reserved },
 { "ls",	"<l> <pathname>- List contents of directory [long]",
   MF_PREBOOT,0,2,list_unix },
 { "b(oot)",	"<pathname>- Boot from disk", 
   MF_PREBOOT, 0, 1, boot_k },
 { "load",	"<pathname>- Load from disk", 
   MF_PREBOOT, 0, 1, load_it },
 { "con",	"- Switch to unix console", 
   0, 0, 0, unix_console },
 { "ts",	"<on/off>- time stamp kernel printfs", 
   MF_EXPERT, 0, 1, time_stamp },
 { "ps",	"- ps -el",
   MF_POSTBOOT, 0, 2, ps },
 { "review",	"- display the printf buffer",
   0, 0, 0, disp_save_buf },
 { "exit",	"- exit to SPM PROM",
   MF_EXPERT, 0, 0, do_exit },
 { "reboot",	"- reset and reboot",
   MF_EXPERT, 0, 0, do_reboot },
 { 0 }
};
