/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pw.c: version 25.1 created on 11/27/91 at 15:39:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pw.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* pw.c */

#include "sys/types.h"
#include "misc.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "menu.h"
#include "novram.h"

uint		key_on, 
		setting_password;

extern char	rubber_room;
extern char 	*strcpy();
extern char	*comm_args[];
extern char	*dis_en_abled[];

display_pw()
{
	printf("password set to ->%s<-\n", NOVRAM->password);
}

set_pw()
{
	if (!rubber_room)
		(void) alter_pw();
	else if (key_toggled() && alter_pw())
		rubber_room = 0;
}

key_toggled()
{
	register uint	count;

	ASSERT(get_spl() == 0);

	key_on = 1;
	setting_password = 1;

	printf("Please insert key into the key switch and rotate the key\n");
	printf("to the `off' position and back to `on' within 10 seconds.\n");
	/* 
	 * wait 10 seconds for the response 
	 */
	for (count = 100; --count >= 0; ) {
		delay_and_poll(TICKS_PER_SEC / 10);	/* 100 msec */
		if (key_on == 2) {
			setting_password = 0;
			return(1);
		}
	}

	printf("Sorry, access denied\n");

	while (!key_on) {
		printf("\nPlease return key switch to `on' position.");
			/* 
			 * wait 10 seconds for the response
			 */
			for (count = 100; --count >= 0; ) {
				delay_and_poll(TICKS_PER_SEC / 10); /* .1 sec */
				if (key_on)
					break;
			}
	}
	setting_password = 0;
	return(0);
}

alter_pw()
{
	register uint	i = 0;
	unchar		buf[PASSWORD_LENGTH + 1];
	unchar		buf1[PASSWORD_LENGTH + 1];
	uint		retval = 0;

	/* clear out input arrays */
	for (i = 0; i < PASSWORD_LENGTH; i++) {
		buf[i] = 0;
		buf1[i] = 0;
	}

	printf("Please limit your password to %d printable characters\n",
	  PASSWORD_LENGTH);
	if (get_password("Enter your password, type <ESC> to abort\n->",
			buf, PASSWORD_LENGTH)) {
		if (get_password("Re-enter password\n->",buf1,PASSWORD_LENGTH)){
			if (!strcmp(buf,buf1)) {
				printf("New password accepted.\n");
				strcpy(NOVRAM->password, buf);
				shared_crc();
				retval = 1;
			}
			else
				printf("Sorry, the passwords don't match.\n");
		}
	}
	return(retval);
}

enter_pw()
{
	register uint	i = 0;
	unchar		buf[PASSWORD_LENGTH];

	for (i = 0; i < PASSWORD_LENGTH; i++)
		buf[i] = 0;
	
	if (get_password("Enter password\n", buf, PASSWORD_LENGTH)) {
		if (!strcmp(buf, NOVRAM->password)) {
			printf("Unrestricted level access granted\n");
			rubber_room = 0;
		}
		else
			printf("Unrestricted level access denied\n");
	}
}

ret()
{
	rubber_room = 1;
}


get_password(str, buf, bsize)
char	*str;
char	*buf;
uint	bsize;
{
	int	retval;

	printf("%s", str);

	if ((retval = get_string(buf, bsize)) == -1) {
		printf("Sorry, password string too long\n");
		retval = 0;		/* failed to get the password */
	}
	return(retval);
}


get_string(bp, bsize)
char	*bp;
uint	bsize;
{
	register int	c;
	register int	count;

	count = 0;
	while (1) {
		c = get_char();
		if (c == ESCAPE) {
			count = 0;
			break;
		}
		if ((c == '\r') || (c == '\n'))  /* carriage return */
			break;
		if ( c == '\b' ) {
			if ( count ) {
				printf( "\b \b" );
				--count;
				--bp;
			}
			else
				putchar(BELL);
		} else if ( count < bsize ) {
			/* check for printable character */
			if ((c >= '!') && (c <= '~')) { 
				++count;
				*bp++ = c;
				putchar('X');
			}
			else
				putchar(BELL);
		} else {
			/* line too long */
			count = -1;
			break;
		}
	}
	*bp = 0;			/* terminate the string */
	putchar('\n');
	return(count);
}

arm(arg_cnt)
int	arg_cnt;
{
	switch (on_off(arg_cnt, comm_args[1])) {
	case ON_ARG:
		NOVRAM->rubber_room = 1;
		break;
	case OFF_ARG:
		NOVRAM->rubber_room = 0;
		break;
	case NO_ARG:
		if (NOVRAM->rubber_room > 1)
			NOVRAM->rubber_room = 1;
		break;
	case BAD_ARG:
	default:
		return;
	}
	printf("Restricted mode is %s by default.\n",
	  dis_en_abled[NOVRAM->rubber_room]);
}

struct init_menu i_system_pw[] = {
 { "dp",	"- display password", MF_EXPERT, 0, 0, display_pw },
 { "sp",	"- set password", 0, 0, 0, set_pw },
 { "ep",	"- enter password for unrestricted mode", 0, 0, 0, enter_pw },
 { "rm",	"<on/off>- alter restricted mode default",
   MF_EXPERT, 0, 1, arm },
 { "ret",	"- return to restricted mode", MF_EXPERT, 0, 0, ret },
 { 0 }
};
