/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) pagetable.c: version 25.1 created on 11/27/91 at 15:39:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)pagetable.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* pagetable.c */

#include "sys/types.h"
#include "misc.h"
#include "spm_debug.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/kmem.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "sys/immu.h"
#include "sys/iopm_mmu.h"
#include "sys/lio.h"
#include "cpu_method.h"


uint		km_used;	/* global for kernel memory allocation */

extern uint	num_pages;	/* total number of pages in system */


/*
 * km_allocate -- allocate kernel memory using variable "km_used", aligned
 *		to a given boundary (which must be a power of two)
 */

uint
km_allocate(size, boundary)
uint		size;
register uint	boundary;	/* must be power of two */
{
	register uint	addr;

	ASSERT(km_used >= MAINSTORE);

	addr = ALIGN(km_used, boundary);
	km_used = addr + size;
	if (km_used > MAINSTORE + ctob(num_pages)) {
		printf("Kernel memory allocation failed: out of memory!\n");
		rtn_to_monitor();
	}
	return(addr);
}

/*
 * km_freen -- free N bytes of previously allocated kernel memory
 *
 *	(Currently only backs up km_used when freed memory was previous alloc)
 */

km_freen(addr, size)
uint	addr;
uint	size;
{
	if (addr + size == km_used)
		km_used = addr;
}



/*
 * km_map() - given a virtual address, this routine returns a mapped
 *		  address using an iomap.
 *
 * Parameter - Kernel virtual address
 */
unchar *
km_map(vaddr)
uint	vaddr;	/* address in kernel's memory segments */
{
	register uint	mpfn, spfn;
	register uint	sbus_slot, sbus_offset;

	mpfn = pnum(vaddr); 
	vaddr &= ((1 << PNUMSHFT) - 1);		/* vaddr now offset in page */

	spfn = MAINCPU_mpfn_to_spfn(mpfn);

	sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	sbus_offset = (spfn << PNUMSHFT) + vaddr;
	return((unchar *)iomap(sbus_slot, sbus_offset));
}

unchar *
km_pmap(vaddr)
uint	vaddr;	/* address in kernel's memory segments */
{
	register uint	mpfn, spfn;
	register uint	sbus_slot, sbus_offset;

	mpfn = pnum(vaddr); 
	vaddr &= ((1 << PNUMSHFT) - 1);		/* vaddr now offset in page */

	spfn = MAINCPU_mpfn_to_spfn(mpfn);

	sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	sbus_offset = (spfn << PNUMSHFT) + vaddr;
	return((unchar *)piomap(sbus_slot, sbus_offset));
}

/*
 * JPC: note that the following two copy routines rely on the fact that a
 *	page is the same size on all of our current PMs!
 */

/*
 * copy_to_km:
 *
 *	copy "size" bytes from spm address "from" to kernel
 *	address "to".  Memory striping is handled.
 */

copy_to_km(from, to, size)
uchar	*from;
uchar	*to;
uint	size;
{
	register uint	offset, max;
	uint		saved_map = iomap_save();

	offset = poff(to);

	while (size != 0) {

		max = size + offset;

		if (max > ctob(1))
			max = ctob(1);
		max = max - offset;

		bcopy(from, km_map(to), max);

		to += max;
		size -= max;
		from += max;
		offset = 0;
	}
	iomap_restore(saved_map);
}

/*
 * copy_from_km:
 *
 *	copy "size" bytes from kernel address "from" to spm
 *	address "to".  Memory striping is handled.
 */

copy_from_km(from, to, size)
uchar	*from;
uchar	*to;
uint	size;
{
	register uint	offset, max;
	uint		saved_map = iomap_save();

	offset = poff(from);

	while (size != 0) {

		max = size + offset;

		if (max > ctob(1))
			max = ctob(1);
		max = max - offset;

		bcopy(km_map(from), to, max);

		to += max;
		size -= max;
		from += max;
		offset = 0;
	}
	iomap_restore(saved_map);
}
