/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) monitor.c: version 25.1 created on 11/27/91 at 15:39:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)monitor.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * monitor.c
 *
 */

#include "global.h"
#include "menu.h"
#include "setjmp.h"
#include "spm_debug.h"
#include "saio.h"

#define	NHIST	16	/* number of histories -- must be a power of 2	*/
#define	CMDLEN	80	/* length of each command line			*/

extern uint	running_standalone;

static char	histbuf[NHIST][CMDLEN];
static char	histchar = '!';
static char	escape = '\033';
static int	cmdno;

rtn_to_monitor()
{
	int		i;
	extern uint	spm_mem_copy_called;

	polling = 0;
	running_standalone = 0;
	unix_console_mode = 0;
	if (!spm_mem_copy_called) {
		for (i = 3; i < NFILES + 3; i++)
			Close(i);
	}
	longjmp(environbuf, 1);
}

monitor()
{
	/* Command buffer */
	char	combuf[256];
	int	i;
	char	*getsss();

	mref_siz = 'l';

	pagsize = 20;
	lastchar = 0;

	/* Set up menu pointer stack */
	menu_stack[0].m_ptr = runtime_boot_level;
	menu_stack[0].name = "Runtime Boot Level Menu";
	menu_idx = 0;


	i = setjmp(environbuf);
	/* insure spl is at 0 */
	spl0();

	switch (i) {
	case 0:		/* initialization */
		check_autoboot();
		/* fall through! */
	case 1:		/* longjmp */
	default:
		printf("\nType '?' for help\n");
		break;
#if 0
	case 2:		/* do Unix console mode */
	while (unix_console_mode)
		poll();
#endif
	}

	/* Eternal loop */
	for (;;) {
		/* Print prompt */
		printf("%s%s: ", (last_put_char() != '\n' ? "\n" : ""),
		  menu_stack[menu_idx].name);

		if (!getsss(combuf, sizeof(combuf))) {
			if (menu_idx > 0)
				--menu_idx;
			continue;		/* escape to previous menu */
		}
		if (combuf[0] == histchar) {	/* Run a previous command */
			int	repeat,
				adjust;	/* return value from editline */

			if (combuf[1] == histchar) {
				if ((repeat = cmdno - 1) < 0) {
					printf("No history yet!\n");
					continue;
				}
			}
			else 
				repeat = atoi(&combuf[1]);

			if ((adjust = cmdno - NHIST) < 0)
				adjust = 0;	/* smallest valid cmdno */

			if (repeat >= cmdno || repeat < 0 || repeat < adjust) {
				printf("History # %d out of range: %d to %d\n",
				  repeat, adjust, cmdno - 1);
				continue;
			}

			/*
			 * edit specified command (histbuf[repeat]). 
			 *	if editline returns nonzero, adjust current
			 *	command number by that amount.
			 */
			do {
				if ( repeat < 0 )
					repeat = NHIST - 1;

				strncpy(combuf, histbuf[repeat%NHIST], CMDLEN);
				combuf[CMDLEN] = '\0';
				adjust = editline(combuf);
				repeat += adjust;
			} while (adjust);
		}
		if (blankline(combuf))
			continue;

		strncpy(histbuf[cmdno % NHIST], combuf, CMDLEN);
		cmdno++;

		parse(combuf);
	}
}

char *
getsss(buf, limit)
char	*buf;
int	limit;
{
	register char	*lp = buf;
	register int	c, count = 0, count1 = 0;

	while (count < limit) {
		c = get_char() & 0x7f;	/* only take 7 bits */

		if (c >= 0x20 || c == '\b')
			put_char(c);	/* Echo char */

		switch(c) {
		case CTRL_R:
			if (count1)
				continue;	/* already typed -- no redo. */
			printf("%s\n", buf);	/* print it. */
			return (buf);
		case '\n':
		case '\r':
			put_char('\n');
			*lp = '\0';
			return (buf);
		case '\b':
			if (lp <= buf)
				lp = buf;
			else {
				put_char(' ');
				put_char('\b');
				count--;
				lp--;
			}
			continue;
		case '\025':	/* ^U */
		case '\030':	/* ^X */
			count = 0;
			lp = buf;
			put_char('\n');
			continue;
		case ESCAPE:
#if !defined(go_into_history_mode)
			*buf = '\0';
			put_char('\n');
			return (NULL);
#else
			lp = buf;
			*lp++ = '!';
			*lp++ = '!';
			*lp = '\0';
			put_char('\n');
			return (buf);
#endif /* !go_into_history_mode */
		case DELETE:
			buf[0] = '\0';
			return (buf);
		default:
			count1 = 1;	/* typed good character. */
			count++;
			*lp++ = c;
		}
	}
	buf[limit - 1] = '\0';
	return (buf);
}

history(argc)
int	argc;
{
	register int	cmd;
	char		buf[CMDLEN + 1];

	if (argc <= 0 || (cmd = atoi(comm_args[1])) <= 0 || cmd > NHIST)
		cmd = NHIST;			/* clip history size value */

	if ((cmd = cmdno - cmd) < 0)
		cmd = 0;

	while (cmd < cmdno) {
		printf("%3d: ", cmd);
		strncpy(buf, histbuf[cmd % NHIST], CMDLEN);
		buf[CMDLEN] = '\0';
		ctrlprint(buf);
		put_char('\n');
		cmd++;
	}
}


/*	Editline is called with a pointer to a buffer that is CMDLEN bytes 
 *	long.  The line is printed with the cursor at the end.  Simple editing
 *	commands are accepted.  Carriage return completes the editing.
 *	If k or K is entered, returns -1 to indicate get previous command.
 */

editline(buf)
char *buf;
{
	char c;		/* character buffer		*/
	int len;	/* total string length		*/
	int pos;	/* position in string		*/
	int i;

	len = strlen(buf);
	if (len == 0)
		pos = 0;
	else {
		pos = len - 1;
		printf("\r%s\b",buf);
	}

	while ((c = get_char() & 0177) != '\n') {
		
		switch (c) {

		case 'k':	/* get previous command in buffer */
			printf("\r");
			for (i=0; i<len; i++) 	/* wipe out current command */
				put_char(' ');
			printf("\r");
			return(-1); 
		case 'j':	/* get next command in buffer  */
			printf("\r");
			for (i=0; i<len; i++) 
				put_char(' ');
			printf("\r");
			return(1); 
		case 'a':	/* append mode		*/
			printf("%c",buf[pos++]);
			i = in_mode(buf, pos, len);
			if (i < 0){
				printf("\n");
				return(0);
			}
			pos += i;
			len += i;
			break;
		case 'r':	/* replace a single character  */
		case 'R':	/* Replace multiple characters */
			i = overwrite_mode(buf, &pos, len, c == 'R' ? 0 : 1 );
			if (i < 0){
				printf("\n");
				return(0);
			}
			len += i;
			break;
		case '\b':	/* backspace 		*/
		case 'h':
			if (pos) {
				printf("\b");
				pos--;
			}
			break;
		case 'i':	/* insert mode		*/
			i = in_mode(buf, pos, len);
			if (i < 0){
				printf("\n");
				return(0);
			}
			pos += i;
			len += i;
			break;
		case 'l':	/* move right one char	*/
		case '\014':
			if (pos < len-1)
				printf("%c",buf[pos++]);
			break;
		case 'x':	/* delete char		*/
			if (len <= 0)
				break;
			for (i=pos; i<len; i++)
				buf[i] = buf[i+1];
			len--;
			if ((pos == len) && pos)
				pos--;
			printf("\r%s ",buf);	/* extra blank this printf */
			for (i=0; i< (len-pos+1); i++)
				printf("\b");
			break;
		case '0':	/* goto start of line	*/
			printf("\r");
			pos = 0;
			break;
		case '$':	/* goto end of line	*/
			printf("\r%s\b",buf);
			pos = len - 1;
			break;
		case '\r':	/* return		*/
			printf("\n");
			return(0);
		case DELETE:
			buf[0] = '\0';
			return(0);
		}

	}
	printf("\n");
	return(0);
}


/*	Accept inserted characters until an esc is received.  Return the
 *	number of characters inserted.  If a carriage return or line-feed
 *	is entered return the number of characters as a negative.  This tells
 *	the caller to terminate editing and execute the line.
 */

in_mode( buf, pos, len)
char	*buf;	/* ptr to string buffer	*/
int	pos;	/* starting pos in str	*/
int	len;	/* starting len of str	*/
{
	int  i;
	int  n;
	char c;

	n = 0;
	while ((c = get_char() & 0177) != '\033') {
		if ((c == '\n') || (c == '\r')) {
			printf("\r%s",buf);
			return(-n);
			}
		for (i=len; i>=pos; i--)
			buf[i+1] = buf[i];
		buf[pos++] = c;
		len++;
		printf("\r%s",buf);		/* reprint the line	 */
		for (i=0; i< (len-pos); i++)	/* reposition the cursor */
			printf("\b");
		n++;
	}
	return(n);
}


overwrite_mode( buf, pos_addr, len, once)
char	*buf;		/* ptr to string buffer	*/
int	*pos_addr;	/* starting pos in str	*/
int	len;		/* starting len of str	*/
uchar	once;		/* only overwrite one character */
{
	register int pos;
	register int  i;
	int  n = 0;
	char c;

	pos = *pos_addr;
	while ((c = get_char() & 0177) != '\033') {
		if ((c == '\n') || (c == '\r')) {
			printf("\r%s",buf);
			return(-1);
		}
		buf[pos] = c;
		if (pos == len) {		/* adding to line	 */
			buf[++len] = '\0';	/* replace null		 */
			n++;
		}
		pos++;
		printf("\r%s",buf);		/* reprint the line	 */
		for (i=0; i< (len-pos); i++)	/* reposition the cursor */
			printf("\b");
		if(once){
			printf("\b");
			break;
		}
	}
	pos--;
	*pos_addr = pos;
	return(n);
}

blankline( buf )
register char *buf;
{
	register char c;

	while ((c = *buf++) != '\0')
		if ((c != ' ') && (c != '\09'))
			return(0);
	return(1);
}

/*********** line limit routines ***************/

static uint	lines_left;

line_limit_set(lines)
uint	lines;
{
	lines_left = lines;
}

uint
line_limit_use(lines)
uint	lines;
{
	if (lines <= lines_left) {
		lines_left -= lines;
		return(1);
	}
	switch (get_char()) {
	case '\r': 
	case '\n':
		if (lines < 20) {
			lines_left = 20 - lines;
			break;
		}
		/* no break */
	case ' ':
		lines_left = 0;
		break;
	default:
		return(0);
	}
	return(1);
}
