/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) main.c: version 25.1 created on 11/27/91 at 15:39:34	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)main.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* main.c */

#include "misc.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "cio.h"
#include "rwi.h"
#include "novram.h"
#include "sys/types.h"
#include "sys/spm_mem.h"


main()
{
	clear_bss();			/* clear out bss area */
	if (setjmp(environbuf))		/* init environbuf */
		panic("bad trap");
	init_novram();
	init_vars();			/* initialize some variables */
	rwi_init();

	GREEN_LED_ON;			/* SPM "all is normal light" */
	initcio();			/* init cio will start sending clk */ 
					/* ints to a PM after sbus is polled */
	check_rwi_rev();		/* check for correct rev rwi board */
	
	spl1();				/* don't start polling loop until */
					/* sbus has been polled */

	printf("\n\n");
	print_spm_version();

	if (*STATUSREG & STAT_CLK) {
	    printf("SPM not on CSS clock, system bus initialization aborted\n");
		monitor();
	}
	init_css_interface();		/* init the css interface */
	iomap_init();			/* init our i/o mapper */
	sbus_init();			/* init the system bus */
	sbus_mem_clear();		/* clear system memory */
	init_devslot();			/* setup io device array */
	set_boot_defaults();		/* set boot defaults in nvram */

	spl0();				/* accept all interrupt levels */

	css_error_capture(TRUE);
	sbus_polled = 1;		/* Starts clk ints to PMs */
	save_char_flag = 1;		/* save non spl0 output */

	monitor();
	/*NOTREACHED*/
}

print_spm_version()
{
	printf("SPM Runtime Code: Version 0x%08x, ID %d.%02d\n",
	  SPM_MEM_VERSION,			/* from sys/spm_mem.h	*/
	  SPM_ID_NUM >> 8, SPM_ID_NUM & 0xff);	/* from head/misc.h	*/
}

/*
 * delay - pause for a few ticks
 *
 * Argument:
 *
 *	number of 20 millisecond ticks to spin.
 *
 * Note:
 *
 *	This routine currently only has 20 msec resolution,
 *	and is somewhat skewed by the amount of interrupt
 *	processing being done. This routine counts on uints wrapping.
 */

delay(timeout)
register uint timeout;
{
	register uint	start_ticks = int_counter;

	while (int_counter - start_ticks < timeout)
		;
}

delay_and_poll(timeout)
register uint timeout;
{
	register uint	start_ticks = int_counter;
	uint		x;

	if ((x = get_spl()) > 3) {	/* the clock interrupt comes in at */
		printf("\ndelay_and_poll: at level %d, did spl3\n", x);
		x = spl3();		/* level 4, so be at level 3 or less */
	}
	else
		x = 0;

	while (int_counter - start_ticks < timeout)
		poll();

	if (x)
		splx(x);
}

delay_and_poll_until(timeout, routine, arg)
register uint	timeout;
uint	(*routine)();
void	*arg;
{
	register uint	start_ticks = int_counter;

	while (int_counter - start_ticks < timeout) {
		if ( (*routine)(arg) )
			break;
		cpu_all_check_printf();
		poll();
	}
}

delay_check_iomap(ticks)
uint	ticks;
{
	extern uint	iomap_save();
	uint		iomap_check;

	/* iomap_check used to make sure iomap is OK */
	iomap_check = iomap_save();
	delay_and_poll(ticks);
	ASSERT(iomap_save() == iomap_check);
}


delay_no_poll(n_msecs)
register uint n_msecs;
{
	register uint i;
	/* 
	 * one loop approx = 1ms 
	 */
	n_msecs *= 0x418; 
	for(i=0; i<n_msecs; i++)
		;
}
