/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) localmenu.c: version 25.1 created on 11/27/91 at 15:39:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)localmenu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:localmenu.c	25.1"
/*  localmenu.c
 *
 *	All the local menus.
 *
 *	struct menu {
 *		char *comm_text;
 *		char *comm_desc;
 *		unsigned char flags;
 *		unsigned char lo_limit;
 *		unsigned char hi_limit;
 *		union {
 *			PFI procedure;
 *			struct menu *menu_p;
 *		} command;
 *	};
 *
 *	Menu.comm_text is the full text for the command name, such as 'l(ist)'.
 *	Menu.comm_desc is the description for the command.
 *	Menu.flags is the type (command or menu) and display flags.
 *	Menu.lo_limit is the low limit of the number of arguments allowed for
 *		the command.
 *	Menu.hi_limit is the high limit of the number of arguments allowed for
 *		the command.
 *	Menu.command is a union containing either a pointer to a procedure or
 *		a pointer to another menu.
 *	Menu.command.procedure points to the related procedure.
 *	Menu.command.menu_p points to the related sub-menu.
 *	Menus are terminated with a null string in the menu.comm_text field.
 */
#include "menu.h"
#include "localmenu.h"

/*
 * Menus
 *
 * The menu pointers have to be cast to PFI due to a compiler deficiency.
 * The same for the init_menu struct instead of just a menu declaration.
 */

struct init_menu i_runtime_boot_level[] = {
 { "d(ebugger)",	"-Runtime Debugger Menu",
   MF_MENU | MF_EXPERT, 0, 0, (PFI)i_debugger },
 { "dd(ebugger)",	"-Runtime Dispatcher Debugger Menu",
   MF_MENU | MF_EXPERT, 0, 0, (PFI)i_ddebugger },
 { "u(tilities)",	"-Utility Programs Menu",
   MF_MENU, 0, 0, (PFI)i_utilities },
 { "kd(ebugger)",	"-Kernel Debugger Menu",
   MF_MENU | MF_EXPERT, 0, 0, (PFI)i_kernel_debugger },
 { "s(tatus)",		"-Runtime System Status Menu",
   MF_MENU | MF_EXPERT, 0, 0, (PFI)i_system_status },
 { "sys(tem)",		"-System Configuration Menu",
   MF_MENU | MF_EXPERT, 0, 0, (PFI)i_system_config },
 { "t(db)",		"-TDB Debugger Menu",
   MF_MENU | MF_EXPERT, 0, 0, (PFI)i_tdb },
 { "pw",		"-System Privilege Level Menu",
   MF_MENU, 0, 0, (PFI)i_system_pw },
 { 0 }
};

struct menu *runtime_boot_level = (struct menu *)i_runtime_boot_level;

help()
{
    printf("\n");
    printf("    The SPM Runtime Code has a multiple level menu structure. To print this\n");

    printf("message type 'h', '?' or 'help' followed by a carriage return (<RET>). To print\n");

    printf("the current menu, type 'l' or 'list' followed by <RET>.\n");

    printf("    On boot, The SPM Runtime Code comes up in the top level menu. To simply\n");

    printf("boot the system, type 'boot'.  To access one of the menus, type the key letter\n");

    printf("or letters for the command followed by <RET>.  For example, the command:\n");

    printf("                u(tilities)     Utility Programs Menu\n");

    printf("is executed by typing 'u' or 'utilities' followed by <RET>.  The menu displayed\n");

    printf("would be the \"Utilities Programs Menu\". This is referred to as going \"down\"\n");

    printf("to a menu. To go \"up\" to the previous menu, press the escape key (<ESC>).\n");
    printf("\n");
    dev_help_message();
    return (0);
}
