/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) k_dwnld.c: version 25.1 created on 11/27/91 at 15:39:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)k_dwnld.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "misc.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "spm_debug.h"
#include "spm.h"
#include "sa_dir.h"
#include "iomap.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "menu.h"
#include "novram.h"
#include "disksect.h"
#include "dev.h"
#include "sdk_ioctl.h"
#include "sbus_conf.h"
#include "cpu_method.h"
#include "sys/sbus_iom.h"
#include "slotdefs.h"

extern char	*comm_args[];
extern uint	pm_booting_done,
		first_spm_cmd,
		kernel_entry_point,
		kernel_end,
		kernel_etext,
		dbug,
		pm_entry,
		enable_clock_on_start,
		kern_clock_enable,
		first_pm_slot;


extern uint		iopm_download_dsdb();
extern void		slice_basename();


check_autoboot()
{
	register int	count;
	static uint	autoboot_check;

	if (pm_booting_done || autoboot_check)
		return;

	autoboot_check = 1;
	if (NOVRAM->autoboot) {
		printf("Press any key to abort kernel autoboot (%s)...",
		  NOVRAM->kernel_boot_disk);
		for (count = 40; --count >= 0; ) {
			delay_and_poll(5);
			if (con_in() >= 0) {
				printf("aborted\n");
				return;
			}
		}
		put_char('\n');
		boot_k(0);
	}
}

/*
 * get_iopm_swap_slice
 */
static
get_iopm_swap_slice(dev_str)
char	*dev_str;
{
	int	fd, ld;

	if ((fd = Open(dev_str, 0)) < 0) {
		printf("get_iopm_swap_slice: Can't open %s\n", dev_str);
		return (-1);
	}

	if ((ld = Ioctl(fd, DSDB_GET_SWAP_SLICE, 0)) < 0) {
		Close(fd);
		printf("DSDB_GET_SWAP_SLICE of %s failed\n", dev_str);
		return (-1);
	}

	ASSERT(ld >= 0 && ld < 16);
	Close(fd);
	return(ld);
}

/*
 * set up rootdev and swapdev for the kernel.
 */
static
set_dev(boot_str)
char	*boot_str;
{
	register int	ld;
	char		*p, source_str[DEV_NAMLEN];

	strcpy(source_str, boot_str);

	ld = get_device_info(source_str, &sbus_config.rootdev, &p);
	if (p)
		*p = '\0';
	if (ld != DV_DK) {
		if (ld == DV_HELP_REQUEST)
			dev_help_message();
		else
			printf("%s isn't a disk device!\n", source_str);
		return (-1);
	}

	sbus_config.swapdev = sbus_config.rootdev;

	/* FIX MARK, need permanent solution */
	switch (sbus_config.slot_id[sbus_config.rootdev.s.slot]) {
	case SBUS_IOPM:
		if ((ld = get_iopm_swap_slice(source_str)) < 0)
			return (-1);
		break;
	case SBUS_NIOM:
		switch (iom_ex_bd_type(sbus_config.rootdev.s.slot)) {
		case IOM_TYPE_IOSBA:
			if ((ld = get_iopm_swap_slice(source_str)) < 0)
				return (-1);
			break;
		default:
			return (-1);
		}
		break;
	default:
		return (-1);
	}
	if (ld == sbus_config.rootdev.s.log) {
		printf("Root slice and swap slice are the same! (%s)\n",
		  source_str);
		return (-1);
	}
	sbus_config.swapdev.s.log = ld;

	return (0);
}

load_kernel(source_device, umod_flag)
char	*source_device;
uint	umod_flag;
{
	if (!umod_flag)
		kernel_entry_point = load_m68k(source_device);
	else
		kernel_entry_point = load_m68k("umod");
#if 0
	if (kernel_entry_point == 0 || kernel_entry_point == ~0)
		rtn_to_monitor();

	cpu_all_build_page_tables();

	int_to_first_pm(first_pm_slot);
#endif
	return(kernel_entry_point);
}

/* 
 * load_it : load a cpu without booting it 
 */
load_it(arg_cnt)
int	arg_cnt;
{
	char	*src_dev;

	src_dev = (arg_cnt ? comm_args[1] : NOVRAM->kernel_boot_disk);

	if (SBUS_IS_PM(sbus_config.slot_id[SLOT_FM_SNS(cpu_cur_sns())]))
		(void) load_k(src_dev, UMOD_OFF);
	else
		(void) CPU_load(src_dev, UMOD_OFF);
}

fdl(arg_cnt)
int	arg_cnt;
{
	char	*src_dev;

	src_dev = (char *)(NOVRAM->kernel_boot_disk);

	(void) CPU_load(src_dev, UMOD_ON);
}

/*
 * PM_start -- start the kernel, using the global kernel_entry_point
 */

void
PM_start()
{
	spm_mem_copy();

	pm_entry = kernel_entry_point;
	cpu_all_start();

	Spm_Mem->kernel_green_light = 1;	/* and they're off */
	if (Spm_Mem->pm_version != SPM_MEM_VERSION) {
		printf("spm_mem version mismatch! 0x%08x vs 0x%08x\n",
		  SPM_MEM_VERSION, Spm_Mem->pm_version);
		return;
	}
	pm_booting_done = 1;
	if (enable_clock_on_start)
		kern_clock_enable = 1;
	unix_console();
}

/*
 * find_first_pm -- return the SNS of the first PM board
 */
uint
find_first_pm()
{
	register uint	slot, sns;

	for (slot = 0; slot < SBUS_NUM_SLOT; slot++)
		if (SBUS_IS_PM(sbus_config.slot_id[slot]))
			return(MAKE_SNS(slot, NO_SUB_SLOT));
	return (SNS_NO_PM);
}

/*
 * PM_first -- set cur to first pm. return sns.
 */
static uint
PM_first()
{
	uint	sns;

	if ((sns = find_first_pm()) == SNS_NO_PM)
		return (SNS_NO_PM);

	if (!cpu_set_slot(NULL, sns))
		return (SNS_NO_PM);
	return(sns);
}

static	int kernel_loaded = 0;

/*
 * pm_loaded - is the kernel loaded.
 *
 * No reconfiguration changes can be made after this is true.
 */
pm_loaded()
{
	return(kernel_loaded);
}

extern uint	cpu_all_prep_boot();

/*
 * load_k -- load the kernel and do other necessary stuff
 *		finds first PM
 *		returns SNS_NO_PM on error, or sns
 */
load_k(src_dev, umod_flag)
char	*src_dev;
uint	umod_flag;
{
	uint	sns;

	if (kernel_loaded) {
		printf("kernel already loaded\n");
		return(SNS_NO_PM);
	}

	if (set_dev(src_dev) < 0) {
		printf("Failed to find swap slice on boot disk\n");
		return(SNS_NO_PM);
	}

	if (iopm_download_dsdb(src_dev)) {
		printf("IOPM/DSDB load failed -- aborting kernel load!\n");
		return(SNS_NO_PM);
	}

	if ((sns = PM_first()) == SNS_NO_PM) {
		printf("Can't find a PM for kernel load!\n");
		return (SNS_NO_PM);
	}

	/*
	 * be careful when changing the order in which the following are
	 * called.
	 */
	if (CPU_mem_stripe_init())
		return (SNS_NO_PM);

	cpu_all_set_pm_id();

	kernel_loaded = 1; /* set this here, since no turning back */

	if ((kernel_entry_point = cpu_all_prep_boot(src_dev, umod_flag)) == 0
		|| kernel_entry_point == ~0 || 
	    !CPU_check_coffdata(kernel_entry_point)) {
		printf("Didn't get a valid kernel entry point! (0x%08x)\n",
		  kernel_entry_point);
		printf("the spm must be rebooted before kernel booting is \
tried again !\n");
		kernel_entry_point = 0;
		return (SNS_NO_PM);
	}

	cpu_all_build_page_tables();
	int_to_first_pm(SLOT_FM_SNS(sns));

	if (src_dev != NOVRAM->kernel_boot_disk) {
		strcpy(NOVRAM->kernel_boot_disk, src_dev);
		runtime_crc();
	}

	/* declan : should be no need to call cpu_set_slot again */
	return (cpu_set_slot(NULL, sns) ? sns: SNS_NO_PM);
}

boot_kernel(arg_cnt, umod_flag)
int	arg_cnt;
int	umod_flag;
{
	uint	first;
	char	*src_dev;

	src_dev = (arg_cnt ? comm_args[1] : NOVRAM->kernel_boot_disk);

	if ((first = load_k(src_dev, umod_flag)) == SNS_NO_PM)
		return (0);

	PM_start();
	return (cpu_set_slot(NULL, first));
}

boot_k(arg_cnt)
int	arg_cnt;
{
	if (!boot_kernel(arg_cnt, UMOD_OFF))
		printf("kernel boot failed\n");;
}

xfdl(arg_cnt)
int	arg_cnt;
{
	if (!boot_kernel(arg_cnt, UMOD_ON))
		printf("kernel boot failed\n");;
}
