/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iomap.c: version 25.1 created on 11/27/91 at 15:39:16	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iomap.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:iomap.c	25.1"
/*
 * iomap -- all routines that deal with SPM's iomap
 */

#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "sys/lio.h"
#include "spm.h"
#include "iomap.h"


/*
 * This file contains routines that allocate and manipulate the SPM's
 * mapping registers.
 *
 * piomap and iomap all have the same interface:
 *	Given a SBUS slot and an addr on that slot, they return a pointer
 *	that can be used to access the item(s) at that slot/addr.
 */


/*
 * iomap_init - initialize the io maps
 *
 * clear the 8 io maps
 */
iomap_init()
{
	register uint	map_reg;

	for (map_reg = 0; map_reg != SPM_IOMAP_MANY; map_reg++)
		*(IO_MAPPER + (map_reg << UnmappedBits)) = 0;
}

/*
 * piomap -- permanent map to system bus area
 *		value returned is valid up to next megabyte boundary
 */

unsigned char *
piomap(sbus_slot, addr)
uint	sbus_slot;
uint	addr;
{
	register uint	low_part, high_part;

	last_map++;

	if (last_map >= SPM_IOMAP_MANY)
		panic("last_map >= SPM_IOMAP_MANY");

	low_part = LowBits(UnmappedBits, addr);
	high_part = HighBits(UnmappedBits, addr);
	high_part |= (sbus_slot << (UintBits - UnmappedBits));

	/*
	 * high_part now contains the upper part of the combined address
	 * low_part now contains the lower part of the combined address
	 */

	*(IO_MAPPER + (last_map << UnmappedBits)) = high_part;
	return(IO_SPACE + (last_map << UnmappedBits) + low_part);
}

/*
 * iomap -- temporary map of system bus area
 *
 * WARNING: iomap programs a single mapping register.
 *	iomap_save and iomap_restore must be used.
 *
 *	Typical use:
 *
 *	uint xxx = iomap_save();
 *
 *	abc_reg = iomap(slot, offset);
 *	printf("abc_reg contains\n", *abc_reg);
 *
 *	iomap_restore(xxx);
 */


unchar *
iomap(sbus_slot, addr)
uint	sbus_slot;
uint	addr;
{
	register uint	low_part, high_part;

	low_part = LowBits(UnmappedBits, addr);
	high_part = HighBits(UnmappedBits, addr);
	high_part |= (sbus_slot << (UintBits - UnmappedBits));

	/*
	 * high_part now contains the upper part of the combined address
	 * low_part now contains the lower part of the combined address
	 */


	*(IO_MAPPER + (MyMap << UnmappedBits)) = high_part;
	return(IO_SPACE + (MyMap << UnmappedBits) + low_part);
}


/*
 * iomap_save -- return current map value
 */

uint
iomap_save()
{
	return(*(IO_MAPPER + (MyMap << UnmappedBits)));
}

/*
 * iomap_restore -- restore value returned from earlier call to iomap_save 
 */

iomap_restore(value)
uint	value;
{
	*(IO_MAPPER + (MyMap << UnmappedBits)) = value;
}


/*
 * is_iomap -- return TRUE (i.e. 1) if address is in mapped i/o area
 */

is_iomap(vaddr)
unsigned char	*vaddr;
{
	if (vaddr < IO_SPACE)
		return(0);

	return(1);
}

/*
 * iomap_to_slot --  given a virtual address in iomap return the system
 *		bus slot currently being mapped to
 */

uint
iomap_to_slot(vaddr)
unsigned char	*vaddr;
{
	register uint	map;
	register uint	slot;

	ASSERT(is_iomap(vaddr));

	map = (vaddr - IO_SPACE) >> UnmappedBits;
	slot = HighBits((UintBits - UnmappedBits),
		HighBits(MapOutShft, *(IO_MAPPER + (map << UnmappedBits))));
	return(slot);
}

/*
 * iomap_to_offset --  given a virtual address in the iomap
 *		       return the system offset currently being mapped to
 */

uint
iomap_to_offset(vaddr)
unsigned char	*vaddr;
{
	register uint	map;
	register uint	high_part;

	ASSERT(is_iomap(vaddr));

	map = (vaddr - IO_SPACE) >> UnmappedBits;
	high_part = LowBits((UintBits - UnmappedBits),
		HighBits(MapOutShft, *(IO_MAPPER + (map << UnmappedBits))));

	return((high_part << UnmappedBits) | LowBits(UnmappedBits, (uint) vaddr));
}

uint
iomap_to_map(vaddr)
unsigned char	*vaddr;
{
	register uint	map;

	ASSERT(is_iomap(vaddr));

	map = (vaddr - IO_SPACE) >> UnmappedBits;
	return(map);
}
	

/*
 * alt_iomap -- secondary map of system bus area
 */
unchar *
alt_iomap(sbus_slot, addr)
uint	sbus_slot;
uint	addr;
{
	register uint	low_part, high_part;

	low_part = LowBits(UnmappedBits, addr);
	high_part = HighBits(UnmappedBits, addr);
	high_part |= (sbus_slot << (UintBits - UnmappedBits));

	/*
	 * high_part now contains the upper part of the combined address
	 * low_part now contains the lower part of the combined address
	 */


	*(IO_MAPPER + (AltMap << UnmappedBits)) = high_part;
	return(IO_SPACE + (AltMap << UnmappedBits) + low_part);
}


/*
 * alt_iomap_save -- return current alternate map value.
 */
uint
alt_iomap_save()
{
	return(*(IO_MAPPER + (AltMap << UnmappedBits)));
}

/*
 * alt_iomap_restore -- restore value returned from earlier call to iomap_save. 
 */
alt_iomap_restore(value)
uint	value;
{
	*(IO_MAPPER + (AltMap << UnmappedBits)) = value;
}

