/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) init.c: version 25.1 created on 11/27/91 at 15:39:11	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)init.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* init.c */

#include "sys/param.h"
#include "sys/types.h"
#include "misc.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "cio.h"
#include "iomap.h"
#include "novram.h"
#include "scc.h"
#include "adc.h"
#include "rwi.h"
#include "dev.h"
#include "sbus_conf.h"

extern uint	runtime_crc_val();
extern char	*gs_str();
extern void	slice_basename();


/*
 * init_vars() - initialize some variables
 */
init_vars()
{
	rubber_room = NOVRAM->rubber_room;
	poll_rwi = poll_local = NOVRAM->poll;
	time_stamp_window = NOVRAM->timestamp ? STAMP_WIN_ON : STAMP_WIN_OFF;
	modem_on = NOVRAM->modem_active;
	printer_on = NOVRAM->printer_active;

	warning_light_off();		/* turn off warning light */
	ON_LIGHT_ON;			/* light the "system on" light */

	init_local();
	init_rwi();

/*	init_tape_status();	*/
	init_save_buf();
	save_char_flag = 0;		/* 1 - save non spl0 output */
					/* 0 - don't save output */
	tdb_check_state = HZ / 4 + 1;
}


init_novram()
{
	if (NOVRAM->novram_ver != SPM_NOVRAM_VERSION_A &&
	    NOVRAM->novram_ver != SPM_NOVRAM_VERSION_B) {
		printf("Mismatched NOVRAM versions: need %#x or %#x, got:%#x\n",
		  SPM_NOVRAM_VERSION_A, SPM_NOVRAM_VERSION_B,
		  NOVRAM->novram_ver);
		panic("");
	}
	if (runtime_crc_val() == NOVRAM->runtime_crc)
		return;

	NOVRAM->shutdown = 0;
	NOVRAM->rubber_room = 0;
	NOVRAM->poll = 1;
	NOVRAM->timestamp = 1;
	NOVRAM->modem_active = 0;
	NOVRAM->printer_active = 0;
	shared_crc();
	runtime_crc();
}

set_boot_defaults()
{
	char	str[DEV_NAMLEN];
	int	crc_changed = runtime_crc_val() != NOVRAM->runtime_crc;

	strcpy(str, NOVRAM->spm_boot_disk);
	slice_basename(str);
	if (!(*NOVRAM->sa_boot_disk) || crc_changed ||
	   strcmp(NOVRAM->sa_boot_disk, str))
		strcpy(NOVRAM->sa_boot_disk, str);
	if (!(*NOVRAM->kernel_boot_disk) || crc_changed)
		sprintf(NOVRAM->kernel_boot_disk, "%sd0s0arix",
		  gs_str(dev_slot[0].unit));

	runtime_crc();
}


/*
 * init_css_interface()
 *
 * reset CSS bus
 * init SPM write control registers 0,1 & 2
 * reset and increment ready count
 */
init_css_interface()
{
	register unsigned  slot,inv_slot;

	/* init CSS interface */

	*WRCNTL2 = *WRCNTL2 | WR2_BDRST;	/* set board reset */
	slot = (*STATUSREG & STAT_SLOTMASK) >> STAT_SLOTSH;/* read out slot */
	spm_slot = slot;
	inv_slot = ~slot & 0x0f;		/* inverse of slot id */ 

	/* don't write dispatcher slot id until the sbus has been polled */
	/* this id must be either a memory module or empty slot id */ 
	/* CSS errors are inhibited now */

	*WRCNTL0 = /* WR0_FRC_BAD_DEST |*/ WR0_FRC_GRANT_ERR | WR0_FRC_ACK_NAK |
	  (slot << 12) | (slot << 16) | (inv_slot << 20);

	*WRCNTL1 = WR1_FRC_RST_ACK	/* force reset ack* normally high */
		| WR1_IRDY | WR1_RRDY	/* iready, rready are normally high */
		| WR1_FMOD		/* CSS modify cycle off */
		| WR1_FDEST		/* fake destination not used */
		| WR1_DIAG_ANY_TYPE	/* don't use this mode */
		| WR1_FINTREC		/* don't decode a CSS cpu int request
					as a CSS command */
		| WR1_DREQ		/* dispatcher in normal mode */
		| WR1_IDLERST		/* reset for idle FIFO, normally 1 */
		| WR1_RSTREC		/* reset receive flag, normally 1 */
		| WR1_TPOL		/* sets polarity of type field
					normally 1 */
		| WR1_UFTYPE		/* use forced type off */
		| WR1_ID_RST		/* don't reset int dispatcher */
		| WR1_4BYTE_RD		/* 4 byte read */
		| WR1_MOTOR		/* floppy motor off */
		| WR1_FDACK		/* used by floppy cntlr,normally high */
		| WR1_FRES		/* don't force response signal at
					the arbiter */
		| WR1_TP		/* floppy controller terminal count */ 
		| (slot << WR1_DEST_SH) /* a fake destination if the fake
					destination bit is set */
		| WR1_POL		/* odd parity for all CSS data bytes */ 
		| WR1_CSSRST;

	rready();
	iready();
}


/*
 * init_disp() - initialize the interrupt dispatcher
 *
 * assert/de-assert frc.reset.ack*
 * assert/de-assert frc.reset.rcv*
 * reset the interrupt dispatcher
 * request the dispatcher rams
 * initialize the dispatcher queue ram
 * initialize the dispatcher pointer ram
 * initialize the dispatcher miscellaneous ram
 * drop the request to the dispatcher rams
 *
 *	note: must be called after the sbus has been polled
 */

#if defined(JAMES)

init_disp()
{
	register uint	*ramp;
	register uint	sbus_slot, val, next_slot;
	register uint	disp_slot_id = 0;
	register uint	found_empty_slot = 0;
	register uint	id;

	/* assert/de-assert frc.reset.ack */
	*WRCNTL1 &= ~WR1_FRC_RST_ACK;
	*WRCNTL1 |= WR1_FRC_RST_ACK;

	/* assert/de-assert frc.reset.rcv */
	*WRCNTL1 &= ~WR1_FRC_RST_RCV;
	*WRCNTL1 |= WR1_FRC_RST_RCV;

	/* reset interrupt dispatcher */
	*WRCNTL1 &= ~WR1_ID_RST;		/* the reset signal */

	/* setup for cpu access to dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ;
	*WRCNTL1 |= WR1_ID_RST;			/* back to normal */

	wait_for_dispatcher_rams();

	/* initialize the queue ram */
	bzero((caddr_t)QUEUE_RAM, QUEUE_LWORDS * sizeof(*QUEUE_RAM));

	/* initialize the pointer rams */
	bset_long((ulong *)POINTER_RAM, INIT_IN_POINTER | INIT_OUT_POINTER,
	  POINTER_LWORDS);

	/* initialize the miscellaneous rams */
	/* keep bit 28 = 0 (directed ints only) */
	bset_long((ulong *)MISC_RAM, 0x000003ff | (spm_slot << CONFIG_SH),
	  MISC_LWORDS);

	next_slot = spm_slot;

	/* fill configuration ram */
	for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; sbus_slot++) {
/* DPM40 CHANGE NEEDED, but the change is board specific. */
/* hanna FIX: do i need to do two rings for a double stuffed card */
		if (SBUS_IS_PM(id = sbus_config.slot_id[sbus_slot])) {
			ramp = MISC_RAM + next_slot;
			next_slot = sbus_slot;
			val = *ramp & ~(CONFIG_MASK | CNTR_ZERO_BIT);
			*ramp = val | (sbus_slot << CONFIG_SH) | 0x10000000;
		}
		if (!found_empty_slot) {
			if ((id == SBUS_MM) || (id == SBUS_NO_BOARD)) {
				found_empty_slot = 1;
				disp_slot_id = sbus_slot;
			}
		}
	}

	if (!found_empty_slot)
		/* no mem or empty slot for id to be put in WR0 */
		panic(
	"init_disp: configuration must have a memory module or an empty slot");

	/* program up the dispatcher slot id */

	*WRCNTL0 |= (disp_slot_id << 8);

	/* put dispatcher in normal mode */

	*WRCNTL1 |= WR1_DREQ;

	/* reset interrupt dispatcher */
	*WRCNTL1 &= ~WR1_ID_RST;		/* the reset signal */
	*WRCNTL1 |= WR1_ID_RST;			/* back to normal */
}
#else /* JAMES */
init_disp()
{
	register uint *j, sbus_slot, val,next_slot;
	register uint disp_slot_id = 0;
	register uint found_empty_slot = 0;

	/* assert/de-assert frc.reset.ack */
	*WRCNTL1 &= ~WR1_FRC_RST_ACK;
	*WRCNTL1 |= WR1_FRC_RST_ACK;
	
	/* assert/de-assert frc.reset.rcv */
	*WRCNTL1 &= ~WR1_FRC_RST_RCV;
	*WRCNTL1 |= WR1_FRC_RST_RCV;

	/* reset interrupt dispatcher */
	*WRCNTL1 &= ~WR1_ID_RST;		/* the reset signal */

	/* setup for cpu access to dispatcher rams */
	*WRCNTL1 &= ~WR1_DREQ; 
	*WRCNTL1 |= WR1_ID_RST;			/* back to normal */

	wait_for_dispatcher_rams();

	/* initialize the queue ram */
	for(j=QUEUE_RAM; j<QUEUE_RAM + QUEUE_LWORDS;j++) 
		*j = 0;
	/* initialize the pointer rams */
	for(j=POINTER_RAM; j<POINTER_RAM + POINTER_LWORDS;j++)
		*j= (POINTER_INIT_VAL << POINTER_IN_SH) |
			(POINTER_INIT_VAL << POINTER_OUT_SH);
	/* initialize the miscellaneous rams */
	for(j=MISC_RAM; j<MISC_RAM + MISC_LWORDS; j++)

		/* keep bit 28 = 0 (directed ints only) */
		*j= 0x000003ff | (spm_slot << CONFIG_SH);

	next_slot = spm_slot;
	/* fill configuration ram */
	for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; sbus_slot++) {
		if (SBUS_IS_PM(sbus_config.slot_id[sbus_slot])) {
			j = MISC_RAM + next_slot;
			next_slot = sbus_slot;
			val = *j & ~CONFIG_MASK & ~CNTR_ZERO_BIT;
			*j = val | (sbus_slot << CONFIG_SH) | 0x10000000;
		}
		if(!found_empty_slot) {
			if((sbus_config.slot_id[sbus_slot] == SBUS_MM) ||
			(sbus_config.slot_id[sbus_slot] == SBUS_NO_BOARD)) {
				found_empty_slot = 1;
				disp_slot_id = sbus_slot;
			}
		}
	}

	if(!found_empty_slot)
		/* no mem or empty slot for id to be put in WR0 */
		panic("init_disp: configuration must have a memory module or an empty slot");

	/* program up the dispatcher slot id */

	*WRCNTL0 |= (disp_slot_id << 8);
	
	/* put dispatcher in normal mode */

	*WRCNTL1 |= WR1_DREQ; 

	/* reset interrupt dispatcher */
	*WRCNTL1 &= ~WR1_ID_RST;		/* the reset signal */
	*WRCNTL1 |= WR1_ID_RST;			/* back to normal */
}
#endif /* JAMES */

/*
 * clear_bss()
 *
 * clear the bss area
 */
clear_bss()
{
	extern int	edata, end;

	bzero((caddr_t)&edata, (uint)&end - (uint)&edata + 1);
}

wait_for_dispatcher_rams()
{
	if(*STATUSREG & STAT_ID)
		panic("init_disp: cannot access dispatcher rams");   
}

css_error_capture(state)
uint	state;
{
	if(state == TRUE) {
		*WRCNTL0 |= WR0_CSS_ERR_INHIBIT;
		ignore_css_error = 0;
	}
	else {
 		/* inhibit CSS error capturing */
		*WRCNTL0 &= ~WR0_CSS_ERR_INHIBIT;
		ignore_css_error = 1;
	}
}


/*
 * slice_basename -- truncate off any filename part of a pathname
 */

void
slice_basename(str)
char	*str;
{
	iunit_t	iunit;
	char	*p;

	(void) get_device_info(str, &iunit, &p);

	if (p)
		*p = '\0';
}
