/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dnld.c: version 25.1 created on 11/27/91 at 15:39:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dnld.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:dnld.c	25.1"
/* dnld.c */

#include "misc.h"
#include "global.h"
#include "spm.h"
#include "scc.h"
#include "iomap.h"
#include "sys/types.h"
#include "rwi.h"
#include "sa_dir.h"
#include "dev.h"
#include "novram.h"
#include "sys/debug.h"

#define BITMASK		0xff	/* removes extra bits from int */

#define	iqsize	1024

/*******************************************************************
 * declarations for the Xmodem protocol provided in xmodem.c
 */
#define BBUFSIZ         1024    /* buffer size -- do not change! */
extern char xferbuff[];
extern xmodem_get();
extern xmodem_ack();
extern xmodem_cancel();
extern xmodem_start();
extern sendbyte();
void   x_signal();
/*****************************************************************/

unsigned char *head, *tail, input_q[iqsize];

/*
 *	Set up connection with host computer 
 */
connect()
{
	int     c;

	while (1) {
		if (( c = keyin(0) ) != -1) {
			if ( c == CTRL_C ) 	/* abort it */
				return(0);
			if ( c == CTRL_Z )	/* continue download */
				return(1);
			keyout(c,1);
		}
		if (( c = keyin(1) ) != -1)
			keyout(c,0);
	}
}


/*
 * rfile() - Receive a file and download it to memory, 1K at a time with a
 *           1k resolution.
 */
rfile(mem)
register unsigned char *mem;	/* Pointer to memory in object array..*/
{
	int blk_state;
	unsigned blknum = 0;

	xmodem_start();

	while ( (blk_state = xmodem_get()) == 1) {
/*		copy_to_km(xferbuff, mem, BBUFSIZ); */
		bcopy(xferbuff, mem, BBUFSIZ);
		mem += BBUFSIZ; 
		x_signal(++blknum);
		xmodem_ack(); 
	}

	/* Return zero (bad) if tranfer went bad. */
	return(blk_state != -1);
}

keyin(port)
char        port;
{
	int     c;

	if ( port == 0 )	{
		return(con_in());
	}
	if ( port == 1 )	{
		ringin();
		if (head != tail)	{
			c = (*head++);
			if ( head == &input_q[sizeof input_q])
				head = input_q;
			return(c & BITMASK);
		}
		else	{
			return(-1);
		}
	}
	return(-1);
}

/* send one byte data to a port */
keyout(data,port)
char        port;
int    data;
{
	char    dataout;
	register struct scc *sccaptr = CONSOLE_PORT;
	register struct scc *sccbptr = MODEM_PORT;

	dataout = (char)data & BITMASK;	/* only send one byte. */
	if ( port == 0 )	{
		while(!(sccaptr->reg[0].reg & RR0_TX) )
			ringin();
		sccaptr->reg[8].reg = dataout; /* sent one byte to channel 0 */
	}
	if ( port == 1 )	{
		while(!(sccbptr->reg[0].reg & RR0_TX) )
			;
		sccbptr->reg[8].reg = dataout; /* sent one byte to channel 1 */
	}
		return;
}

ringin()
{
	char	c;
	register struct scc *sccptr = MODEM_PORT;

	if(sccptr->reg[0].reg & RR0_RX) { 
		c = sccptr->reg[8].reg; 
		*tail++ = c;
		if ( tail == &input_q[sizeof input_q])
			tail = input_q;
	}
}

send1byte(ch)
{
	int	i;

/*	for(i = 0; i < 5000; i++) ;	/* */
/*	sendbyte(ch);	/* */
	sendbyte(ch);	/* send this character. */
	for(i = 0; i < 38000; i++)	/* loop for a long time.. */
	{
		if(keyin(1) != -1)	/* if a key came back.. */
			break;	/* exit loop. key for key.. */
	}
	while(keyin(1) != - 1) ; /* loop in case extra chars come across. */
}

void
x_signal(blknum)
unsigned blknum;
{
	if(blknum & 1)
		GREEN_LED_OFF;
	else
		GREEN_LED_ON;
	printf("\rblock %u", blknum);
}
