/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) atox.c: version 25.1 created on 11/27/91 at 15:38:52	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)atox.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 * atox.c -- improved arithmetic parser for the SPM
 *
 * JPC 8/29/88
 *
 * JPC 1/18/90	Changed exlex to use strtol.
 */

#include "global.h"
#include "sys/types.h"
#include "setjmp.h"
#include "ctype.h"
#include "cpu_method.h"

/* #define DEBUG_EXPR		/* debugging output */

#ifndef NULL
#define NULL		(0)
#endif

#define EOE		(0)		/* end of expression		*/
#define NUMB		(1)		/* last token was a number	*/
#define UMN		('-' | 0x80)	/* unary minus			*/
#define UNARY_MINUS	(op_toks + 1)	/* pointer to unary minus OP	*/
#define UPT		('*' | 0x80)	/* unary indirection		*/
#define INDIRECT	(op_toks + 2)	/* pointer to indirect OP	*/

#define UNARY_OP	0		/* this OP is unary (1 arg)	*/
#define BINARY_OP	1		/* this OP is binary (2 args)	*/

#define TOK_NUM		0		/* token is a number		*/
#define TOK_OP		1		/* token is an operator		*/
#define TOK_VAR		2		/* token is a variable		*/

#ifdef DEBUG_EXPR
#define STACK_SIZE	7
#else
#define STACK_SIZE	16
#endif /* DEBUG_EXPR */
#define NAME_SIZE	32
#define VARPOOL_SIZE	22

#define NEL(x)		(sizeof(x) / sizeof(*x))
#define EQn(a, b, n)	(strncmp(a, b, n) == 0)
#define is_symb(c)	(isalnum(c) || c == '_')
					/* DIGIT - use only with isalnum */
#define DIGIT(c)	((c) - (isdigit(c) ? '0' : (isupper(c) ? 'A' : 'a')))

#define push_num(num)	push_it(&exnum_stack, num)
#define pop_num()	pop_it(&exnum_stack)
#define top_num()	stk_top(&exnum_stack)
#define push_op(op)	push_it(&exop_stack, (uint)(op))
#define pop_op()	(OP *)pop_it(&exop_stack)
#define top_op()	stk_top(&exop_stack)

#define CASE		break;case
#define DEFAULT		break;default

typedef struct operator {
	uchar	symb;			/* operator's token		*/
	uchar	pushprec;		/* push precedence		*/
	uchar	popprec;		/* pop (on stack) precedence	*/
	uchar	binop;			/* unary/binary operator flag	*/
	char	*str;			/* debugging representation	*/
} OP;

typedef struct variable {		/* user varariable structure	*/
	char	name[NAME_SIZE];
	uint	value;
} VAR;

typedef union stk_u {			/* stuff that goes on a stack	*/
	uint	num;
	OP	*op;
	VAR	*var;
} STK_U;

typedef struct stack {			/* stack structure		*/
	STK_U	*ptr;
	STK_U	stk[STACK_SIZE];
} STACK;

typedef struct exprenv {		/* expression string data	*/
	char	*ptr;
	int	un_ch1;			/* allow up to 3 eungetch()s	*/
	int	un_ch2;
	int	un_ch3;
} EXPRDT;

typedef struct token {			/* parser token structure	*/
	uint	type;
	union tok_u {
		uint	num;
		OP	*op;
		VAR	*var;
	} u;
} TOKEN;

OP	op_toks[] = {
	{ '(', 15,  1, UNARY_OP,  "(" },
	{ UMN, 14, 14, UNARY_OP,  "_" },	/* unary minus */
	{ UPT, 14, 13, UNARY_OP,  "@" },	/* unary indirection */
	{ '~', 14, 13, UNARY_OP,  "~" },
	{ '*', 12, 12, BINARY_OP, "*" },
	{ '/', 12, 12, BINARY_OP, "/" },
	{ '%', 12, 12, BINARY_OP, "%" },
	{ '+', 11, 11, BINARY_OP, "+" },
	{ '-', 11, 11, BINARY_OP, "-" },
	{ '<', 10, 10, BINARY_OP, "<<" },	/* left shift	*/
	{ '>', 10, 10, BINARY_OP, ">>" },	/* right shift	*/
	{ '&',  9,  9, BINARY_OP, "&" },
	{ '^',  8,  8, BINARY_OP, "^" },
	{ '|',  7,  7, BINARY_OP, "|" },
	{ ')',  1,  1, UNARY_OP,  ")" },
	{ 0 }
};
static OP	eoe_op = { 0, 0, 0 };

static EXPRDT	exd;
static STACK	exnum_stack;
static STACK	exop_stack;
static VAR	exvars[VARPOOL_SIZE];

int		ex_base = 16;

extern jmp_buf	environbuf;		/* SPM-wide jump buf back to menu */

static uint	eval();
static VAR	*exvar_get();

extern void	longjmp();
extern char	*strcpy();
extern long	strtol();

/*
 * err -- print an error message and longjmp to safety
 */

/*VARARGS1*/
err(fmt, a1, a2, a3, a4)
char	*fmt;
{
	printf(fmt, a1, a2, a3, a4);
	printf("\n");
	longjmp(environbuf, 1);
}

/*
 * Atox -- convert ASCII to uint -- now works with non-hexadecimal strings!
 */

uint
Atox(str)
char	*str;
{
	if (str == NULL)
		err("Atox: NULL string");

	exd.ptr = str;
	exd.un_ch1 = exd.un_ch2 = exd.un_ch3 = EOE;
	exnum_stack.ptr = exnum_stack.stk;
	exop_stack.ptr = exop_stack.stk;

	return (eval());
}

/*
 * egetch -- get the next char
 */

static
egetch()
{
	register int	c;

	if ((c = exd.un_ch1) != EOE) {
		exd.un_ch1 = exd.un_ch2;
		exd.un_ch2 = exd.un_ch3;
		exd.un_ch3 = EOE;
		return (c);
	}
	if ((c = *exd.ptr) == '\0')
		return (EOE);
	++exd.ptr;
	return (c);
}

/*
 * eungetch -- unget up to 3 characters
 */

static
eungetch(c)
int	c;
{
	if (c == EOE)
		return;					/* do nothing */
	if (exd.un_ch3 != EOE)
		err("eungetch: ungot more than 3 chars!");

	if (exd.un_ch1 != EOE) {
		exd.un_ch3 = exd.un_ch2;
		exd.un_ch2 = exd.un_ch1;
	}
	exd.un_ch1 = c;
}

#ifndef DEBUG_EXPR
/*
 * set_var -- menu interface to set values to variables
 *	Format:  set  <name> <expression>
 */

set_var(arg_cnt)
int	arg_cnt;
{
	register char	*p;
	register int	c;

	if (arg_cnt == 0) {
		exvar_list();
		return;
	}

	for (p = comm_args[1]; c = *p; p++) {
		if (!isalnum(c) && c != '_') {
			if (c != '=') {
				printf("Invalid char '%c' (0x%x) in var name\n",
				  c, c);
				return;
			}
			*p++ = NULL;
			break;
		}
	}
	if (*p == NULL) {
		if (arg_cnt == 1)
			p = "0";
		else
			p = comm_args[2];
	}

	exvar_set(comm_args[1], Atox(p));
}

/*
 * unset_var -- menu interface to obliterate variables
 *	Format:  unset  [<var_name> . . . .]
 */

unset_var(arg_cnt)
register int	arg_cnt;
{
	register int	i;

	if (arg_cnt == 0) {
		exvar_list();
		return;
	}

	for (i = 1; i <= arg_cnt; i++) {
		(void)exvar_unset(comm_args[i]);
	}
}
#endif /* DEBUG_EXPR */


/*
 * exvar_set -- set the value of the named variable
 */

exvar_set(nm, value)
char	*nm;
uint	value;
{
	register int	c, i;
	register char	*p;
	register VAR	*vp;
	char		name[NAME_SIZE + 4];

	if (nm == NULL) {
		exvar_list();
		return;
	}

	for (p = nm, i = 0; (c = *p++) != '\0'; ) {
		if ((!isalnum(c) && c != '_') || i >= sizeof(name) - 1)
			break;

		name[i++] = c;
	}
	if (i == 0) {
		exvar_list();
		return;
	}
	name[i] = '\0';
	if (i > NAME_SIZE - 1) {
		printf("Var name '%s' too long (max %d characters).\n",
		  name, NAME_SIZE - 1);
		name[NAME_SIZE - 1] = '\0';
		printf("Truncating to: '%s'\n", name);
	}

	if ((vp = exvar_get(name)) == NULL) {
							/* alloc new variable */
		for (vp = exvars, i = NEL(exvars); --i >= 0; vp++)
			if (*vp->name == '\0')
				break;
		if (i < 0)
			err("All %d variables in use!", NEL(exvars));
		strcpy(vp->name, name);
	}
	vp->value = value;
}

/*
 * exvar_list -- print the values of all variables
 */

exvar_list()
{
	register VAR	*vp;
	register int	i, n, maxlen;

	for (vp = exvars, maxlen = 0, i = NEL(exvars); --i >= 0; vp++) {
		if (*vp->name != '\0' && (n = strlen(vp->name)) > maxlen)
			maxlen = n;
	}
	for (vp = exvars, i = NEL(exvars); --i >= 0; vp++) {
		if (*vp->name != '\0')
			printf("%-*s = %10d (0x%08x)\n",
			  maxlen, vp->name, vp->value, vp->value);
	}
}

/*
 * exvar_unset -- free the named variable, returns non-zero if succeeded
 */

exvar_unset(name)
char	*name;
{
	VAR	*vp;

	if (vp = exvar_get(name)) {
		*vp->name = '\0';
		return (1);
	}
	return (0);
}


/*
 * exvar_get -- find the named variable and return a pointer to it.  If
 *	the var isn't found, returns NULL
 */

static VAR *
exvar_get(name)
register char	*name;
{
	register VAR	*vp;
	register int	i;

	for (vp = exvars, i = NEL(exvars); --i >= 0; vp++)
		if (*vp->name != '\0' && EQn(name, vp->name, NAME_SIZE - 1))
			break;
	if (i < 0)
		return (NULL);

	return (vp);
}

/*
 * find_op -- recognize operators and return their OPs
 */

static OP *
find_op(c)
register int	c;
{
	register OP	*op;
	register int	ch;

	for (op = op_toks; op->symb != 0; op++) {
		if (op->symb == c) {
			/* check multi-char operators */
			switch (c) {
			case '<':
			case '>':
				if ((ch = egetch()) != c) {
					eungetch(ch);
					continue;		/* not it */
				}
			}
			return (op);				/* gotcha */
		}
	}
	return (NULL);						/* not found */
}

/*
 * checkreg -- Check to see if the following two characters spell out a
 *	register name.  If so, put its value in uip and return non-zero,
 *	else return zero on error.
 */

static
checkreg(uip)
uint	*uip;
{
	register int	ch1, ch2, ch3, ch4;
	char		str[4];

	ch2 = ch3 = EOE;
	switch (ch1 = egetch()) {
#ifndef aSPARC
	case 'a':	case 'd':
#else
	case 'g':	case 'o':
#endif
		if (isdigit(ch2 = egetch()) && ch2 <= '7') {
			if (!isalnum(ch3 = egetch())) {
doit:				str[0] = ch1;
				str[1] = ch2;
				str[2] = '\0';
				eungetch(ch3);
				*uip = CPU_get_named_reg(str);
				return(1);
			}
		}
#ifndef aSPARC
	CASE 's':
		if (((ch2 = egetch()) == 'r' || ch2 == 'p') &&
		  !isalnum(ch3 = egetch())) {
			goto doit;
		}
	CASE 'p':
		if ((ch2 = egetch()) == 'c' && !isalnum(ch3 = egetch())) {
			goto doit;
		}
	CASE 'f':
		if ((ch2 = egetch()) == 'p' && !isalnum(ch3 = egetch())) {
			goto doit;
		}
#else
	CASE 'p':
		if ((ch2 = egetch()) == 'c') {
			if (!isalnum(ch3 = egetch()))
				goto doit;
		} else
		if ((ch2 == 's') && ((ch3 = egetch()) == 'r')) {
			if (!isalnum(ch4 = egetch())) {
doit3:				str[0] = ch1;
				str[1] = ch2;
				str[2] = ch3;
				str[3] = '\0';
				eungetch(ch4);
				*uip = CPU_get_named_reg(str);
				return(1);
			}
			else
				eungetch(ch4);
		}
	CASE 'n':
		if (((ch2 = egetch()) == 'p') && ((ch3 = egetch()) == 'c')) {
			if (!isalnum(ch4 = egetch())) 
				goto doit3;
			else
				eungetch(ch4);
		}
	CASE 'y':
		if (!isalnum(ch2 = egetch())) {
			str[0] = 'y';
			str[1] = '\0';
			eungetch(ch2);
			*uip = CPU_get_reg(str);
			return (1)
		}
		break;
#endif  /* aSPARC */
	}

	if (ch3 != EOE)
		eungetch(ch3);
	if (ch2 != EOE)
		eungetch(ch2);
	eungetch(ch1);

	return (0);
}

/*
 * edostr -- collect a string and convert it into:
 *		1) a numeric constant (decimal, octal, or hex)
 *		2) the value of a local variable
 *		3) the value of a kernel symbol
 *	Returns the value (calls err and longjmps out on failure)
 */

static uint
edostr(c, dollar)
register int	c;
int		dollar;
{
	register int	i;
	register char	*p;
	VAR		*vp;
	char		*ptr;
	int		num;
	char		str[NAME_SIZE + 4];

	i = sizeof(str);
	p = str;
	do {
		if (--i > 0)
			*p++ = c;
	} while ((c = egetch()) != EOE && is_symb(c));
	*p = '\0';
	p = str;
	if (c != EOE)
		eungetch(c);			/* put back char */

	if (i < 4) {
		printf("Warning: string '%s' too long (max. %d characters)\n",
		  p, NAME_SIZE - 1);
		str[NAME_SIZE - 1] = '\0';
	}

	/*
	 * check to see if the string is a number (decimal, octal, or hex)
	 */
	if (p[0] == '0' && (p[1] == 'x' || p[1] == 'X'))
		i = 16;
	else {
		for (i = ex_base; (c = *p++) != '\0'; )
			if (!isxdigit(c) || (ex_base && DIGIT(c) > ex_base)) {
				i = -1;			/* bad char */
				break;
			}
		p = str;
	}

	if (!dollar && i >= 0) {
		i = strtol(p, &ptr, i);
		if ((c = *ptr) != '\0')
			err("Non-numeric char in '%s': %c", p, c);

		return (i);		/* got num */
	}

	/*
	 * must be either a variable or a kernel symbol
	 */
	if (vp = exvar_get(p))
		return (vp->value);	/* got num */

	if (atov(&num, p))
		return (num);		/* got num */

	err("'%s' is not a SPM variable or a kernel symbol.", p);
	/*NOTREACHED*/
}

/*
 * exlex -- lexical analyzer; returns a valid TOKEN pointer, or NULL
 */

static TOKEN *
exlex()
{
	register int	c, dollar;
	static TOKEN	tok;

	dollar = 0;
	while ((c = egetch()) != EOE) {
		if (isspace(c))
			continue;			/* skip white space */

		/*
		 * build an alphanumeric (and underscore) string, then test
		 * to see if it is a hex number, a variable, or a kernel symbol
		 */
		if (is_symb(c)) {
			tok.u.num = edostr(c, dollar);
			tok.type = TOK_NUM;
			return (&tok);		/* got num */
		}

		if (dollar) {
			printf("Use '$' only with a variable or symbol\n");
			dollar = 0;
		}

		/*
		 * a dollar sign prefix will disable the hex number check above
		 * (in an odd reversal of Motorola assembler syntax)
		 */
		if (c == '$') {
			dollar = 1;			/* var/symb follows */
			continue;
		}

		/*
		 * the percent sign may be the prefix to a register name
		 */
		if (c == '%' && checkreg(&tok.u.num)) {
			tok.type = TOK_NUM;
			return (&tok);			/* was register */
		}

		if (tok.u.op = find_op(c)) {		/* recognize operands */
			tok.type = TOK_OP;
			return (&tok);
		}

		err("Unrecognized chararacter in expression: 0x%x ('%c')",
		  c, c);
	}
	return (NULL);
}

/*
 * push_it -- push a value on a stack
 */

static void
push_it(sp, val)
register STACK	*sp;
uint		val;
{
	if (sp->ptr >= &sp->stk[NEL(sp->stk)]) {
		err("push_it: stack overflow! [stk=%x]", sp);
	}
	sp->ptr->num = val;
	sp->ptr++;
}

/*
 * pop_it -- pop a value off its stack, returns value on new top-of-stack
 */

static uint
pop_it(sp)
register STACK	*sp;
{
	if (--sp->ptr < sp->stk) {
		err("pop_it: stack underflow! [stk=%x]", sp);
	}
	return (sp->ptr->num);
}

/*
 * stk_top -- returns a pointer to the top value on a stack, or NULL
 */

static STK_U *
stk_top(sp)
STACK	*sp;
{
	return ((sp->ptr <= sp->stk) ? NULL : sp->ptr - 1);
}

/*
 * eval -- parse them tokens
 */

static uint
eval()
{
	register TOKEN	*tp;
	register STK_U	*vp;
	register OP	*op;
	register char	*laststr = "";
	register int	lastsymb = 0;

	while (tp = exlex()) {
		switch (tp->type) {
		case TOK_NUM:

			/*
			 * always push numbers
			 */
			if (lastsymb == NUMB)
				err("eval: %x following %x?",
				  tp->u.num, top_num()->num);
			push_num(tp->u.num);
			lastsymb = NUMB;

		CASE TOK_OP:

			op = tp->u.op;
			/*
			 * Check for syntax errors, like (6)-+4, as well as
			 * recognize unary minus.
			 */
			if (lastsymb != NUMB || op->symb == '~') {
				switch (op->symb) {
				case '-':
					if (lastsymb == UMN)
						err("err: double unary minus");
					if (lastsymb != ')')
						op = UNARY_MINUS;
				CASE '(':
				case ')':	/* parens can follow anything */
					;
				CASE '~':	/* tilde can follow other ops */
					if (lastsymb == ')' || lastsymb == NUMB)
						err("missing operand before ~");
				CASE '*':
					if (lastsymb != ')')
						op = INDIRECT;
				DEFAULT:
					if (lastsymb == 0) {
						err("eval: '%s' before number?",
						  op->str);
					}
					if (lastsymb == ')')
						break;	/* right paren ok */

					err("eval: '%s' following '%s'?",
					  op->str, laststr);
				}
			}

			/*
			 * See if the stack can be evaulated, given the new
			 * operator.
			 */
			if (eval_stack(op))
				push_op(op);
			lastsymb = op->symb;
			laststr  = op->str;

		DEFAULT:

			err("eval: bad type=%x", tp->type);
		}
#ifdef DEBUG_EXPR
		printstk();
#endif
	}

	/*
	 * make sure any final operands are evaluated
	 */
	(void) eval_stack(&eoe_op);

	if ((vp = top_num()) == NULL)
		return (0);			/* backwards compatibility */
	if (vp > exnum_stack.stk)
		err("expr: numbers left on stack!?!");

	return (vp->num);
}

/*
 * eval_stack -- while the push precedence of the supplied op is not greater
 *	than the pop precedence of the stack top, pop arguments and evaluate
 *	Returns non-zero if supplied op should be pushed, else zero if not.
 */

static
eval_stack(x)
register OP	*x;
{
	register OP	*v;
	register STK_U	*top;
	register uint	val2;

	while (top = top_op()) {
		if (x->pushprec > top->op->popprec) {
			return (1);			/* wait till later */
		}
		v = pop_op();

		if (v->binop) {
			val2 = pop_num();
		}
		if ((top = top_num()) == NULL) {
			err("eval_stack: out of numbers!");
		}

		switch (v->symb) {
		case '(':
			if (x->symb == ')')
				return (0);		/* did matched parens */
		CASE UMN:
			top->num = -top->num;
		CASE UPT:
			top->num = CPU_get_long(top->num);
		CASE '~':
			top->num = ~top->num;
		CASE '*':
			top->num *= val2;
		CASE '/':
			if (val2 == 0)
				err("eval_stack: divide by 0!");
			top->num /= val2;
		CASE '%':
			top->num %= val2;
		CASE '+':
			top->num += val2;
		CASE '-':
			top->num -= val2;
		CASE '<':
			top->num <<= val2;
		CASE '>':
			top->num >>= val2;
		CASE '&':
			top->num &= val2;
		CASE '^':
			top->num ^= val2;
		CASE '|':
			top->num |= val2;
		DEFAULT:
		case ')':	/* should never get right parens on stack */
			err("eval_stack: impossible symb=0x%x", v->symb);
		}
#ifdef DEBUG_EXPR
		printstk();
#endif
	}
	if (x->symb == ')')
		err("eval_stack: unmatched right parenthesis");
	return (1);
}


#ifdef DEBUG_EXPR

jmp_buf	environbuf;

printstk()
{
	register int	i, top;

	top = exnum_stack.ptr - exnum_stack.stk;
	for (i = 0; i < NEL(exnum_stack.stk); i++) {
		if (i < top)
			printf("%08x ", exnum_stack.stk[i].num);
		else
			printf(".........");
	}
	printf("| ");
	top = exop_stack.ptr - exop_stack.stk;
	for (i = 0; i < top; i++) {
		printf("%s ", exop_stack.stk[i].op->str);
	}
	printf("\n");
}

/*
 * CPU_get_reg -- fetch the given register's value -- returns zero on error
 */

uint
CPU_get_reg(regname)
char	*regname;
{
	switch (*regname) {
	case 'a':
		return(0xa0 + regname[1] - '0');
	CASE 'd':
		return(0xd0 + regname[1] - '0');
	CASE 's':
		return(regname[1] == 'p' ? 0xfadedace : 0xfadedbed);
	CASE 'p':
		return(0xdeadface);
	CASE 'f':
		return(0xdeafabed);
	DEFAULT:
		return(0);
	}
}

/*
 * CPU_get_long -- return the long at the given address
 */

CPU_get_long(addr)
uint	addr;
{
	return (-addr);
}

/*
 * atov -- put the value of kernel symbol name in uip -- returns zero on error
 */

atov(uip, name)
uint	*uip;
char	*name;
{
	register uint	val, num;

	for (num = 0; (val = *name++) != '\0'; num += val + (num >> 16))
		num <<= 1;
#ifdef notdef
	if (num & 1)
		return (0);			/* 50/50 chance of error */
#endif

	*uip = num;
	return (1);
}

main()
{
	register char	*p, *v;
	char		buf[256];
	extern char	*gets(), *strchr();

	(void) setjmp(environbuf);
	for (;;) {
		printf("> ");
		if (!gets(buf))
			return (0);

		p = buf;
		switch (*p) {
		case 's':
			while (isspace(*++p))
				;
			if (v = strchr(p, '=')) {
				*v++ = NULL;
			}
			exvar_set(p, Atox(v));
		CASE 'l':
			exvar_list();
		CASE 'u':
			while (isspace(*++p))
				;
			printf("%s.\n", exvar_unset(p) ? "Unset" : "Not found");
		DEFAULT:
			printf("value = 0x%x\n", Atox(p));
		}
	}
}
#endif /* DEBUG_EXPR */
