#	START NEW ARIX SCCS HEADER
#
#	@(#) vector.s: version 25.1 created on 11/27/91 at 15:38:42
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)vector.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)vector.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
# vector.s

set	A7S,0x0001
set	A6S,0x0002
set	A5S,0x0004
set	A4S,0x0008
set	A3S,0x0010
set	A2S,0x0020
set	A1S,0x0040
set	A0S,0x0080
set	D7S,0x0100
set	D6S,0x0200
set	D5S,0x0400
set	D4S,0x0800
set	D3S,0x1000
set	D2S,0x2000
set	D1S,0x4000
set	D0S,0x8000
set	D0R,0x0001
set	D1R,0x0002
set	D2R,0x0004
set	D3R,0x0008
set	D4R,0x0010
set	D5R,0x0020
set	D6R,0x0040
set	D7R,0x0080
set	A0R,0x0100
set	A1R,0x0200
set	A2R,0x0400
set	A3R,0x0800
set	A4R,0x1000
set	A5R,0x2000
set	A6R,0x4000
set	A7R,0x8000

global Xauto1%,Xauto2%,Xauto3%,Xauto7%
global Trap0%
global LCIOerr
global LCIOt1int
global LCIOt2int
global LCIOt3int

global SCC0B_BEint
global SCC0B_SCint
global SCC0B_CAint
global SCC0B_SRCint
global SCC0A_BEint
global SCC0A_SCint
global SCC0A_CAint
global SCC0A_SRCint

global SCC1B_BEint
global SCC1B_SCint
global SCC1B_CAint
global SCC1B_SRCint
global SCC1A_BEint
global SCC1A_SCint
global SCC1A_CAint
global SCC1A_SRCint

global CIO0_PORTA_INT
global CIO0_PORTB_INT
global CIO0_TIMER_INT

	text
#-------------------------------------------------------------------------
#
#	T  R  A  P
#
#-------------------------------------------------------------------------

busint: global	busint		# vector address 8
mov.w	&0x2700, %sr
	movm.l	&0xfffe, -(%sp)	# save all registers
	mov.l	%usp, %a0
	mov.l	%a0, -(%sp)

	jsr	buserr		# general purpose bus error handler
	bra	trap_ret


#-------------------------------------------------------------------------
#
#	G R O U P   1   E X C E P T I O N S
#
#	entry stack:
#			|------------------------------------------|
#		SSP -->	|   status register                        |
#			|------------------------------------------|
#			|   program counter high                   |
#			|------------------------------------------|
#			|   program counter low                    |
#			|------------------------------------------|
#
#-------------------------------------------------------------------------

#	dispatcher error
Xauto1%:
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	disp_err
	bra.w	int_ret%

#	command register write
Xauto2%:
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	cmd_int
	bra.w	int_ret%

#	interrupt to SPM
Xauto3%:
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	spm_int
	bra.w	int_ret%


#	CSS error interrupt
Xauto7%:
	movm.l	&0xc0c0,-(%sp)		# save d0,d1,a0,a1
	jsr	css_err
 	bra.w	int_ret%

Trap0%:	
	movm.l	&0x40c0,-(%sp)		# save d1,a0,a1
	jsr	trap_0			# d0 used to return parameters	
	movm.l	(%sp)+,&0x0302		# restore a1,a0,d1
	rte

#-------------------------------------------------------------------------
#
#	G R O U P   2   E X C E P T I O N S
#
#	entry stack:
#			|------------------------------------------|
#		SSP -->	|   status register                        |
#			|------------------------------------------|
#			|   program counter high                   |
#			|------------------------------------------|
#			|   program counter low                    |
#			|------------------------------------------|
#
#-------------------------------------------------------------------------




#-------------------------------------------------------------------------
#
#	I N T    R E T
#			 15                                       0
#			|------------------------------------------|
#		SSP --> |                 a1                       |
#			|                 a0                       |
#			|                 d1                       |
#			|                 d0                       |
#			|------------------------------------------|
#	   		|   status register                        |
#			|------------------------------------------|
#	   		|   program counter high                   |
#			|------------------------------------------|
#	   		|   program counter low                    |
#			|------------------------------------------|
#
#-------------------------------------------------------------------------

int_ret%:
	movm.l	(%sp)+,&0x0303		# restore a1,a0,d1,d0
	rte


#-------------------------------------------------------------------------
#
#	A L L    T R A P S (see sys/state.h)
#
#-------------------------------------------------------------------------

nullvect:	global	nullvect
	mov.w	&0x2700, %sr
	movm.l	&0xfffe,-(%sp)		# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)

	jsr	trap

trap_ret:
	mov.l	&9,%d0
	mov.l	%d0,%cacr	# clear Processor's internal cache

	btst	&3,70(%sp)	# check if stack needs to be "crunched"
	beq	no_crunch

#
#	STACK CRUNCHING CODE:
#	Turns any stack frame into a normal stack frame
#
#	When started, sp points to:
#		16 saved registers, ps, pc, vecoff, optional info
#
#	When finished, sp points to:
#			16 saved registers, ps, pc, 0
#
	mov.w	70(%sp),%d0
	lsr.w	&12,%d0			# d0 is format code
	andi.w	&0x07ff,70(%sp)		# clear format code and "crunch bit"
	mov.l	&0,%d1
	mov.b	(stkfmtsz,%d0.w),%d1	# d1 is # of bytes change in size
	lea	72(%sp),%a0		# a0 points past bottom of src area
	lea	(%d1,%a0),%a1		# a1 points past bottom of dst area

# copy regs, ps, pc, vecoff
# crunch_loop will go around 18 times.
# 16 times for the registers, 2 times for the normal stack
#
	mov.l	&17, %d0		# d0 contains one less than loop count
crunch_loop:
	mov.l	-(%a0),-(%a1)
	dbra.w	%d0,crunch_loop
	mov.l	%a1,%sp

no_crunch:
	mov.l	(%sp)+,%a0
	mov.l	%a0,%usp
	movm.l	(%sp)+,&0x7fff
	rte

LCIOerr:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIO_err
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

LCIOt1int:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIOt1_int	
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

LCIOt2int:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIOt2_int	
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

LCIOt3int:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	LCIOt3_int	
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

# modem port receive character available 
SCC0B_CAint: 
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	modem_char_available
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#
# modem port external status change
#
SCC0B_SCint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	modem_status_change
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

# modem port special receive condition
SCC0B_SRCint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	modem_special_receive
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#
# modem port transmit buffer empty
#
SCC0B_BEint:
	bra	nullvect


#
# console port transmit buffer empty
# console port status change 
# console port special receive condition
#
SCC0A_BEint:
	bra	nullvect
#
# console port external status change
#
SCC0A_SCint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	console_status_change
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

# console port special receive condition
SCC0A_SRCint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	console_special_receive
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#
# console port receive character available
#
SCC0A_CAint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	console_char_available
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#
# ups port transmit buffer empty
# ups port external status change 
# ups port receive character available 
# ups port special receive condition
#
SCC1B_BEint:
SCC1B_SCint:
SCC1B_CAint: 
SCC1B_SRCint:
# nothing defined for the ups port
	bra	nullvect

#
# printer port transmit buffer empty
#
SCC1A_BEint:
	bra	nullvect

# printer port special receive condition
SCC1A_SRCint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	printer_special_receive
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#
# printer port receive character available
#
SCC1A_CAint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	printer_char_available
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

#
# printer port external status change
#
SCC1A_SCint:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	printer_status_change
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

CIO0_PORTA_INT:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	cio0_porta_change
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

CIO0_PORTB_INT:
	movm.l	&A0S+A1S+D0S+D1S,-(%sp)	# Save the scratch registers
	jsr	cio0_portb_change
	movm.l	(%sp)+,&A0R+A1R+D0R+D1R	# Restore them
	rte

CIO0_TIMER_INT:
	bra	nullvect
