#	START NEW ARIX SCCS HEADER
#
#	@(#) probe.s: version 25.1 created on 11/27/91 at 15:38:27
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)probe.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)probe.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
# probe.s

	global	probe_rd_byte, probe_rd_short, probe_rd_long
	global	probe_wr_byte, probe_wr_short, probe_wr_long

	text

probe_rd_byte:
	mov.l	4(%sp), %a1	# a1 contains address to probe
	mov.l	8(%sp), %a0	# a0 contains address to store data
	mov.l	&probe_error, spm_caddrflt	# protect in case of bus error
	mov.b	(%a1), (%a0)	# do the actual probe
	bra	probe_done

probe_rd_short:
	mov.l	4(%sp), %a1	# a1 contains address to probe
	mov.l	8(%sp), %a0	# a0 contains address to store data
	mov.l	&probe_error, spm_caddrflt	# protect in case of bus error
	mov.w	(%a1), (%a0)	# do the actual probe
	bra	probe_done

probe_rd_long:
	mov.l	4(%sp), %a1	# a1 contains address to probe
	mov.l	8(%sp), %a0	# a0 contains address to store data
	mov.l	&probe_error, spm_caddrflt	# protect in case of bus error
	mov.l	(%a1), (%a0)	# do the actual probe
	bra	probe_done



probe_wr_byte:
	mov.l	4(%sp), %a1	# a1 contains address to probe
	mov.l	&probe_error,spm_caddrflt	# protect in case of bus error
	mov.b	8 + 3(%sp), (%a1)	# do the actual probe
	bra	probe_done

probe_wr_short:
	mov.l	4(%sp), %a1	# a1 contains address to probe
	mov.l	&probe_error,spm_caddrflt	# protect in case of bus error
	mov.w	8 + 2(%sp), (%a1)	# do the actual probe
	bra	probe_done

probe_wr_long:
	mov.l	4(%sp), %a1	# a1 contains address to probe
	mov.l	&probe_error,spm_caddrflt	# protect in case of bus error
	mov.l	8(%sp), (%a1)	# do the actual probe

probe_done:
	clr.l	spm_caddrflt	# we don't expect to get an error now
	mov.l	&1, %d0		# return TRUE VALUE
	rts

probe_error:
	clr.l	spm_caddrflt	# we don't expect to get an error now
	clr.l	%d0		# return FALSE VALUE
	rts
