#	START NEW ARIX SCCS HEADER
#
#	@(#) misc.s: version 25.1 created on 11/27/91 at 15:38:23
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)misc.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)misc.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#	@(#)misc.s	2.1
#-----------------------------------------------------------------------------
#
#	M I S C
#
#-----------------------------------------------------------------------------

	global	Chgint
	global	spl0,spl1,spl2,spl3,spl4,spl5,spl6,spl7,get_spl,splx
	global	spl_console, splhi
	global	set_pc_sp
	global	upkern_inc
#	global	atom_add
	global	atom_and_byte
	global	atom_or_byte
#	global  cas_long

	text

#change interrupt level to value passed on stack and return old level
global Chgint
Chgint:
	mov.l	4(%sp),%d0	#get desired level (from stack)
	lsl.l	&8,%d0		#get level info into position
	mov.w	%sr,%d1		#get present level
	and.w	&0xf8ff,%d1	#strip out int level
	or.l	%d0,%d1		#fill in desired level
	mov.w	%sr,%d0		#get present level again (for return)
	lsr.l	&8,%d0		# shift level
	and.l	&0x7,%d0	#save interrupt level info only
	mov.w	%d1,%sr		#update status register with desired level
	rts			#with original level in d0

#-----------------------------------------------------------------------------
#
#	S Y S T E M    P R I V I L E G E    L E V E L S
#
#-----------------------------------------------------------------------------

spl0:
	mov.w	%sr,%d0		# previous level
	and.w	&0xf8ff,%sr
	rts

spl1:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0100,%d1
	mov.w    %d1,%sr
	rts

spl2:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0200,%d1
	mov.w    %d1,%sr
	rts

spl3:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0300,%d1
	mov.w    %d1,%sr
	rts

spl4:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0400,%d1
	mov.w    %d1,%sr
	rts

spl_console:
spl5:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0500,%d1
	mov.w    %d1,%sr
	rts

spl6:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	and.w	&0xf8ff,%d1
	or.w	&0x0600,%d1
	mov.w    %d1,%sr
	rts

splhi:
spl7:
	mov.w	%sr,%d0		# previous level
	mov.w	%sr,%d1
	or.w	&0x0700,%d1
	mov.w    %d1,%sr
	rts

splx:
	mov.w	6(%sp),%sr
	rts

# returns current priority level
get_spl:
	mov.w	%sr,%d0
	lsr.w	&8,%d0
	and.l	&0x00000007,%d0
	rts


#
# upkern_inc()	atomically increment upkern.up_cnt, making it stick to a PM.
#
#		return upkern pm_id, or -1 for buserr

upkern_inc:
	mov.l	4(%sp), %a0			# load address of upkern
	mov.l	&atom_err, spm_caddrflt		# protect in case of bus error
	clr.l	%d0
	mov.w	(%a0), %d0			# old_up_cnt = up_cnt
L%upkern_inc_loop:
	mov.w	%d0, %d1			# new_up_cnt = up_cnt
	add.w	&1, %d1				# ++new_up_cnt
	cas.w	%d0, %d1, (%a0)			# old_up_cnt == up_cnt ?
						# 	up_cnt = new_up_cnt :
						#	new_up_cnt = up_cnt
	bne.b	L%upkern_inc_loop
	mov.w	2(%a0), %d0			# return up_pm_id
	clr.l	spm_caddrflt
	rts

#
# upkern_dec()	atomically decrement upkern.up_cnt.
#
#		return -1 for buserr, 1 for success
#
#upkern_dec:
#	mov.l	&atom_err, spm_caddrflt		# protect in case of bus error
#	mov.l	4(%sp), %a0			# load address of upkern
#	mov.w	(%a0), %d0
#upkern_dec_loop:
#	mov.w	%d0, %d1
#	sub.w	&1, %d1
#	cas.w	%d0, %d1, (%a0)
#	bne.b	upkern_dec_loop
#	clr.l	spm_caddrflt
#	mov.l	&1, %d0				# success
#	rts


# ulong
# atom_add(&ulong, add_val)	adds add_val to ulong using a cas, returns prev
#
# JPC: seems to be unused...
#atom_add:
#	mov.l	&atom_err, spm_caddrflt		# protect in case of bus error
#	mov.l	4(%sp), %a0			# load address of ulong into a0
#	mov.l	8(%sp), %a1			# load add_val into a1
#	mov.l	(%a0), %d0			# pre-load ulong's value into d0
#L%atom_add_loop:
#	mov.l	%a1, %d1
#	add.l	%d0, %d1			# d1 = d0 + a1
#	cas.l	%d0, %d1, (%a0)
#	bne.b	L%atom_add_loop
#	clr.l	spm_caddrflt
#	rts					# success

# atom_err	common atomic error routine

atom_err:
	clr.l	spm_caddrflt
	mov.l	&0xffffffff, %d0		# return value for buserr
	rts


# ulong
# atom_and_byte(&byte, and_val)	ands and_val to byte using a cas
#	returns prev value if successful, else -1
#
atom_and_byte:
	mov.l	&atom_err, spm_caddrflt		# protect in case of bus error
	mov.l	4(%sp), %a0			# load address of byte into a0
	mov.l	8(%sp), %a1			# load and_val into a1
	clr.l	%d0
	mov.b	(%a0), %d0			# pre-load byte's value into d0
L%ab0:
	mov.l	%a1, %d1
	and.b	%d0, %d1			# d1 = d0 & a1
	cas.b	%d0, %d1, (%a0)
	bne.b	L%ab0
	clr.l	spm_caddrflt
	rts					# success

# ulong
# atom_or_byte(&byte, or_val)	or's or_val to byte using a cas
#	returns previous value if successful, else -1
#
atom_or_byte:
	mov.l	&atom_err, spm_caddrflt		# protect in case of bus error
	mov.l	4(%sp), %a0			# load address of byte into a0
	mov.l	8(%sp), %a1			# load or_val into a1
	clr.l	%d0
	mov.b	(%a0), %d0			# pre-load byte's value into d0
L%ao0:
	mov.l	%a1, %d1
	or.b	%d0, %d1			# d1 = d0 | a1
	cas.b	%d0, %d1, (%a0)
	bne.b	L%ao0
	clr.l	spm_caddrflt
	rts					# success


# ulong
# cas_long(address, old_val, new_val)
#
#	/* Start atomic sequence */
#	if (*address != old_val)
#		return(0);
#
#	*address = new_val
#	/* End atomic sequence */
#	return(1);
# JPC: seems to be unused...
#cas_long:
#	mov.l	4(%sp), %a0
#	mov.l	8(%sp), %d0
#	mov.l	12(%sp), %d1
#	cas.l	%d0, %d1, (%a0)
#	bne.b	L%cas_long_fail
#	mov.l	&1, %d0
#	bra.b	L%cas_long_out
#L%cas_long_fail:
#	clr.l	%d0
#L%cas_long_out:
#	rts

#------------------------------------------------------------------
# set_pc_sp
#	change pc and sp to new values
#	No return possible
#------------------------------------------------------------------

set_pc_sp:
	mov.l	(%sp)+,%a0	# toss return PC (pushed by jsr), don't care
	mov.l	(%sp)+,%a0	# new pc will be needed
	mov.l	(%sp),%sp	# set new sp value
	jmp	(%a0)		# jmp to new pc
