/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) trace.c: version 25.1 created on 11/27/91 at 15:38:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)trace.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#include "sys/types.h"
#include "spm_debug.h"
#include "sys/user.h"
#include "sys/kmem.h"
#include "sys/immu.h"
#include "sys/own.h"
#include "sys/spm_mem.h"
#include "sys/param.h"
#include "sys/region.h"
#include "sys/sysmacros.h"
#include "sys/proc.h"
#include "sys/tty.h"
#include "sys/sbus_pm.h"
#include "sys/signal.h"
#include "sys/stat.h"
#include "sys/user.h"
#include "sys/var.h"
#include "sys/sbus.h"
#include "sys/lio.h"
#include "sys/tdb.h"
#include "misc.h"
#include "global.h"
#include "spm.h"
#include "menu.h"
#include "rtc.h"
#include "iomap.h"
#include "spm_tdb.h"
#include "cpu_method.h"

extern struct sbus_config;
extern unchar	*km_map();
extern char	*symstr();
extern uint	tdb_at_brk;
extern uint	next_symbol;


/*
 * u_page_trace -- print a stack trace for a given PM, or a given page
 *	address in kernel memory
 */

u_page_trace()
{
	register uint	addr;
	uint		saved_map = iomap_save();

	addr = Atox(comm_args[1]);

	switch (poff(addr)) {
	case 0:
		addr += U_OFFSET;
		/* fall through */
	case U_OFFSET:
		u_stack_trace((user_t *)km_map(addr));
		break;
	default:
		printf("utrace: bad u page address = 0x%x\n", addr);
		printf(" The address must be on a page boundary or %d (0x%x)\n",
		  U_OFFSET, U_OFFSET);
	}
	iomap_restore(saved_map);
}

/*
 * u_stack_trace -- given a user pointer, do a stack trace
 */

#define OP_ADDA_A7	0xdefc		/* 68020 opcode for adda.w #xx, a7 */
#define OP_ADDQ_A7	0x504f		/* 68020 opcode for addq.l #xx, a7 */
#define ADDQ_MASK	0x0e00		/* mask to remove data from addq */
#define ADDQ_SHIFT	9		/* shift to extract data from addq */

/*
 * new u-page layout:  u struct above system stack
 *	up ==> spm_mapped user_t pointer
 *	ka ==> kernel u-page address
 *	ua ==> address of u
 *
 *	U_CONV converts the kernel address to a spm address
 */
#define U_CONV(ka, up, ua)	(uint *)((uint)(up) - (ua - (uint)(ka)))

u_stack_trace(up)
register user_t	*up;
{
	register uint	*fp, *addr;
	register ushort	*usp;
	register uint	retpc, uaddr, op;
	register int	n, args, lines;
	uint		saved_map = iomap_save();

	display_u(up);

	fp = (uint *)&up->u_rsav[11];	/* see resume() in kernel for details */
	retpc = up->u_rsav[6];
	uaddr = CPU_get_u_addr();
	op = *fp;
	fp = U_CONV(op, up, uaddr);
	lines = 14;

	for (; CPU_valid_fp(op); op = *fp, fp = U_CONV(op, up, uaddr)) {
		printf("%-32s(", symstr(retpc));
		/*
		 * Guess at the number arguments by looking at the opcode
		 * pointed at by the return pc and checking how much is added
		 * to the stack.  Divide by 4 to get the number of arguments.
		 */
		retpc = fp[1];
		usp = (ushort *)km_map(retpc);
		op = *usp;
		if ((op & ~ADDQ_MASK) == OP_ADDQ_A7) {
			switch (op = (op & ADDQ_MASK) >> ADDQ_SHIFT) {
			case 0:		/* addq 8 */
				args = 2;
				break;
			case 4:		/* addq 4 */
				args = 1;
				break;
			default:
				printf("[addq %d]", op);
				args = 0;
			}
		}
		else if (op == OP_ADDA_A7)
			args = ((short *)usp)[1] / 4;
		else 
			args = 0;		/* 0 args? */

		iomap_restore(saved_map);	/* put back u pg map */

		if (args > 7) {
			printf("{%d} ", args);
			args = 7;
		}
		for (addr = &fp[2]; --args >= 0; )
			printf("%s%s",
			  symstr(*addr++), ((args > 0) ? ", " : ""));
		printf(")\n");

		if (--lines < 0) {
			if (inkey() < 0)
				break;
			lines = 20;
		}
	}
	printf("%s\n", symstr(retpc));
}
