/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tdbsys.c: version 25.1 created on 11/27/91 at 15:37:57	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tdbsys.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*
 *
 * spm/s90sys/tdbsys.c - system dependant portions of the tiny debugger
 *
 */

#include "sys/types.h"
#include "spm_debug.h"
#include "sys/own.h"
#include "misc.h"
#include "spm.h"
#include "rtc.h"
#include "cpu_method.h"

extern char	atext[];
extern inst_t	mem[];

#define OP_ADDA_A7	0xdefc		/* 68020 opcode for adda.w #xx, a7 */
#define OP_ADDQ_A7	0x504f		/* 68020 opcode for addq.l #xx, a7 */
#define ADDQ_MASK	0x0e00		/* mask to remove data from addq */
#define ADDQ_SHIFT	9		/* shift to extract data from addq */

/*	Backtrace command
 */

m68k_backtrace(fp)
register uint	*fp;
{
	register uint	op, pc;
	register int	n, args;
	register uint	*addr;

	line_limit_set(20);

	pc = CPU_get_named_reg("pc");

	while (line_limit_use(1)) {
		printf("%-24s", CPU_symbolic_version(pc));

		/*
		 * Guess at the number arguments by looking at the opcode
		 * pointed at by the return pc and checking how much is added
		 * to the stack.  Divide by 4 to get the number of arguments.
		 */
		if (!CPU_valid_fp(fp)) {
			printf("\n");
			break;
		}
		pc = CPU_get_long(fp+1);	/* return pc */
		op = CPU_get_short(pc);
		if ((op & ~ADDQ_MASK) == OP_ADDQ_A7) {
			switch (op = (op & ADDQ_MASK) >> ADDQ_SHIFT) {
			case 0:		/* addq 8 */
				args = 2;
				break;
			case 4:		/* addq 4 */
				args = 1;
				break;
			default:
				printf("[addq %d]", op);
				args = 0;
			}
		}
		else if (op == OP_ADDA_A7)
			args = CPU_get_short(pc + sizeof(ushort)) / 4;
		else
			args = 0;

		printf("(");
		if (args > 7) {
			printf("{%d} ", args);
			args = 7;
		}
		for (addr = fp + 2; --args >= 0; )
			printf("%s%s",
			  CPU_symbolic_version(CPU_get_long(addr++)),
			  ((args > 0) ? ", " : ""));
		printf(")\n");

		fp = (uint *) CPU_get_long(fp);
	}
}

/*
 * m68k_valid_reg_name -- returns the TDB_REG code for the register
 */

uint
m68k_valid_reg_name(regname)
register char	*regname;
{
	register uint	c, reg = 0;

	switch (*regname) {
	case 'a':		/* a0 - a7 */
		if ((c = regname[1]) >= '0' && c <= '7')
			reg = 0xa0 + c - '0';
		break;
	case 'd':		/* d0 - d7 */
		if ((c = regname[1]) >= '0' && c <= '7')
			reg = 0xd0 + c - '0';
		break;
	case 'p':		/* pc */
		if (regname[1] == 'c')
			reg = TDB_REG_PC;
		break;
	case 's':		/* sr or sp */
		if (regname[1] == 'r')
			reg = TDB_REG_SR;
		else if (regname[1] == 'p')
			reg = TDB_REG_A7;
		break;
	case 'f':		/* fp */
		if (regname[1] == 'p')
			reg = TDB_REG_A6;
		break;
	}

	switch ( reg ) {

	case TDB_REG_A0:
	case TDB_REG_A1:
	case TDB_REG_A2:
	case TDB_REG_A3:
	case TDB_REG_A4:
	case TDB_REG_A5:
	case TDB_REG_A6:
	case TDB_REG_A7:
	case TDB_REG_D0:
	case TDB_REG_D1:
	case TDB_REG_D2:
	case TDB_REG_D3:
	case TDB_REG_D4:
	case TDB_REG_D5:
	case TDB_REG_D6:
	case TDB_REG_D7:
	case TDB_REG_PC:
	case TDB_REG_SR:
		break;
	default:
		m68k_pr_valid_reg_names();
		rtn_to_monitor();
	}
	return(reg);
}

m68k_pr_valid_reg_names()
{
	printf("valid register names are:\n");
	printf("d0 d1 d2 d3 d4 d5 d6 d7 a0 a1 a2 a3 a4 a5 a6 a7 pc sr\n");
}

uint
m68k_display_dis(addr)
uint	addr;
{
	uint			nwords;
	unchar			*name;

	extern char	atext[];
	extern ushort	mem[];

	name = CPU_symbolic_version(addr);
	if (name)
		printf("%-20s: ", name);
	else
		printf("%08lx: ", addr);

	nwords = m68k_dis(addr);
#ifdef SHOW_OPCODE_WORDS
	{
	register uint		i;
	register ushort		*mp;
	char			acode[80];

	acode[0] = '\0';
	for (i = 0, mp = mem; i < nwords; i++) {
		sprintf(acode, "%s%04x ", acode, *mp);
		mp++;
	} 
	printf("%-32s%s\n", acode, atext);
	}
#else
	printf("%s\n", atext);
#endif /* SHOW_OPCODE_WORDS */
	return(nwords);
}

/*
 * m68k_at_jsr -- return true if processor about to execute
 *	BSR, CALLM, JSR, TRAP, TRAPcc, TRAPV
 */

uint
m68k_at_jsr()
{
	register uint		kernel_pc;
	register ushort		opcode;
	register ushort		extension;
	register BRK_TAB	*brkp;

	kernel_pc = CPU_get_named_reg("pc");
	if (brkp = CPU_find_bp(kernel_pc))
		opcode = brkp->text;
	else
		opcode = CPU_get_short(kernel_pc);

	if ((opcode & 0xff00) == 0x6100)
		return(1);
	if ((opcode & 0xffc0) == 0x4e80)
		return(1);
	if ((opcode & 0xffc0) == 0x06c0) {
		extension = CPU_get_short(kernel_pc + sizeof(ushort));
		if ((extension & 0xff00) == 0)
			return(1);
	}
	if ((opcode & 0xfff0) == 0x4e40)
		return(1);
	if ((opcode & 0xf0f8) == 0x50f8)
		return(1);
	if (opcode == 0x4e76)
		return(1);
	return(0);
}
