/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) load.c: version 25.1 created on 11/27/91 at 15:37:52	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)load.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* M68020/load.c */

#include "sys/types.h"
#include "spm_debug.h"
#include "scnhdr.h"
#include "filehdr.h"
#include "aouthdr.h"
#include "symbol.h"
#include "cpu_method.h"
#include "polyio.h"
#include "coff_hdr.h"

#define	min(A, B)	((A) < (B) ? (A) : (B))

extern uint	dbug;

/* Global arguments kept here. */
/***********************************************************************/

/* Print download information. */
print_hdr_info(hd)
register struct coff_hdr_data	*hd;	/* COFF information */
{
	printf("Text: 0x%08x at 0x%08x\n", hd->tsize, hd->text_start);
	printf("Data: 0x%08x at 0x%08x\n", hd->dsize, hd->data_start);
	printf("Bss:  0x%08x at 0x%08x\n", hd->bsize, hd->bss_start);
	printf("Entry at 0x%08x\n", hd->entry);
	printf("Text offset is 0x%08x\n", hd->fp_text);
	printf("Data offset is 0x%08x\n", hd->fp_data);
	printf("Has %d symbols\n", hd->nsyms);
}

#define	BLK_SIZE	1024
/* FIX joe, make it passed. */
extern char	xferbuff[];

uint
xfer_bytes(where, ap, dest, count)
uint			where;	/* To cpu or local buffer */
register args_buf_t	*ap;	/* Pointer to arguments 'structure'. */
unchar			*dest;	/* Destination */
uint			count;	/* Total xfer size */
{
	uint	xfer_size = 0;

#ifdef TOO_MUCH_DEBUG
	if (dbug)
		printf("xfer_bytes(%d, %#x, %#x, %u)\n", where, ap, dest,count);
#endif
	while (count) {
		ASSERT(count >= 0);
		if (!ap->valid_bytes) {
			ap->valid_start = (unchar *)xferbuff;
			ap->valid_bytes = poly_read(ap, xferbuff, BLK_SIZE);
			if (ap->valid_bytes == -1) {
				printf("Failed to read block 0x%x of %s\n",
					ap->current_block, ap->source_dev);
				return(0);
			}
			if (ap->valid_bytes == 0) {
				printf("Reached EOF of %s prematurely!\n",
					ap->source_dev);
				return(0);
			}
			ap->current_block++;
		}

		xfer_size = min(count, ap->valid_bytes);

		if (where == TO_CPU)
			CPU_copyout(ap->valid_start, dest, xfer_size);
		else
			bcopy(ap->valid_start, dest, xfer_size);	

		count -= xfer_size;
		dest += xfer_size;

		ap->valid_bytes -= xfer_size;
		ap->valid_start += xfer_size;
	}
	return(1);
}

static uint
get_filehdr_data(ap, h_data)
args_buf_t	*ap;
coff_hdr_data_t	*h_data;	/* COFF information */
{
	struct filehdr	filehdr;

	/* Read file header (filehdr)... */
	if (!xfer_bytes(TO_BUF, ap, (unchar *)&filehdr, sizeof(FILHDR)))
		return(0);

	switch (filehdr.f_magic) {
	case A68020MAGIC:	/* 522: local 68020 Magic number */
	case M68040MAGIC_OS:	/* 523: local 68040 OS Magic number */
		if (!CPU_check_magic(filehdr.f_magic))
			return(0);

#if 0 /* declan : these are obsolete, it seems */
	case M68AWRMAGIC:	/* 570: arete normal file */
	case M68AROMAGIC:	/* 575: arete pure file */
#endif
		break;				/* ok */
	default:
		printf("Unknown filehdr magic number: 0%o\n", filehdr.f_magic);
		return (0);
	}

	if (filehdr.f_opthdr < sizeof(struct aouthdr)) {
		printf("File doesn't have an aouthdr!\n");
		return (0);
	}

	h_data->nsyms = (uint)filehdr.f_nsyms;
	h_data->nscns = (uint)filehdr.f_nscns;

	return(1);
}

static	ushort	saved_vstamp;

static uint
get_aouthdr_data(ap, h_data)
args_buf_t	*ap;
coff_hdr_data_t	*h_data;	/* COFF information */
{
	struct aouthdr	aouthdr;
	
	/* ...read in aouthdr. */
	if (!xfer_bytes(TO_BUF, ap, (unchar *)&aouthdr, sizeof(struct aouthdr)))
		return(0);

	switch (aouthdr.magic) {
	case 0410:	/* read-only text -- kernel	*/
/**	case 0407:	/* unshared text  -- standalone	*/
		break;				/* OK */
	default:
		printf("Unknown magic number: 0%o\n", aouthdr.magic);
		return(0);
	}

	saved_vstamp = aouthdr.vstamp; /* save for printing later */

		/* Get 'aouthdr' header data. */
	h_data->tsize = aouthdr.tsize;
	h_data->dsize = aouthdr.dsize;
	h_data->bsize = aouthdr.bsize;

	h_data->text_start = (unchar *)aouthdr.text_start;
	h_data->data_start = (unchar *)aouthdr.data_start;
	h_data->entry = aouthdr.entry;

	if (!CPU_check_coffdata(h_data->text_start) ||
	    !CPU_check_coffdata(h_data->text_start + h_data->tsize) ||
	    !CPU_check_coffdata(h_data->data_start) ||
	    !CPU_check_coffdata(h_data->data_start + h_data->dsize +
	      h_data->bsize)) {
		printf("Bad address!");
		return(0);
	}

	return(1);
}

static uint
get_sections_data(ap, h_data)
args_buf_t	*ap;		/* arguments buffer */
coff_hdr_data_t	*h_data;	/* COFF information */
{
	struct scnhdr 	s_hdr;
	uint		scns;

	/*
	 * read the section headers; there had better be at
	 * least three: .text, .data and .bss.
	 */
#ifdef TOO_MUCH_DEBUG
	if (dbug)
		printf("get_sections_data: %d sections\n", h_data->nscns);
#endif
	h_data->sec_size = 0;
	scns = 0;
	while (--h_data->nscns >= 0) {
		if (!xfer_bytes(TO_BUF, ap, (unchar *)&s_hdr, sizeof(s_hdr))) {
			printf("Can't read file's scnhdr!\n");
			return (0);
		}
#ifdef TOO_MUCH_DEBUG
		if (dbug)
			printf("scns=%#x: s_flags=%#x s_vaddr=%#x s_size=%#x\n",
			  scns, s_hdr.s_flags, s_hdr.s_vaddr, s_hdr.s_size);
#endif

		switch ((int) s_hdr.s_flags) {
		case STYP_TEXT:
			scns |= STYP_TEXT;
			h_data->fp_text = s_hdr.s_scnptr;
			if (h_data->text_start != (uchar *)s_hdr.s_vaddr) {
				printf("Bad text start! %x vs %x\n",
				  h_data->text_start, s_hdr.s_vaddr);
				return (0);
			}
			if (h_data->tsize != s_hdr.s_size) {
				printf("Bad text size! %x vs %x\n",
				  h_data->tsize, s_hdr.s_size);
				return (0);
			}
			break;

		case STYP_DATA:
			scns |= STYP_DATA;
			h_data->fp_data = s_hdr.s_scnptr;
			if (h_data->data_start != (uchar *)s_hdr.s_vaddr) {
				printf("Bad data start! %#x vs %#x\n",
				  h_data->data_start, s_hdr.s_vaddr);
				return (0);
			}
			if (h_data->dsize != s_hdr.s_size) {
				printf("Bad data size! %x vs %x\n",
				  h_data->dsize, s_hdr.s_size);
				return (0);
			}
			break;

		case STYP_BSS:
			scns |= STYP_BSS;
			h_data->bss_start = (uchar *)s_hdr.s_vaddr;
			break;

		case STYP_INFO:
		default:
			h_data->sec_size += s_hdr.s_size;
			break;		/* ignore comment/other sections */
		}
	}

	if (scns != (STYP_TEXT|STYP_DATA|STYP_BSS)) {
		printf("The file is missing a section:  scns = %#x\n", scns);
		return (0);
	}

	return(1);
}

uint
read_xtra_sects(ap, hd)
args_buf_t	*ap;	/* arguments buffer */
coff_hdr_data_t	*hd;	/* COFF information */
{
	register uint	n, count;

	for (n = hd->sec_size; n; n -= count) {
		count = min(BLK_SIZE, n);
		if (!xfer_bytes(TO_BUF, ap, (unchar *)xferbuff, count))
			return(0);
	}

	return(1);
}

/* get_hdr_data() - extracts COFF header data needed to download a COFF
 * file.  This routine sees a COFF file as follows:
 *
 * byte 0                                                               n n+1...
 *      +---------+--------------+--------------+-------------+------------+
 *	| filehdr | a.out header | text  header | data header | bss header |
 *      +---------+--------------+--------------+-------------+------------+...
 *
 * Success on exit => hdr_data has all necessary COFF info.
 */
static uint
get_hdr_data(ap, hd)
args_buf_t	*ap;	/* Pointer to arguments 'structure'. */
coff_hdr_data_t	*hd;	/* COFF information */
{
	extern uint	dbug;
	uint		text_end, bss_end;

	printf("\nLoading from %s\n", ap->source_dev);

	if(!get_filehdr_data(ap, hd))
		printf("Cannot read file header (filehdr).\n");
	else if (!get_aouthdr_data(ap, hd))
		printf("Cannot read a.out (aouthdr) header.\n");
	else if (!get_sections_data(ap, hd))
		printf("Cannot read section headers.\n");
	else {
		text_end = (uint)hd->text_start + hd->tsize;
		bss_end  = (uint)hd->bss_start + hd->bsize;

		if (!CPU_prep_syms(bss_end, text_end))
			hd->nsyms = 0;			/* don't got none */

		if (dbug)
			print_hdr_info(hd);

		return(1);
	}
	return(0);
}

/* load_m68k_bin() - Open source device, download text, data and symbols to
 *	desired memory region, close source device.
 *	Returns entry point, or ~0 on error.
 */
static uint
load_m68k_bin(source_dev, where)
char	*source_dev;
uint	where;
{
	args_buf_t 	args, *ap = &args;	/* Arguments buffer */
	coff_hdr_data_t	hdr, *hd = &hdr;	/* Needed COFF data */
	uint		ok = 0;

	ap->source_dev = source_dev;

	if (poly_open(ap, 0) < 0) {				 /* OPEN FILE */
		printf("open on %s failed\n", ap->source_dev);
		return (~0);
	}

	if (!get_hdr_data(ap, hd))			    /* Get COFF info. */
		;
	else if (!xfer_bytes(where, ap, hd->text_start, hd->tsize))  /* TEXT */
		printf("text download failed!\n");
	else if (!xfer_bytes(where, ap, hd->data_start, hd->dsize))  /* DATA */
		printf("data download failed!\n");
	else if (!read_xtra_sects(ap, hd))   		    /* EXTRA SECTIONS */
		printf("read past extra sections failed!\n");
	else if (!CPU_load_syms(ap, hd))	   		   /* SYMBOLS */
		printf("symbols download failed!\n");
	else if (CPU_zero(hd->bss_start, hd->bsize))
		printf("bzero of bss section failed!\n");
	else
		ok = 1;

	if (poly_close(ap) < 0)
		printf("close failed\n");			/* CLOSE FILE */

	return (ok ? hd->entry : ~0);
}


/* load_m68k() - Open source device, download text, data and symbols to 
 * desired local memory, close source device.
 */
uint
load_m68k(source_dev)
char	*source_dev;
{
	return (load_m68k_bin(source_dev, TO_CPU));
}


/* load_m68k_sa() - Open source device, download text, data and symbols to 
 * desired local memory, close source device.
 */
uint
load_m68k_sa(source_dev, vstamp)
char	*source_dev;
ushort	*vstamp;
{
	uint	entry;

	if (pm_booted() || check_io())
		return (0);

	entry = load_m68k_bin(source_dev, TO_BUF);

	if (!entry)
		return(0);
	*vstamp = saved_vstamp;
	return(entry);
}
