/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) dis.c: version 25.1 created on 11/27/91 at 15:37:47	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)dis.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 *	Disassemble one 680X0 instruction
 *	June 5, 1987
 *
 *	Copyright (C) 1987 by Boris Krtolica
 *	All Rights Reserved
 */

#include "cpu_method.h"

typedef unsigned short  word;
typedef unsigned long   lword;
typedef unsigned char   byte;

#define B	1
#define W	2
#define L	3
#define X	6

static char *bit[]   = {"tst", "chg", "clr", "set"};
static char *cond[]  = {"t",  "f",  "hi", "ls", "cc", "cs", "ne", "eq",
			"vc", "vs", "pl", "mi", "ge", "lt", "gt", "le"};
static char *shift[] = {"asr",  "asl",  "lsr",  "lsl",
			"roxr", "roxl", "ror",  "rol"};
static char *size[] = {"", ".b", ".w", ".l"};

static char QQQQQ[] = "?????";

static char *sp;
char atext[256];
word mem[8];
word *currpc;

extern char *strcat();
extern char *strcpy();

/*
 *	Disassemble instruction at mem.
 *	Put disassembly text in atext.
 *	Return number of processed words.
 */

m68k_dis(laddr)
word *laddr;
{
	int fop00(), fop01();
	int gop00(), gop01(), gop02(), gop03(), gop04(), gop05();
	int gop06(), gop07(), gop08(), gop09(), gop10(), gop11();
	int gop12(), gop13(), gop14();
	int sop00(), sop01(), sop02(), sop03(), sop04(), sop05();
	int sop06(), sop07(), sop08(), sop09(), sop10(), sop11();
	int sop12(), sop13(), sop14(), sop15(), sop16(), sop17();
	int sop18(), sop19(), sop20(), sop21(), sop22(), sop23();
	int sop24(), sop25(), sop26(), sop27(), sop28(), sop29();
	int sop30(), sop31(), sop32(), sop33(), sop34(), sop35();
	int sop36(), sop37(), sop38(), sop39(), sop40(), sop41();
	int sop42(), sop43(), sop44(), sop45(), sop46(), sop47();

	typedef struct _code {
	    word	mask;
	    word	val;
	    int		(*fun)();
	    word	size;
	    char	*name;
	} code;

	static char NONE	[] = "x";
	static char ABCD	[] = "abcd";
	static char ADDA	[] = "adda";
	static char ADDI	[] = "addi";
	static char ADDQ	[] = "addq";
	static char ADDX	[] = "addx";
	static char ADD		[] = "add";
	static char ANDI	[] = "andi";
	static char AND		[] = "and";
	static char BKPT	[] = "bkpt";
	static char BRA		[] = "bra";
	static char BSR		[] = "bsr";
	static char Bx		[] = "bx";
	static char CALLM	[] = "callm";
	static char CAS2	[] = "cas2";
	static char CAS		[] = "cas";
	static char CHK		[] = "chk";
	static char CLR		[] = "clr";
	static char CMPA	[] = "cmpa";
	static char CMPI	[] = "cmpi";
	static char CMPM	[] = "cmpm";
	static char CMP		[] = "cmp";
	static char DBx		[] = "dbx";
	static char DIVS	[] = "divs";
	static char DIVU	[] = "divu";
	static char EORI	[] = "eori";
	static char EOR		[] = "eor";
	static char EXG		[] = "exg";
	static char EXTB	[] = "extb";
	static char EXT		[] = "ext";
	static char FMOVEM	[] = "fmovem";
	static char FNOP	[] = "fnop";
	static char FRESTORE	[] = "frestore";
	static char FSAVE	[] = "fsave";
	static char ILLEGAL	[] = "illegal";
	static char JMP		[] = "jmp";
	static char JSR		[] = "jsr";
	static char LEA		[] = "lea";
	static char LINK	[] = "link";
	static char MOVEA	[] = "movea";
	static char MOVEC	[] = "movec";
	static char MOVEM	[] = "movem";
	static char MOVEP	[] = "movep";
	static char MOVEQ	[] = "moveq";
	static char MOVES	[] = "moves";
	static char MOVE	[] = "move";
	static char MULS	[] = "muls";
	static char MULU	[] = "mulu";
	static char NBCD	[] = "nbcd";
	static char NEGX	[] = "negx";
	static char NEG		[] = "neg";
	static char NOP		[] = "nop";
	static char NOT		[] = "not";
	static char ORI		[] = "ori";
	static char OR		[] = "or";
	static char PACK	[] = "pack";
	static char PEA		[] = "pea";
	static char RESET	[] = "reset";
	static char RTD		[] = "rtd";
	static char RTE		[] = "rte";
	static char RTM		[] = "rtm";
	static char RTR		[] = "rtr";
	static char RTS		[] = "rts";
	static char SBCD	[] = "sbcd";
	static char STOP	[] = "stop";
	static char SUBA	[] = "suba";
	static char SUBI	[] = "subi";
	static char SUBQ	[] = "subq";
	static char SUBX	[] = "subx";
	static char SUB		[] = "sub";
	static char SWAP	[] = "swap";
	static char Sx		[] = "sx";
	static char TAS		[] = "tas";
	static char TRAPV	[] = "trapv";
	static char TRAPx	[] = "trapx";
	static char TRAP	[] = "trap";
	static char TST		[] = "tst";
	static char UNLK	[] = "unlk";
	static char UNPK	[] = "unpk";

	static code tab0[] = {
	    {0xf1f8, 0x0108, sop17, W, MOVEP},	/* op (d16,Ay),Dx	*/
	    {0xf1f8, 0x0148, sop17, L, MOVEP},	/* op (d16,Ay),Dx	*/
	    {0xf1f8, 0x0188, sop18, W, MOVEP},	/* op Dx,(d16,Ay)	*/
	    {0xf1f8, 0x01c8, sop18, L, MOVEP},	/* op Dx,(d16,Ay)	*/
	    {0xf100, 0x0100, gop00, 0, Bx},	/* op Dn,<ea>		*/
	    {0xf100, 0x0100, sop00, 0, QQQQQ},	/* op			*/

	    {0xffff, 0x003c, sop10, 0, ORI},	/* op #<data>,CCR	*/
	    {0xffff, 0x007c, sop09, 0, ORI},	/* op #<data>,SR	*/
	    {0xffff, 0x023c, sop10, 0, ANDI},	/* op #<data>,CCR	*/
	    {0xffff, 0x027c, sop09, 0, ANDI},	/* op #<data>,SR	*/
	    {0xffff, 0x0a3c, sop10, 0, EORI},	/* op #<data>,CCR	*/
	    {0xffff, 0x0a7c, sop09, 0, EORI},	/* op #<data>,SR	*/
	    {0xffff, 0x0afc, sop19, B, CAS2},	/* op Dc1:Dc2,Du1:Du2,..*/
	    {0xffff, 0x0cfc, sop19, W, CAS2},	/* op Dc1:Dc2,Du1:Du2,..*/
	    {0xffff, 0x0efc, sop19, L, CAS2},	/* op Dc1:Dc2,Du1:Du2,..*/

	    {0xffc0, 0x0000, sop08, B, ORI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0040, sop08, W, ORI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0080, sop08, L, ORI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x00c0, gop11, B, NONE},	/* op <ea>,Rn		*/
	    {0xffc0, 0x0200, sop08, B, ANDI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0240, sop08, W, ANDI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0280, sop08, L, ANDI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x02c0, gop11, W, NONE},	/* op <ea>,Rn		*/
	    {0xffc0, 0x0400, sop08, B, SUBI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0440, sop08, W, SUBI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0480, sop08, L, SUBI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x04c0, gop11, L, NONE},	/* op <ea>,Rn		*/
	    {0xffc0, 0x0600, sop08, B, ADDI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0640, sop08, W, ADDI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0680, sop08, L, ADDI},	/* op #<data>,<ea>	*/
	    {0xfff8, 0x06c0, sop01, 0, RTM},	/* op Dn		*/
	    {0xfff8, 0x06c8, sop02, 0, RTM},	/* op An		*/
	    {0xffc0, 0x06c0, sop20, 0, CALLM},	/* op #<data>,<ea>	*/
	    {0xff00, 0x0800, gop01, 0, Bx},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0a00, sop08, B, EORI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0a40, sop08, W, EORI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0a80, sop08, L, EORI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0ac0, sop21, B, CAS},	/* op Dc,Du,<ea>	*/
	    {0xffc0, 0x0c00, sop08, B, CMPI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0c40, sop08, W, CMPI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0c80, sop08, L, CMPI},	/* op #<data>,<ea>	*/
	    {0xffc0, 0x0cc0, sop21, W, CAS},	/* op Dc,Du,<ea>	*/
	    {0xffc0, 0x0e00, gop14, B, MOVES},	/* MOVES		*/
	    {0xffc0, 0x0e40, gop14, W, MOVES},	/* MOVES		*/
	    {0xffc0, 0x0e80, gop14, L, MOVES},	/* MOVES		*/
	    {0xffc0, 0x0ec0, sop21, L, CAS},	/* op Dc,Du,<ea>	*/
	    {0xf000, 0x0000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab1[] = {
	    {0xf000, 0x1000, sop07, B, MOVE},	/* op <ea>,<ea>		*/
	};

	static code tab2[] = {
	    {0xf1c0, 0x2040, sop07, L, MOVEA},	/* op <ea>,<ea>		*/
	    {0xf000, 0x2000, sop07, L, MOVE},	/* op <ea>,<ea>		*/
	};

	static code tab3[] = {
	    {0xf1c0, 0x3040, sop07, W, MOVEA},	/* op <ea>,<ea>		*/
	    {0xf000, 0x3000, sop07, W, MOVE},	/* op <ea>,<ea>		*/
	};

	static code tab4[] = {
	    {0xfff8, 0x49c0, sop01, 0, EXTB},	/* op Dn		*/
	    {0xf1c0, 0x4100, sop04, L, CHK},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x4180, sop04, W, CHK},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x41c0, sop06, 0, LEA},	/* op <ea>,An		*/
	    {0xf100, 0x4100, sop00, 0, QQQQQ},	/* op			*/

	    {0xffc0, 0x4000, sop03, B, NEGX},	/* op <ea>		*/
	    {0xffc0, 0x4040, sop03, W, NEGX},	/* op <ea>		*/
	    {0xffc0, 0x4080, sop03, L, NEGX},	/* op <ea>		*/
	    {0xffc0, 0x40c0, sop24, 0, MOVE},	/* op SR,<ea>		*/
	    {0xffc0, 0x4200, sop03, B, CLR},	/* op <ea>		*/
	    {0xffc0, 0x4240, sop03, W, CLR},	/* op <ea>		*/
	    {0xffc0, 0x4280, sop03, L, CLR},	/* op <ea>		*/
	    {0xffc0, 0x42c0, sop25, 0, MOVE},	/* op CCR,<ea>		*/
	    {0xffc0, 0x4400, sop03, B, NEG},	/* op <ea>		*/
	    {0xffc0, 0x4440, sop03, W, NEG},	/* op <ea>		*/
	    {0xffc0, 0x4480, sop03, L, NEG},	/* op <ea>		*/
	    {0xffc0, 0x44c0, sop27, 0, MOVE},	/* op <ea>,CCR		*/
	    {0xffc0, 0x4600, sop03, B, NOT},	/* op <ea>		*/
	    {0xffc0, 0x4640, sop03, W, NOT},	/* op <ea>		*/
	    {0xffc0, 0x4680, sop03, L, NOT},	/* op <ea>		*/
	    {0xffc0, 0x46c0, sop26, 0, MOVE},	/* op <ea>,SR		*/
	    {0xfff8, 0x4808, sop28, L, LINK},	/* op An,#<data>	*/
	    {0xffc0, 0x4800, sop03, 0, NBCD},	/* op <ea>		*/
	    {0xfff8, 0x4840, sop01, 0, SWAP},	/* op Dn		*/
	    {0xfff8, 0x4848, sop29, 0, BKPT},	/* op #<data>		*/
	    {0xffc0, 0x4840, sop03, 0, PEA},	/* op <ea>		*/
	    {0xfff8, 0x4880, sop01, W, EXT},	/* op Dn		*/
	    {0xffc0, 0x4880, sop33, W, MOVEM},	/* op list,<ea>		*/
	    {0xfff8, 0x48c0, sop01, L, EXT},	/* op Dn		*/
	    {0xffc0, 0x48c0, sop33, L, MOVEM},	/* op list,<ea>		*/
	    {0xffc0, 0x4a00, sop03, B, TST},	/* op <ea>		*/
	    {0xffc0, 0x4a40, sop03, W, TST},	/* op <ea>		*/
	    {0xffc0, 0x4a80, sop03, L, TST},	/* op <ea>		*/
	    {0xffff, 0x4afc, sop00, 0, ILLEGAL},/* op			*/
	    {0xffc0, 0x4ac0, sop03, 0, TAS},	/* op			*/
	    {0xffc0, 0x4c00, gop12, L, NONE},	/* Long multiplication	*/
	    {0xffc0, 0x4c40, gop13, L, NONE},	/* Long division	*/
	    {0xffc0, 0x4c80, sop34, W, MOVEM},	/* op <ea>,list		*/
	    {0xffc0, 0x4cc0, sop34, L, MOVEM},	/* op <ea>,list		*/
	    {0xfff0, 0x4e40, sop30, 0, TRAP},	/* op #<data>		*/
	    {0xfff8, 0x4e50, sop28, W, LINK},	/* op An,#<data>	*/
	    {0xfff8, 0x4e58, sop02, 0, UNLK},	/* op An		*/
	    {0xfff8, 0x4e60, sop35, 0, MOVE},	/* op An,USP		*/
	    {0xfff8, 0x4e68, sop36, 0, MOVE},	/* op USP,An		*/
	    {0xffff, 0x4e70, sop00, 0, RESET},	/* op			*/
	    {0xffff, 0x4e71, sop00, 0, NOP},	/* op			*/
	    {0xffff, 0x4e72, sop31, 0, STOP},	/* op #data		*/
	    {0xffff, 0x4e73, sop00, 0, RTE},	/* op			*/
	    {0xffff, 0x4e74, sop00, 0, RTD},	/* op			*/
	    {0xffff, 0x4e75, sop00, 0, RTS},	/* op			*/
	    {0xffff, 0x4e76, sop00, 0, TRAPV},	/* op			*/
	    {0xffff, 0x4e77, sop00, 0, RTR},	/* op			*/
	    {0xffff, 0x4e7a, sop37, 0, MOVEC},	/* op Rc,Rn		*/
	    {0xffff, 0x4e7b, sop38, 0, MOVEC},	/* op Rn,Rc		*/
	    {0xffc0, 0x4e80, sop03, 0, JSR},	/* op <ea>		*/
	    {0xffc0, 0x4ec0, sop03, 0, JMP},	/* op <ea>		*/
	    {0xf000, 0x4000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab5[] = {
	    {0xf1c0, 0x5000, sop11, B, ADDQ},	/* op #<data>,<ea>	*/
	    {0xf1c0, 0x5040, sop11, W, ADDQ},	/* op #<data>,<ea>	*/
	    {0xf1c0, 0x5080, sop11, L, ADDQ},	/* op #<data>,<ea>	*/
	    {0xf1c0, 0x5100, sop11, B, SUBQ},	/* op #<data>,<ea>	*/
	    {0xf1c0, 0x5140, sop11, W, SUBQ},	/* op #<data>,<ea>	*/
	    {0xf1c0, 0x5180, sop11, L, SUBQ},	/* op #<data>,<ea>	*/
	    {0xf0f8, 0x50c8, gop02, 0, DBx},	/* op Dn,label		*/
	    {0xf0ff, 0x50fa, gop03, W, TRAPx},	/* op #<data>		*/
	    {0xf0ff, 0x50fb, gop03, L, TRAPx},	/* op #<data>		*/
	    {0xf0ff, 0x50fc, gop04, 0, TRAPx},	/* op			*/
	    {0xf0c0, 0x50c0, gop05, 0, Sx},	/* op <ea>		*/
	    {0xf000, 0x5000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab6[] = {
	    {0xffff, 0x6000, sop16, W, BRA},	/* op label		*/
	    {0xffff, 0x60ff, sop16, L, BRA},	/* op label		*/
	    {0xff00, 0x6000, sop16, B, BRA},	/* op label		*/
	    {0xffff, 0x6100, sop16, W, BSR},	/* op label		*/
	    {0xffff, 0x61ff, sop16, L, BSR},	/* op label		*/
	    {0xff00, 0x6100, sop16, B, BSR},	/* op label		*/
	    {0xf0ff, 0x6000, gop06, W, Bx},	/* op label		*/
	    {0xf0ff, 0x60ff, gop06, L, Bx},	/* op label		*/
	    {0xf000, 0x6000, gop06, B, Bx},	/* op label		*/
	};

	static code tab7[] = {
	    {0xf100, 0x7000, sop39, 0, MOVEQ},	/* op #<data>,Dn	*/
	    {0xf000, 0x7000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab8[] = {
	    {0xf1c0, 0x8000, sop04, B, OR},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x8040, sop04, W, OR},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x8080, sop04, L, OR},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x80c0, sop04, W, DIVU},	/* op <ea>,Dn		*/
	    {0xf1f8, 0x8100, sop12, 0, SBCD},	/* op Dx,Dy		*/
	    {0xf1f8, 0x8108, sop13, 0, SBCD},	/* op -(Ax),-(Ay)	*/
	    {0xf1c0, 0x8100, sop05, B, OR},	/* op Dn,<ea>		*/
	    {0xf1f8, 0x8140, sop40, 0, PACK},	/* op Dx,Dy,#<data>	*/
	    {0xf1f8, 0x8148, sop41, 0, PACK},	/* op -(Ax),-(Ay),#<data>*/
	    {0xf1c0, 0x8140, sop05, W, OR},	/* op Dn,<ea>		*/
	    {0xf1f8, 0x8180, sop40, 0, UNPK},	/* op Dx,Dy,#<data>	*/
	    {0xf1f8, 0x8188, sop41, 0, UNPK},	/* op -(Ax),-(Ay),#<data>*/
	    {0xf1c0, 0x8180, sop05, L, OR},	/* op Dn,<ea>		*/
	    {0xf1c0, 0x81c0, sop04, W, DIVS},	/* op <ea>,Dn		*/
	    {0xf000, 0x8000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab9[] = {
	    {0xf1c0, 0x9000, sop04, B, SUB},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x9040, sop04, W, SUB},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x9080, sop04, L, SUB},	/* op <ea>,Dn		*/
	    {0xf1c0, 0x90c0, sop06, W, SUBA},	/* op <ea>,An		*/
	    {0xf1f8, 0x9100, sop12, B, SUBX},	/* op Dx,Dy		*/
	    {0xf1f8, 0x9108, sop13, B, SUBX},	/* op -(Ax),-(Ay)	*/
	    {0xf1c0, 0x9100, sop05, B, SUB},	/* op Dn,<ea>		*/
	    {0xf1f8, 0x9140, sop12, W, SUBX},	/* op Dx,Dy		*/
	    {0xf1f8, 0x9148, sop13, W, SUBX},	/* op -(Ax),-(Ay)	*/
	    {0xf1c0, 0x9140, sop05, W, SUB},	/* op Dn,<ea>		*/
	    {0xf1f8, 0x9180, sop12, L, SUBX},	/* op Dx,Dy		*/
	    {0xf1f8, 0x9188, sop13, L, SUBX},	/* op -(Ax),-(Ay)	*/
	    {0xf1c0, 0x9180, sop05, L, SUB},	/* op Dn,<ea>		*/
	    {0xf1c0, 0x91c0, sop06, L, SUBA},	/* op <ea>,An		*/
	    {0xf000, 0x9000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab10[] = {
	    {0xf000, 0xa000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab11[] = {
	    {0xf1c0, 0xb000, sop04, B, CMP},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xb040, sop04, W, CMP},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xb080, sop04, L, CMP},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xb0c0, sop06, W, CMPA},	/* op <ea>,An		*/
	    {0xf1f8, 0xb108, sop15, B, CMPM},	/* op (Ay)+,(Ax)+	*/
	    {0xf1c0, 0xb100, sop05, B, EOR},	/* op Dn,<ea>		*/
	    {0xf1f8, 0xb148, sop15, W, CMPM},	/* op (Ay)+,(Ax)+	*/
	    {0xf1c0, 0xb140, sop05, W, EOR},	/* op Dn,<ea>		*/
	    {0xf1f8, 0xb188, sop15, L, CMPM},	/* op (Ay)+,(Ax)+	*/
	    {0xf1c0, 0xb180, sop05, L, EOR},	/* op Dn,<ea>		*/
	    {0xf1c0, 0xb1c0, sop06, L, CMPA},	/* op <ea>,An		*/
	    {0xf000, 0xb000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab12[] = {
	    {0xf1c0, 0xc000, sop04, B, AND},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xc040, sop04, W, AND},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xc080, sop04, L, AND},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xc0c0, sop04, W, MULU},	/* op <ea>,Dn		*/
	    {0xf1f8, 0xc100, sop12, 0, ABCD},	/* op Dy,Dx		*/
	    {0xf1f8, 0xc108, sop13, 0, ABCD},	/* op -(Ay),-(Ax)	*/
	    {0xf1c0, 0xc100, sop05, B, AND},	/* op Dn,<ea>		*/
	    {0xf1f8, 0xc140, sop14, 0, EXG},	/* op Dx,Dy		*/
	    {0xf1f8, 0xc148, sop43, 0, EXG},	/* op Ax,Ay		*/
	    {0xf1c0, 0xc140, sop05, W, AND},	/* op Dn,<ea>		*/
	    {0xf1f8, 0xc188, sop44, 0, EXG},	/* op Dx,Ay		*/
	    {0xf1c0, 0xc180, sop05, L, AND},	/* op Dn,<ea>		*/
	    {0xf1c0, 0xc1c0, sop04, W, MULS},	/* op <ea>,Dn		*/
	    {0xf000, 0xc000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab13[] = {
	    {0xf1c0, 0xd000, sop04, B, ADD},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xd040, sop04, W, ADD},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xd080, sop04, L, ADD},	/* op <ea>,Dn		*/
	    {0xf1c0, 0xd0c0, sop06, W, ADDA},	/* op <ea>,An		*/
	    {0xf1f8, 0xd100, sop12, B, ADDX},	/* op Dx,Dy		*/
	    {0xf1f8, 0xd108, sop13, B, ADDX},	/* op -(Ax),-(Ay)	*/
	    {0xf1c0, 0xd100, sop05, B, ADD},	/* op Dn,<ea>		*/
	    {0xf1f8, 0xd140, sop12, W, ADDX},	/* op Dx,Dy		*/
	    {0xf1f8, 0xd148, sop13, W, ADDX},	/* op -(Ax),-(Ay)	*/
	    {0xf1c0, 0xd140, sop05, W, ADD},	/* op Dn,<ea>		*/
	    {0xf1f8, 0xd180, sop12, L, ADDX},	/* op Dx,Dy		*/
	    {0xf1f8, 0xd188, sop13, L, ADDX},	/* op -(Ax),-(Ay)	*/
	    {0xf1c0, 0xd180, sop05, L, ADD},	/* op Dn,<ea>		*/
	    {0xf1c0, 0xd1c0, sop06, L, ADDA},	/* op <ea>,An		*/
	    {0xf000, 0xd000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab14[] = {
	    {0xf0e0, 0xe000, gop07, B, NONE},	/* op #<data>,Dy	*/
	    {0xf0e0, 0xe020, gop08, B, NONE},	/* op Dx,Dy		*/
	    {0xf0e0, 0xe040, gop07, W, NONE},	/* op #<data>,Dy	*/
	    {0xf0e0, 0xe060, gop08, W, NONE},	/* op Dx,Dy		*/
	    {0xf0e0, 0xe080, gop07, L, NONE},	/* op #<data>,Dy	*/
	    {0xf0e0, 0xe0a0, gop08, L, NONE},	/* op Dx,Dy		*/
	    {0xf8c0, 0xe0c0, gop09, 0, NONE},	/* op <ea>		*/
	    {0xf8c0, 0xe8c0, gop10, 0, NONE},	/* op <ea>{offset:width}*/
	    {0xf000, 0xe000, sop00, 0, QQQQQ},	/* op			*/
	};

	static code tab15[] = {
	    {0xffc0, 0xf200, fop00, 0, FMOVEM},		/* op <ea>	*/
	    {0xffff, 0xf280, fop01, 0, FNOP},		/* op		*/
	    {0xffc0, 0xf300, sop03, 0, FSAVE},		/* op <ea>	*/
	    {0xffc0, 0xf340, sop03, 0, FRESTORE},	/* op <ea>	*/
	    {0xf000, 0xf000, sop00, 0, QQQQQ},		/* op		*/
	};

	static code *tab[] = {tab0, tab1, tab2, tab3, tab4, tab5, tab6,
	    tab7, tab8, tab9, tab10, tab11, tab12, tab13, tab14, tab15};

	register code	*p;
	register word	*mp;
	BRK_TAB		*bp;
	int		retval, hit_breakpoint;
	char		name[12];

	hit_breakpoint = 0;
	currpc = laddr;
	for (mp = mem; mp < &mem[8]; mp++) {
		*mp = CPU_get_short(laddr);
		/* handle breakpoints set in main memory */
		if ( mp == mem && *mp == ILLEGAL_INSTR ) {
			if (bp = CPU_find_bp(laddr)) {
				hit_breakpoint = 1;
				*mp = bp->text;
			}
		}
		laddr++;
	}
	for (p = tab[mem[0]>>12]; (mem[0] & p->mask) != p->val; ++p)
		;
	strcat(strcpy(name, p->name), size[p->size]);
	sp = atext;
	retval = (*p->fun)(mem, name, p->size);
	if ( hit_breakpoint )
		strcpy(sp, " (breakpoint)");
	return(retval);
}

/*
 *	Build opcode for dynamic bit operation
 */

static
gop00(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop05(mem, buildop(name, bit[mem[0]>>6&3]), size));
}

/*
 *	Build opcode for static bit operation
 */

static
gop01(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop08(mem, buildop(name, bit[mem[0]>>6&3]), B));
}

/*
 *	Build opcode for dbcc operation
 */

static
gop02(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop45(mem, buildop(name, cond[mem[0]>>8&15]), size));
}

/*
 *	Build opcode for TRAPcc operation
 */

static
gop03(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop32(mem, buildop(name, cond[mem[0]>>8&15]), size));
}

/*
 *	Build opcode for TRAPcc operation
 */

static
gop04(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop00(mem, buildop(name, cond[mem[0]>>8&15]), size));
}

/*
 *	Build opcode for Scc operation
 */

static
gop05(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop03(mem, buildop(name, cond[mem[0]>>8&15]), size));
}

/*
 *	Build opcode for bcc operation
 */

static
gop06(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop16(mem, buildop(name, cond[mem[0]>>8&15]), size));
}

/*
 *	Build opcode for shift operation
 */

static
gop07(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop42(mem,buildop(name,shift[mem[0]>>2&6|mem[0]>>8&1]),size));
}

/*
 *	Build opcode for shift operation
 */

static
gop08(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop14(mem,buildop(name,shift[mem[0]>>2&6|mem[0]>>8&1]),size));
}

/*
 *	Build opcode for shift operation
 */

static
gop09(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();

	return(sop03(mem, buildop(name, shift[mem[0]>>8&7]), size));
}

/*
 *	Build opcode for bit field operation
 */

static
gop10(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();
	static char *bfield[] = {"bftst",  "bfextu", "bfchg",  "bfexts",
				 "bfclr",  "bfffo",  "bfset",  "bfins"};

	return(sop46(mem, buildop(name, bfield[mem[0]>>8&7]), size));
}

/*
 *	Build opcode for CMP2 and CHK2 operations
 */

static
gop11(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();
	static char *opcode[] = {"cmp2", "chk2"};

	return(sop23(mem, buildop(name, opcode[mem[0]>>8&1]), size));
}

/*
 *	Build opcode for long multiplication
 */

static
gop12(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();
	static char *opcode[] = {"mulu", "muls"};

	return(sop47(mem, buildop(name, opcode[mem[1]>>11&1]), size));
}

/*
 *	Build opcode for long division
 */

static
gop13(mem, name, size)
word mem[];
char *name;
int size;
{
	char *buildop();
	static char *opcode[] = {"divu", "divs"};
	static char *opcodel[] = {"divul", "divsl"};
	char **op;

	op = (mem[1]&0x0400) && (mem[1]>>12&7) == (mem[1]&7) ? opcodel : opcode;
	return(sop47(mem, buildop(name, op[mem[1]>>11&1]), size));
}

/*
 *	Chose from <ea>,Rn and Rn,<ea>
 */

static
gop14(mem, name, size)
word mem[];
char *name;
int size;
{
	return((*((mem[1]&0x0800 ? sop22 : sop23)))(mem, name, size));
}

/*
 *	Print instruction op
 *
 *	................
 */

static
sop00(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s", name);
	return(1);
}

/*
 *	Print instruction op dn
 *
 *	.............nnn
 */

static
sop01(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sd%ld", name, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op dn
 *
 *	.............nnn
 */

static
sop02(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sa%ld", name, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op <ea>
 *
 *	..........eeeeee
 */

static
sop03(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s", name);
	return(printea(mem[0], mem, 1, size));
}

/*
 *	Print instruction op <ea>,dn
 *
 *	....nnn...eeeeee
 */

static
sop04(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 1, size);
	sp += sprintf(sp, ",d%ld", mem[0]>>9&7);
	return(n);
}

/*
 *	Print instruction op dn,<ea>
 *
 *	....nnn...eeeeee
 */

static
sop05(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sd%ld,", name, mem[0]>>9&7);
	return(printea(mem[0], mem, 1, size));
}

/*
 *	Print instruction op <ea>,an
 *
 *	....nnn...eeeeee
 */

static
sop06(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 1, size);
	sp += sprintf(sp, ",a%ld", mem[0]>>9&7);
	return(n);
}

/*
 *	Print instruction op <ea>,<dea>
 *
 *	....ddddddeeeeee
 */

static
sop07(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 1, size);
	sp += sprintf(sp, ",");
	return(printea(mem[0] >> 3 & 070 | mem[0] >> 9 & 007, mem, n, size));
}

/*
 *	Print instruction op #<data>,<ea>
 *
 *	..........eeeeee
 *	dddddddddddddddd
 *	dddddddddddddddd
 */

static
sop08(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s#", name);
	switch (size) {
	case B: sp += sprintf(sp, "%02lx,", *((byte *)mem + 3));
		n = 2;
		break;
	case W: sp += sprintf(sp, "%04lx,", *((word *)(mem + 1)));
		n = 2;
		break;
	case L: sp += sprintf(sp, "%08lx,", *((lword *)(mem + 1)));
		n = 3;
		break;
	}
	return(printea(mem[0], mem, n, size));
}

/*
 *	Print instruction op #<data>,sr
 *
 *	................
 *	dddddddddddddddd
 */

static
sop09(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%04lx,sr", name, *((word *)(mem + 1)));
	return(2);
}

/*
 *	Print instruction op #<data>,ccr
 *
 *	................
 *	........dddddddd
 */

static
sop10(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%02lx,ccr", name, *((byte *)mem + 3));
	return(2);
}

/*
 *	Print instruction op #<data>,<ea>
 *
 *	....ddd...eeeeee
 */

static
sop11(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%ld,",name, mem[0]&0x0e00 ? mem[0]>>9&7 : 8);
	return(printea(mem[0], mem, 1, size));
}

/*
 *	Print instruction op dx,dy
 *
 *	....yyy......xxx
 */

static
sop12(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sd%ld,d%ld", name, mem[0]&7, mem[0]>>9&7);
	return(1);
}

/*
 *	Print instruction op -(ax),-(ay)
 *
 *	....yyy......xxx
 */

static
sop13(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s-(a%ld),-(a%ld)", name, mem[0]&7, mem[0]>>9&7);
	return(1);
}

/*
 *	Print instruction op dx,dy
 *
 *	....xxx......yyy
 */

static
sop14(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sd%ld,d%ld", name, mem[0]>>9&7, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op (ax)+,(ay)+
 *
 *	....yyy......xxx
 */

static
sop15(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s(a%ld)+,(a%ld)+", name, mem[0]&7, mem[0]>>9&7);
	return(1);
}

/*
 *	Print instruction op label
 *
 *	........dddddddd
 *	dddddddddddddddd
 *	dddddddddddddddd
 */

static
sop16(mem, name, size)
word mem[];
char *name;
int size;
{
	register long offset;
	unchar	*str;

	switch (size) {
	case B: offset = *((char *) mem + 1);
		break;
	case W: offset = *((short *) mem + 1);
		break;
	case L: offset = *((long *) (mem + 1));
		break;
	}
	str = CPU_symbolic_version((long)(currpc + 1) + offset);
	if (str)
		sp += sprintf(sp, "%-8s%s", name, str);
	else
		sp += sprintf(sp, "%-8s%08lx", name,
			(long)(currpc + 1) + offset);
	return(size);
}

/*
 *	Print instruction op (d16,ay),dx
 *
 *	....xxx......yyy
 *	dddddddddddddddd
 */

static
sop17(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp,"%-8s(%04lx,a%ld),d%ld",name,
			mem[1],mem[0]&7,mem[0]>>9&7);
	return(2);
}

/*
 *	Print instruction op dx,(d16,ay)
 *
 *	....xxx......yyy
 *	dddddddddddddddd
 */

static
sop18(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp,"%-8sd%ld,(%04lx,a%ld)",name,
			mem[0]>>9&7,mem[1],mem[0]&7);
	return(2);
}

/*
 *	Print instruction op dc1:dc2,du1:du2,(rn1):(rn2)
 *
 *	................
 *	Rn1n...du1...dc1
 *	Rn2n...du2...dc2
 */

static
sop19(mem, name, size)
word mem[];
char *name;
int size;
{
	char *defrn();
	static char s[] = "Rn";
	static char s1[] = "Rn";

	sp += sprintf(sp, "%-8sd%ld:d%ld,", name, mem[1]&7, mem[2]&7);
	sp += sprintf(sp, "d%ld:d%ld,(%s):(%s)", mem[1]>>6&7, mem[2]>>6&7,
	    defrn(mem[1], s), defrn(mem[2], s1));
	return(3);
}

/*
 *	Print instruction op #<data>,<ea>
 *
 *	..........eeeeee
 *	........dddddddd
 */

static
sop20(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%02lx,", name, *((byte *)mem + 3));
	return(printea(mem[0], mem, 2, size));
}

/*
 *	Print instruction op dc,du,<ea>
 *
 *	..........eeeeee
 *	.......uuu...ccc
 */

static
sop21(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sd%ld,d%ld,", name, mem[1]&7, mem[1]>>6&7);
	return(printea(mem[0], mem, 2, size));
}

/*
 *	Print instruction op rn,<ea>
 *
 *	..........eeeeee
 *	annn............
 */

static
sop22(mem, name, size)
word mem[];
char *name;
int size;
{
	char *defrn();
	static char s[] = "Rn";

	sp += sprintf(sp, "%-8s%s,", name, defrn(mem[1], s));
	return(printea(mem[0], mem, 2, size));
}

/*
 *	Print instruction op <ea>,rn
 *
 *	..........eeeeee
 *	annn............
 */

static
sop23(mem, name, size)
word mem[];
char *name;
int size;
{
	char *defrn();
	register int n;
	static char s[] = "Rn";

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 2, size);
	sp += sprintf(sp, ",%s", defrn(mem[1], s));
	return(n);
}

/*
 *	Print instruction op sr,<ea>
 *
 *	..........eeeeee
 */

static
sop24(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8ssr,", name);
	return(printea(mem[0], mem, 1, size));
}

/*
 *	Print instruction op ccr,<ea>
 *
 *	..........eeeeee
 */

static
sop25(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sccr,", name);
	return(printea(mem[0], mem, 1, size));
}

/*
 *	Print instruction op <ea>,sr
 *
 *	..........eeeeee
 */

static
sop26(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 1, W);
	sp += sprintf(sp, ",sr");
	return(n);
}

/*
 *	Print instruction op <ea>,ccr
 *
 *	..........eeeeee
 */

static
sop27(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 1, B);
	sp += sprintf(sp, ",ccr");
	return(n);
}

/*
 *	Print instruction op an,#<data>
 *
 *	.............nnn
 *	dddddddddddddddd
 *	dddddddddddddddd
 */

static
sop28(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sa%ld,#", name, mem[0]&7);
	switch (size) {
	case W: sp += sprintf(sp, "%04lx", mem[1]);
		return(2);
	case L: sp += sprintf(sp, "%08lx", *((lword *)(mem + 1)));
		return(3);
	}
}

/*
 *	Print instruction op #<data>
 *
 *	.............ddd
 */

static
sop29(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%ld", name, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op #<data>
 *
 *	............dddd
 */

static
sop30(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%ld", name, mem[0]&15);
	return(1);
}

/*
 *	Print instruction op #<data>
 *
 *	................
 *	dddddddddddddddd
 */

static
sop31(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%04lx", name, mem[1]);
	return(2);
}

/*
 *	Print instruction op #<data>
 *
 *	................
 *	dddddddddddddddd
 *	dddddddddddddddd
 */

static
sop32(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#", name);
	switch (size) {
	case W: sp += sprintf(sp, "%04lx", mem[1]);
		return(2);
	case L: sp += sprintf(sp, "%08lx", *((lword *)(mem + 1)));
		return(3);
	}
}

/*
 *	Print instruction op reglist,<ea>
 *
 *	................
 *	llllllllllllllll
 */

static
sop33(mem, name, size)
word mem[];
char *name;
int size;
{
	word invert();
	char *codelist();
	char list[32];
	register word mask = mem[1];

	if ((mem[0] & 070) == 040)
		mask = invert(mem[1]);
	sp += sprintf(sp, "%-8s%s,", name, codelist(list, mask));
	return(printea(mem[0], mem, 2, size));
}

/*
 *	Print instruction op <ea>,reglist
 *
 *	................
 *	llllllllllllllll
 */

static
sop34(mem, name, size)
word mem[];
char *name;
int size;
{
	char *codelist();
	register int n;
	char list[32];

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 2, size);
	sp += sprintf(sp, ",%s", codelist(list, mem[1]));
	return(n);
}

/*
 *	Print instruction op an,usp
 *
 *	.............nnn
 */

static
sop35(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sa%ld,usp", name, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op usp,an
 *
 *	.............nnn
 */

static
sop36(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8susp,a%ld", name, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op rc,rn
 *
 *	................
 *	Rnnncccccccccccc
 */

static
sop37(mem, name, size)
word mem[];
char *name;
int size;
{
	char *creg(), *defrn();
	static char s[] = "Rn";

	sp += sprintf(sp, "%-8s%s,%s", name, creg(mem[1]), defrn(mem[1], s));
	return(2);
}

/*
 *	Print instruction op rn,rc
 *
 *	................
 *	Rnnncccccccccccc
 */

static
sop38(mem, name, size)
word mem[];
char *name;
int size;
{
	char *creg(), *defrn();
	static char s[] = "Rn";

	sp += sprintf(sp, "%-8s%s,%s", name, defrn(mem[1], s), creg(mem[1]));
	return(2);
}

/*
 *	Print instruction op #data,dn
 *
 *	....nnn.dddddddd
 */

static
sop39(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8s#%02lx,d%ld", name, mem[0]&0xff, mem[0]>>9&7);
	return(1);
}

/*
 *	Print instruction op dx,dy,#<data>
 *
 *	....yyy......xxx
 *	dddddddddddddddd
 */

static
sop40(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp,"%-8sd%lx,d%lx,#%04lx",name,
			mem[0]&7,mem[0]>>9&7,mem[1]);
	return(2);
}

/*
 *	Print instruction op -(ax),-(ay),#<data>
 *
 *	....yyy......xxx
 *	dddddddddddddddd
 */

static
sop41(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp,"%-8s-(a%lx),-(a%lx),#%04lx",name,
			mem[0]&7,mem[0]>>9&7,mem[1]);
	return(2);
}

/*
 *	Print instruction op #<data>,dy
 *
 *	....ddd......yyy
 */

static
sop42(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp,"%-8s#%ld,d%ld",name,
			mem[0]&0x0e00?mem[0]>>9&7:8,mem[0]&7);
	return(1);
}

/*
 *	Print instruction op ax,ay
 *
 *	....xxx......yyy
 */

static
sop43(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sa%ld,a%ld", name, mem[0]>>9&7, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op dx,ay
 *
 *	....xxx......yyy
 */

static
sop44(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sd%ld,a%ld", name, mem[0]>>9&7, mem[0]&7);
	return(1);
}

/*
 *	Print instruction op dn,label
 *
 *	.............nnn
 *	dddddddddddddddd
 */

static
sop45(mem, name, size)
word mem[];
char *name;
int size;
{
	sp += sprintf(sp, "%-8sd%ld,%08lx", name, mem[0]&7,
		 (long)(currpc+1) + (short) mem[1]);
	return(2);
}

/*
 *	Print instruction op [dn,]<ea>{offset:width}[,dn]
 *
 *	..........eeeeee
 *	.nnndooooodwwwww
 */

static
sop46(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s", name);
	if ((mem[0] & 0x0700) == 0x0700)
		sp += sprintf(sp, "d%ld,", mem[1]>>12&7);
	n = printea(mem[0], mem, 2, size);
	if (mem[1] & 0x0800)
		sp += sprintf(sp, "{d%ld:", mem[1]>>6&7);
	else
		sp += sprintf(sp, "{#%lx:", mem[1]>>6&0x1f);
	if (mem[1] & 0x0020)
		sp += sprintf(sp, "d%ld}", mem[1]&7);
	else
		sp += sprintf(sp, "#%lx}", mem[1]&0x1f ? mem[1]&0x1f : 32);
	if (mem[0] & 0x0100 && (mem[0] & 0x0700) != 0x0700)
		sp += sprintf(sp, ",d%ld", mem[1]>>12&7);
	return(n);
}

/*
 *	Print instruction op <ea>,[dh:]dl
 *
 *	..........eeeeee
 *	.lll.........hhh
 */

static
sop47(mem, name, size)
word mem[];
char *name;
int size;
{
	register int n;

	sp += sprintf(sp, "%-8s", name);
	n = printea(mem[0], mem, 2, size);
	if ((mem[1]>>12&7) == (mem[1]&7))
		sp += sprintf(sp, ", d%ld", mem[1]&7);
	else
		sp += sprintf(sp, ",d%ld:d%ld", mem[1]&7, mem[1]>>12&7);
	return(n);
}

/*
 *	Print effective address.
 *	Return number of processed words.
 */

static
printea(ea, mem, n, size)
word ea, mem[];
int n, size;
{
	char *makindex();
	register int iw, comma, reg = ea & 7;
	register long pc, off;
	unchar	*name;
	uint	value;

	switch (ea >> 3 & 7) {
	case 0: sp += sprintf(sp, "d%ld", reg);
		break;
	case 1: sp += sprintf(sp, "a%ld", reg);
		break;
	case 2: sp += sprintf(sp, "(a%ld)", reg);
		break;
	case 3: sp += sprintf(sp, "(a%ld)+", reg);
		break;
	case 4: sp += sprintf(sp, "-(a%ld)", reg);
		break;
	case 5: sp += sprintf(sp, "(%04lx,a%ld)", mem[n++], reg);
		break;
	case 6: iw = mem[n++];
		if ((iw & 0x0100) == 0)
			sp += sprintf(sp,"(%02lx,a%ld,%s)",iw&0xff,reg,makindex(iw));
		else {
			sp += sprintf(sp, "(");
			comma = 0;
			if (iw & 7)
				sp += sprintf(sp, "[");
			switch (iw>>4&3) {
			case 2: sp += sprintf(sp, "%04lx", mem[n++]);
				comma = 1;
				break;
			case 3: sp += sprintf(sp,"%08lx",*((lword *)(mem+n)));
				n += 2;
				comma = 1;
				break;
			}
			if ((iw & 0x0080) == 0) {
				if (comma)
					sp += sprintf(sp, ",");
				sp += sprintf(sp, "a%ld", reg);
				comma = 1;
			}
			if (iw & 4) {
				sp += sprintf(sp, "]");
				comma = 1;
			}
			if ((iw & 0x0040) == 0) {
				if (comma)
					sp += sprintf(sp, ",");
				sp += sprintf(sp, "%s", makindex(iw));
				comma = 1;
			}
			if ((iw & 7) && !(iw & 4)) {
				sp += sprintf(sp, "]");
				comma = 1;
			}
			switch (iw & 3) {
			case 2: if (comma)
					sp += sprintf(sp, ",");
				sp += sprintf(sp, "%04lx", mem[n++]);
				break;
			case 3: if (comma)
					sp += sprintf(sp, ",");
					sp += sprintf(sp,"%08lx",*((lword *)(mem+n)));
					n += 2;
					break;
			}
			sp += sprintf(sp, ")");
		}
		break;
	case 7: switch (reg) {
		case 0: sp += sprintf(sp, "(%04lx).w", mem[n++]);
			break;
		case 1: name = CPU_symbolic_version(*((uint *)(mem + n)));
			if (name)
				sp += sprintf(sp,"%s", name);
			else
				sp += sprintf(sp,"(%08lx).l",
					*((lword *)(mem + n)));
			n += 2;
			break;
		case 2: pc = (long)(currpc + n);
			off = (short)mem[n++];
			name = CPU_symbolic_version((uint)(pc+off));
			if (name)
				sp += sprintf(sp,"%s", name);
			else
				sp += sprintf(sp, "(%04lx,pc:%08lx)", (word)off, pc + off);
			break;
		case 3: pc = (long)(currpc + n);
			iw = mem[n++];
			if ((iw & 0x0100) == 0) {
				off = (char)(iw & 0xff);
				sp += sprintf(sp, "(%02lx,pc:%08lx,%s)",
					(byte)off, pc + off,  makindex(iw));
			}
			else {
				sp += sprintf(sp, "(");
				comma = 0;
				if (iw & 7)
					sp += sprintf(sp, "[");
				switch (iw>>4&3) {
				case 2: off = (short)mem[n++];
					sp += sprintf(sp, "%04lx", off);
					comma = 1;
					break;
				case 3: off = *((long *)(mem + n));
					n += 2;
					sp += sprintf(sp, "%08lx", off);
					comma = 1;
					break;
				}
				if ((iw & 0x0080) == 0) {
					if (comma)
						sp += sprintf(sp, ",");
					sp += sprintf(sp, "pc:%08lx", pc + off);
				}
				if (iw & 4) {
					sp += sprintf(sp, "]");
					comma = 1;
				}
				if ((iw & 0x0040) == 0) {
					if (comma)
						sp += sprintf(sp, ",");
					sp += sprintf(sp, "%s", makindex(iw));
					comma = 1;
				}
				if ((iw & 7) && !(iw & 4)) {
					sp += sprintf(sp, "]");
					comma = 1;
				}
				switch (iw & 3) {
				case 2: if (comma)
						sp += sprintf(sp, ",");
					sp += sprintf(sp, "%04lx", mem[n++]);
					break;
				case 3:
					if (comma)
						sp += sprintf(sp, ",");
					sp += sprintf(sp,"%08lx",*((lword *)(mem+n)));
					n += 2;
					break;
				}
				sp += sprintf(sp, ")");
			}
			break;
		case 4: sp += sprintf(sp, "#");
			switch (size) {
			case B: sp += sprintf(sp, "%02lx", mem[n++]&0xff);
				break;
			case X: sp += sprintf(sp, "%04lx", mem[n++]);
				sp += sprintf(sp, "%04lx", mem[n++]);
				sp += sprintf(sp, "%04lx", mem[n++]);
				sp += sprintf(sp, "%04lx", mem[n++]);
				break;
			case W: sp += sprintf(sp, "%04lx", mem[n++]);
				break;
			case L: value = (mem[n++]<<16);
				value += mem[n++];
				name = CPU_symbolic_version(value);
				if (name)
					sp += sprintf(sp,"%s",name);
				else
					sp += sprintf(sp, "%04lx", value);
				break;
			}
			break;
		}
		break;
	}
	return(n);
}

/*
 *	Return pointer to index string.
 */

static char *
makindex(w)
word w;
{
	static char s[8] = "Rn.S*s";

	s[0] = w & 0x8000 ? 'a' : 'd';
	s[1] = w >> 12 & 7 | '0';
	s[3] = w & 0x0800 ? 'l' : 'w';
	switch (w>>9&3) {
	case 0: s[4] = '\0';
		break;
	case 1: s[4] = '*';
		s[5] = '2';
		break;
	case 2: s[4] = '*';
		s[5] = '4';
		break;
	case 3: s[4] = '*';
		s[5] = '8';
		break;
	}
	return(s);
}

/*
 *	Build new opcode name by replacing x's from oldname
 *	with characters from replacement. Return new name.
 */

static char *
buildop(oldname, replacement)
char *oldname, *replacement;
{
	extern char *strcpy();
	static char newname[16];
	register char *tempname;

	tempname = newname;
	for (; *oldname; ++oldname)
	    if (*oldname == 'x') {
		strcpy(tempname, replacement);
		return(newname);
	    }
	    else
		*tempname++ = *oldname;
	*tempname = '\0';
	return(newname);
}

/*
 *	Return pointer do string describing general register:
 *	    Rnnn............
 */

static char *
defrn(w, s)
register word w;
register char *s;
{
	s[0] = w & 0x8000 ? 'a' : 'd';
	s[1] = w >> 12 & 7 | '0';
	return(s);
}

/*
 *	Return pointer to general register string
 *	....cccccccccccc
 */

static char *
creg(w)
word w;
{
	static char *s[] = {"scf", "dcf", "cacr", "usp", "vbr", "caar",
			    "msp", "isp", "???"};

	w &= 0xfff;
	if (w > 2)
		w -= 0x800 - 3;
	if (w > 7)
		w = 8;
	return(s[w]);
}

/*
 *	Invert register list
 */

static word
invert(mask)
word mask;
{
	register word mode;
	register int i;

	mode = mask;
	mask = 0;
	for (i = 16; i; --i) {
	    mask <<= 1;
	    mask |= mode & 1;
	    mode >>= 1;
	}
	return(mask);
}

/*
 *	Encode register list
 *	Return pointer to string.
 */

static char *
codelist(string, mask)
char *string;
word mask;
{
	char *codeset();
	register char *next;

	next = codeset(string, mask, 'd');
	if (mask&0xff00 && mask&0x00ff)
		*next++ = '/';
	next = codeset(next, mask>>8, 'a');
	*next = '\0';
	return(string);
}

/*
 *	Build list of register subset.
 *	Return pointer to next character.
 */

static char *
codeset(next, mask, ch)
char *next, ch;
word mask;
{
	register int i, j, first = 1;

	i = 0;
	mask &= 0xff;
	while (mask)
		if (mask & 1) {
			j = i;
			while (mask & 1) {
				++i;
				mask >>= 1;
			}
			if (!first)
				*next++ = '/';
			*next++ = ch;
			*next++ = j + '0';
			if (i > j+1) {
				    *next++ = '-';
				    *next++ = ch;
				    *next++ = i + ('0'-1);
			}
			first = 0;
		}
		else {
			++i;
			mask >>= 1;
		}
	return(next);
}

/*
 *	Print FMOVEM instruction
 *
 *	..........eeeeee
 *	ccdxxxxxxxxxxxxx
 */

static
fop00(mem, name, size)
word mem[];
char *name;
int size;
{
	extern char *fplist();
	extern unsigned char fpinvert();

	static char *fcregs[] =  {"", "fpiar", "fpsr", "fpsc/fpisr",
		"fpcr", "fpcr/fpiar", "fpcr/fpsr", "fpcr/fpsr/fpiar"};

	register int retval;
	register unsigned char mask;

	switch (mem[1] >> 13 & 7) {
	case 4:
		sp += sprintf(sp, "%-12s", strcat(name, ".l"));
		retval = printea(mem[0], mem, 2, 0);
		sp += sprintf(sp, ",%s", fcregs[mem[1] >> 10 & 7]);
		break;
	case 5:
		sp += sprintf(sp, "%-12s%s,", strcat(name, ".l"),
				fcregs[mem[1] >> 10 & 7]);
		retval = printea(mem[0], mem, 2, 0);
		break;
	case 6:
		sp += sprintf(sp, "%-12s", strcat(name, ".x"));
		retval = printea(mem[0], mem, 2, 0);
		if (mem[1] & 0x800)
			sp += sprintf(sp, ",d%ld,", mem[1] >> 4 & 7);
		else {
			mask = (unsigned char)mem[1];
			if (mem[1] & 0x1000)
				mask = fpinvert(mask);
			sp += sprintf(sp, ",%s", fplist(mask));
		}
		break;
	case 7:
		sp += sprintf(sp, "%-12s", strcat(name, ".x"));
		if (mem[1] & 0x800)
			sp += sprintf(sp, "d%ld,", mem[1] >> 4 & 7);
		else {
			mask = (unsigned char)mem[1];
			if (mem[1] & 0x1000)
				mask = fpinvert(mask);
			sp += sprintf(sp, "%s,", fplist(mask));
		}
		retval = printea(mem[0], mem, 2, 0);
		break;
	default:
		sp += sprintf(sp, "%-8s", QQQQQ);
		retval = 1;
		break;
	}
	return(retval);
}

/*
 *	Print instruction FNOP (this is special case of FBcc.W)
 *
 *	................
 *	0000000000000000
 *	0000000000000000
 */

static
fop01(mem, name, size)
word mem[];
char *name;
int size;
{
	if (mem[1] == 0) {
		sp += sprintf(sp, "%-8s", name);
		return(2);
	}
	else {
		sp += sprintf(sp, "%-8s", QQQQQ);
		return(1);
	}
}

/*
 *	Invert FP register mask
 */

static unsigned char
fpinvert(mask)
register unsigned char mask;
{
	register unsigned char mode;
	register int i;

	mode = mask;
	mask = 0;
	for(i = 8; i; i--) {
		mask <<= 1;
		mask |= mode & 1;
		mode >>= 1;
	}
	return(mask);
}

/*
 *	Build FP register list from mask in the form
 *
 *		fp7 ... fp0
 */

static char *
fplist(mask)
register unsigned char mask;
{
	static char string[32];

	register int i, j, first;
	register char *next;

	i = 0;
	first = 1;
	next = string;

	while (mask) {
		if (mask & 1) {
			j = i;
			while (mask & 1) {
				i++;
				mask >>= 1;
			}
			if (!first)
				*next++ = '/';
			*next++ = 'f';
			*next++ = 'p';
			*next++ = j + '0';
			if (i > j + 1) {
				*next++ = '-';
				*next++ = 'f';
				*next++ = 'p';
				*next++ = i + ('0' - 1);
			}	
			first = 0;
		}
		else {
			i++;
			mask >>= 1;
		}
	}
	*next = '\0';
	return(string);
}

