/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) xmodem.c: version 25.1 created on 11/27/91 at 15:37:38	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)xmodem.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* xmodem.c */

#include "sys/types.h"
#include "scc.h"
#include "rwi.h"

#define SOH             001 	/* Start Of Header (protocol stuff) */
#define EOT             004     /* End Of Transmission */
#define ACK             006     /* Acknowledge packet */
#define DN_NAK          025     /* NOT acknowledge packet */
#define CAN             030 	/* Cancel transmission */
#define DN_TIMEOUT     	-1	/* Timeout while waiting for a byte */
#define ERRORMAX        10      /* maximum errors tolerated */
#define BBUFSIZ         1024    /* buffer size -- do not change! */
#define BITMASK		0x00ff	/* removes extra bits from int */
#define TRUE		1

#define POLL_DELAY	10	/* current delay factor (10 seconds) */
#define SHORT_MASK	0xffff
#define BLK_MAX		256	/* max value for protocol block count */

/*  UMODEM Constants  */
#define		 CRCCHR		'C'	/* CRC request character */
/*
 CRC-16 constants:
*/
/* the CRC polynomial. */
#define P	0x1021
/* number of bits in CRC */
#define W	16
/* number of bits per char */
#define B	8

/* crctab as calculated by initcrctab() */
unsigned short crctab[1<<B] = {
	0x0000,  0x1021,  0x2042,  0x3063,  0x4084,  0x50a5,  0x60c6,  0x70e7,
	0x8108,  0x9129,  0xa14a,  0xb16b,  0xc18c,  0xd1ad,  0xe1ce,  0xf1ef,
	0x1231,  0x0210,  0x3273,  0x2252,  0x52b5,  0x4294,  0x72f7,  0x62d6,
	0x9339,  0x8318,  0xb37b,  0xa35a,  0xd3bd,  0xc39c,  0xf3ff,  0xe3de,
	0x2462,  0x3443,  0x0420,  0x1401,  0x64e6,  0x74c7,  0x44a4,  0x5485,
	0xa56a,  0xb54b,  0x8528,  0x9509,  0xe5ee,  0xf5cf,  0xc5ac,  0xd58d,
	0x3653,  0x2672,  0x1611,  0x0630,  0x76d7,  0x66f6,  0x5695,  0x46b4,
	0xb75b,  0xa77a,  0x9719,  0x8738,  0xf7df,  0xe7fe,  0xd79d,  0xc7bc,
	0x48c4,  0x58e5,  0x6886,  0x78a7,  0x0840,  0x1861,  0x2802,  0x3823,
	0xc9cc,  0xd9ed,  0xe98e,  0xf9af,  0x8948,  0x9969,  0xa90a,  0xb92b,
	0x5af5,  0x4ad4,  0x7ab7,  0x6a96,  0x1a71,  0x0a50,  0x3a33,  0x2a12,
	0xdbfd,  0xcbdc,  0xfbbf,  0xeb9e,  0x9b79,  0x8b58,  0xbb3b,  0xab1a,
	0x6ca6,  0x7c87,  0x4ce4,  0x5cc5,  0x2c22,  0x3c03,  0x0c60,  0x1c41,
	0xedae,  0xfd8f,  0xcdec,  0xddcd,  0xad2a,  0xbd0b,  0x8d68,  0x9d49,
	0x7e97,  0x6eb6,  0x5ed5,  0x4ef4,  0x3e13,  0x2e32,  0x1e51,  0x0e70,
	0xff9f,  0xefbe,  0xdfdd,  0xcffc,  0xbf1b,  0xaf3a,  0x9f59,  0x8f78,
	0x9188,  0x81a9,  0xb1ca,  0xa1eb,  0xd10c,  0xc12d,  0xf14e,  0xe16f,
	0x1080,  0x00a1,  0x30c2,  0x20e3,  0x5004,  0x4025,  0x7046,  0x6067,
	0x83b9,  0x9398,  0xa3fb,  0xb3da,  0xc33d,  0xd31c,  0xe37f,  0xf35e,
	0x02b1,  0x1290,  0x22f3,  0x32d2,  0x4235,  0x5214,  0x6277,  0x7256,
	0xb5ea,  0xa5cb,  0x95a8,  0x8589,  0xf56e,  0xe54f,  0xd52c,  0xc50d,
	0x34e2,  0x24c3,  0x14a0,  0x0481,  0x7466,  0x6447,  0x5424,  0x4405,
	0xa7db,  0xb7fa,  0x8799,  0x97b8,  0xe75f,  0xf77e,  0xc71d,  0xd73c,
	0x26d3,  0x36f2,  0x0691,  0x16b0,  0x6657,  0x7676,  0x4615,  0x5634,
	0xd94c,  0xc96d,  0xf90e,  0xe92f,  0x99c8,  0x89e9,  0xb98a,  0xa9ab,
	0x5844,  0x4865,  0x7806,  0x6827,  0x18c0,  0x08e1,  0x3882,  0x28a3,
	0xcb7d,  0xdb5c,  0xeb3f,  0xfb1e,  0x8bf9,  0x9bd8,  0xabbb,  0xbb9a,
	0x4a75,  0x5a54,  0x6a37,  0x7a16,  0x0af1,  0x1ad0,  0x2ab3,  0x3a92,
	0xfd2e,  0xed0f,  0xdd6c,  0xcd4d,  0xbdaa,  0xad8b,  0x9de8,  0x8dc9,
	0x7c26,  0x6c07,  0x5c64,  0x4c45,  0x3ca2,  0x2c83,  0x1ce0,  0x0cc1,
	0xef1f,  0xff3e,  0xcf5d,  0xdf7c,  0xaf9b,  0xbfba,  0x8fd9,  0x9ff8,
	0x6e17,  0x7e36,  0x4e55,  0x5e74,  0x2e93,  0x3eb2,  0x0ed1,  0x1ef0
};

extern char xferbuff[];	/* GLOBAL 1K transfer buffer */

static int sectnum;

/**********************************************************************
 * xmodem routines --
 *
 * xmodem_cancel() - Cancel connection.
 * xmodem_ack()    - Acknowledge a packet.
 * xmodem_start()  - Signal sender to start sending.
 * xmodem_cancel() - Cancel connection.
 *
 * xmodem_getbuf() - Receive, fill input buffer, and do crc on data.
 *                   return 1; - If incoming block is good.
 *                   return 0; - If incoming block is corrupted.
 * 
 * xmodem_get()    - Sync receive and load global 1K buffer with data.
 *                   return  1; - If incoming block is good.
 *                   return  0; - When done (at EOT).
 *                   return -1; - If transfer has failed.
 */

/* forward declarations */
void sendbyte();
static int xmodem_getbuf();

void
xmodem_cancel()
{
	sendbyte(CAN); 		/* xmodem cancel */
	sendbyte(ACK); 		/* xmodem cancel */
}

void
xmodem_ack()
{
	sendbyte(ACK);		/* got a good block now. */
}

void
xmodem_start()
{
	sendbyte(CRCCHR);	/* CRC startup, in place of DN_NAK. */
	sectnum = 0;
}


int
xmodem_get()
{
	int blknum, inv_blknum;
	int errors     = 0; 
	int done       = 0;
	int fatalerror = 0;
	int start_blk  = 0;
	int firstchar  = 0;

	do {
		do {
			/* wait for character. */
	    		firstchar = readbyte(POLL_DELAY); 
			if (firstchar == EOT) {
				xmodem_ack();
				return(0);
			}

		} while ((firstchar != SOH) && (firstchar != DN_TIMEOUT));

		if ( firstchar == DN_TIMEOUT ) {
			errors++; /* we had an error. */

			while (readbyte(POLL_DELAY) != DN_TIMEOUT)
				;	/* wait until bytes stop. */

			printf ("ERROR! -- timeout.\n");
			sendbyte(DN_NAK);/* tell sender we failed block read. */

			continue; /* ...at next iteration */
		}

		/* get block number. */
		blknum     = readbyte(POLL_DELAY); 

		/* get inverse of block number.     */
		inv_blknum = readbyte(POLL_DELAY);
					    

		/*  -- Testing the blknum and ~blknum  */
		/*     bytes of block header bytes.    */
		if ( blknum != ((~inv_blknum) & 0xff) ) {
			/* block number and inverse block number bad. */
			/* set error to ignore the block. */
			errors++;
			printf("BAD blocknumbers 0x%x 0x%x\n",blknum,inv_blknum);
			/* wait until bytes stop. */
			while (readbyte(POLL_DELAY) != DN_TIMEOUT)
					;	

			/* tell sender we failed block read. */
			sendbyte(DN_NAK);
			continue;

		}

		/* now check that this is the block you wish..*/
		if (blknum != (((sectnum + 1) % BLK_MAX) & BITMASK)) {

			if (blknum == ((sectnum % BLK_MAX) & BITMASK)) { 
				/* if last block was re-sent, */
				/* ok, receive it, ACK it.    */
				while(readbyte(POLL_DELAY) != DN_TIMEOUT) 
						; 

				printf("duplicate sector.\n"); 
				sendbyte(ACK);
			} 
			else {
				/*if not previous block, not */
				/* this block, then bad.     */
				printf("Fatal error -- out of sync!\n");
				/* abort transfer. */
				fatalerror = TRUE; 
				sendbyte(CAN);
			}
			continue;
		}

		if (!xmodem_getbuf()) {
			/* checksum failed..bad block */
			errors++; /* we had an error. */

			/* wait until bytes stop. */ 
			while (readbyte(POLL_DELAY) != DN_TIMEOUT)
					;	

			/* tell sender we failed. */
			printf("ERROR! bad checksum\n");
			sendbyte(DN_NAK);
			continue;
		}
		/* update sector counter */
		sectnum = blknum;
		errors  = 0;
		done    = TRUE;

	} while ((errors < ERRORMAX) && !done && !fatalerror);

	/* done => no fatal error or ERRORMAX */
	if (done)
		return(1);

	/* bad finish -- the block is half baked */
	return(-1);
	
}

static int
xmodem_getbuf()
{
	register int ndx, c, crcndx, checksum, inchecksum = 0;
	ndx =  c = crcndx = checksum = inchecksum = 0;

	for ( ndx = 0; ndx < BBUFSIZ; ndx++ ) {
		c = readbyte(POLL_DELAY);
		xferbuff[ndx] = (char)c;
		crcndx = ((((checksum>>(8))&BITMASK) ^ (c & 0x00ff))&BITMASK);
		checksum = (checksum<<8) ^ crctab[crcndx];
	} 

	checksum &= SHORT_MASK; 		/* strip it.*/
	inchecksum = readbyte(POLL_DELAY); 	/* get 16 bit CRC */
	c = readbyte(POLL_DELAY);
	inchecksum = ((inchecksum<<8) | c) & SHORT_MASK;

	return( checksum == inchecksum );
}

/* get a byte from channel 1 -- timeout if "seconds" elapses */
/*      NOTE, however, that this function returns an INT, not a BYTE!!!  */
int
readbyte(seconds)
unsigned        seconds;
{
	register struct scc *sccptr = MODEM_PORT;
	int     count;

	for (count = seconds * 0x10000; count; --count)
		if (sccptr->reg[0].reg & RR0_RX) 	/* data available */
			return(sccptr->reg[8].reg & BITMASK); 	/* read it */
	return(DN_TIMEOUT);
}

/* send a byte to channel 1 */
void
sendbyte(data)
char    data;
{
	char    dataout;
	register struct scc *sccptr = MODEM_PORT;

	dataout = data & BITMASK;	/* only send one byte. */
	while(!(sccptr->reg[0].reg & RR0_TX) )
		;
	sccptr->reg[8].reg = dataout; /* sent one byte */
}
