/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sbus_iom.c: version 23.4 created on 9/23/91 at 18:13:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sbus_iom.c	23.4	9/23/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * iom.c
 *
 *	Routines for dealing with the I/O Module (IOM).
 */

#include "sys/types.h"
#include "sys/sbus.h"
#include "sys/ints.h"
#include "misc.h"
#include "sbus_iom.h"
#include "sbus_conf.h"
#include "spm_debug.h"
#include "sys/sbus_iom.h"
#include "sys/sbus_spm.h"
#include "iom_config.h"
#include "error.h"


extern uint	kern_clock_enable;
extern uint	spm_mem_copy_called;
extern uint	spm_slot;
extern uint	iom_count;

extern unchar	*iomap();

get_iom_err_info(iom_slot)
uint	iom_slot;
{
	uint		err_data;
	register uint	tmp;
	register struct error	*ep;
	uint		saved_map = iomap_save();

	if (probe_rd_long((uint *)iomap(iom_slot, IOM_ERROR_REG), &err_data)) {
		/* increase tail pointer */
		tmp = (error_tail == ERROR_SIZE) ? 0 : error_tail + 1;
		if (tmp != error_head) {
			ep = &error[error_tail];
			ep->type = IOM_ERR;
			ep->data.iom.iom_slot = iom_slot;
			ep->data.iom.err_reg = err_data;
			error_tail = tmp;
		}
	}
	else
		printf("Bus error occured reading IOM in slot %d\n", iom_slot);

	iomap_restore(saved_map);
}


show_iom_err(iom_slot, iom_err_reg_data)
register uint	iom_slot;
register uint	iom_err_reg_data;
{
	put_char('\n');
	print_time_stamp(0);
	printf("IOM error: slot 0x%x\n", iom_slot);

	if ( iom_err_reg_data & IOM_BUS_GRANT_TIMEOUT ) {
		printf("sbus grant timeout: ");
		break_out_iom_grant_timeout_info(iom_slot, iom_err_reg_data);
	}

	if ( (iom_err_reg_data & IOM_IOA_5V_OK) == 0 )
		printf("Bus Adapter's 5 volt low\n");

	if ( iom_err_reg_data & IOM_BUS_ERROR_LATCHED )
		break_out_iom_sbus_err_info(iom_slot);

	if ( iom_err_reg_data & IOM_LINK_ERROR_LATCHED )
		break_out_iom_iolink_error_info(iom_slot);

	if ( iom_err_reg_data & IOM_DOWNLINK_ERROR_LATCHED ) {

		printf("downlink error: ");

		printf("type 0%x, ", (iom_err_reg_data & IOM_DL_TYPE) >>
		  IOM_DL_TYPE_SHIFT);

		if ( iom_err_reg_data & IOM_DL_RESP80 )
			printf("8 byte response, ");
		if ( iom_err_reg_data & IOM_DL_RESP44 )
			printf("4 byte response at byte 4, ");
		if ( iom_err_reg_data & IOM_DL_RESP40 )
			printf("4 byte response at byte 0, ");
	}
	
	printf("\n");
}

break_out_iom_grant_timeout_info(iom_slot, err_reg_info)
uint	iom_slot;
uint	err_reg_info;
{
	uint	info;
	uint	saved_map = iomap_save();

	info = *(uint *)iomap(iom_slot, IOM_BUS_GRANT_TIMEOUT_REG);

	if (err_reg_info & IOM_LOCAL_TIMEOUT) {
		if (err_reg_info & IOM_INTR_REQ_TIMEOUT)
			printf("interrupt request timeout");
		else
			printf("local read response timeout");
	}
	else
		printf("uplink transmission timeout");

	printf(":\n");

	printf("type 0x%x, ", (info & IOM_BUS_GRANT_TIMEOUT_TYPE) >> 
	  IOM_BUS_GRANT_TIMEOUT_TYPE_SHIFT);

	printf("i/o slot 0x%x, ", (info & IOM_BUS_GRANT_TIMEOUT_IOSLOT) >>
	  IOM_BUS_GRANT_TIMEOUT_IOSLOT_SHIFT);

	printf("sbus slot 0x%x, ", (info & IOM_BUS_GRANT_TIMEOUT_SBSLOT) >>
	  IOM_BUS_GRANT_TIMEOUT_SBSLOT_SHIFT);

	printf("sbus slot complement 0x%x, ",
	  (info & IOM_BUS_GRANT_TIMEOUT_SBSLOT_NOT) >>
	  IOM_BUS_GRANT_TIMEOUT_SBSLOT_NOT_SHIFT);

	printf("\n");
	iomap_restore(saved_map);
}

break_out_iom_sbus_err_info(iom_slot)
uint	iom_slot;
{
	uint 	bus_err_reg0, bus_err_reg1, bus_err_reg2;
	uint	saved_map = iomap_save();	

	bus_err_reg0 = *(uint *)iomap(iom_slot, IOM_BUS_ERROR_REG0);
	bus_err_reg1 = *(uint *)iomap(iom_slot, IOM_BUS_ERROR_REG1);
	bus_err_reg2 = *(uint *)iomap(iom_slot, IOM_BUS_ERROR_REG2);

	if (bus_err_reg0 & IOM_BUS_READ_TIMEOUT) {
		printf("sbus read resp timeout:\n");
		printf("    dest 0x%x, resps pending 0x%x, dma channel 0x%x\n",
			((bus_err_reg2 & IOM_BUS_READ_DEST) >> 
				IOM_BUS_READ_DEST_SHIFT),
			(~(bus_err_reg2 & IOM_BUS_READ_RESP_PENDING_CNT_NOT) >> 
				IOM_BUS_READ_RESP_PENDING_CNT_NOT_SHIFT),
			((bus_err_reg2 & IOM_BUS_IOSLOT) >> 
				IOM_BUS_IOSLOT_SHIFT));
	}

	if (bus_err_reg0 & IOM_BUS_RMSEQ_ERROR)
		printf("sbus rmseq error, ");

	if (bus_err_reg0 & IOM_BUS_IOSLOT_ERROR)
		printf("i/o slot error, i/o slot 0x%x, ",
		      (bus_err_reg2 & IOM_BUS_IOSLOT) >> IOM_BUS_IOSLOT_SHIFT);

	if (bus_err_reg0 & IOM_DL_CMD_BUF_OVFL)
		printf("downlink cmd buf overflow, ");

	if (bus_err_reg0 & IOM_DL_RESP_BUF_OVFL)
		printf("downlink response buf overflow, ");

	printf("\n");
	if (bus_err_reg0 & (IOM_DL_CMD_BUF_OVFL | IOM_DL_RESP_BUF_OVFL) == 0 ) {

		if (bus_err_reg0 & IOM_BUS_ERRORS) {

			printf("buserr: ");

			if (bus_err_reg0 & IOM_BUS_ACTIVE_NOT)
				printf("no active, ");

			if (bus_err_reg0 & IOM_BUS_SOURCE_ERROR)
				printf("src error, ");

			if (bus_err_reg0 & IOM_BUS_DEST_ERROR)
				printf("dest error, ");

			if (bus_err_reg0 & IOM_BUS_RESP_SOURCE_MISMATCH)
				printf("response/src mismatch, ");

			if (bus_err_reg0 & IOM_BUS_TYPE_ERROR)
				printf("type error, ");

			if (bus_err_reg0 & IOM_BUS_DATA_ERROR)
				printf("data error, ");

			if (bus_err_reg0 & IOM_BUS_ACK_NOT)
				printf("missing ack, ");

			if (bus_err_reg0 & IOM_BUS_NACK)
				printf("nack, ");
	

			printf("src slot 0x%x ",
				(bus_err_reg1 & IOM_BUS_SOURCE) >>
					IOM_BUS_SOURCE_SHIFT);

			printf("dest slot 0x%x ",
			   (bus_err_reg1 & IOM_BUS_DEST) >> IOM_BUS_DEST_SHIFT);

			printf("type 0%o, ",
			   (bus_err_reg1 & IOM_BUS_TYPE) >> IOM_BUS_TYPE_SHIFT);

			printf("\n");

			if (bus_err_reg2 & IOM_BUS_XMIT)
				printf("iom was transmitting, ");

			if (bus_err_reg2 & IOM_BUS_LOCAL_GRANT)
				printf("iom local grant, ");

			if (bus_err_reg2 & IOM_BUS_DEST_IOM)
				printf("iom was dest, ");

			if (bus_err_reg2 & IOM_BUS_DATA_PARITY_VALID)
				printf("data parity valid, ");

			printf("\n");

			printf("read dest 0x%x, ",
				(bus_err_reg2 & IOM_BUS_READ_DEST) >>
					IOM_BUS_READ_DEST_SHIFT);

			printf("i/o slot 0x%x, ",
				(bus_err_reg2 & IOM_BUS_IOSLOT) >>
					IOM_BUS_IOSLOT_SHIFT);
		}
	}
	printf("\n");
	iomap_restore(saved_map);
}

break_out_iom_iolink_error_info(iom_slot)
uint	iom_slot;
{
	uint 	link_err_reg0, link_err_reg1, link_err_reg2;
	uint	saved_map = iomap_save();

	link_err_reg0 = *(uint *)iomap(iom_slot, IOM_LINK_ERROR_REG0);
	link_err_reg1 = *(uint *)iomap(iom_slot, IOM_LINK_ERROR_REG1);
	link_err_reg2 = *(uint *)iomap(iom_slot, IOM_LINK_ERROR_REG2);

	if ( link_err_reg0 & IOM_LINK_CONN1_PIN1_OPEN)
		printf("connector 1 pin 1 open, ");

	if ( link_err_reg0 & IOM_LINK_CONN1_PIN64_OPEN)
		printf("connector 1 pin 64 open, ");

	if ( link_err_reg0 & IOM_LINK_CONN2_PIN1_OPEN)
		printf("connector 2 pin 1 open, ");

	if ( link_err_reg0 & IOM_LINK_CONN2_PIN64_OPEN)
		printf("connector 2 pin 64 open, ");

	if ( link_err_reg0 & IOM_LINK_RMSEQ_ERROR)
		printf("link rmseq error, ");

	if ( link_err_reg0 & IOM_UL_CMD_BUF_OVFL)
		printf("uplink cmd buf overflow, ");

	if ( link_err_reg0 & IOM_UL_RESP_BUF_OVFL)
		printf("uplink resp buf overflow, ");

	printf("\n");

	if (link_err_reg0 & IOM_LINK_ERROR) {

		printf("link error: ");

		if (link_err_reg0 & IOM_LINK_STROBE_NOT)
			printf("no strobe, ");

		if (link_err_reg0 & IOM_LINK_DEST_ERROR)
			printf("dest error, ");

		if (link_err_reg0 & IOM_LINK_IOSLOT_ERROR)
			printf("i/o slot error, ");

		if (link_err_reg0 & IOM_LINK_SBSLOT_ERROR)
			printf("sbus slot error, ");

		if (link_err_reg0 & IOM_LINK_TYPE_ERROR)
			printf("type error, ");

		if (link_err_reg0 & IOM_LINK_DATA_ERROR)
			printf("data error, ");

		if (link_err_reg0 & IOM_LINK_ACK_NOT)
			printf("no ack, ");

		if (link_err_reg0 & IOM_LINK_NACK)
			printf("nack, ");

		if (link_err_reg1 & IOM_LINK_SOURCE)
			printf("iom was transmitting, ");

/* FIX joe, possible iosba change needed here. */
		if (link_err_reg1 & IOM_LINK_DESTINATION)
			printf("iom was dest, ");
		else
			printf("IOA was dest, ");

		printf("\n");

/****** NOTE: 
If uplink:
	then  if response or interrupt write write, no meaning.
if downlink
	if read or write no meaing.
otherwise for both:
means 0x10 + dma channel,
*************/
		printf("dma channel 0x%x ", (link_err_reg1 & IOM_LINK_IOSLOT) >>
		  IOM_LINK_IOSLOT_SHIFT);

		printf("type 0%o, ", (link_err_reg1 & IOM_LINK_TYPE) >>
		  IOM_LINK_TYPE_SHIFT);

		if ((link_err_reg1 & IOM_LINK_CMD_DATA_READY_NOT) == 0)
			printf("cmd data ready, ");

		if (link_err_reg1 & IOM_LINK_RESP2OR6_READY)
			printf("resp 2 or 6 ready, ");

		printf("\n");

		printf("sbus slot 0x%x, ", (link_err_reg2 & IOM_LINK_SBSLOT) >>
		  IOM_LINK_SBSLOT_SHIFT);

		if (link_err_reg2 & IOM_LINK_DATA_ERROR_BYTE0)
			printf("error in byte 0, ");
		if (link_err_reg2 & IOM_LINK_DATA_ERROR_BYTE1)
			printf("error in byte 1, ");
		if (link_err_reg2 & IOM_LINK_DATA_ERROR_BYTE2)
			printf("error in byte 2, ");
		if (link_err_reg2 & IOM_LINK_DATA_ERROR_BYTE3)
			printf("error in byte 3, ");

		printf("\n");
	}
	iomap_restore(saved_map);
}

break_out_iom_err_info(iom_slot)
uint	iom_slot;
{
	uint	err_data;
	uint	saved_map;

	if (sbus_config.slot_id[iom_slot] != SBUS_NIOM) {
		printf("Slot %d does not contain an IOM2\n");
		return;
	}

	saved_map = iomap_save();

	if (probe_rd_long((uint *)iomap(iom_slot, IOM_ERROR_REG), &err_data))
		show_iom_err(iom_slot, err_data);
	else {
		printf("Bus error occured reading IOM in slot %d\n", iom_slot);
		iom_unwedge(iom_slot);
	}

	iomap_restore(saved_map);
}

iom_unwedge(iom_slot)
uint	iom_slot;
{
	uint		err_data;
	uint		saved_map;

	char	*str = "Get the IOM error info via a bus reset? (y or n)-> ";

	if (! getyn(str))
		return;
	printf("\n");

	/* kern clock off */
	kern_clock_enable = 0;
	/* no more printfs or tdb */
	/* FIX THIS, DS: need a better method for throttling poll */
	spm_mem_copy_called = 0;

	splhi();
	css_reset();
	half_assed_reenable();
	spl0();

	saved_map = iomap_save();

	if (probe_rd_long((uint *)iomap(iom_slot, IOM_ERROR_REG), &err_data))
		show_iom_err(iom_slot, err_data);
	else
		printf("Still got a bus error reading IOM in slot %d\n",
		  iom_slot);

	iomap_restore(saved_map);
}

/* FIX THIS, DS: add reenabling for IOPMs behind IOSBA's */
half_assed_reenable()
{
	register uint	sbus_slot;

	/* module enable mm's, iom's, iosbas(?) and iopms */
	for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; sbus_slot++) {
		switch (sbus_config.slot_id[sbus_slot]) {
		case  SBUS_NIOM:
			module_enable(sbus_slot);
			interface_enable(sbus_slot);
			break;
		case  SBUS_MM:
			/*
			 * MM's have a bug by which
			 * they NAK control writes.
			 * ignore these NAKs here.
			 */
			css_error_capture(FALSE);
			module_enable(sbus_slot);
			interface_enable(sbus_slot);
			css_error_capture(TRUE);
			break;
		case  SBUS_IOPM:
			interface_enable(sbus_slot);
			break;
		}
	}
}

/*
 * adapter_bd_init -- gets type and initializes adapter boards
 *			returns non-zero on error
 */

uint
adapter_bd_init(iomp, iom_slot)
iom_config_t	*iomp;
register uint	iom_slot;
{
	uint	ex_bd_id;
	uint	saved_map = iomap_save();

	if (!probe_rd_long(iomap(iom_slot, EXTENSION_BD_ID_ADDR), &ex_bd_id)) {
		printf("Can't read EXTENSION_BD_ID_ADDR in IOM %d\n", iom_slot);
		iomap_restore(saved_map);
		return (1);
	}
	ex_bd_id &= EXTENSION_BD_ID_MASK;
	
	switch (ex_bd_id) {
	case IOM_TYPE_IOA:
		printf("Deconfiguring unsupported IOM/IOA in slot %d\n",
		  iom_slot);
		BOARD_DECONFIG(iom_slot);
		iomap_restore(saved_map);
		return (1);
	case IOM_TYPE_IOSBA:
		iomp->card_cage_type = IOM_TYPE_IOSBA;
		iosb_brd_init(iomp);
		break;
	default:
		iomp->card_cage_type = SBUS_NO_BOARD;
		printf("Cannot identify the adapter board connected to\n");
		printf("the IOM in slot: %d!!  ID = 0x%02x\n",
		  iom_slot, ex_bd_id);
		iomap_restore(saved_map);
		return (1);
	}

	iomap_restore(saved_map);		/* restore temp map */
	return (0);
}

/* extention_bus_init() - Bus extention board init.  Returns non-zero on error.
 */

uint
extension_bus_init(iom_ndx)
uint	iom_ndx;	/* Index to relevent IOM data structure. */
{
	switch (iom_config[iom_ndx].card_cage_type) {
	case IOM_TYPE_IOSBA:
		ios_bus_brd_init(iom_ndx);
		return 0;
	default:
		ASSERT(0);			/* IOA not supported anymore */
		/*NOTREACHED*/
	}
	return (1);
}

/*
 * iom_init
 *
 *	initialize an IOM and the IOA behind it; returns non-zero on error
 *
 */

iom_init(iom_num, iom_slot)
register uint	iom_num;
register uint	iom_slot;
{
	register iom_config_t	*iomp;
	uint			saved_map = iomap_save();

	/* check for an illegal configuration */
	if ( iom_num >= NUM_IOM_PER_SYS )
		panic("iom_num >= NUM_IOM_PER_SYS");

	/* mark this one and permanently map it */
	iomp = &iom_config[iom_num];
	iomp->iom_slot = iom_slot;

	/* reset IOM error registers only */

	if (!probe_wr_long(iomap(iom_slot, IOM_ERROR_RESET), 0)) {
		printf("Can't reset IOM %d!\n", iom_slot);
		iomap_restore(saved_map);
		return (1);
	}

	/* program up iom interrupt info and controller interrupt table */

	all_interrupts_to_slot(spm_slot, iom_slot);

	/* iom error interrupt enable */

	/* FIX joe, check this out!! (IOM_MAX_OFFSET_ADDR_EN) */
	if (!probe_wr_long(iomap(iom_slot, IOM_CONTROL_REG),
			   IOM_ERROR_INTR_EN | IOM_MAX_OFFSET_ADDR_EN)) {
		printf("Can't enable interrupts on IOM %d!\n", iom_slot);
		iomap_restore(saved_map);
		return (1);
	}

	/* turn on normal led, enable  IOM to pass IOA interrupts */

	/* FIX joe, check this out!! (IOM_IOA_INTERRUPT_EN) */
	if (!probe_wr_long(iomap(iom_slot, IOM_LINK_CONTROL_REG),
			   IOM_NORMAL_LED | IOM_IOA_INTERRUPT_EN)) {
		printf("Can't light green LED on IOM %d!\n", iom_slot);
		iomap_restore(saved_map);
		return (1);
	}

	if (adapter_bd_init(iomp, iom_slot) || extension_bus_init(iom_num)) {
		iomap_restore(saved_map);
		return (1);
	}

	iomap_restore(saved_map);
	return (0);
}


/* DPM40 NOTE: 'all_interrupts_to_slot()' is called to direct iom interrupts
 * to the spm. Therefore no dpm40 change is needed. */
all_interrupts_to_slot(sbus_slot, iom_slot)
unchar	sbus_slot;
uint	iom_slot;
{
	register disp_int_t	*intp;
	register uint		icb_slot, level, vector;
	disp_int_t		int_request_val;
	uint			saved_map = iomap_save();

	switch (sbus_config.slot_id[sbus_slot]) {
	case SBUS_SPM:
		/* map IOM interrupt vector */
		intp = (disp_int_t *)iomap(iom_slot, IOM_ERROR_INTR_VECTOR);
		int_request_val.entire_32_bits = 0;
		int_request_val.fields.vector = IOM_ERROR;
		int_request_val.fields.directed = DIRECTED;
		int_request_val.fields.level = SPM_DISP_LEVEL_FOUR;
		int_request_val.fields.src_slot = sbus_slot;
		int_request_val.fields.dest_slot = sbus_slot;
		*intp = int_request_val;
		break;

	case SBUS_PM20:
	case SBUS_DPM40_SGL:
	case SBUS_DPM40_DBL:
		break;
		
	default:
		panic("all_interrupts_to_slot: not an SPM or PM type");
	}
	iomap_restore(saved_map);
}

char *
iom_link_id(iom_ndx)
uint	iom_ndx;
{
	ASSERT(iom_ndx < NUM_IOM_PER_SYS);
	switch (iom_config[iom_ndx].card_cage_type) {
	case IOM_TYPE_IOSBA:
		return("IOM/IOSBA");
	case IOM_TYPE_IOA:
		return("IOM/IOA");
	default:
		return("Unidentified");
	}
}

/*
 * show_iom_config() - print the type of boards installed on the expansion bus
 */
show_iom_config(slot)
uint	slot;
{
	register uint		iom_num;
	register uint		iom_css_slot;
	register iom_config_t	*iomp;

	if (slot != SBUS_NO_BOARD) {
		if (slot >= SBUS_NUM_SLOT ||
		    sbus_config.slot_id[slot] != SBUS_NIOM) {
			printf("Invalid IOM slot number %d.\n", slot);
			return;
		}
	}

	iomp = iom_config;
	for (iom_num = 0; iom_num < iom_count; iom_num++, iomp++) {
		iom_css_slot = iomp->iom_slot;
		if (slot != SBUS_NO_BOARD && slot != iom_css_slot)
			continue;

	    	put_char('\n');
		switch (iomp->card_cage_type) {
		case IOM_TYPE_IOSBA:
			show_iosb_config(iom_num, iom_css_slot);
			break;
		}
	}
}

/*
 * find_iom -- return the iom_config_t pointer to the IOM in slot, or NULL
 */

iom_config_t *
find_iom(slot)
uint	slot;
{
	register int	i;
	iom_config_t	*iomp;

	for (iomp = iom_config, i = iom_count; --i >= 0; iomp++)
		if (iomp->iom_slot == slot)
			return (iomp);

	return (NULL);
}

/*
 * iom_ex_bd_type -- return the IOM's expansion board type or -1
 */

iom_ex_bd_type(slot)
uint	slot;
{
	iom_config_t	*iomp;

	if (iomp = find_iom(slot))
		return (iomp->card_cage_type);

	return (-1);
}
