/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sbus.c: version 25.1 created on 11/27/91 at 15:37:28	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sbus.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* sbus.c */

#include "misc.h"
#include "spm.h"
#include "iom_config.h"
#include "cpu_method.h"
#include "novram.h"
#include "sys/types.h"
#include "sys/kmem.h"
#include "spm_debug.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "sys/sbus_pm.h"
#include "sys/sbus_spm.h"
#include "sys/sbus_iopm.h"
#include "sys/own.h"
#include "sys/ints.h"
#include "sbus_conf.h"
#include "setjmp.h"
#include "sys/iopmioctl.h"
#include "slotdefs.h"

extern uint	*interrupt_dispatcher,
		km_used,
		spm_slot,
		first_pm_mapped,
		iom_count,
		first_pm_slot,
		num_pages,
		spm_mem_copy_called;

extern jmp_buf	environbuf;

extern struct sbus_config sbus_config;

extern unchar	*km_map();
extern unchar	*km_pmap();
extern unchar	*iomap();

extern uint	iopm_setup();

/* forward declarations */
void module_enable();
void module_disable();

/* sbus_init() - initialize the system bus
 *
 * poll system bus
 * display slot configuration
 * initialize system boards
 */
sbus_init()
{
	sbus_brds_config();
	init_disp();		/* initialize the dispatcher */
	interrupt_dispatcher = (uint *)piomap(spm_slot, SPM_INT_DISPATCHER);
	/* Sbus boards all tested, configured and ready to go */

	/* Tell us what type of boards we have */
	show_css_config();
	show_iom_config(SBUS_NO_BOARD);
}

sbus_brds_config()
{
	register uint	sbus_slot;

	for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; sbus_slot++) 
		sbus_config_any_slot(sbus_slot);
	check_pm_config();
}

sbus_config_any_slot(sbus_slot)
unchar	sbus_slot;
{
	get_slot_config(sbus_slot);
	sbus_init_brd(sbus_slot);
}

sbus_real_slot_id(sbus_slot)
unchar	sbus_slot;
{
	return(NOVRAM->css_slot[sbus_slot]);
}

get_slot_config(sbus_slot)
unchar	sbus_slot;
{
	sbus_config.slot_id[sbus_slot] = sbus_real_slot_id(sbus_slot);
#if 0	/* FIX MSS, temporary */
	if (sbus_config.slot_id[sbus_slot] == SBUS_IOPM - 1) {
		sbus_config.slot_id[sbus_slot] = SBUS_IOPM;
		css_slot[sbus_slot] = SBUS_IOPM;
	}
#endif
}

#ifdef notdef
/*
 * sbus_get_id()
 *
 * given any SBUS slot, return its SBUS id or SBUS_NO_BOARD
 *
 *  Parameter -	system bus slot to probe
 */
sbus_get_id(sbus_slot)
uint	sbus_slot;
{
	uint	sbus_id;
	uint	saved_map;

	saved_map = iomap_save();		/* save temp map entry */

	if (!probe_rd_long((uint *)iomap(sbus_slot, SBUS_ADDR_ID), &sbus_id))
		sbus_id = SBUS_NO_BOARD;	/* bus error happened */
	else
		switch ( sbus_id &= 0xff )
		{
		    case SBUS_SPM:
		    case SBUS_PM20:
		    case SBUS_DPM40_SGL:
		    case SBUS_DPM40_DBL:
		    case SBUS_MM:
		    case SBUS_IOPM:
		    case SBUS_IOM:
		    case SBUS_NIOM:
			break;
		    default:
			sbus_id = SBUS_NO_BOARD;
		}

	iomap_restore(saved_map);		/* restore temp map */
	return(sbus_id);
}
#endif /* notdef */

/*
 * sbus_init_brd - initialize board in any slot
 *
 */
sbus_init_brd(sbus_slot)
unchar	sbus_slot;
{
	sbus_config.dev_board_id[sbus_slot] = IOPM_NO_DB;
	switch (sbus_config.slot_id[sbus_slot]) {
	case SBUS_SPM:
		spm_setup(sbus_slot);
		break;
	case SBUS_MM:
		sbus_config.slot_size[sbus_slot] = mm_init(sbus_slot);
		break;
	case SBUS_IOPM:
		sbus_config.dev_board_id[sbus_slot] =
		  iopm_setup(sbus_slot);
		break;
	case SBUS_PM20:
		if (pm20_setup(sbus_slot))
			break;
#if 0
		if (first_pm_mapped == 0)
			first_pm_init(sbus_slot);
#endif
		break;
	case SBUS_DPM40_SGL:
	case SBUS_DPM40_DBL:
		dpm40_setup(sbus_slot);
#if 0
		first_pm_init(sbus_slot);
#endif
		break;
	case SBUS_IOM:		/* I/O Module */
		printf("WARNING:  Unsupported IOM in slot %d\n", sbus_slot);
		break;
	case SBUS_NIOM:		/* I/O Module */
		if (iom_init(iom_count, sbus_slot))
			break;
#if 0
/* FIX JPC: this duplicates code in iom_init -- what gives?? */
		adapter_bd_init(iom_count, sbus_slot); /* IOM or IOSBA*/
		extension_bus_init(iom_count);	   /* ICB or CSS-type */
#endif
		iom_count++; /* global var */
		break;
	case SBUS_NO_BOARD:
		break;
	}
}

/* FIX declan - not sure where this routine should go */
check_pm_config()
{
	int	pm20_found = 0, dpm40_found = 0;
	uint	sbus_slot;

	for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; sbus_slot++) {
		switch (sbus_config.slot_id[sbus_slot]) {
			case SBUS_PM20:
				pm20_found = 1;
				break;
			case SBUS_DPM40_SGL:
			case SBUS_DPM40_DBL:
				dpm40_found = 1;
				break;
		}
	}

	if (!pm20_found || !dpm40_found)
		return;

	/* must deconfigure pm20s */
	printf("PM20 and DPM40 can't coexist\n");
	for (sbus_slot = 0; sbus_slot != SBUS_NUM_SLOT; sbus_slot++)
		if (sbus_config.slot_id[sbus_slot] == SBUS_PM20) {
			cpu_set_slot(NULL, MAKE_SNS(sbus_slot, NO_SUB_SLOT));
			CPU_deconfigure();
		}
}

#if 0
/*
 * first_pm_init(sbus_slot)
 *
 *	maps the first PM's command register for clock interrupts. If this
 *	is called again, then remap the new PM slot in the previously used
 *	map entry.
 *
 * Parameter:
 *
 *	sbus_slot the PM is located
 */
first_pm_init(sbus_slot)
	uint	sbus_slot;
{
	first_pm_mapped = 1;
	first_pm_slot = sbus_slot;
}
#endif

/*
 * sbus_mem_clear() - clear system memory pages to zero
 */
sbus_mem_clear()
{
	register uint	slot;

	printf("\ninitializing memory....");

	for (slot = 0; slot < SBUS_NUM_SLOT; slot++)
		if (sbus_config.slot_id[slot] == SBUS_MM)
			mm_clear(slot);

	printf("done\n");
}

/*
 * km_clear() - clear kernel virtual memory
 */
km_clear(kv_addr, size)
register uint	kv_addr;
register int	size;
{
	register uint	count;
	register uint	saved_map = iomap_save();

	/* NOTE!  assumes all PM's pages are the same size */

	/* first clear to end of page */
	count = MIN(MIN(NBPP, size), NBPP - poff(kv_addr));

	while (size > 0) {
		bzero(km_map(kv_addr), count);	/* bzero(addr,size) */
		size -= count;
		kv_addr += count;
		count = MIN(NBPP, size);
	}
	iomap_restore(saved_map);
	return (0);
}

/* iom_data_mem_copy(iom) - Update spm_mem using local configuration 
 * information.
 */

iom_data_mem_copy()
{
	bcopy((caddr_t)iom_config, (caddr_t)Spm_Mem->iom_config,
	      sizeof(Spm_Mem->iom_config));
}

css_config_mem_copy()
{
	int	sbus_slot;

#define s_copy(src, dest)	bcopy((caddr_t)src, (caddr_t)dest, sizeof(dest))

	/* Note:  make sure the sizes of these arrays stay the same! */
	s_copy(sbus_config.slot_id, Spm_Mem->sbus_slot_id);
	s_copy(sbus_config.dev_board_id, Spm_Mem->dev_board_id);
	s_copy(sbus_config.slot_size, Spm_Mem->slot_size);
	s_copy(sbus_config.pfn_adjust, Spm_Mem->pfn_adjust);
	s_copy(sbus_config.lpfn_end, Spm_Mem->lpfn_end);
	s_copy(sbus_config.pm_own, Spm_Mem->pm_own);

	Spm_Mem->num_pm = 0;
	sbus_slot = SBUS_NUM_SLOT;
	while (--sbus_slot >= 0) {
		switch (sbus_config.slot_id[sbus_slot]) {
		case SBUS_DPM40_DBL:
			Spm_Mem->num_pm += 2;
			break;
		case SBUS_PM20:
		case SBUS_DPM40_SGL:
			Spm_Mem->num_pm += 1;
			break;
		}
	}
}

kmem_data_mem_copy()
{
	Spm_Mem->spm_mem_used = km_used - MAINSTORE;
	Spm_Mem->invalid_qde.qde_all = sbus_config.invalid_qde;
	Spm_Mem->invalid_rde.rde_all = sbus_config.invalid_rde;
	Spm_Mem->invalid_sde.sg_sge = sbus_config.invalid_sde;
	Spm_Mem->iopm_stbl = (sde_t *)sbus_config.iopm_stbl;
	Spm_Mem->mem_ptbl = (pde_t *)sbus_config.mem_ptbl;
	Spm_Mem->lpfn_tbl = sbus_config.lpfn_tbl;
	Spm_Mem->kv_iomap = (uint *)sbus_config.kv_iomap;
}

int_data_mem_copy()
{
	disp_int_t	int_data;

	int_data.fields.vector = KERNEL_TO_SPM_CMD;
	int_data.fields.directed = DIRECTED;
	int_data.fields.level = SPM_DISP_LEVEL_FOUR;
	int_data.fields.dest_slot = spm_slot;
	Spm_Mem->kern2spm_int = int_data;

	/* spm sends interrupt, gets an SPM_TO_KERNEL_DONE back */
	int_data.fields.vector = SPM_TO_KERNEL_DONE;
	Spm_Mem->spm2kern_done = int_data;

	int_data.fields.vector = KERNEL_TO_SPM_OUTPUT;
	Spm_Mem->console.spm_output_int  = int_data;
}

/*
 * spm_mem_copy() - copy a local configuration structure to the SPM's
 *		    kernel interface structure. Also assign a fixed map
 *		    for this structure.
 */  
spm_mem_copy()
{
	char	*p;
	iunit_t	unit;

	if (num_pages == 0) {     /* If no memory, bail. */
		printf("spm_mem_copy() -  No memory boards\n");
		rtn_to_monitor();
	}

	bzero((caddr_t)Spm_Mem, NBPP);

	css_config_mem_copy();	/* Set up main css bus conf info in spm_mem. */

	kmem_data_mem_copy();	/* Access to mem management data in spm_mem. */

	Spm_Mem->spm_slot = spm_slot;

	/* If there are any IOM's initialize IOM specific SPM mem. */
	if (iom_count)  
		iom_data_mem_copy();

	Spm_Mem->spm_version = SPM_MEM_VERSION;


	int_data_mem_copy();	/* Set up interrupt data and copy to spm_mem. */

	Spm_Mem->cache_off = sbus_config.cache_off; /* Used in past for cache dbug. */

	Spm_Mem->rootdev = sbus_config.rootdev;
	Spm_Mem->swapdev = sbus_config.swapdev;

	Spm_Mem->num_pages = num_pages;
	Spm_Mem->cpu_type = sbus_config.cpu_type;
		/* get_device_info had better succeed if it got this far... */
	(void) get_device_info(NOVRAM->kernel_boot_disk, &unit, &p);
	strncpy(Spm_Mem->kern_name, p, sizeof(Spm_Mem->kern_name) - 1);
	Spm_Mem->next_lock_id = SBUS_MAX_NUM_PM;

	Spm_Mem->spm_time = rtc_time();
	spm_mem_syms();

	spm_mem_copy_called = TRUE;
}

/* DPM40 CHANGE: add for the case of dpm40. */
/* hanna FIX: i think this is ok  and needs no change */
int_to_first_pm(pm_slot)
uint		pm_slot;
{
	uint	sbus_slot;
	uint	iom_num;

	iom_num = 0;

	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {
		if (sbus_config.slot_id[sbus_slot] == SBUS_NIOM)
			all_interrupts_to_slot(pm_slot, sbus_slot, iom_num++);
	}
}

/* DPM40 CHANGE: add for the case of dpm40. */
interface_enable(sbus_slot)
uint	sbus_slot;
{
	register uint	saved_map = iomap_save();
	register uint *addr;

	addr = (uint *)iomap(sbus_slot, SBUS_ADDR_ID);

	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE); /*clear the force responce bit. */

	/* Enable css bus interface with module */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | BUSTALK_ENABLE;
	probe_wr_long(addr, 0);		/* send any data, it's ignored */

	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE); /* turn off forced stuff. */
	delay_no_poll(100);

	iomap_restore(saved_map);
}

void
module_disable(slot) /* used to disable io boards */
uint	slot;
{
	register uint  *addr;
	uint           savmap = iomap_save();
	ushort         savspl;

	/* disable any module plugged into css bus */
	addr = (uint *)iomap(slot, SBUS_ADDR_ID);
	savspl = splhi();

	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE);       /* cause control write */
	*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | MODULE_DISABLE;
	probe_wr_long(addr, 0);	 		/* send data, it's ignored */
	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE);      /* turn off forced stuff */
	delay_no_poll(100);

	splx(savspl);
	iomap_restore(savmap);
}

void
module_enable(slot) /* used to enable io cards only? */
uint	slot;
{
	register uint  *addr;
	uint           savmap = iomap_save();
	ushort         savspl;

	/* enable any module plugged into css bus */
	savmap = iomap_save();
	addr = (uint *)iomap(slot, SBUS_ADDR_ID);
	savspl = splhi();

	*WRCNTL1 &= ~(WR1_FRES | WR1_UFTYPE);       /* cause control write */ 
	*WRCNTL0 = (*WRCNTL0 & ~WR0_FTYPE_MASK) | MODULE_ENABLE;
	probe_wr_long(addr, 0);			/* send data, it's ignored */
	*WRCNTL1 |= (WR1_FRES | WR1_UFTYPE); 	  /* turn off forced stuff */
	delay_no_poll(100);

	splx(savspl);
	iomap_restore(savmap);
}

extern void	ios_bus_module_dis();
extern void	ios_bus_module_en();
void
enable_any_module(sns)
uint	sns;
{
	if (SUB_SLOT_FM_SNS(sns) == NO_SUB_SLOT)
		module_enable(SLOT_FM_SNS(sns));
	else
		ios_bus_module_en(SLOT_FM_SNS(sns), SUB_SLOT_FM_SNS(sns));
}

void
disable_any_module(sns)
uint	sns;
{
	if (SUB_SLOT_FM_SNS(sns) == NO_SUB_SLOT)
		module_disable(SLOT_FM_SNS(sns));
	else
		ios_bus_module_dis(SLOT_FM_SNS(sns), SUB_SLOT_FM_SNS(sns));
}

/*
 * warning: resetting the css resets all boards except for the spm
 */

css_reset()
{
	printf("Resetting CSS\n");
	*WRCNTL1 &= ~WR1_CSSRST;		/* and assert it. */
	delay_no_poll(750);
	*WRCNTL1 |= WR1_CSSRST;			/* and assert it. */
	delay_no_poll(750);
}
