/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mm.c: version 25.1 created on 11/27/91 at 15:37:19	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mm.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* mm.c -- memory module routines */ 

#include "sys/types.h"
#include "misc.h"
#include "sbus_mm.h"
#include "sbus_conf.h"
#include "error.h"
#include "sys/types.h"
#include "spm_debug.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/lio.h"
/*	#include "sys/icb.h"	*/
#include "sys/kmem.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "sys/sbus_spm.h"
#include "sys/immu.h"
#include "sys/ints.h"
#include "error.h"

extern uint	spm_slot;
extern uint	error_head, error_tail;
extern struct error error[ERROR_SIZE];

/*
 * mm_init
 *
 *	intialize a memory module in a give slot.
 *
 *	Enable EDAC, parity checking, interrupt generation.
 *
 *	Turn off Red LED, and turn on Green LED.
 *
 * Return:
 *
 *	Number of bytes of memory on card.
 */

mm_init(sbus_slot_id)
register uint	sbus_slot_id;
{
	register uint	*mm_reg;
	register uint	mm_status;
	uint		mm_chip_size;
	uint		mm_total_bytes;
	uint		saved_map = iomap_save();
	disp_int_t	mm_int_info;

	mm_reg = (uint *)iomap(sbus_slot_id, MM_STATUS_REG);

	mm_status = *mm_reg;

	/* 4Mbit Rams if true, else 1Mbit rams */

	if ( mm_status & MM_4MBIT_RAM )
		mm_chip_size = 4;
	else
		mm_chip_size = 1;

	if ((mm_status & MM_STUFFING_MASK) == MM_FULLY_STUFFED)
		mm_total_bytes =  mm_chip_size * MM_FULL_COUNT;
	else if ((mm_status & MM_STUFFING_MASK) == MM_HALF_STUFFED)
		mm_total_bytes = mm_chip_size * MM_HALF_COUNT;
	else if ((mm_status & MM_STUFFING_MASK) == MM_QUARTER_STUFFED)
		mm_total_bytes = mm_chip_size * MM_QUARTER_COUNT;
	else if ((mm_status & MM_STUFFING_MASK) == MM_EIGTH_STUFFED)
		mm_total_bytes = mm_chip_size * MM_EIGTH_COUNT;
	else if ((mm_status & MM_STUFFING_MASK) == MM_SIXTEENTH_STUFFED)
		mm_total_bytes = mm_chip_size * MM_SIXTEENTH_COUNT;
	else {
		printf("Error on MM in slot %x, 0 bytes memory\n",sbus_slot_id);
		mm_total_bytes = 0;
	}

	/* if there was an error sizing memory light the red led only */

	if ( mm_total_bytes == 0 ) {
		mm_reg = (uint *)iomap(sbus_slot_id, MM_CONTROL_REG);
		*mm_reg = MM_GREEN_LED_OFF;
		iomap_restore(saved_map);
		return (0);
	}

	/*
	 * program up the interrupt information register:
	 *
	 */

	mm_reg = (uint *)iomap(sbus_slot_id, MM_INT_INFO_REG);

	mm_int_info.entire_32_bits = 0;
	mm_int_info.fields.vector = MM_INTERRUPT;
	mm_int_info.fields.directed = DIRECTED;
	mm_int_info.fields.level = SPM_DISP_LEVEL_FOUR;
	mm_int_info.fields.dest_slot = spm_slot;
	/* This is a kludge. */
	mm_int_info.entire_32_bits |= SPM_INT_DISPATCHER & MM_INT_ADDR_MASK;

	*mm_reg = mm_int_info.entire_32_bits;

	mm_reg = (uint *)iomap(sbus_slot_id, MM_CONTROL_REG);

	/*
	 * Enable EDAC.  NOTE: we are enabling EDAC before we have
	 * initialized memory.  Thus the first access to each location
	 * MUST be a long-word write or we will get EDAC errors.
	 * This is fine, as the first thing we should be doing with
	 * memory is clearing it.
	 *
	 * Enable MM to send an interrupt for errors.
	 *
	 * Light the green led for normal operation
	 */

	*(char *)mm_reg = MM_RED_LED_OFF | MM_GREEN_LED_ON | MM_EDAC_ENABLE
		| MM_ERR_INT_ENABLE;

	iomap_restore(saved_map);

	return (mm_total_bytes);
}

/*
 * mm_interrupt:
 *
 *	handle a memory module error interrupt.
 *
 *	read error information and error address which will
 *	re-enable interrupts.
 *
 *	To run on SPM:
 *
 *		The SPM should read the two registers, then log the error
 *		for itself, and then pass the error along to a processor
 *		module so that the kernel can log the error in its unix
 *		error logging facility.
 *
 */

mm_interrupt(mm_slot)
register uint	mm_slot;
{
	register uint	*mm_reg;
	register uint	tmp;
	uint		saved_map = iomap_save();
	uint		mm_err_info, mm_err_addr;

	/*
	 * This register must be read first, as the err info register
	 * resets the error capturing.
	 */

	/* read memory error address register */

	mm_reg = (uint *)iomap(mm_slot, MM_ERR_ADDR_REG);
	mm_err_addr = *mm_reg;

	/* read memory error information register */

	mm_reg = (uint *)iomap(mm_slot, MM_ERR_INFO_REG);
	mm_err_info = *mm_reg;

	/* increase tail pointer */
	tmp = (error_tail == ERROR_SIZE) ? 0 : error_tail + 1;
	if(tmp != error_head) {
		error[error_tail].type = MEM_ERR;
		error[error_tail].data.mm.slot = mm_slot;
		error[error_tail].data.mm.addr_reg = mm_err_addr;
		error[error_tail].data.mm.info_reg = mm_err_info;
		error_tail = tmp;
	}
	iomap_restore(saved_map);
}


show_mm_err(mm_slot, mm_err_addr, mm_err_info )
register uint	mm_slot;
register uint	mm_err_addr;
register uint	mm_err_info;
{
	put_char('\n');
	print_time_stamp(0);
	printf(
	    "Memory Module Error in slot 0x%x, location 0x%x, error reg 0x%x\n",
		mm_slot, GET_MM_ERR_ADDR(mm_err_addr),mm_err_info);

	/*
	 * If a multiple bit error is seen, then single
	 * bit errors should not be checked for.
	 */

	if ((mm_err_info & MM_A0_MB_ERR) == MM_ERROR) {
		printf("Array 0 Uncorrectable Error, Syndrome 0x%x\n",
		  GET_A0_SYNDROME(mm_err_info));
		mm_break_out_err_info(GET_A0_ERR_INFO(mm_err_info));
	}
	else if ((mm_err_info & MM_A1_MB_ERR) == MM_ERROR) {
		printf("Array 1 Uncorrectable Error, Syndrome 0x%x\n",
		  GET_A1_SYNDROME(mm_err_info));
		mm_break_out_err_info(GET_A1_ERR_INFO(mm_err_info));
	}
	else if ((mm_err_info & MM_A0_SB_ERR) == MM_ERROR) {
		printf("Array 0 Single Bit Corrected Error, Syndrome 0x%x\n",
		  GET_A0_SYNDROME(mm_err_info));
		mm_break_out_err_info(GET_A0_ERR_INFO(mm_err_info));
	}
	else if ( (mm_err_info & MM_A1_SB_ERR) == MM_ERROR ) {
		printf("Array 1 Single Bit Corrected Error, Syndrome 0x%x\n",
		  GET_A1_SYNDROME(mm_err_info));
		mm_break_out_err_info(GET_A1_ERR_INFO(mm_err_info));
	}
}


/*
 * mm_break_out_err_info
 *
 * Parameter:
 *
 *	The right shifted bits directly out of the error information field.
 *	Thus the slot id bits are active high, while the other 3 bits of info
 *	are active low. (yuck).
 */

mm_break_out_err_info(mm_err_info)
register uint	mm_err_info;
{
	printf("CSS slot 0x%x, ", GET_SLOT_FROM_ERR_INFO(mm_err_info));

	if (!(mm_err_info & MM_READ_ERROR) == MM_ERROR) {
		printf("write error\n");
		return;
	}

	/* otherwise it was a read error */

	if ((mm_err_info & MM_READ_32_ERROR) == MM_ERROR)
		printf("read 32 error\n");
	else if ((mm_err_info & MM_READ_16_ERROR) == MM_ERROR)
		printf("read 16 error\n");
	else
		printf("read 8 error\n");
}

/*
 * mm_clear -- bzero all memory on a MM -- gets more complicated with new MMs
 */

mm_clear(slot)
uint	slot;
{
	uint	save = iomap_save();

	ASSERT(sbus_config.slot_id[slot] == SBUS_MM);
	bzero((caddr_t)iomap(slot, 0), sbus_config.slot_size[slot]);

	iomap_restore(save);
}
