/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) config.c: version 25.1 created on 11/27/91 at 15:37:12	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)config.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* config.c */

#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "rwi.h"
#include "param.h"
#include "menu.h"
#include "novram.h"
#include "iom_config.h"
/*	#include "icb_config.h"	*/
#include "slotdefs.h"

extern char	*frac_str();
extern char	*iom_link_id(); /* returns string representing iom link type */
extern void	show_iom_config();

void
show_css_config()
{
	register uint	sbus_slot, nov_id, sbus_id;
	register uint	local_iom_count = 0;

	printf("\n");
	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {
		switch (nov_id = NOVRAM->css_slot[sbus_slot]) {
		case SBUS_SPM:
			printf("SPM         ");
			break;
		case SBUS_MM:
			printf("MM (%2d Meg) ",
			  sbus_config.slot_size[sbus_slot] / (1024 * 1024));
			break;
		case SBUS_DPM40_DBL:
			printf("DPM40_DBL   ");
			break;
		case SBUS_DPM40_SGL:
			printf("DPM40_SGL   ");
			break;
		case SBUS_PM20:
			printf("PM20        ");
			break;
		case SBUS_IOM:
			printf("obsolete IOM");
			break;
		case SBUS_NIOM:
			printf("%-12s", iom_link_id(local_iom_count++));
			break;
		case SBUS_IOPM:
		case (SBUS_IOPM-1):		/* FIX MSS, remove */
			printf("%s", iopm_id_str(sbus_slot, NO_SUB_SLOT));
			break;
		case SBUS_NO_BOARD:
			continue;
		default:
			printf("Unknown 0x%02x", NOVRAM->css_slot[sbus_slot]);
			break;
		}
		printf(" module in slot %u", sbus_slot);
		sbus_id = sbus_config.slot_id[sbus_slot];
		if (nov_id == sbus_id)
			put_char('\n');
		else if (sbus_id == SBUS_NO_BOARD)
			printf(" is deconfigured\n");
		else if (nov_id == SBUS_DPM40_DBL && sbus_id == SBUS_DPM40_SGL)
			printf(" (CPU B deconfigured)\n");
		else
			printf(", does not match sbus_config! [0x%02x]\n",
			  sbus_id);
	}
}

show_config(arg_cnt)
int	arg_cnt;
{
	uint	slot;

	if (arg_cnt == 0) {
		show_css_config();
		show_iom_config(SBUS_NO_BOARD);
	}
	else if (arg_cnt) { 
		if (!strcmp (comm_args[1], "css"))
			show_css_config();
		else if (!strcmp(comm_args[1], "iom")) {
			if (arg_cnt == 2)
				slot = atoi(comm_args[2]); 
			else
				slot = SBUS_NO_BOARD;	/* show all IOMs */
			show_iom_config(slot);
		}
		else {
			printf("Illegal argument: '%s' Use 'css'",
			  comm_args[1]);
			printf(" or 'iom'. ('iom' has optional slot #)\n");
		}
	}
}

show_power_config()
{
	register uint num;

	printf("\n");
	for (num = 0; num < NUM_PS_PER_SYS; num++) {
		switch (NOVRAM->main_pwr[num].ps_id) {
		case SWITCHING_POWER:
			printf("power supply %d type is Switching Power\n",
			  num);
			break;
		case HC_POWER:
			printf("power supply %d type is HC Power\n", num);
			break;
		case NO_POWER_SUPPLY:
			break;
		default:
			printf("power supply %d is an unknown type %d\n",
			  num, NOVRAM->main_pwr[num].ps_id);
			break;
		}
	}
}

show_devices()
{
	printf("\n");
	printf("SPM PROM default filename:    %s\n", NOVRAM->spm_boot_disk);
	printf("SPM Runtime default filename: %s\n", NOVRAM->sa_boot_disk);
	printf("Kernel default filename:      %s\n", NOVRAM->kernel_boot_disk);
	printf("\n");
}

show_baud_rate()
{
	printf("\nDefault SPM port baud rates are:\n\n");
	printf("Console port : %d\n", NOVRAM->console_baud_rate);
	printf("Modem port   : %d\n", NOVRAM->modem_baud_rate);
	printf("Printer port : %d\n", NOVRAM->printer_baud_rate);
}

show_cab_info()
{
	register uint num;

	printf("\nCabinets Present:\n\n");
	for (num = 0; num < NUM_CAB_PER_SYS; num++) {
		if (NOVRAM->cab_present[num].present)
			printf("Cabinet %d\n", num);
	}
	printf("\n");
}

show_limit_info()
{
	printf("                    WARNING/SHUTDOWN RANGE LIMITS\n");
	printf("                    -----------------------------\n\n");
	printf("               shutdown   warning    warning   shutdown\n");
	do_limit_fmt(INLET_AIR, &NOVRAM->inlet_air_shutdown,
	  &NOVRAM->inlet_air_warning, "Inlet Air", 'C');
	do_limit_fmt(EXHAUST_AIR, &NOVRAM->exhaust_air_shutdown,
	  &NOVRAM->exhaust_air_warning, "Exhaust Air", 'C');
	do_limit_fmt(PS_TEMP, &NOVRAM->main_ps_temp_shutdown,
	  &NOVRAM->main_ps_temp_warning, "Pwr Supply Temp", 'C');
	printf("cage air delta    -          -       %s C       -\n",
	  frac_str(CAGE_AIR, NOVRAM->cage_air_delta));
	do_limit_fmt(MAIN_FIVE_VOLT, &NOVRAM->five_volt_shutdown,
	  &NOVRAM->five_volt_warning, "Main 5 V", 'V');
	do_limit_fmt(MAIN_TWELVE_VOLT, &NOVRAM->twelve_volt_shutdown,
	  &NOVRAM->twelve_volt_warning, "Main 12 V", 'V');
	do_limit_fmt(MAIN_NEG_TWELVE_VOLT, &NOVRAM->neg_twelve_volt_shutdown,
	  &NOVRAM->neg_twelve_volt_warning, "Main -12 V", 'V');
}

/*
 * do_limit_fmt -- print out a single limit range
 */

static
do_limit_fmt(type, shutp, warnp, name, unit)
register uint		type;
register limit_t	*shutp, *warnp;
char			*name, unit;
{
	register int	u = unit;

	printf("%-15s%s %c    %s %c    %s %c    %s %c\n",
	  name,
	  frac_str(type, shutp->low),  u, frac_str(type, warnp->low),  u,
	  frac_str(type, warnp->high), u, frac_str(type, shutp->high), u);
}

void
show_iosb_config(iom_ndx, iom_slot)
uint	iom_ndx;	/* Logical iom -- iom location in data structure. */
uint	iom_slot;	/* Iom location in the main cabinet. */
{
	register uint	sbus_slot;
	css_bd_dat_t	*cbp;

	/* used for code-readability */
	cbp = iom_config[iom_ndx].ex_card_cage.css_bd_dat;

	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++, cbp++) {
		switch (cbp->css_slot_id) {
		case SBUS_IOPM:
			printf("%s", iopm_id_str(iom_slot, sbus_slot));
			break;
		case SBUS_NO_BOARD:
			continue;
		default:
			printf("Unknown 0x%02x ", cbp->dev_board_id);
			break;
		}

		printf(" module, IOM %u, CSS slot %u, IOSB slot %u (%u/%u)",
		  iom_ndx, iom_slot, sbus_slot, iom_slot, sbus_slot);

		if (cbp->dev_board_id == SBUS_NO_BOARD)
			printf(" is deconfigured");

		printf("\n");
	}
}


/*
 * prompt_line -- prompt for and get a line of input
 */

prompt_line(buf, buflen, prompt)
char	*buf, *prompt;
uint	buflen;
{
	extern char		*getsss();

	printf("%s", prompt);
	*buf = '\0';
	(void) getsss(buf, buflen);
}

/*
 * parse_frac -- parse a line for a fractional number:  [-]nnn.nn
 *		returns 0 for null string, -1 on bad char, 1 for good number
 */

parse_frac(str, fnump)
register char	*str;
register frac_t	*fnump;
{
	register int	c, num;
	int		neg = 0;

	while (isspace(*str))		/* skip leading white space */
		str++;

	if ((c = *str) == '-') {
		neg = 1;
		c = *++str;
	}

	if (!isdigit(c))
		return (-1);

	for (num = 0; isdigit(c); c = *++str)
		num = num * 10 + c - '0';

	fnump->number = neg ? -num : num;
	fnump->tenths = 0;
	fnump->hundredths = 0;

	if (c == '\0')
		return (1);
	if (c != '.')
		return (-1);

	if (isdigit(c = *++str))
		fnump->tenths = c - '0';
	if (isdigit(c = *str))
		fnump->hundredths = c - '0';

	return (1);
}

/*
 * get_frac -- prompt for and get a line of input, then parse it for a number
 *		returns -1 on error, 0 for null string, 1 for a good number
 */

get_frac(fnump, prompt)
frac_t	*fnump;
char	*prompt;
{
	int	ret;
	char	line[256];

	prompt_line(line, sizeof(line), prompt);

	if (*line == '\0')
		return (0);

	if ((ret = parse_frac(line, fnump)) < 0) {
		printf("Invalid number '%s'.  Use [-]nnn.nn\n", line);
		return (-1);
	}
	return (ret);
}

/*
 * do_frac -- get a frac number and convert it
 *	returns BAD_UINT on error or no num
 */

uint
do_frac(type, prompt)
uint	type;
char	*prompt;
{
	int	i;
	uint	num, convert_frac();
	frac_t	fnum;

	if ((i = get_frac(&fnum, prompt)) < 0)
		return (BAD_UINT);
	if (i > 0) {
		if ((num = convert_frac(type, &fnum)) == BAD_UINT) {
			printf("Bad conversion.\n");
			return (BAD_UINT);
		}
	}
	else
		return (BAD_UINT);

	return (num);
}

/*
 * print_lim_fmt -- print out a formated version of the limit
 */

print_lim_fmt(limp, type, name)
limit_t	*limp;
uint	type;
char	*name;
{
	char	*lowp, *highp;

	lowp  = frac_str(type, limp->low);

	if (type == EXHAUST_DELTA)
		printf("%-30s limit = %s [%02x]\n", name, lowp, limp->low);
	else {
		highp = frac_str(type, limp->high);
		printf("%-30s low = %s [%02x],  high = %s [%02x]\n",
		  name, lowp, limp->low, highp, limp->high);
	}
}

/*
 * set_limits -- display limit numbers, or set warning/shutdown limits
 */

static
set_limits(arg_cnt)
uint	arg_cnt;
{
	register int		i;
	register uint		n;
	register limit_t	*limp;
	limit_t			temp;

	extern uint		do_frac();

	typedef struct s_lim {
		char	*name;
		uint	type;
	} s_lim_t;

	register s_lim_t	*slp;

	/*
	 * NOTE:  these are in the same order as the limit structs in novram_t!
	 */
	static s_lim_t	lim_lst[] = {
		{ "Inlet Air Warning",		INLET_AIR },
		{ "Inlet Air Shutdown",		INLET_AIR },
		{ "Exhaust Air Warning",	EXHAUST_AIR },
		{ "Exhaust Air Shutdown",	EXHAUST_AIR },
		{ "Main PS Temp Warning",	PS_TEMP },
		{ "Main PS Temp Shutdown",	PS_TEMP },
		{ "Five Volt Warning",		MAIN_FIVE_VOLT },
		{ "Five Volt Shutdown",		MAIN_FIVE_VOLT },
		{ "Twelve Volt Warning",	MAIN_TWELVE_VOLT },
		{ "Twelve Volt Shutdown",	MAIN_TWELVE_VOLT },
		{ "Neg Twelve Volt Warning",	MAIN_NEG_TWELVE_VOLT },
		{ "Neg Twelve Volt Shutdown",	MAIN_NEG_TWELVE_VOLT },
		{ "Five Volt Current",		999 },
		{ "Cage Air Warning",		CAGE_AIR },
		{ "Cage Air Shutdown",		CAGE_AIR },
		{ "Cage Air Delta",		EXHAUST_DELTA }
	};

	if (arg_cnt == 0) {
		printf("\n\t\tLimit Numbers\n\n");
		for (i = 0, slp = lim_lst; i < NEL(lim_lst); i++, slp++) {
			printf("%02x) %-30s", i, slp->name);
			if (++i >= NEL(lim_lst))
				break;
			printf("%02x) %s\n", i, (++slp)->name);
		}
		printf("\n");
		return;
	}

	n = Atox(comm_args[1]);
	if (n >= NEL(lim_lst)) {
		printf("Invalid limit number = %x.  Use 0 to %x.\n",
		  n, NEL(lim_lst) - 1);
		return;
	}

	slp = &lim_lst[n];
	if (slp->type == 999) {
		printf("Sorry -- can't set limit '%s' yet.\n", slp->name);
		return;
	}

	limp = &NOVRAM->nv_lim[n];
	print_lim_fmt(limp, slp->type, slp->name);

	temp = *limp;
	i = 0;
	if (slp->type == EXHAUST_DELTA) {
		if ((n = do_frac(slp->type, "Limit: ")) != BAD_UINT) {
			++i;
			temp.low = n;
		}
	}
	else {
		if ((n = do_frac(slp->type, "Low:   ")) != BAD_UINT) {
			++i;
			temp.low = n;
		}
		if ((n = do_frac(slp->type, "High:  ")) != BAD_UINT) {
			++i;
			temp.high = n;
		}
		else
			i = 0;
	}
	if (i) {
		*limp = temp;
		/* shared_crc(); */
	}

	print_lim_fmt(limp, slp->type, slp->name);
}

struct init_menu i_system_config[] = {
 { "show",	"<css/iom> - show CSS/IOM configuration",
   MF_EXPERT, 0, 1, show_config },
 { "power",	"- show power supply configuration",
   MF_EXPERT, 0, 0, show_power_config },
 { "dev(ices)",	"- display default boot devices",
   MF_EXPERT, 0, 0, show_devices },
 { "baud",	"- display default spm port baud rates",
   MF_EXPERT, 0, 0, show_baud_rate },
 { "cabs",	"- display cabinet information",
   MF_EXPERT, 0, 1, show_cab_info },
 { "limits",	"- display warning/shutdown limits",
   MF_EXPERT, 0, 0, show_limit_info },
 { "setlim",	"<lim_num> - set warning/shutdown limits",
   MF_EXPERT, 0, 1, set_limits },
 { 0 }
};
