/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) cio.c: version 25.1 created on 11/27/91 at 15:37:08	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)cio.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:cio.c	25.1"

/* cio.c */

#include "misc.h"
#include "sys/types.h"
#include "spm.h"
#include "cio.h"

/*
 * initcio() - initializes the local CIO as follows:
 *
 *		Timer channel 1 generates interrupts at 20msec intervals
 *		Timer channel 2 generates interrupts at 500usec intervals
 */
initcio()
{
	LOCCIO->mic.reg = C_RESET;		/* software reset	*/
	LOCCIO->mic.reg = 0;			/* take away the reset	*/
	LOCCIO->mic.reg = C_CTVIS;		/* vector includes status */
	LOCCIO->ctivect.reg = LOC_CIO_INTERRUPT_VECTOR; /* interrupt vector */

	/* channel 1 */
	LOCCIO->ctmode[0].reg = CT_CONT;	/* continuous single cycle */
	LOCCIO->ctcs[0].reg = ICW_CPUS;		/* clear int pend & serv */
	LOCCIO->ctcs[0].reg = ICW_SIE;		/* interrupt enable	*/

	/* 20msec time constant */
	LOCCIO->cttc[0].tcmsb.reg = (LOC_CIO_TIMER0_TC >> 8) & 0xff;
	LOCCIO->cttc[0].tclsb.reg = LOC_CIO_TIMER0_TC & 0xff;

	/* channel 2 */
	LOCCIO->ctmode[1].reg = CT_CONT;	/* continuous single cycle */
	LOCCIO->ctcs[1].reg = ICW_CPUS;		/* clear int pend & serv */
	LOCCIO->ctcs[1].reg = ICW_SIE;		/* interrupt enable	*/

	/* 500usec time constant */
	LOCCIO->cttc[1].tcmsb.reg = (LOC_CIO_TIMER1_TC >> 8) & 0xff;
	LOCCIO->cttc[1].tclsb.reg = LOC_CIO_TIMER1_TC & 0xff;

	/* channel 3 */
	LOCCIO->ctcs[2].reg = ICW_CIE;		/* interrupt disable	*/

	LOCCIO->mcc.reg = C_CT1E | C_CT2E;	/* timer 1,2 enable	*/

	LOCCIO->ctcs[0].reg = ICW_SIE | CT_GCB | CT_TCB; /* start timer 1 */
	LOCCIO->ctcs[1].reg = ICW_SIE | CT_GCB | CT_TCB; /* start timer 2 */

	LOCCIO->mic.reg = C_MIE | C_CTVIS;	/*  enable CIO ints	*/
}

/*
 * set_local_timer0 -- set the divide-by-N value of timer 0 on the local CIO
 */

set_local_timer0(timer_val)
uint	timer_val;
{
	LOCCIO->cttc[0].tcmsb.reg = (timer_val >> 8) & 0xff;
	LOCCIO->cttc[0].tclsb.reg = timer_val & 0xff;
}
