/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mmu.c: version 25.1 created on 11/27/91 at 15:36:59	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mmu.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* insert standard SCCS header here */
/* iopm_init.c */


#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/kmem.h"
#include "spm.h"
#include "sys/spm_mem.h"
#include "sys/sbus.h"
#include "cpu_method.h"
#include "slotdefs.h"

/* Be sure that the mmu defines are for the 68020 */
#ifdef	M68040
#undef	M68040
#undef	THREE_LEVEL_MMU
#define	CROSS_MMU
#define	M68020
#endif	/* M68040 */

#include "sys/immu.h"
#include "sys/iopm_mmu.h"
#include "memstripe.h"

/* #include "sys/lio.h" */

#define KM_TO_U32(x)  ((MAINCPU_mpfn_to_spfn(pnum(x)) << (PNUMSHFT - 4)) + \
			(((uint)(x) & POFFMASK) >> 4))

/* #define IOPM_MMU_DEBUG	/* extra debug info */

char	slot_to_num[SBUS_NUM_SLOT] = {
	-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1
};

extern			cpu_set_cur();

void
iopm_build_page_table()
{
	register uint	*pt_ptr, *pt_sav;
	register uint   *st_ptr;
	register uint	n, addr, num, i;
	register uint	kpde;
	register uint	saved_map = iomap_save();
	cpu_data_t	*sav_current;

	/* set up slot_to_num[] */
	for (num = n = 0; n < SBUS_NUM_SLOT; n++)
		if (sbus_config.slot_id[n] == SBUS_MM)
			slot_to_num[n] = num++;

	ASSERT(maincpu_mpfn_to_spfn);
	/*
	 * The "segment table" is an array of u32's pointing to the page tables
	 * It must all reside in one page.  If there are more pointers to page
	 * tables than can fit in one page then give up.  Else, find the
	 * smallest portion of a page that will hold it.
	 */
	addr = km_allocate(0, 16);  /* u32s must be on 16 byte boundaries */
	num = num_pages / NPDPPT;	/* number of seg descrs needed */
	if (num <= (NBPP - poff(addr)) / sizeof(ulong))
		/* the page pointers all fit in the remainder of this page */
		n = sizeof(ulong);
	else if (num <= NPDPPT)
		/* the page pointers fit in 1/4 page */
		n = NPDPPT;
	else if (num <= 2 * NPDPPT)
		/* the page pointers fit in 1/2 page */
		n = 2 * NPDPPT;
	else if (num <= NBPP / sizeof(ulong))
		/* the page pointers fit in 1 page */
		n = NBPP;
	else {
		printf("SPM: ERROR: Too much memory for IOPM to handle!  ");
		printf("(%d seg descrs)\n", num);
		rtn_to_monitor();
	}
	addr = km_allocate(num * sizeof(ulong), n);
#ifdef IOPM_MMU_DEBUG
	printf("iopm_build_page_tables: addr=%#x, num=%#x, bound=%d\n",
	  addr, num * sizeof(ulong), n);
#endif

	sbus_config.iopm_stbl = KM_TO_U32(addr);
	st_ptr = (uint *)km_map(addr);
	/* Start page table after page table pointers on page table boundary */
	pt_ptr = pt_sav = (uint *) km_allocate(num_pages * sizeof(ipde_t),
	                         NPDPPT * sizeof(ipde_t));
	/* fill in the page table pointers */
	for (i = 0; i < num; i++) {
		*st_ptr++ = n = KM_TO_U32(pt_ptr);
#ifdef IOPM_MMU_DEBUG
		printf("sde for %#x = 0x%08x\n", pt_ptr, n);
#endif
		pt_ptr += NPDPPT;
	}

	pt_ptr = pt_sav;

	/*
	 * Note:  the following code assumes that MAINSTORE is the same for
	 *	  all PMs.  Change it when this is no longer true.
	 */
	/* fill in the page tables */
	n = MAINSTORE + ctob(num_pages);
	for (addr = MAINSTORE; addr < n; addr += NBPP) {
		/* MAINCPU_mpfn_to_spfn returns a System Page Frame Number.  */
		/* Construct that here, from an sbus address & mask off the  */
		/* Lower bits that would be modes, etc			     */

		kpde = KM_TO_U32(addr) & PAMASK;
		num = slot_to_num[kpde >> U32TOSLOT];

		ASSERT(num >= 0);
		*(uint *)km_map(pt_ptr++) = i =
		  (num << U32TOSLOT) | ((kpde & TAMASK) << 4) | PGDESC;
#ifdef IOPM_MMU_DEBUG
		printf("@%08x=%08x%c",
		  pt_ptr - 1, i, ((btoc(addr) & 3) == 3 ? '\n' : ' '));
#endif
	}
#ifdef IOPM_MMU_DEBUG
	printf("\niopm_build_page_tables done.");
#endif

	iomap_restore(saved_map);
}
