/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sld.c: version 25.1 created on 11/27/91 at 15:36:51	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sld.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* sld.c - Serial line driver. */

#include "sys/types.h"
#include "spm.h"
#include "sa_dir.h"
#include "spm_debug.h"
#include "novram.h"
#include "cpu_method.h"
#include "misc.h"
#include "polyio.h"
#include "saio.h"

#define BITMASK		0xff	/* removes extra bits from int */

#define	iqsize	1024

/*******************************************************************
 * declarations for the Xmodem protocol provided in xmodem.c
 */
#define BBUFSIZ         1024    /* buffer size -- do not change! */
char xferbuff[BBUFSIZ + 1];
extern xmodem_get();
extern xmodem_ack();
extern xmodem_cancel();
extern xmodem_start();
extern sendbyte();
extern x_signal();

extern uchar *head, *tail, input_q[];
/******************** serial line driver routines ****************/
#define SL_EOT			0	/* End of transmission. */
#define	SL_CLOSED		1	/* Serial line is closed. */
#define	SL_READY_TO_OPEN	2	/* Serial line Ready. */
#define	SL_OPEN			3	/* Serial line active. */
#define	SL_ABORT		5	/* block acknowledged. */

static uint	sd_state = SL_CLOSED;
static uint	ack_expected;
static uint	blknum;

/* sl_open() - Configure the modem port, make a connection
 * with the host machine.
 */
static int
sl_open(how)
int	how;
{
	if (how != 0) {
		printf("sl_open: cannot write!\n");
		return (-1);
	}
	if (sd_state != SL_CLOSED) {
		printf("sl_open: xmodem already opened!\n");
		return (-1);
	}
	/* change modem port baud rate for serial downloading */
	config_modem_port(0);

	head = tail = input_q;	/* initilize connect routine. */
	if (!connect()) {
		printf("\nUmod cancelled!\n");
		config_modem_port(1);
		rtn_to_monitor();
	}

	sd_state = SL_READY_TO_OPEN;
	blknum = 0;
	ack_expected = 0;

	return(99);
}

/* sl_read() - signal host machine to start the transfer if first read.
 * ACK the last read and toggle LED and increment block count for most
 * reads.  Just return if lseek was just called.
 */
static int
sl_read(rbuf, count)
char	*rbuf;
uint	count;
{
	int blk_state;

	if (sd_state == SL_CLOSED) {
		printf("sl_read: serial download line not open!\n");
		return(-1);
	}
	if (rbuf != xferbuff) {
		printf("sl_read: must use xferbuff!\n");
		return(-1);
	}
	if (count != BBUFSIZ) {
		printf("sl_read: count must be BBUFSIZ!\n");
		return(-1);
	}

	if (sd_state == SL_READY_TO_OPEN) {
		xmodem_start();
		sd_state = SL_OPEN;
	} else {
		xmodem_ack();		/* ACK previous block. */
		ack_expected = 0;
		x_signal(blknum++);
	}

	/* FIX joe, take care of all return cases from 'xmodem_get()'. */
	if (!(blk_state = xmodem_get())) {
		ack_expected = 1;
		sd_state = SL_EOT;
		return(0);
	}

	ack_expected = 1;

	if (blk_state == -1) {
		sd_state = SL_ABORT;
		return(-1);
	}

	return(count);
}

/* sl_close() - (Serial download close) re-cofigure the 
 * modem port, check for SL_EOT.
 */
static int
sl_close()
{
	if (ack_expected) {
		xmodem_ack();
		ack_expected = 0;
		x_signal(blknum++);
	}
		

	/* FIX joe, take care of all return cases from 'xmodem_get()'. */
	if (sd_state != SL_EOT) {

		while (xmodem_get())
			xmodem_ack();	/* If early close, ack rest of blks */

		xmodem_ack();		/* Last ack on a close! */
	}

	config_modem_port(1);

	sd_state = SL_CLOSED;

	return(0);
}

/****************** SWITCH functions for open, close, read and switch ******/
int
poly_open(ap, how)
register args_buf_t 	*ap;
int			how;
{
	ap->current_block = 0;
	ap->valid_bytes = 0;

	if (strcmp(ap->source_dev, "umod") == 0) {
		ap->serial_download = 1;
		return (ap->fd = sl_open(how));
	}
	else {
		ap->serial_download = 0;
		return (ap->fd = Open(ap->source_dev, how));
	}
}

int
poly_close(ap)
register args_buf_t 	*ap;
{
	int	fd;

	fd = ap->fd;
	ap->fd = -1;
	if (ap->serial_download)
		return (sl_close());
	else
		return (Close(fd));
}

int
poly_read(ap, buf, count)
args_buf_t 	*ap;
char		*buf;
uint		count;
{
	if (ap->serial_download)
		return (sl_read(buf, count));
	else
		return (Read(ap->fd, buf, count));
}
