/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) poll.c: version 25.1 created on 11/27/91 at 15:36:47	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)poll.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:poll.c	22.1"
/* poll.c */

#include "misc.h"
#include "global.h"
#include "spm.h"
#include "rtc.h"
#include "rwi.h"
#include "adc.h"
#include "sys/types.h"
#include "spm_debug.h"
#include "sys/spm_mem.h"
#include "sys/sbus_spm.h"
#include "sys/sbus_pm.h"
#include "sys/ints.h"


poll()
{
	uint	sec_tick;

	if ((get_spl() != 0) || polling)
		return;

	polling++;

	if (sec_tick = seconds_tick)
		seconds_tick = 0;

	display_errors();

	if (spm_mem_copy_called) {
		if (clock_tick) {
			clock_tick = 0;
			cpu_all_check_printf();
			check_tdb();
		}
		if (sec_tick)
			timewarp();

		Unix_Console_Output();
		Unix_Console_Input();
	}

	rwi_poll(sec_tick);
	local_poll(sec_tick);

	polling = 0;
}

display_errors()
{
	register struct error	*ep;
	uint			spl_level;

	ASSERT(polling);

	while (error_head != error_tail) {
		spl_level = spl1();

		ep = &error[error_head];
		switch (ep->type) {
		case CSS_ERR:
			show_css_err(ep->data.css.err_reg,
			  ep->data.css.status_reg);
			break;
		case DISP_ERR:
			show_disp_err(ep->data.disp_reg);
			break;
		case MEM_ERR:
			show_mm_err(ep->data.mm.slot, ep->data.mm.addr_reg,
			  ep->data.mm.info_reg);
			break;
		case IOM_ERR:
			show_iom_err(ep->data.iom.iom_slot,
			  ep->data.iom.err_reg);
			break;
		case IOSBA_ERR: 
			show_iosba_err(ep->data.iosba.iom_slot,
			  ep->data.iosba.iosba_error_reg);
			break;
		case SPM_ERR:
			printf("%s\n", ep->data.spm.str);
			break;
		default:
			printf("display_errors: unknown error type = 0x%x!\n",
			  ep->type);
			break;
		}

		splx(spl_level);
		if (++error_head >= ERROR_SIZE)
			error_head = 0;
	}
}

Unix_Console_Output()
{
	if (!unix_console_mode)
		return;
	if (!unix_console_interrupt)
		return;
	K_ASSERT(get_spl() == 0);
	K_ASSERT(Spm_Mem->console.enable_output);
	con_out(Spm_Mem->console.output_buf);

	unix_console_interrupt = 0;
	Spm_Mem->console.enable_output = 0;

	if (!probe_wr_long(interrupt_dispatcher, Spm_Mem->console.output_int)) {
		printf("bus error: writing console interrupt to dispatcher\n");
		cpu_all_stop();
	}
}
	
Unix_Console_Input()
{
	static int	c;

	if (!unix_console_mode) {
		c = -1;
		return;
	}
	K_ASSERT(get_spl() == 0);

	if (c == -1 && ((c = get_char()) == -1))
		return;

	if (!Spm_Mem->console.enable_input)
		return;

	Spm_Mem->console.input_buf = c;
	K_ASSERT(Spm_Mem->console.enable_input);
	Spm_Mem->console.enable_input = 0;

	if (! probe_wr_long(interrupt_dispatcher, Spm_Mem->console.input_int)) {
		printf("bus error: writing console interrupt to dispatcher\n");
		cpu_all_stop();
	}

	c = -1;
}
