/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iosba.c: version 25.1 created on 11/27/91 at 15:36:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iosba.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "iosba.h"
#include "misc.h"
#include "spm.h"
#include "slotdefs.h"
#include "sys/param.h"
#include "sys/spm_mem.h"
#include "iom_config.h"
#include "sbus_conf.h"
#include "spm_debug.h"
#include "sys/sysmacros.h"
#include "sys/sbus.h"
#include "error.h"
#include "sys/iunit.h"
#include "sys/sbus_iopm.h"

extern uint	kern_clock_enable, spm_mem_copy_called;

extern uint	spm_slot;
extern uint	error_head, error_tail;
extern struct error error[ERROR_SIZE];

extern unchar 	*iomap();
extern uint	iopm_any_setup();

extern unchar	*iomap();
extern unchar	*sio_map();

/***********************************************************************/
/***** IOSBA specific afifo register data structures. ******************/
/* Afifo register/init-value component. */
struct fifo_component {
	uint	reg_ptr;	/* IOSBA board address of the fifo register */
	unchar	init_value;	/* initialization value		      */
};


/*
 ***** Table of AFIFO register initialization values. *************
 * Each pair represents an Associative FIFO register pointer and an 
 * initialization value for that register.
 */

struct fifo_component fifo_tab[] = {
	/* Down-link afifo initialization values. */
	{ IOSBA_DL_CMD_AP, FIFO_READ_WRITE },			/* 0xffffeb20 */
	{ IOSBA_DL_CMD_AR, IN_PAR_GEN_DIS + READYAB_SYNC},	/* 0xffffeb00 */
	{ IOSBA_DL_CMD_BP, FIFO_READ_WRITE },			/* 0xffffeb24 */
	{ IOSBA_DL_CMD_BR, IN_PAR_GEN_DIS + READYAB_SYNC},	/* 0xffffeb04 */
	{ IOSBA_DL_RSP_AP, FIFO_READ_WRITE },			/* 0xffffeb28 */
	{ IOSBA_DL_RSP_AR, IN_PAR_GEN_DIS + READYAB_SYNC},	/* 0xffffeb08 */
	{ IOSBA_DL_RSP_BP, FIFO_READ_WRITE },			/* 0xffffeb2c */
	{ IOSBA_DL_RSP_BR, IN_PAR_GEN_DIS + READYAB_SYNC},	/* 0xffffeb0c */

	/* Up-link fifo initialization values. */
	{ IOSBA_UL_CMD_AP, FIFO_READ_WRITE },			/* 0xffffeb30 */
	{ IOSBA_UL_CMD_AR, IN_PAR_GEN_DIS  },			/* 0xffffeb10 */
	{ IOSBA_UL_CMD_BP, FIFO_READ_WRITE },			/* 0xffffeb34 */
	{ IOSBA_UL_CMD_BR, IN_PAR_GEN_DIS  },			/* 0xffffeb14 */
	{ IOSBA_UL_RSP_AP, FIFO_READ_WRITE },			/* 0xffffeb38 */
	{ IOSBA_UL_RSP_AR, IN_PAR_GEN_DIS  },			/* 0xffffeb18 */
	{ IOSBA_UL_RSP_BP, FIFO_READ_WRITE },			/* 0xffffeb3c */
	{ IOSBA_UL_RSP_BR, IN_PAR_GEN_DIS  },			/* 0xffffeb1c */
};

#define NUM_FIFO_REGS	(sizeof(fifo_tab)/sizeof(struct fifo_component))

program_iosba_afifos(iom_slot)
uint iom_slot;
{
	uint	saved_map = iomap_save();
	unchar	*fifo_ptr;
	uint	reg_data;

	for (reg_data = 0; reg_data != NUM_FIFO_REGS; reg_data++) {
	
		/* Map the afifo register. */
		fifo_ptr = iomap(iom_slot, fifo_tab[reg_data].reg_ptr);

		/* load initialization value */
		*fifo_ptr = fifo_tab[reg_data].init_value;

		/* check that register was loaded */
		if ( *fifo_ptr != fifo_tab[reg_data].init_value)
			printf("IOSBA fifo init error, IOM: %u\n", iom_slot);
	}
	iomap_restore(saved_map);
}

/* display_error_status()
 *                 +----+----+----+----+----+----+----+----+
 *	0xffffe800 |EOI |UCSD| UL |DCSD| DL | BE | XE |GTO |
 *                 +----+----+----+----+----+----+----+----+
 */

void
iosba_display_error_status(iom_slot, error_reg)
uint	iom_slot;
unchar	error_reg;
{
	register uint 	bit_ndx;
	register char	*p;

	printf("IOSBA%u: error_reg -> %x\n", iom_slot, error_reg);

	for (bit_ndx = 0; bit_ndx < 8; bit_ndx++) {
		switch (error_reg & (1 << bit_ndx)) {
		case GTO_BIT:
			p = "GTO  - arbitration grant timeout";
			break;
		case XE_BIT:
			p = "XE   - down-link fifo error during IOSB transmit";
			break;
		case BE_BIT:
			p = "BE   - IOS bus error";
			break;
		case DL_BIT:
			p = "DL   - down-link error detected";
			break;
		case DCSD_BIT:
			p = "DCSD - downlink command or type-field error";
			break;
		case UL_BIT:
			p = "UL   - up-link fifo error during up-link transmit";
			break;
		case UCSD_BIT:
			p = "UCSD - up-link command or type-field error";
			break;
		case EOI_BIT:
			p = "EOI - error interrupt sent by IOSBA";
			break;
		default:
			continue;
		}
		printf("  %s.\n", p);
	}
}

/* iosba_check_error() - Will check and clear error control register.
 */
iosba_check_error(iom_slot)
uint	iom_slot;
{
	uint	saved_map = iomap_save();
	unchar	*error_reg, val;

	/* Read IOSBA error register, if non-zero report errors. */
	error_reg = iomap(iom_slot, IOSBA_ERROR_REGISTER);
	if (!probe_rd_byte(error_reg, &val))
		printf("Can't read IOSBA error register for IOM slot %d\n",
		  iom_slot);
	else if (val) {
		iosba_display_error_status(iom_slot, val);
		printf("Clearing error control register\n");
		*error_reg = ERROR_RESET;   /* Setting to zero clears errors. */
	}
	iomap_restore(saved_map);
}

void
iosb_brd_init(iomp)
iom_config_t	*iomp;
{
	unchar		*iosba_reg_addr;
	uint		saved_map = iomap_save();
	uint		iom_slot = iomp->iom_slot;
	disp_int_t	int_request_val;

	/* Read IOSBA error register, if non-zero report errors. */
	iosba_check_error(iom_slot);

	/* Program the AFIFO registers , check for errors,
	 * Turn off and on the LED on the IOSBA. */
	program_iosba_afifos(iom_slot);

	/* Read IOSBA error register, if non-zero report errors. */
	iosba_check_error(iom_slot);

	/* IOSBA LED of then on. */
	iosba_reg_addr = iomap(iom_slot, IOSBA_RESET_CNTL_REG_3);
	*iosba_reg_addr = IOSBA_READY_LED_ON | IOSBA_BOTH_LEDS_OFF;

	/* Interface enable the IOSBA. */
	iosba_reg_addr= iomap(iom_slot, IOSBA_MODE_CNTL_REG_3);
	*iosba_reg_addr = IOSBA_INTERFACE_EN;

	int_request_val.entire_32_bits = 0;
	int_request_val.fields.vector = IOSBA_ERROR;
	int_request_val.fields.directed = DIRECTED;
	int_request_val.fields.level = SPM_DISP_LEVEL_FOUR;
	int_request_val.fields.src_slot = spm_slot;
	int_request_val.fields.dest_slot = spm_slot;
	*(disp_int_t *)iomap(iom_slot, IOSBA_INTERRUPT_CTRL) = int_request_val;
	
	iosba_check_error(iom_slot);
	iomap_restore(saved_map);
}


/* delay_n_check_GTO() - Wait atleast 200ms then check for grant timeout.
 */
uint
delay_n_check_GTO(iom_slot)
uint	iom_slot;
{
	uint	saved_map = iomap_save();
	unchar	*error_reg;

	delay(HZ/2 + 1);	/* Atleast 200ms... */

	/* Read IOSBA error register, if non-zero report errors. */
	error_reg = iomap(iom_slot, IOSBA_ERROR_REGISTER);

	if (*error_reg & GTO_BIT) {
		*error_reg = ERROR_RESET;   /* Setting to zero clears errors. */
		iomap_restore(saved_map);
		return 1;
	}
	iomap_restore(saved_map);
	return 0;
}

void
ios_bus_module_en(iom_slot, subslot)
uint	iom_slot, subslot;
{
	uint	saved_map = iomap_save();
	unchar	*cntl_reg;

	ASSERT(subslot < SBUS_NUM_SLOT);
	cntl_reg = iomap(iom_slot, (IOS_CNTL_REG_OFFSET | subslot));

	/* With the current subslot issue a module enable. */
	*cntl_reg = IOS_BUS_MODULE_EN;

	/* FIX joe, print appropriate message. */
	/* Check for an arbitration grant timeout (GTO)... */
	if (delay_n_check_GTO(iom_slot)) {
		iomap_restore(saved_map);
		return;			/* If GTO then no board.... */
	}
	iomap_restore(saved_map);	/* ...else board present enabled.   */
}

void
ios_bus_module_dis(iom_slot, subslot)
uint	iom_slot, subslot;
{
	uint	saved_map = iomap_save();
	unchar	*cntl_reg;

	ASSERT(subslot < SBUS_NUM_SLOT);
	cntl_reg = iomap(iom_slot, (IOS_CNTL_REG_OFFSET | subslot));

	/* With the current subslot issue a module enable. */
	*cntl_reg = IOS_BUS_MODULE_DIS;

	iomap_restore(saved_map);
}

uint
ios_bus_interface_en(iom_slot, subslot)
uint	iom_slot;
uint	subslot;
{
	uint	saved_map = iomap_save();
	unchar	*cntl_reg;

	ASSERT(subslot < SBUS_NUM_SLOT);
	cntl_reg = iomap(iom_slot, (IOS_CNTL_REG_OFFSET | subslot));

	/* With the current subslot issue an interface enable. */
	*cntl_reg = IOS_BUS_INTERFACE_EN;

	if (delay_n_check_GTO(iom_slot)) {
		iomap_restore(saved_map);
		return 0;			/* If GTO then no board.... */
	}

	iomap_restore(saved_map);
	return 1;			/* ...else board present and interface
					 * enabled.   */
}

void
ios_bus_interface_dis(iom_slot, subslot)
uint	iom_slot;
uint	subslot;
{
	uint	saved_map = iomap_save();
	unchar	*cntl_reg;

	ASSERT(subslot < SBUS_NUM_SLOT);
	cntl_reg = iomap(iom_slot, (IOS_CNTL_REG_OFFSET | subslot));

	/* With the current subslot issue an interface enable. */
	*cntl_reg = IOS_BUS_INTERFACE_DIS;

	iomap_restore(saved_map);
}


/*
 * ios_bus_module_init
 */
uint
ios_bus_module_init(slot, subslot, module_id)
uint	slot;
uint	subslot;
uint	module_id;
{
	switch (module_id) {
	case SBUS_IOPM:
		return (iopm_any_setup(slot, subslot));
	case SBUS_NO_BOARD:
		break;
	}
	return (IOPM_NO_DB);
}

unchar
get_ios_bus_bd_id(slot, subslot)
uint	slot;
uint	subslot;
{
	uint	saved_map = iomap_save();
	uint	module_id;
	iunit_t	iunit;
	
	iunit.i = IUNIT_NO_DEV;
	iunit.s.slot = slot;
	iunit.s.subslot = subslot;
#if 0 /* JPC: previous versions */
/***	module_id = *sio_map(ioslot, MODULE_ID_BYTE);	****/
	module_id = *(uint *)sio_map(ioslot, SBUS_ADDR_ID) & SBUS_ID_MASK;
#endif
	if (probe_rd_long((uint *)sio_map(iunit, SBUS_ADDR_ID), &module_id))
		module_id &= SBUS_ID_MASK;
	else
		module_id = SBUS_NO_BOARD;
	iomap_restore(saved_map);
	return(module_id);
}

void
ios_bus_brd_init(iom_ndx)
uint	iom_ndx;
{
	uint			saved_map = iomap_save();
	uint			cur_slot;
	uint			iom_slot;
	uint			iosba_phys_slot;
	uint			bd_id;
	register iom_config_t	*iomp;
	register css_bd_dat_t	*cbp;

	iomp = &iom_config[iom_ndx];
	iom_slot = iomp->iom_slot;

	/* used for code-readability -- IOSB conf struct pointer. */

	/* Get the sub-slot the IOSBA resides in. */
	iosba_phys_slot = (uint)*iomap(iom_slot, IOSBA_PHYS_SLOT);
	cbp = iomp->ex_card_cage.css_bd_dat;
	for (cur_slot = 0; cur_slot < SBUS_NUM_SLOT; cur_slot++, cbp++) {
		cbp->dev_board_id = SBUS_NO_BOARD;
		/* If IOSBA show presence and continue */
		if (iosba_phys_slot == cur_slot) {
			cbp->css_slot_id = SBUS_NO_BOARD;
			continue;
		}

		/* Grant timeout on interface enable indicates no board. */
		if (!ios_bus_interface_en(iom_slot, cur_slot)) {
			cbp->css_slot_id = SBUS_NO_BOARD;
			continue;
		}

		/* If board present, get id, init board. */
 		bd_id = get_ios_bus_bd_id(iom_slot, cur_slot);
		cbp->css_slot_id = bd_id;
		cbp->dev_board_id =
		  ios_bus_module_init(iom_slot, cur_slot, bd_id);
	}
	iomap_restore(saved_map);
}

break_out_iosba_err_info(iom_slot)
uint	iom_slot;
{
	uchar			err_data;
	uint			saved_map;

	if (sbus_config.slot_id[iom_slot] != SBUS_NIOM) {
		printf("Slot %d does not contain an IOM\n");
		return;
	}
	if (iom_ex_bd_type(iom_slot) != IOM_TYPE_IOSBA) {
		printf("IOM in slot %d is not connected to an IOSBA\n",
		  iom_slot);
		return;
	}

	saved_map = iomap_save();

	if (probe_rd_byte(iomap(iom_slot, IOSBA_ERROR_REGISTER), &err_data))
		iosba_display_error_status(iom_slot, err_data);
	else {
		printf("Bus error occured reading IOM/IOSBA in slot %d\n",
		  iom_slot);
		iosba_unwedge(iom_slot);
	}

	iomap_restore(saved_map);
}

iosba_unwedge(iom_slot)
uint	iom_slot;
{
	uchar		err_data;
	uint		saved_map;

	char	*str = "Get the IOSBA error info via a bus reset? (y or n)-> ";

	if (! getyn(str))
		return;
	printf("\n");

	/* kern clock off */
	kern_clock_enable = 0;
	/* no more printfs or tdb */
	/* FIX THIS, DS: need a better method for throttling poll */
	spm_mem_copy_called = 0;

	splhi();
	css_reset();
	half_assed_reenable();
	spl0();

	saved_map = iomap_save();

	if (probe_rd_byte(iomap(iom_slot, IOSBA_ERROR_REGISTER), &err_data))
		iosba_display_error_status(iom_slot, err_data);
	else
		printf("Still got a bus error reading IOSBA in slot %d\n",
		  iom_slot);

	iomap_restore(saved_map);
}

/*
 * get_iosba_err_info -- set and store IOSBA error info
 */

get_iosba_err_info(iom_slot)
uint	iom_slot;
{
	uint		err, tmp, saved_map = iomap_save();
	unchar		*error_reg, val;
	struct error	*ep;

	/* Read IOSBA error register; on error, use BAD_UINT. */
	error_reg = iomap(iom_slot, IOSBA_ERROR_REGISTER);
	if (probe_rd_byte(error_reg, &val)) {
		err = val;
		*error_reg = ERROR_RESET;   /* Setting to zero clears errors. */
	}
	else
		err = BAD_UINT;

	/* increase tail pointer */
	tmp = (error_tail >= ERROR_SIZE) ? 0 : error_tail + 1;
	if (tmp != error_head) {
		ep = &error[error_tail];
		ep->type = IOSBA_ERR;
		ep->data.iosba.iom_slot = iom_slot;
		ep->data.iosba.iosba_error_reg = err;
		error_tail = tmp;
	}

	iomap_restore(saved_map);
}

show_iosba_err(iom_slot, iosba_err_reg)
uint	iom_slot;
uint	iosba_err_reg;
{
	put_char('\n');
	print_time_stamp(0);
	if (iosba_err_reg == BAD_UINT) {
		printf("Was unable to read IOSBA error status! (IOM # %d)\n",
		  iom_slot);
		iosba_unwedge(iom_slot);
	}
	else
		iosba_display_error_status(iom_slot, iosba_err_reg);
}
