/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) console.c: version 25.1 created on 11/27/91 at 15:36:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)console.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)stand/cmd/spm:console.c	22.1"
/* console.c */

#include "misc.h"
#include "sys/types.h"
#include "global.h"
#include "spm_debug.h"
#include "spm.h"
#include "scc.h"
#include "rwi.h"

/* con_out()
 *
 * console output routine
 *
 * Parameter:
 *	character to be sent out on serial channel
 *
 */
con_out(c)
register uint	c;
{
	register uint	x;

	if ((x = get_spl()) != 0) {
		save_char(c);
		/* 
		 * wait for console 
		 */
		while (!(CONSOLE_PORT->reg[0].reg & RR0_TX))
			;

		while (modem_on && !(MODEM_PORT->reg[0].reg & RR0_TX))
			;
		while (printer_on && !(PRINTER_PORT->reg[0].reg & RR0_TX))
			;
	}
	else {
		while (!(CONSOLE_PORT->reg[0].reg & RR0_TX) || console_xonflag)
			poll();

		while (modem_on && (!(MODEM_PORT->reg[0].reg & RR0_TX) ||
		  console_xonflag))
			poll();
		while (printer_on && (!(PRINTER_PORT->reg[0].reg & RR0_TX) ||
		  printer_xonflag))
			poll();
	}

	/* 
	 * A possible race condition exists here if an interrupt happens here
	 * and that interrupt outputs characters. We could lose the last 
	 * character by returning here and writing to the scc before it is 
	 * ready. This is avoided by waiting for the scc to transmit as done 
	 * below
	 */

	CONSOLE_PORT->reg[8].reg = c;

	if (modem_on)
		MODEM_PORT->reg[8].reg = c;

	if (printer_on)
		PRINTER_PORT->reg[8].reg = c;

	if (x == 0) 
		return;
		
	while (!(CONSOLE_PORT->reg[0].reg & RR0_TX))
		;

	while (modem_on && !(MODEM_PORT->reg[0].reg & RR0_TX))
		;

	while (printer_on && !(PRINTER_PORT->reg[0].reg & RR0_TX))
		; 
}


/*
 * con_in()
 *
 *	chan A
 */
con_in()
{
	int	retval = -1;
	ushort 	spl_level;

	spl_level = spl_console();
	if (unix_console_mode) {
		if (unix_bufhead != unix_buftail) {
			/* wrap around */
			if (unix_bufhead == &unix_bufinputq[CQSIZ])
				unix_bufhead = unix_bufinputq;
			retval = *unix_bufhead++;
		}
	}
	else {
		if (spm_bufhead != spm_buftail) {
			/* wrap around */
			if (spm_bufhead == &spm_bufinputq[CQSIZ])
				spm_bufhead = spm_bufinputq;
			retval = *spm_bufhead++;
			lastchar = retval;	/* for monitor support */
		}
	}
	splx(spl_level);
	return(retval);
}

get_possible_char()
{
	K_ASSERT(get_spl() == 0);

	return(con_in());
}

get_char()
{
	int	c;

	if (unix_console_mode)
		c = get_possible_char();
	else 
		while ((c = get_possible_char()) < 0) 
			poll();

	return(c);
}

/* used thru the trap mechanism for standalone programs */
Get_char()
{
	int	ch;

	ch = get_char();
	if (ch == DELETE)
		Exit();
	if ((ch == ESCAPE) && !abortflag)
		ch = 0; 
	return(ch);
}

Usrabort()
{
	if (abortflag) {
		abortflag = FALSE;
		return(1);
	}
	return(0);
}


#define SAVE_BUF_SIZE	0x800

static char	save_buf[SAVE_BUF_SIZE];
static char	*save_buf_ptr;
static uint	save_buf_overflow;

/*
 * put char into a circular buffer storing the last ?k of priority
 * output (kernel printfs, dispatcher errors, css errors).
 */

save_char(c)
int	c;
{
	if ( save_char_flag == 0 )
		return;

	if (save_buf_ptr == &save_buf[SAVE_BUF_SIZE]) {
		save_buf_ptr = save_buf;
		save_buf_overflow = 1;
	}

	*save_buf_ptr++ = c;
}

disp_save_buf()
{
	register char	*cp;

	if (!save_buf_overflow) {
		for ( cp = save_buf; cp <= save_buf_ptr; cp++ )
			con_out(*cp);
		return;
	}

	cp = save_buf_ptr;

	while (cp <= &save_buf[SAVE_BUF_SIZE])
		con_out(*cp++);

	cp = save_buf;

	while (cp != save_buf_ptr)
		con_out(*cp++);
}

init_save_buf()
{
	save_buf_overflow = 0;
	save_buf_ptr = save_buf;
}



static	unsigned char	last_char_printed = '\n';

/* last_put_char()
 * 
 * returns the value of the last character printed.
 *
 */

unsigned char
last_put_char()
{
	return(last_char_printed);
}

/* put_char()
 *
 * Parameter:
 *
 *	character to print
 *
 */

put_char(c)
register int	c;
{
	sticky_put_char(NULL);
	if (c != ESCAPE) {
		con_out(c);
		last_char_printed = c;	
		if (c == '\n')
			con_out('\r');
	}
}

#define	STICKY_DELAY		4	/* number of ticks to put of printf */

static uint	last_clock_cnt; 
static void	*last_channel;

uint
ok_to_put_char(channel)
void	*channel; 	/* address of caller's private data structure */
{
	if (channel != last_channel) {

			/* ..a more current printf may be pending, so 
							forget it for now. */
		if ( int_counter - last_clock_cnt <= STICKY_DELAY )
			return(0);

		if (last_put_char() != '\n')
			put_char('\n');
		last_channel = channel;
	}
	return(1);
}

sticky_put_char(channel)
void	*channel; 	/* address of caller's private data structure */
{
	last_channel = channel;
	last_clock_cnt = int_counter;
}
