/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) SYS.c: version 25.1 created on 11/27/91 at 15:36:26	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)SYS.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/* Standalone I/O support for s90 */

#include "misc.h"
#include "sys/types.h"
#include "saio.h"
#include "sa_dir.h"
#include "iom_config.h"
#include "spm_debug.h"
#include "sbus_iom.h"
#include "sys/sysmacros.h"
#include "sys/param.h"
#include "sys/ino.h"
#include "sys/fs/s5filsys.h"
#include "sys/fs/s5dir.h"
#include "sys/sbus.h"
#include "sys/sbus_iopm.h"
#include "sys/immu.h"
#include "sbus_conf.h"
#include "dev.h"
#include "sys/stat.h"
#include "sys/ioctl.h"
#include "../dsdb/sdk_disk.h"	/* JPC: isn't there a kernel include file ??? */


extern uint			dbug;

/* indir_blk, indir_blknos, and indir_unit cache indirect block info */
static union indir_blk {
	char	c[BUFFSIZE];
	daddr_t	d[BUFFSIZE / sizeof(daddr_t)];
} indir_blk[NBUFS];
static daddr_t		indir_blknos[NBUFS];
static iunit_t		indir_unit[NBUFS];

uint			iob_size;

static ino_t 		dlook();
devsw_t			*get_dev();

dev_slot_t		dev_slot[MAX_DEV];

extern dev_slot_t	*get_dev_slot();
extern char		*strncpy();
extern unchar		*alt_iomap();


static
Openi(n, io)
ino_t		n;
register iob_t	*io;
{
	register struct dinode	*dp;

	io->i_offset = 0;

	io->i_bn = (daddr_t)(sec_itod(n,io->inodesize));
	io->i_cc = BUFFSIZE;
	io->i_ma = (char *)dir_load_point;

	if (dbug) 
		printf("Openi: ino %x, io %x, io->i_unit %08x, io->i_bn %08x\n",
		  n, io, io->i_unit.i, io->i_bn);

	if (devread(io) <= 0) {
		printf("Openi: read of inode %d failed : i_unit = %08x\n",
		  n, io->i_unit.i);
		return (-1);
	}

	dp = (struct dinode *)
		(dir_load_point + io->inodesize * sec_itoo(n, io->inodesize));

	if (dbug)
		printf("Openi: dp=%x, sec_itoo(%d)=%x itoo(%d)=%x\n",
		  dp, n, sec_itoo(n, io->inodesize), n, itoo(n));

	io->i_ino.i_number = n;
	io->i_ino.i_mode  = dp->di_mode;
	io->i_ino.i_size  = dp->di_size;
	io->i_ino.i_nlink = dp->di_nlink;
	io->i_ino.i_uid   = dp->di_uid;
	io->i_ino.i_gid   = dp->di_gid;
	io->i_ino.i_atime = dp->di_atime;
	io->i_ino.i_mtime = dp->di_mtime;
	io->i_ino.i_ctime = dp->di_ctime;

	l3tol((char *)io->i_ino.i_addr, (char *)dp->di_addr, NADDR);
	return (0);
}


static
find(path, file)
register char	*path;
iob_t		*file;		/* io block pointer */
{
	register char 	*q;
	char 		c;
	int 		n;

	if (dbug)
		printf("find: path = %s file = %x\n", path, file);
	if (path == NULL || *path == '\0') {
		printf("null path\n");
		return(0);
	}

	if (Openi((ino_t) 2, file))
		return(0);
	while (*path) {
		while (*path == '/')
			path++;
		q = path;
		while (*q != '/' && *q != '\0')
			q++;
		c = *q;
		*q = '\0';

		if ((n = dlook(path, file)) == 0) {
			printf("%s not found\n", path);
			return(0);
		}
		if (c == '\0')
			break;
		if (Openi((ino_t)n, file))
			return(0);
		*q = c;
		path = q;
	}
	return(n);
}


/* 
 * sbmap -- convert a file byte offset into a physical disk block 
 *		Side effects:  may alter i_bn, i_cc, i_ma
 */
static daddr_t
sbmap(io, log_blk)
register iob_t	*io;
daddr_t		log_blk;
{
	register int		i, level, sh;
	register daddr_t	fs_blk, blk;
	sainode_t		*ip;

	ip = &io->i_ino;
	if ((blk = log_blk) < 0) {
		printf("sbmap: log_blk is negative! (%d)\n", blk);
		return((daddr_t)0);
	}

/* for convenience */
#define NUM_DIRECT	(NADDR - 3)		/* number of direct blocks */
#define INDIR_BLK	((daddr_t)1 << NSHIFT)	/* daddr_t in indirect block */

	/*
	 * blocks 0..NADDR-4 are direct blocks
	 */
	if (log_blk < NUM_DIRECT)
		return (ip->i_addr[log_blk]);

	/*
	 * addresses NADDR-3, NADDR-2, and NADDR-1
	 * have single, double, triple indirect blocks.
	 * the first step is to determine
	 * how many levels of indirection.
	 */
	sh = 0;
	fs_blk = 1;
	blk -= NADDR-3;
	for (level = 1; level <= 3; level++) {
		sh += NSHIFT;
		fs_blk <<= NSHIFT;
		if (blk < fs_blk)
			break;
		blk -= fs_blk;
	}
	if (level > 3) {
		printf("sbmap: block # %d too big for file system\n", log_blk);
		return((daddr_t)0);
	}

	/*
	 * get the indirect block address from the inode
	 */
	if ((fs_blk = ip->i_addr[NUM_DIRECT + level - 1]) == 0) {
		printf("sbmap: i_addr[%d] is zero for block # %d\n",
		  NUM_DIRECT + level - 1, log_blk);
		return((daddr_t)0);
	}

	while (--level >= 0) {
		if (indir_blknos[level] != fs_blk ||
		    indir_unit[level].i != io->i_unit.i) {
			io->i_bn = fs_blk;
			io->i_ma = indir_blk[level].c;
			io->i_cc = BUFFSIZE;
			if (devread(io) != BUFFSIZE) {
				indir_blknos[level] = 0;
				printf("sbmap: read of indir blk %#x failed!\n",
				  fs_blk);
				return ((daddr_t)0);
			}
			indir_blknos[level] = fs_blk;
			indir_unit[level] = io->i_unit;
		}
		sh -= NSHIFT;
		i = (blk >> sh) & NMASK;
		if ((fs_blk = indir_blk[level].d[i]) <= 0) {
			printf("sbmap: log_blk=%#x, indir[%d][%d] is %#x!\n",
			  log_blk, level, i, fs_blk);
			return ((daddr_t)0);
		}
	}
	if (dbug)
		printf("sbmap: log_blk=%#x --> fs_blk=%#x \n", log_blk, fs_blk);

	return (fs_blk);
}

/*
 * dlook -- search for a file in a directory
 *		Side effects:  will do I/O using io
 */
static ino_t
dlook(s, io)
char		*s;
register iob_t	*io;
{
	register struct direct	*dp;
	register sainode_t	*ip;
	daddr_t bn;
	int n,dc;

	if (s == NULL || *s == '\0')
		return(0);
	ip = &io->i_ino;

	/*
	 * most heinous compiler wierdness : do not remove parens below!!!
	 */
	if ((ip->i_mode & IFMT) != IFDIR) {
		printf("not a directory, i_mode 0x%x \n", ip->i_mode);
		return(0);
	}

	n = ip->i_size/sizeof(struct direct);

	if (!n) {
		printf("zero length directory\n");
		return(0);
	}

	dc = BUFFSIZE;
	bn = (daddr_t)0;
	while (--n >= 0) {
		if (++dc >= BUFFSIZE/sizeof(struct direct)) {
			if ((io->i_bn = sbmap(io, bn++)) == 0)
				return (0);
			io->i_ma = (char *)dir_load_point;
			io->i_cc = BUFFSIZE;
			if (devread(io) != BUFFSIZE) {
				printf("dlook: dir read of block %#x failed!\n",
				  io->i_bn);
				return (0);
			}
			dp = (struct direct *)dir_load_point;
			dc = 0;
		}
		if (strncmp(s, dp->d_name, DIRSIZ) == 0)
			return(dp->d_ino);
		dp++;
	}
	return(0);
}

off_t
Lseek(fdesc, addr, ptr)
int	fdesc;
off_t	addr;
int	ptr;
{
	register iob_t	*io;
	register off_t	byte_count, count;

	if (dbug)
		printf("lseek(%d, %d, %d)\n", fdesc, addr, ptr);

	if (ptr != 0) {
		printf("Must lseek from beginning of file only!\n");
		return(-1);
	}
	fdesc -= 3;

	io = &iob[fdesc];

	if (fdesc < 0 || fdesc >= NFILES || (io->i_flgs & F_ALLOC) == 0)
		return(-1);
	if (dbug)
		printf("lseek: i_unit=0x%08x i_flgs=%#x\n",
		  io->i_unit.i, io->i_flgs);

	fdesc += 3;

	/*
	 * seek on tape 
	 */
	switch (devsw[io->i_ino.i_dev].dv_id & DV_TYPE_MASK) {
	case DV_MT:
	case DV_9T:
		/* JPC -- can we rely on i_bn and skip the rewind sometimes? */
		/* FIX, HH, TW, should use ioctl here (not yet avail. for IOPM)
		 */
		if (devsw[io->i_ino.i_dev].dv_id & DV_IOPM) {
			if (itcommand(REWIND, io->i_unit) != 0)
				return(-1);
			/* 
			 * check tape status to let tape finish the rewind 
			 */
			if (itcommand(TAPESTAT, io->i_unit) != 0)
				return(-1);
		}
		else { 
			printf("Unsupported device!\n");
			return(-1);
		}
		io->i_offset = 0;
		io->i_bn = 0;

		if (dbug)
			printf("lseek: rewind done\n");

		for (byte_count = addr; byte_count > 0; byte_count -= count) {
			count = (byte_count >= BUFFSIZE) ? BUFFSIZE: byte_count;
			if (Read(fdesc, dir_load_point, count) != count)
				return(-1);
			io->i_offset += count;
			io->i_bn += count / BUFFSIZE;
		}	
		break;
	default:
		/* disks, etc -- just do it */
		io->i_offset = addr;
		io->i_bn = addr / BUFFSIZE;
		io->i_cc = 0;
	}

	if (dbug)
		printf("lseek: i_off=%#x, i_bn=%#x\n", io->i_offset, io->i_bn);
	return(addr);
}

getc(fdesc)
int	fdesc;
{
	register iob_t	*io;
	register char	*p;
	register int	c;
	int off;


	if (fdesc >= 0 && fdesc <= 2)
		return(get_char());
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES ||
	    ((io = &iob[fdesc])->i_flgs & F_ALLOC) == 0)
		return(-1);
	p = io->i_ma;
	if (io->i_cc <= 0) {
		io->i_bn = c = io->i_offset / (off_t)BUFFSIZE;
		if ((io->i_flgs & F_FILE) && (io->i_bn = sbmap(io, c)) == 0)
			return(-1);

		io->i_ma = (char *)getc_block;
		io->i_cc = BUFFSIZE;

		if (devread(io) != BUFFSIZE) {
			io->i_cc = 0;
			return(-1);
		}
		if (io->i_flgs & F_FILE) {
			off = io->i_offset % (off_t)BUFFSIZE;

			if (io->i_offset + (BUFFSIZE - off) >= io->i_ino.i_size)
				io->i_cc = io->i_ino.i_size - io->i_offset +off;
			io->i_cc -= off;
			if (io->i_cc <= 0)
				return(-1);
		}
		else
			off = 0;
		p = (char *)(getc_block + off);
	}
	io->i_cc--;
	io->i_offset++;

	c = *p++ & 0377;
	io->i_ma = p;
	return(c);
}


Read(fdesc, buf, count)
int	fdesc;
char	*buf;
uint	count;
{
	register long	i;
	register iob_t	*file;

	if (dbug)
		printf("read(%d, %#x, %u)\n", fdesc, buf, count);
	if (fdesc >= 0 && fdesc <= 2) {
		i = count;
		do {
			*buf = get_char();
		} while (--i > 0 && *buf++ != '\n');
		return(count - i);
	}

	file = &iob[fdesc -= 3];
	if (fdesc < 0 || fdesc >= NFILES || (file->i_flgs & F_ALLOC) == 0)
		return(-1);
#ifdef TOO_MUCH_DEBUG
	if (dbug)
		printf("read: io=%#x, i_unit=0x%08x, i_flgs=%#x\n",
		  file, file->i_unit.i, file->i_flgs);
#endif

	if ((file->i_flgs & F_READ) == 0)
		return(-1);

	if ((file->i_flgs & F_FILE) == 0) {
		file->i_cc = count;
		if ((file->i_flgs & F_BOOT) &&
		    count > (i = file->i_ino.i_size - file->i_offset)) {
			if (i <= 0)
				return(0);
			file->i_cc = i;
		}
#ifdef TOO_MUCH_DEBUG
		if (dbug)
			printf("i_off=%d i_bn=%d i_cc=%d i_size=%d i_ma=%#x\n",
			  file->i_offset, file->i_bn, file->i_cc,
			  file->i_ino.i_size, file->i_ma);
#endif
		file->i_ma = buf;
		if ((i = devread(file)) < 0)
			return(-1);
		file->i_bn += i / BSIZE;
		file->i_offset += i;
		return(i);
	}
	else {
#ifdef TOO_MUCH_DEBUG
		if (dbug)
			printf("read: c=%#x i_off=%#x i_size=%#x\n",
			  count, file->i_offset, file->i_ino.i_size);
#endif
		if (file->i_offset+count > file->i_ino.i_size)
			i = file->i_ino.i_size - file->i_offset;
		else
			i=count;

		if (i <= 0)
			return(0);

		if (!(file->i_bn = sbmap(file, file->i_offset/(off_t)BUFFSIZE)))
			return(-1);
		file->i_cc = BLK_SIZE;
		file->i_ma = buf;

		if (devread(file) < 0)
			return (-1);

		file->i_offset += i;
		file->i_cc = 0;
		return(i);
	}
}

Write(fdesc, buf, count)
int	fdesc;
char	*buf;
int	count;
{
	register int	i;
	register iob_t	*file;

	if (dbug)
		printf("write(%d, %#x, %u)\n", fdesc, buf, count);
	if (fdesc >= 0 && fdesc <= 2) {
		i = count;
		while (--i >= 0)
			put_char(*buf++);
		return(count);
	}
	fdesc -= 3;

	file = &iob[fdesc];

	if (dbug) {
		printf("write: fdesc=%x, ", fdesc);
		printf("file->i_unit=%08x, ", file->i_unit.i);
		printf("file->i_flgs=%x\n", file->i_flgs);
	}

	if (fdesc < 0 || fdesc >= NFILES || (file->i_flgs & F_ALLOC) == 0)
		return(-1);

	if ((file->i_flgs & F_WRITE) == 0)
		return(-1);

	if (file->i_flgs & F_FILE) {
		printf("ERROR: we don't write to files!\n");
		return(-1);
	}

	file->i_cc = count;
	file->i_ma = buf;

	if (dbug) {
		printf("write: file->i_bn = %x\n", file->i_bn);
		printf("write: file->i_ma = %x\n", file->i_ma);
		printf("write: file->i_cc = %x\n", file->i_cc);
	}

	if ((i = devwrite(file)) > 0)
		file->i_bn += i / BSIZE;

	return(i);
}

/*
 * open_boot -- open a file in a bootimage
 */

open_boot(fd, io, filename)
int	fd;
iob_t	*io;
char	*filename;
{
	register sa_dir_t 	*sap;	
	register sa_dir_entry_t	*entp;	
	int			i;

	if (dbug)
		printf("open_boot(%d, %#x, %s)\n", fd, io, filename);

	io->i_flgs |= F_BOOT;
	io->i_ino.i_size = entp->byte_count; 
	sap = (struct sa_dir *)dir_load_point;

	if (Read(fd, dir_load_point, BLK_SIZE) != BLK_SIZE) {
		printf("Failed to read bootimage directory!\n");
		Close(fd);
		return (-1);
	}

	if (sap->magic_num != MAGIC_NUM) {
		printf("Invalid magic number in bootimage!\n");
		Close(fd);
		return (-1);
	}

	for (entp = sap->entry, i = MAX_DIR_ENTRY; --i >= 0; entp++) 
		if (strncmp(entp->name, filename, sizeof(entp->name)) == 0)
			break;	

	if (i < 0) {
		printf("%s not found.\n", filename);
		Close(fd);
		return (-1);
	}
	
	if (Lseek(fd, entp->start_block_num * sap->block_size, 0) < 0) {
		printf("Unable to seek to bootimage block %d!\n",
		  entp->start_block_num);
		Close(fd);
		return (-1);
	}

	return (fd);
}

/*
 * is_boot_dev -- returns true if io is a boot slice
 */

static
is_boot_dev(io, dp)
iob_t	*io;
devsw_t	*dp;
{
	switch (dp->dv_id & DV_TYPE_MASK) {
	case DV_MT:
	case DV_9T:
		return (1);
	case DV_RV:
		panic("DV_RV no longer supported");
	case DV_DK:
		return (devioctl(io, GET_LOG_TYPE, 0) == LD_BOOT_SLICE);
	default:
		panic("is_boot_dev: unknown dev type");
	}
	return (0);
}


/*	iob.i_unit
 *         format: xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx
 *		   css slot sub slot   pd #     ld # 
 *
 */

Open(str, how)
char *str;
int	how;
{
	register iob_t 	*file;	/* pointer to an io block */
	struct devsw 	*dp;	/* pointer to device name,	  */
					/* strategy, open, close routines */ 
	register uint 		i;
	register int 		fdesc;
	char			*p, filename[DEV_NAMLEN];

	if (dbug)
		printf("open(%s, %d)\n", str, how);

	/* 
	 * search for first available file descriptor 
	 */
	for (file = iob, fdesc = 0; file->i_flgs; file++)
		if (++fdesc >= NFILES) {
			printf("No more file slots\n");
			return(-1);
		}

	file->i_flgs = F_ALLOC | ((how + 1) & (F_READ | F_WRITE));
	fdesc += 3;

	/* 
	 * scan string and return a pointer to a devsw structure
	 */
	if ((dp = get_dev(str, &file->i_unit, &p)) == NULL) {
		file->i_flgs = 0;
		return(-1);
	}
	if (p)
		strncpy(filename, p, sizeof(filename));
	else
		*filename = '\0';
	/* 
	 *  i_dev = devsw index (sorta major device number-ish)
	 */
	file->i_ino.i_dev = dp - devsw;

	if (dbug)
		printf("open: file=%x, file->ino.i_dev=%x\n",
		  file, file->i_ino.i_dev);

	file->i_bn   	= 0;		/* block number */
	file->i_cc   	= 0;
	file->i_offset 	= 0;

	if (devopen(file) < 0) {
		file->i_flgs = 0;
		return(-1);
	}
	if (*filename == '\0')			/* open device? */
		return(fdesc);
	if (is_boot_dev(file, dp))		/* open bootimage file? */
		return(open_boot(fdesc, file, filename));

	/* else, must be a file in a file system */

	if (get_super_block(file)) {
		file->i_flgs = 0;
		return(-1);
	}

	if ((i = find(filename, file)) == 0) {
		file->i_flgs = 0;
		return(-1);
	}
	if (how != 0) {
		printf("Can't write files yet.. Sorry\n");
		file->i_flgs = 0;
		return(-1);
	}
	if (Openi((ino_t)i, file))
		return(-1);
	if (dbug)
		printf("file = %x after open\n", file);
	file->i_offset = 0;
	file->i_cc = 0;
	file->i_flgs |= F_FILE;
	return(fdesc);
}

Close(fdesc)
int	fdesc;
{
	iob_t	*file;

	if (dbug)
		printf("close(%d)\n", fdesc);
	fdesc -= 3;
	if (fdesc < 0 || fdesc >= NFILES || 
	    ((file = &iob[fdesc])->i_flgs & F_ALLOC) == 0)
		return(-1);
	if ((file->i_flgs & F_FILE) == 0)
		devclose(file);

	/* clear io block */
	bzero(file, sizeof(iob_t));

	return(0);
}

Ioctl(fdesc, cmd, addr)
int	fdesc;
int	cmd;
char	*addr;
{
	iob_t	*file;

	if (dbug)
		printf("ioctl(%d, %#x, %#x)\n", fdesc, cmd, addr);

	if ((fdesc -= 3) < 0)
		return (-1);

	if (fdesc >= NFILES || ((file = &iob[fdesc])->i_flgs & F_ALLOC) == 0)
		return(-1);

	if (dbug)
		printf("ioctl: file=%#x, file->i_flgs=%#x\n",
		  file, file->i_flgs);

	return(devioctl(file, cmd, addr));
}

/*
 * Fstat -- get the file status of a file descriptor, returns -1 on err, else 0
 */

Fstat(fdesc, buf)
register int		fdesc;
register struct stat	*buf;
{
	register iob_t	*io;

	if (dbug)
		printf("Fstat(%d, %x)\n", fdesc, buf);

	fdesc -= 3;
	io = &iob[fdesc];

	if (fdesc < 0 || fdesc >= NFILES || (io->i_flgs & F_ALLOC) == 0)
		return (-1);

	bzero((caddr_t)buf, sizeof(*buf));
	buf->st_ino   = io->i_ino.i_number;
	buf->st_mode  = io->i_ino.i_mode;
	buf->st_size  = io->i_ino.i_size;
	buf->st_nlink = io->i_ino.i_nlink;
	buf->st_uid   = io->i_ino.i_uid;
	buf->st_gid   = io->i_ino.i_gid;
	buf->st_atime = io->i_ino.i_atime;
	buf->st_mtime = io->i_ino.i_mtime;
	buf->st_ctime = io->i_ino.i_ctime;

	return (0);
}

Exit()
{
	put_char('\n');
	rtn_to_monitor();
}

static void
init_sbus_ds(dev_num, slot, sub_slot)
uint	dev_num;
uint	slot;
uint	sub_slot;
{
	dev_slot_t	*ds = &dev_slot[dev_num];

	ds->dev_id = DV_IOPM;
	ds->unit.i = IUNIT_NO_DEV;
	ds->unit.s.slot = slot;
	ds->unit.s.subslot = sub_slot;
}

static uint
init_iosb_dev_entry(iomp, dev_num)
iom_config_t	*iomp;
register uint	dev_num;
{
	register css_bd_dat_t	*csbp = iomp->ex_card_cage.css_bd_dat;
	register uint		link_slot = iomp->iom_slot;
	register uint		sub_slot;

	for (sub_slot = 0; sub_slot < SBUS_NUM_SLOT; sub_slot++, csbp++) {
		if (csbp->css_slot_id != SBUS_IOPM ||
		    csbp->dev_board_id != IOPM_DB_ID_DSDB)
			continue;

		init_sbus_ds(dev_num, link_slot, sub_slot);

		if (++dev_num >= MAX_DEV)
			break;
	}
	return (dev_num);
}

static void
reset_dev_slots()
{
	register int	ndx;
	iob_t		*ip;
	dev_slot_t	*dp;

	for (ip = iob, ndx = NFILES; --ndx >= 0; ip++)
		ip->i_flgs = 0;			/* clear access mode flags */

	for (dp = dev_slot, ndx = MAX_DEV; --ndx >= 0; dp++)
		dp->dev_id = 0;			/* clear device id's */
}


init_devslot()
{
	register uint		iom_ndx;
	register uint		sbus_slot;
	uint			dev_num = 0;
	extern	 uint		iom_count;
	register iom_config_t	*iomp;
	static uchar		did_iob_map;

	if (!did_iob_map) {
		/* 
		 *  find MM of sufficient size and establish a permanent map 
		 *	to io block 
		 */
		for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {
			if (sbus_config.slot_id[sbus_slot] == SBUS_MM) {
				uint	addr;

				if (sbus_config.slot_size[sbus_slot] <
				    sa_mem_requirement)
					panic("first memory board too small!");

				/* permanent alt map for iob array */
				addr = (uint)alt_iomap(sbus_slot, iob_offset);
				ASSERT(addr == iob_array);
				break;
			}
		}

		if (sbus_slot >= SBUS_NUM_SLOT)
			panic("no memory board for I/O buffers!\n");

		did_iob_map = 1;
	}

	reset_dev_slots();	/* reset (clear) device/file data stuctures. */

	/* I N I T the device table for the sub-cabinets i/o boards. */
	iomp = iom_config;
	for (iom_ndx = 0; iom_ndx < iom_count; iom_ndx++, iomp++) {
		switch (iomp->card_cage_type) {
		case IOM_TYPE_IOA:
			ASSERT(0);	/* IOM/IOA no longer supported */
			break;
		case IOM_TYPE_IOSBA:
			dev_num = init_iosb_dev_entry(iomp, dev_num);
			if (dev_num >= MAX_DEV)
				return;
			break;
		default:
			printf("IOM # %d in slot # %d: unknown type=0x%02x\n",
			  iom_ndx, iomp->iom_slot, iomp->card_cage_type);
			continue;
		}
	}

	/* I N I T device switch table for the main cabinet. */
	for (sbus_slot = 0; sbus_slot < SBUS_NUM_SLOT; sbus_slot++) {
		if (sbus_config.slot_id[sbus_slot] != SBUS_IOPM ||
			sbus_config.dev_board_id[sbus_slot] != IOPM_DB_ID_DSDB)
			continue;
		init_sbus_ds(dev_num, sbus_slot, NO_SUB_SLOT);

		if (++dev_num >= MAX_DEV)
			return;
	}
}


/*
 * get_dev - return the type of device
 */
devsw_t *
get_dev(path, unitp, fptr)
char	*path;
iunit_t	*unitp;
char	**fptr;
{
	register uint		type;
	register devsw_t	*dvp;
	dev_slot_t		*dsp;

	type = get_device_info(path, unitp, fptr);
	if (type == DV_NO_DEV)
		return (NULL);
	if (type == DV_HELP_REQUEST || type == DV_SLOT) {
		dev_help_message();
		return (NULL);
	}

	if ((dsp = get_dev_slot(*unitp)) == NULL)
		return (NULL);

	type |= dsp->dev_id;

	for (dvp = devsw; dvp->dv_id; dvp++)
		if (dvp->dv_id == type)
			return (dvp);

	return (NULL);
}


get_super_block(io)
register iob_t	*io;
{
	register struct filsys	*fptr;

	io->i_offset = 0;

	io->i_bn = 0;
	io->i_cc = BUFFSIZE;
	io->i_ma = (char *)xtra_block;

	if (devread(io) <= 0) {
		printf("get_super_block: superblock read failed: i_unit=%08x\n",
		  io->i_unit);
		return(1);
	}
	fptr = (struct filsys *)(xtra_block + SUPERBOFF);

	if (fptr->s_magic != FsMAGIC) {
		printf("get_super_block: not a valid file system\n");
		return(1);
	}

	if (fptr->s_type == FsSEC1 || fptr->s_type == FsSEC4)
		io->inodesize = SEC_INODESIZE;
	else
		io->inodesize = FsINODESIZE;

	return(0);
}
